/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ContextManagerFactory {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$core$ContextManagerFactory == null ? (class$com$ibm$ws$security$core$ContextManagerFactory = ContextManagerFactory.class$("com.ibm.ws.security.core.ContextManagerFactory")) : class$com$ibm$ws$security$core$ContextManagerFactory), null, (String)"com.ibm.ejs.resources.security");
    private static final String DEFAULT_CONTEXT_MGR_IMPL = "com.ibm.ws.security.auth.distContextManagerImpl";
    private static final String DEFAULT_CONTEXT_MGR_IMPL_Z = "com.ibm.ws.security.auth.zOSContextManagerImpl";
    private static String CONTEXT_MGR_IMPL = "com.ibm.ws.security.auth.distContextManagerImpl";
    private static ContextManager instance = null;
    private static final String plugins_list = "/META-INF/plugins.list";
    static /* synthetic */ Class class$com$ibm$ws$security$core$ContextManagerFactory;

    private ContextManagerFactory() {
    }

    public static ContextManager getInstance() {
        if (instance == null) {
            try {
                ContextManager contextManager = null;
                if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    Tr.debug((TraceComponent)tc, (String)"Default ContextManagerImpl class: com.ibm.ws.security.auth.distContextManagerImpl");
                } else {
                    Tr.debug((TraceComponent)tc, (String)"Default ContextManagerImpl class: com.ibm.ws.security.auth.zOSContextManagerImpl");
                }
                String string = ContextManagerFactory.getContextMgrImplFromPluginList();
                try {
                    contextManager = (ContextManager)Class.forName(string).newInstance();
                    Tr.debug((TraceComponent)tc, (String)("Loaded ContextManagerImpl class: " + string));
                    if (instance == null) {
                        instance = contextManager;
                    } else {
                        contextManager = null;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.security.core.ContextManagerFactory.ContextManagerFactory", (String)"73");
                    Tr.error((TraceComponent)tc, (String)("Could not find class: " + string));
                    throw classNotFoundException;
                }
                catch (InstantiationException instantiationException) {
                    FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.security.core.ContextManagerFactory.ContextManagerFactory", (String)"79");
                    Tr.error((TraceComponent)tc, (String)("Could not instantiate class: " + string));
                    throw instantiationException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerFactory.ContextManagerFactory", (String)"85");
                    Tr.error((TraceComponent)tc, (String)("Could not load class: " + string));
                    throw exception;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerFactory", (String)"38");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error in initializing the ContextManager Implementation Class " + CONTEXT_MGR_IMPL), (Object)exception);
                }
                instance = null;
                throw new ExceptionInInitializerError(exception);
            }
        }
        return instance;
    }

    private static String getContextMgrImplFromPluginList() {
        try {
            InputStream inputStream = Class.forName("com.ibm.ws.security.core.ContextManagerFactory").getResourceAsStream(plugins_list);
            if (inputStream != null) {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string = bufferedReader.readLine()) != null) {
                    if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                        if (!string.startsWith("com.ibm.ws.security.plugin.distContextManager")) continue;
                        int n = string.indexOf(61) + 1;
                        CONTEXT_MGR_IMPL = string.substring(n);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("ContextManager implementation class from plugin.list is: " + CONTEXT_MGR_IMPL));
                        }
                        return CONTEXT_MGR_IMPL;
                    }
                    if (!string.startsWith("com.ibm.ws.security.plugin.zOSContextManager")) continue;
                    int n = string.indexOf(61) + 1;
                    CONTEXT_MGR_IMPL = string.substring(n);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("ContextManager implementation class from plugin.list is: " + CONTEXT_MGR_IMPL));
                    }
                    return CONTEXT_MGR_IMPL;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Could not find com.ibm.ws.security.plugin.ContextManager property in plugins.list file.");
                }
                if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    return DEFAULT_CONTEXT_MGR_IMPL;
                }
                return DEFAULT_CONTEXT_MGR_IMPL_Z;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"plugins.list file not found");
            }
            if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                return DEFAULT_CONTEXT_MGR_IMPL;
            }
            return DEFAULT_CONTEXT_MGR_IMPL_Z;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ContextManagerFactory.ContextManagerFactory", (String)"152");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"failed to load list of admin applications");
            }
            if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                return DEFAULT_CONTEXT_MGR_IMPL;
            }
            return DEFAULT_CONTEXT_MGR_IMPL_Z;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

