/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.auth.j2c.GenericCredentialImpl;
import com.ibm.wsspi.security.ltpa.Token;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.security.auth.AuthPermission;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;

public class zOSWSCredentialImpl
implements WSCredential {
    private static final long serialVersionUID = -1558175421115691311L;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$auth$zOSWSCredentialImpl == null ? (class$com$ibm$ws$security$auth$zOSWSCredentialImpl = zOSWSCredentialImpl.class$("com.ibm.ws.security.auth.zOSWSCredentialImpl")) : class$com$ibm$ws$security$auth$zOSWSCredentialImpl), (String)"Security", (String)"com.ibm.ejs.resource.security");
    private byte[] _lockObject = new byte[0];
    private String _realmName = null;
    private String _securityName = null;
    private String _uniqueSecurityName = null;
    private String _hostName = null;
    private String _oid = null;
    private String _primaryGroupId = null;
    private String _accessId = null;
    private Token _token = null;
    private byte[] _credentialToken;
    private boolean _isForwardable = false;
    private long _expiration = 0L;
    private boolean _isUnauthenticated = false;
    private ArrayList _groupIds = null;
    private ArrayList _roles = null;
    private Hashtable _hashTable = null;
    private boolean _isBasicAuthCred = false;
    private boolean _isDestroyed = false;
    private byte[] _serverCredCipher = null;
    private byte[] _wsCredCipher = null;
    private boolean _isServerCred = false;
    private GenericCredentialImpl _genericCred = null;
    private Subject _wsSubject = null;
    private static final AuthPermission APP_READ_PERMISSION = new AuthPermission("wssecurity.applicationReadCredential");
    private static final AuthPermission APP_UPDATE_PERMISSION = new AuthPermission("wssecurity.applicationUpdateCredential");
    private static final AuthPermission READ_PERMISSION = new AuthPermission("wssecurity.readCredential");
    private static final AuthPermission UPDATE_PERMISSION = new AuthPermission("wssecurity.updateCredential");
    private static final AuthPermission CREATE_PERMISSION = new AuthPermission("wssecurity.createCredential");
    private static final AuthPermission DESTROY_PERMISSION = new AuthPermission("wssecurity.destroyCredential");
    private static final AuthPermission REFRESH_PERMISSION = new AuthPermission("wssecurity.refreshCredential");
    static /* synthetic */ Class class$com$ibm$ws$security$auth$zOSWSCredentialImpl;

    public zOSWSCredentialImpl(String string, String string2, String string3, String string4, String string5, ArrayList arrayList, ArrayList arrayList2) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{string, string2, string3, string4, string5, arrayList, arrayList2});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(CREATE_PERMISSION);
        }
        this._realmName = string;
        this._securityName = string2;
        this._uniqueSecurityName = string3;
        this._primaryGroupId = string4;
        this._accessId = string5;
        this._hashTable = new Hashtable();
        this._roles = arrayList != null ? (ArrayList)arrayList.clone() : null;
        ArrayList arrayList3 = this._groupIds = arrayList2 != null ? (ArrayList)arrayList2.clone() : null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public zOSWSCredentialImpl(WSCredential wSCredential, String string, Token token, boolean bl, long l) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{wSCredential, string, token, new Boolean(bl), new Long(l)});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(CREATE_PERMISSION);
        }
        try {
            this._realmName = wSCredential.getRealmName();
            this._securityName = wSCredential.getSecurityName();
            this._uniqueSecurityName = wSCredential.getUniqueSecurityName();
            this._primaryGroupId = wSCredential.getPrimaryGroupId();
            this._accessId = wSCredential.getAccessId();
            this._roles = wSCredential.getRoles();
            this._groupIds = wSCredential.getGroupIds();
            this._oid = string;
            this._isForwardable = bl;
            this._expiration = l;
            this._token = token;
            this._hashTable = ((WSCredentialImpl)wSCredential).getTable();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception occurred", (Object)exception);
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.WSCredentialImpl.constructor", (String)"194");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public zOSWSCredentialImpl(WSCredential wSCredential, String string, byte[] byArray, boolean bl, long l) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{wSCredential, string, byArray, new Boolean(bl), new Long(l)});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(CREATE_PERMISSION);
        }
        try {
            this._realmName = wSCredential.getRealmName();
            this._securityName = wSCredential.getSecurityName();
            this._uniqueSecurityName = wSCredential.getUniqueSecurityName();
            this._primaryGroupId = wSCredential.getPrimaryGroupId();
            this._accessId = wSCredential.getAccessId();
            this._roles = wSCredential.getRoles();
            this._groupIds = wSCredential.getGroupIds();
            this._oid = string;
            this._isForwardable = bl;
            this._expiration = l;
            this._credentialToken = byArray != null ? (byte[])byArray.clone() : null;
            this._hashTable = ((WSCredentialImpl)wSCredential).getTable();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception occurred", (Object)exception);
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.WSCredentialImpl.constructor", (String)"242");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public zOSWSCredentialImpl(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{string, string2, string3 == null ? null : "****"});
        }
        this._realmName = string;
        this._securityName = string2;
        this._uniqueSecurityName = string2;
        this._accessId = string2;
        this._credentialToken = StringBytesConversion.getConvertedBytes(string3);
        this._isBasicAuthCred = true;
        this._oid = "oid:2.23.130.1.1.1";
        this._isForwardable = true;
        this._expiration = 0L;
        this._hashTable = new Hashtable();
        this._groupIds = new ArrayList();
        this._isUnauthenticated = "UNAUTHENTICATED".equals(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public zOSWSCredentialImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericCredentialImpl getGenericCredential() throws CredentialDestroyedException, CredentialExpiredException {
        byte[] byArray = this._lockObject;
        synchronized (this._lockObject) {
            this._assert();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._genericCred != null ? (GenericCredentialImpl)this._genericCred.clone() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGenericCredential(GenericCredentialImpl genericCredentialImpl) throws CredentialDestroyedException, CredentialExpiredException {
        byte[] byArray = this._lockObject;
        synchronized (this._lockObject) {
            this._assert();
            this._genericCred = genericCredentialImpl != null ? (GenericCredentialImpl)genericCredentialImpl.clone() : null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubject(Subject subject) throws CredentialDestroyedException, CredentialExpiredException {
        byte[] byArray = this._lockObject;
        synchronized (this._lockObject) {
            this._assert();
            this._wsSubject = subject;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject getSubject() throws CredentialDestroyedException, CredentialExpiredException {
        byte[] byArray = this._lockObject;
        synchronized (this._lockObject) {
            this._assert();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._wsSubject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRealmName() throws CredentialDestroyedException, CredentialExpiredException {
        byte[] byArray = this._lockObject;
        synchronized (this._lockObject) {
            this._assert();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._realmName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        byte[] byArray = this._lockObject;
        synchronized (this._lockObject) {
            this._assert();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._securityName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRealmSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRealmSecurityName");
        }
        String string = null;
        byte[] byArray = this._lockObject;
        synchronized (this._lockObject) {
            string = this._realmName != null && this._realmName.length() > 0 ? this._realmName + "/" + this._securityName : this._securityName;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRealmSecurityName");
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUniqueSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        byte[] byArray = this._lockObject;
        synchronized (this._lockObject) {
            this._assert();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._uniqueSecurityName;
        }
    }

    public String getRealmUniqueSecurityName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRealmUniqueSecurityName");
        }
        String string = null;
        string = this._realmName != null && this._realmName.length() > 0 ? this._realmName + "/" + this._uniqueSecurityName : this._uniqueSecurityName;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCredentialToken() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCredentialToken");
        }
        byte[] byArray = null;
        try {
            byte[] byArray2 = this._lockObject;
            synchronized (this._lockObject) {
                this._assert();
                if (this._credentialToken == null && this._token != null) {
                    this._credentialToken = this._token.getBytes();
                }
                if (this._credentialToken != null) {
                    byArray = (byte[])this._credentialToken.clone();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception occurred", (Object)new Object[]{exception, this._token});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.WSCredentialImpl.getCredentialToken", (String)"554");
        }
        {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getCredentialToken", byArray);
            }
            return byArray;
        }
    }

    public String getHostName() throws CredentialDestroyedException, CredentialExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getHostName");
        }
        if (this._hostName == null || this._hostName.length() == 0) {
            this._hostName = VaultImpl.getInstance().getORB().getLocalHost();
            if (this._hostName == null || this._hostName.length() == 0) {
                this._hostName = "localhost";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getHostName", (Object)this._hostName);
        }
        return this._hostName;
    }

    public String getOID() throws CredentialDestroyedException, CredentialExpiredException {
        return this._oid;
    }

    public boolean isForwardable() throws CredentialDestroyedException, CredentialExpiredException {
        return this._isForwardable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExpiration() throws CredentialDestroyedException, CredentialExpiredException {
        byte[] byArray = this._lockObject;
        synchronized (this._lockObject) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._expiration;
        }
    }

    public String getPrimaryGroupId() throws CredentialDestroyedException, CredentialExpiredException {
        return this._primaryGroupId;
    }

    public ArrayList getRoles() throws CredentialDestroyedException, CredentialExpiredException {
        return this._roles == null ? null : (ArrayList)this._roles.clone();
    }

    public String getAccessId() throws CredentialDestroyedException, CredentialExpiredException {
        this._assert();
        return this._accessId;
    }

    public ArrayList getGroupIds() throws CredentialDestroyedException, CredentialExpiredException {
        this._assert();
        return this._groupIds == null ? new ArrayList() : (ArrayList)this._groupIds.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String string) throws CredentialDestroyedException, CredentialExpiredException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"get", (Object)string);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(APP_READ_PERMISSION);
            if (string != null && string.startsWith("wssecurity")) {
                securityManager.checkPermission(READ_PERMISSION);
            }
        }
        Object var3_3 = null;
        byte[] byArray = this._lockObject;
        synchronized (this._lockObject) {
            this._assert();
            var3_3 = this._hashTable.get(string);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"get", var3_3);
            }
            return var3_3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(String string, Object object) throws CredentialDestroyedException, CredentialExpiredException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"set", (Object)new Object[]{string, object});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(APP_UPDATE_PERMISSION);
            if (string != null && string.startsWith("wssecurity")) {
                securityManager.checkPermission(UPDATE_PERMISSION);
            }
        }
        Object object2 = null;
        byte[] byArray = this._lockObject;
        synchronized (this._lockObject) {
            this._assert();
            object2 = this._hashTable.put(string, object);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"set", (Object)object2);
            }
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrent() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isCurrent");
        }
        boolean bl = false;
        try {
            byte[] byArray = this._lockObject;
            synchronized (this._lockObject) {
                long l;
                long l2;
                bl = this._expiration == 0L || this._expiration == -1L ? true : (this.isServerCred() ? true : (l2 = this._expiration - (l = System.currentTimeMillis())) > 0L);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception", (Object)exception);
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.WSCredentialImpl.isCurrent", (String)"855", (Object)this);
            bl = false;
        }
        {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isCurrent", (Object)new Boolean(bl));
            }
            return bl;
        }
    }

    public boolean isUnauthenticated() {
        return this._isUnauthenticated;
    }

    public final void markAsUnauthenticated() {
        this._isUnauthenticated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws DestroyFailedException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(DESTROY_PERMISSION);
        }
        byte[] byArray = this._lockObject;
        synchronized (this._lockObject) {
            if (!this.isServerCred()) {
                this._isDestroyed = true;
                this.cleanup();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"destroy");
            }
            return;
        }
    }

    public boolean isDestroyed() {
        return this._isDestroyed;
    }

    public boolean isBasicAuth() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isBasicAuth");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isBasicAuth", (Object)new Boolean(this._isBasicAuthCred));
        }
        return this._isBasicAuthCred;
    }

    public void refresh() throws RefreshFailedException {
        throw new RefreshFailedException("Refresh is not supported for this mechanism.");
    }

    private final void _assert() throws CredentialDestroyedException, CredentialExpiredException {
        if (this.isDestroyed()) {
            throw new CredentialDestroyedException("Credential is destroyed, can not be used.");
        }
        if (!this.isCurrent()) {
            throw new CredentialExpiredException("Credential is expired, please refresh.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getTable() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(READ_PERMISSION);
        }
        byte[] byArray = this._lockObject;
        synchronized (this._lockObject) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this._hashTable == null ? null : (Hashtable)this._hashTable.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(Hashtable hashtable) {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTable", (Object)hashtable);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(UPDATE_PERMISSION);
        }
        byte[] byArray = this._lockObject;
        synchronized (this._lockObject) {
            this._hashTable = (Hashtable)hashtable.clone();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setTable");
            }
            return;
        }
    }

    protected void markServerCred(byte[] byArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(UPDATE_PERMISSION);
        }
        this._serverCredCipher = byArray;
    }

    protected byte[] getServerCredCipher() {
        return this._serverCredCipher;
    }

    public boolean isServerCred() {
        return this._isServerCred;
    }

    public boolean isWSCred() {
        return true;
    }

    public void markServerCred() {
        this._isServerCred = true;
    }

    protected byte[] getWSCredCipher() {
        return this._wsCredCipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshCred(WSCredential wSCredential) throws WSSecurityException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"refreshCred", (Object)wSCredential);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(UPDATE_PERMISSION);
        }
        try {
            if (wSCredential == null || wSCredential.isBasicAuth()) return;
            if (!this._isDestroyed) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Refreshing credential token and expiration");
                }
                byte[] byArray = this._lockObject;
                synchronized (this._lockObject) {
                    this._credentialToken = wSCredential.getCredentialToken();
                    this._expiration = wSCredential.getExpiration();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
            if (wSCredential == null) return;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Refreshing the entire WSCredential.");
            }
            byte[] byArray = this._lockObject;
            synchronized (this._lockObject) {
                this._isDestroyed = true;
                this._credentialToken = wSCredential.getCredentialToken();
                this._expiration = wSCredential.getExpiration();
                this._realmName = wSCredential.getRealmName();
                this._securityName = wSCredential.getSecurityName();
                this._uniqueSecurityName = wSCredential.getUniqueSecurityName();
                this._hostName = wSCredential.getHostName();
                this._oid = wSCredential.getOID();
                this._primaryGroupId = wSCredential.getPrimaryGroupId();
                this._accessId = wSCredential.getAccessId();
                this._isForwardable = wSCredential.isForwardable();
                this._isUnauthenticated = false;
                this._groupIds = wSCredential.getGroupIds();
                this._roles = wSCredential.getRoles();
                this._hashTable = ((WSCredentialImpl)wSCredential).getTable();
                this._isBasicAuthCred = false;
                this._isDestroyed = false;
                this._genericCred = ((WSCredentialImpl)wSCredential).getGenericCredential();
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred while refreshing credential", (Object)exception);
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.WSCredentialImpl.refreshCred", (String)"1132", (Object)this);
            throw new WSSecurityException(exception.getMessage(), exception);
        }
    }

    private void cleanup() {
        this._realmName = null;
        this._securityName = null;
        this._uniqueSecurityName = null;
        this._oid = null;
        this._primaryGroupId = null;
        this._accessId = null;
        this._isForwardable = false;
        this._expiration = 0L;
        this._credentialToken = null;
        this._groupIds = null;
        this._hashTable = null;
        this._isBasicAuthCred = false;
        this._genericCred = null;
    }

    public String toString() {
        if (this._hashTable == null || this._hashTable.size() == 0) {
            return super.toString() + ";" + this._hashTable;
        }
        return super.toString() + ";" + this._hashTable.keySet().toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

