/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.PrincipalAuthenticatorImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectBasicAuthImpl.CredentialsImpl;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.CredentialsHelper;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.SecurityServer;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.auth.JaasLoginHelper;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ietf.jgss.GSSCredential;
import org.omg.SecurityLevel2.Credentials;

public class distContextManagerImpl
implements ContextManager {
    private boolean serverSecurityEnabled = true;
    private static boolean enableSyncOSThread = false;
    private String regionUserid = "";
    private String DefaultSAFRealm = "";
    private boolean returnToken = false;
    private AuditService _auditService = null;
    private String serverUniqueIdentity = null;
    private static final String DEFAULT_REALM = "<default>";
    private static final String EMPTY = "";
    private String SECURITY_REALM = "";
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final WebSphereRuntimePermission GET_SERVER_CRED_PERM = new WebSphereRuntimePermission("ContextManager.getServerCredential");
    private static Object lock_object = new Object();
    private AuthenticationToken serverAuthToken = null;
    private AuthorizationToken serverAuthzToken = null;
    private SingleSignonToken serverSSOToken = null;
    private CurrentImpl current = null;
    private Credentials[] creds = null;
    private ORB theORB = null;
    private SecurityServer securityServer = null;
    private WSCredential serverBACred = null;
    private Subject serverBASubject = null;
    private WSCredential serverTokenCred = null;
    private Subject serverSubject = null;
    private VaultImpl vault = null;
    private SecurityConfiguration secConfig = null;
    private SecurityCache cache = null;
    private static ServerCredSigner scs = null;
    private JaasLoginHelper jaasLoginHelper = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$auth$distContextManagerImpl == null ? (class$com$ibm$ws$security$auth$distContextManagerImpl = distContextManagerImpl.class$("com.ibm.ws.security.auth.distContextManagerImpl")) : class$com$ibm$ws$security$auth$distContextManagerImpl), null, (String)"com.ibm.ejs.resources.security");
    private static final String FACTORY_CLASS = "com.ibm.ws.security.auth.AuthCache";
    private Class _authCacheClass = null;
    private Method _authCacheGetInstanceMethod = null;
    private static final String SECURITY_SERVER_IMPL_CLASS = "com.ibm.ws.security.server.SecurityServerImpl";
    private Class _securityServerImplClass = null;
    private Method _getRegistryMethod = null;
    private static final String SECURITY_SERVER_FACTORY_CLASS = "com.ibm.ws.security.server.SecurityServerFactory";
    private Class _securityServerFactoryClass = null;
    private Method _getSecurityServerCreateMethod = null;
    private Object _registryObject = null;
    private WSCredentialTokenMapperInterface wsCredTokenMapper = null;
    private static final String WAM_CLASS = "com.ibm.ws.security.core.WSAccessManager";
    private Class _WSAccessManager = null;
    private Method _isIgnoreCaseMethod = null;
    private static String URL_HANDLER_PROP = "java.protocol.handler.pkgs";
    private static final String PKGNAME_DELIMITER = "|";
    static /* synthetic */ Class class$com$ibm$ws$security$auth$distContextManagerImpl;
    static /* synthetic */ Class class$com$ibm$websphere$security$cred$WSCredential;
    static /* synthetic */ Class class$com$ibm$ws$security$server$SecurityServer;
    static /* synthetic */ Class class$java$lang$String;

    public distContextManagerImpl() throws WSSecurityException {
        this.init();
    }

    public void init() throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                Method method;
                this.vault = VaultImpl.getInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"init(): VaultImpl instance: ", (Object)this.vault);
                }
                if (this.vault != null) {
                    scs = ServerCredSigner.getInstance();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"init(): Server cred signer instance: ", (Object)scs);
                    }
                    distContextManagerImpl distContextManagerImpl2 = this;
                    this.secConfig = distContextManagerImpl2.vault.getSecurityConfiguration();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"init(): Security configuration instance: ", (Object)this.secConfig);
                    }
                    this.current = this.vault.getCurrent();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"init(): CurrentImpl instance: ", (Object)((Object)this.current));
                    }
                    this.theORB = this.vault.getORB();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"init(): ORB instance: ", (Object)this.theORB);
                    }
                } else {
                    throw new WSSecurityException("Vault is null during ContextManager initialization");
                }
                if (this.secConfig == null) {
                    throw new WSSecurityException("Security Configuration is null");
                }
                if (this.getCurrent() == null) {
                    throw new WSSecurityException("Security Current is null");
                }
                if (this.secConfig.processIsServer() && (method = this.getAuthCacheGetInstanceMethod()) != null) {
                    this.cache = (SecurityCache)method.invoke(null, null);
                }
            }
            catch (WSSecurityException wSSecurityException) {
                throw wSSecurityException;
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException((Throwable)invocationTargetException.getTargetException(), (String)((class$com$ibm$ws$security$auth$distContextManagerImpl == null ? (class$com$ibm$ws$security$auth$distContextManagerImpl = distContextManagerImpl.class$("com.ibm.ws.security.auth.distContextManagerImpl")) : class$com$ibm$ws$security$auth$distContextManagerImpl).getName() + ".init()"), (String)"218", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed in getting AuthCache, reflection call failed", (Object)invocationTargetException.getTargetException());
                }
                throw new WSSecurityException(invocationTargetException.getMessage(), invocationTargetException);
            }
            catch (Exception exception) {
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public void initialize(Object object, AuditService auditService) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize(value, auditService)");
        }
        if (auditService != null && this._auditService == null) {
            this._auditService = auditService;
        }
        this.initialize(object);
    }

    public void initialize(Object object) throws WSSecurityException {
        if (this.creds != null || !this.isCellSecurityEnabled()) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize(value)");
        }
        if (object == null) {
            throw new WSSecurityException("Excepting Boolean, but null is passed in");
        }
        if (!(object instanceof Boolean)) {
            throw new WSSecurityException("Excepting Boolean, but " + object.getClass().getName() + " is passed in");
        }
        boolean bl = (Boolean)object;
        try {
            Object object2;
            PrincipalAuthenticatorImpl.enableSecurity(bl);
            this.serverBASubject = SubjectHelper.createBasicAuthSubject(this.getDefaultRealm(), this.secConfig.getloginUserid(), this.secConfig.getloginPassword());
            this.serverBACred = SubjectHelper.getWSCredentialFromSubject(this.serverBASubject);
            ((WSCredentialImpl)this.serverBACred).markServerCred(scs.getEncryptedServerSigner());
            Credentials credentials = CredentialsHelper.mapWSToCorba(this.serverBACred);
            this.creds = new Credentials[]{credentials};
            if (credentials instanceof CredentialsImpl) {
                object2 = RealmSecurityName.getRealm(((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)credentials).getPublic());
                credentials = ((CredentialsImpl)credentials).get_mapped_credentials(null, (String)object2, null);
            }
            if ((object2 = this.getSecurityServerCreateMethod()) != null) {
                ((Method)object2).invoke(null, null);
            }
            Subject subject = this.getServerSubject();
            this.serverTokenCred = SubjectHelper.getWSCredentialFromSubject(subject);
            this.setOwnSubject(subject);
            this.setCallerSubject(subject);
            this.setInvocationSubject(subject);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.enable", (String)"193");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)EMPTY, (Object)exception);
            }
            this.current = null;
            throw new WSSecurityException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public boolean processIsServer() {
        if (this.secConfig != null) {
            return this.secConfig.processIsServer();
        }
        return ConfigURLProperties.processIsServer();
    }

    public String getSecurityServerHost() {
        if (this.isCellSecurityEnabled() && this.secConfig != null) {
            return this.secConfig.getSecurityServerHost();
        }
        return EMPTY;
    }

    public String getSecurityServerPort() {
        if (this.isCellSecurityEnabled() && this.secConfig != null) {
            return this.secConfig.getSecurityServerPort();
        }
        return EMPTY;
    }

    public String getSpecificSecurityServerHost() {
        if (this.isCellSecurityEnabled() && this.getCurrent() != null) {
            return this.getCurrent().getAllHosts();
        }
        return EMPTY;
    }

    public String getSpecificSecurityServerPort() {
        if (this.isCellSecurityEnabled() && this.getCurrent() != null) {
            return this.getCurrent().getAllPorts();
        }
        return EMPTY;
    }

    public String getProperty(String string) {
        if (this.theORB != null) {
            return this.theORB.getProperty(string);
        }
        return null;
    }

    public String getProperty(String string, String string2) {
        if (this.theORB != null) {
            String string3 = this.theORB.getProperty(string);
            if (string3 == null || string3.length() == 0) {
                string3 = string2;
            }
            return string3;
        }
        return null;
    }

    public AuditService getAuditService() {
        return this._auditService;
    }

    public PropagationToken setPropagationToken(String string, PropagationToken propagationToken) throws WSSecurityException {
        if (string == null || propagationToken == null) {
            throw new WSSecurityException("Invalid null parameters.");
        }
        if (this.getCurrent() != null) {
            return this.getCurrent().setPropagationToken(string, propagationToken);
        }
        return null;
    }

    public PropagationToken getPropagationToken(String string) throws WSSecurityException {
        if (string == null) {
            throw new WSSecurityException("Invalid null parameters.");
        }
        if (this.getCurrent() != null) {
            return this.getCurrent().getPropagationToken(string);
        }
        return null;
    }

    public Map getPropagationTokens() {
        if (this.getCurrent() != null) {
            return this.getCurrent().getPropagationTokens();
        }
        return null;
    }

    public PropagationToken createPropagationToken(Subject subject) throws WSSecurityException {
        WSCredentialTokenMapperInterface wSCredentialTokenMapperInterface = null;
        try {
            wSCredentialTokenMapperInterface = this.getWSCredTokenMapper();
            if (wSCredentialTokenMapperInterface != null && subject != null) {
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                return wSCredentialTokenMapperInterface.createPropagationTokenFromWSCredential(wSCredential);
            }
            if (wSCredentialTokenMapperInterface != null && subject == null) {
                return wSCredentialTokenMapperInterface.createPropagationTokenBeforeAuthenticatedCallerSet();
            }
            throw new WSSecurityException("Could not instantiate WSCredTokenMapper.");
        }
        catch (WSSecurityException wSSecurityException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WSSecurityException creating propagation token.");
            }
            throw wSSecurityException;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception creating propagation token.");
            }
            throw new WSSecurityException(exception.getMessage(), exception);
        }
    }

    public Subject getUnauthenticatedSubject() throws WSSecurityException {
        return SubjectHelper.createSubjectFromWSCredential(this.getUnauthenticatedCredential());
    }

    public Subject createUnauthenticatedSubject() throws WSSecurityException {
        return SubjectHelper.createUnauthenticatedSubject();
    }

    public String getUnauthenticatedString() {
        return "UNAUTHENTICATED";
    }

    public WSCredential getUnauthenticatedCredential() throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            Credentials credentials = this.getCurrent().get_unauthenticated_credential();
            if (credentials instanceof com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl) {
                return CredentialsHelper.mapCorbaToWS((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)credentials);
            }
            throw new WSSecurityException("CORBA credentials is not an instance com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl");
        }
        return null;
    }

    public List getRealms() {
        List list = null;
        try {
            list = this.getSecurityServer().getRealms();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getRealms", (String)"515", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception during getRealms(): ", (Object)new Object[]{exception});
            }
            list = null;
        }
        return list;
    }

    public UserRegistry getRegistry(String string) {
        UserRegistry userRegistry = null;
        try {
            userRegistry = this.getSecurityServer().getRegistry(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getRegistry", (String)"534", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception during getRegistry(): ", (Object)new Object[]{exception});
            }
            userRegistry = null;
        }
        return userRegistry;
    }

    public String getDefaultRealm() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultRealmName()");
        }
        if (this.isCellSecurityEnabled()) {
            if (this.SECURITY_REALM == null || this.SECURITY_REALM.length() == 0) {
                String string = this.getProperty("com.ibm.CORBA.principalName");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Security name = " + string));
                }
                this.SECURITY_REALM = RealmSecurityName.getRealm(string);
                if (this.SECURITY_REALM == null || this.SECURITY_REALM.length() == 0) {
                    this.SECURITY_REALM = DEFAULT_REALM;
                }
            } else if (this.SECURITY_REALM != null && this.SECURITY_REALM.equals(DEFAULT_REALM) && this.secConfig != null && this.secConfig.processIsServer()) {
                String string = this.getProperty("com.ibm.CORBA.principalName");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Security name = " + string));
                }
                this.SECURITY_REALM = RealmSecurityName.getRealm(string);
                if (this.SECURITY_REALM == null || this.SECURITY_REALM.length() == 0) {
                    this.SECURITY_REALM = DEFAULT_REALM;
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Security is disabled, default realm name will be returned");
            }
            this.SECURITY_REALM = DEFAULT_REALM;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getDefaultRealmName() -> " + this.SECURITY_REALM));
        }
        return this.SECURITY_REALM;
    }

    public boolean isServerSubject(Subject subject) throws WSSecurityException {
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        return scs.isServerCred(wSCredential);
    }

    public boolean isWSSubject(Subject subject) throws WSSecurityException {
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        return scs.isWSCred(wSCredential);
    }

    public boolean isServerCred(WSCredential wSCredential) throws WSSecurityException {
        return scs.isServerCred(wSCredential);
    }

    public boolean isWSCred(WSCredential wSCredential) throws WSSecurityException {
        return scs.isWSCred(wSCredential);
    }

    public boolean getTokenFlag() {
        return this.returnToken;
    }

    public void setTokenFlag(boolean bl) {
        this.returnToken = bl;
    }

    public Subject login(WSCredential wSCredential) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login(credential)");
        }
        if (this.isCellSecurityEnabled() && wSCredential != null) {
            this.checkAuthRetryForThread();
            try {
                if (wSCredential.isBasicAuth()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"authenticating userid/password credential.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"login(credential)");
                    }
                    return this.login(wSCredential.getRealmName(), wSCredential.getSecurityName(), StringBytesConversion.getConvertedString(wSCredential.getCredentialToken()));
                }
                if (wSCredential.isCurrent()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"login(credential)");
                    }
                    return SubjectHelper.createSubjectFromWSCredential(wSCredential);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Credential is not current.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(credential)");
                }
                throw new WSLoginFailedException("Credential is not current.");
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.auth.distContextManagerImpl.login", (String)"672", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WSLoginFailedException occurred.", (Object)new Object[]{wSLoginFailedException});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(credential)");
                }
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.login", (String)"679", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"authenticate failed: ", (Object)this.dump(exception));
                }
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(credential)");
                }
                throw wSLoginFailedException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login(credential)");
        }
        return null;
    }

    public Subject login(String string, String string2) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("login(realm, user) -> login(" + string + ", " + string2 + ")"));
        }
        Subject subject = this.login(string, string2, null, null, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login(realm, user)");
        }
        return subject;
    }

    public Subject login(String string, String string2, String string3, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) throws WSLoginFailedException {
        return this.login(string, string2, string3, httpServletRequest, httpServletResponse, map, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Subject login(String string, String string2, String string3, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map, Subject subject) throws WSLoginFailedException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("login(realm, user, auth_mech) -> login(" + string + ", " + string2 + ", " + string3 + ")"));
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + MAP_CREDENTIAL.toString()));
            }
            securityManager.checkPermission((Permission)MAP_CREDENTIAL);
        }
        if (this.isCellSecurityEnabled()) {
            if (this.secConfig == null || !this.secConfig.processIsServer()) {
                return null;
            }
            this.checkAuthRetryForThread();
            Subject subject2 = null;
            ArrayList arrayList = null;
            String string4 = null;
            try {
                block33: {
                    Object[] objectArray;
                    subject2 = this.getSubjectFromHashtableCacheKey(subject);
                    if (subject2 == null && (this.secConfig.isRMIInboundPropagationEnabled() || this.secConfig.isRMIOutboundPropagationEnabled() || this.secConfig.isWebInboundPropagationEnabled())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Looking for opaque token in thread before doing Subject lookup.");
                        }
                        if ((objectArray = this.getSubjectFromTokenHolderCacheKey(null, arrayList = (ArrayList)this.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup()))) != null) {
                            subject2 = (Subject)objectArray[0];
                            string4 = (String)objectArray[1];
                        }
                    }
                    if (subject2 == null && arrayList == null && !this.getWSCredTokenMapper().subjectContainsLoginHashtable(subject)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Looking for Subject using realm:user.");
                        }
                        subject2 = this.cache.getSubject(string, string2);
                    }
                    if (subject2 != null) {
                        try {
                            objectArray = (Object[])subject2.getPublicCredentials(class$com$ibm$websphere$security$cred$WSCredential == null ? (class$com$ibm$websphere$security$cred$WSCredential = distContextManagerImpl.class$("com.ibm.websphere.security.cred.WSCredential")) : class$com$ibm$websphere$security$cred$WSCredential).iterator().next();
                            if (objectArray != null) {
                                boolean bl = objectArray.isDestroyed();
                                boolean bl2 = objectArray.isForwardable();
                                boolean bl3 = this.getWSCredTokenMapper().checkCushionValidityOfAllTokens(subject2, this.cache.getCushion());
                                if (tc.isDebugEnabled()) {
                                    if (bl2) {
                                        Tr.debug((TraceComponent)tc, (String)("login(realm, user, password, . . .): is subject valid? " + bl3));
                                    } else {
                                        Tr.debug((TraceComponent)tc, (String)"login(realm, user, password, . . .): is subject valid? non-forwardable Subject");
                                    }
                                }
                                if (bl || bl2 && !bl3) {
                                    this.cache.removeEntry(string, string2);
                                    subject2 = null;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Credential has expired or is destroyed, logging in again.");
                                    }
                                    break block33;
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, password, ...)");
                                }
                                return subject2;
                            }
                            subject2 = null;
                        }
                        catch (CredentialDestroyedException credentialDestroyedException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Credential is destroyed.", (Object)new Object[]{credentialDestroyedException});
                            }
                            subject2 = null;
                        }
                        catch (CredentialExpiredException credentialExpiredException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Credential has expired.", (Object)new Object[]{credentialExpiredException});
                            }
                            subject2 = null;
                        }
                    }
                }
                if (subject2 == null) {
                    subject2 = string3 == null ? this.getJaasLoginHelper().jaas_login(string, string2, null, subject) : (httpServletRequest == null ? this.getJaasLoginHelper().jaas_login(string, string2, null, string3, subject) : this.getJaasLoginHelper().jaas_login(string, string2, null, string3, httpServletRequest, httpServletResponse, map, subject));
                    this.processSubjectForPropagationAfterLogin(subject2, string3);
                    this.cache.insert(subject2, string2, null, new Object[]{string4});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, . . .)");
                }
                return subject2;
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.auth.distContextManagerImpl.login", (String)"853", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("login failed: " + wSLoginFailedException));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, . . .)");
                }
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.login", (String)"860", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("login failed: " + this.dump(exception)));
                }
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, . . .)");
                }
                throw wSLoginFailedException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login(realm, user, . . .)");
        }
        return null;
    }

    public Subject login(String string, String string2, String string3) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("login(realm, user, password) -> login(" + string + ", " + string2 + ", " + SecurityConfiguration.mask(string3) + ")"));
        }
        String string4 = null;
        if (this.secConfig != null) {
            string4 = this.secConfig.getAuthMechAuthAlias();
        }
        Subject subject = this.login(string, string2, string3, string4, null, null, (Map)null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login(realm, user, password)");
        }
        return subject;
    }

    public Subject login(String string, String string2, String string3, String string4, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) throws WSLoginFailedException {
        return this.login(string, string2, string3, string4, httpServletRequest, httpServletResponse, map, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Subject login(final String string, final String string2, final String string3, String string4, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("login(realm, user, password) -> login(" + string + ", " + string2 + ", " + SecurityConfiguration.mask(string3) + ", " + string4 + ")"));
        }
        if (string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
            throw new WSLoginFailedException("Username and/or password is null.");
        }
        if (this.isCellSecurityEnabled()) {
            if (this.secConfig == null) {
                return null;
            }
            this.checkAuthRetryForThread();
            try {
                String string5;
                Subject subject2;
                block42: {
                    Object object;
                    if (!this.secConfig.processIsServer()) {
                        WSCredential wSCredential = this.createBasicAuthCredential(string, string2, string3);
                        if (!this.secConfig.validateBasicAuth()) {
                            return SubjectHelper.createSubjectFromWSCredential(wSCredential);
                        }
                        try {
                            Boolean bl = (Boolean)this.runAsSpecified(SubjectHelper.createUnauthenticatedSubject(), new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    boolean bl = distContextManagerImpl.this.getSecurityServer().simple_authenticate(new BasicAuthData(string2, string3, string));
                                    return new Boolean(bl);
                                }
                            });
                            if (bl.booleanValue()) {
                                if (!this.getCurrent().getServerSecurityEnabled()) {
                                    wSCredential = null;
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, password)");
                                }
                                return SubjectHelper.createSubjectFromWSCredential(wSCredential);
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"login(realm, user, password)");
                            }
                            throw new WSLoginFailedException("Failed to authenticate " + wSCredential.getRealmSecurityName());
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            Exception exception = privilegedActionException.getException();
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.login", (String)"942", (Object)this);
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"login(realm, user, password)");
                            }
                            if (exception instanceof WSLoginFailedException) {
                                throw exception;
                            }
                            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                            throw wSLoginFailedException;
                        }
                    }
                    subject2 = null;
                    ArrayList arrayList = null;
                    string5 = null;
                    if (this.secConfig.isRMIInboundPropagationEnabled() || this.secConfig.isRMIOutboundPropagationEnabled() || this.secConfig.isWebInboundPropagationEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Looking for opaque token on the thread before Subject cache lookup.");
                        }
                        if ((object = this.getSubjectFromTokenHolderCacheKey(null, arrayList = (ArrayList)this.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup()))) != null) {
                            subject2 = (Subject)object[0];
                            string5 = (String)object[1];
                        }
                    }
                    if (arrayList == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Looking for subject from cache using token as lookup.");
                        }
                        subject2 = this.cache.getSubject(string, string2, string3);
                    }
                    if (subject2 != null) {
                        try {
                            object = SubjectHelper.getWSCredentialFromSubject(subject2);
                            if (object != null) {
                                boolean bl = object.isDestroyed();
                                boolean bl2 = object.isForwardable();
                                boolean bl3 = this.getWSCredTokenMapper().checkCushionValidityOfAllTokens(subject2, this.cache.getCushion());
                                if (tc.isDebugEnabled()) {
                                    if (bl2) {
                                        Tr.debug((TraceComponent)tc, (String)("login(realm, user, password, . . .): is subject valid? " + bl3));
                                    } else {
                                        Tr.debug((TraceComponent)tc, (String)"login(realm, user, password, . . .): is subject valid? non-forwardable Subject");
                                    }
                                }
                                if (bl || bl2 && !bl3) {
                                    this.cache.removeEntry(string, string2);
                                    subject2 = null;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Credential has expired or is destroyed, logging in again.");
                                    }
                                    break block42;
                                }
                                if (tc.isEntryEnabled()) {
                                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, password, auth_mech, . . .)");
                                }
                                return subject2;
                            }
                            subject2 = null;
                        }
                        catch (CredentialDestroyedException credentialDestroyedException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Credential is destroyed.", (Object)new Object[]{credentialDestroyedException});
                            }
                            subject2 = null;
                        }
                        catch (CredentialExpiredException credentialExpiredException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Credential has expired.", (Object)new Object[]{credentialExpiredException});
                            }
                            subject2 = null;
                        }
                    }
                }
                if (subject2 == null) {
                    subject2 = string4 == null ? this.getJaasLoginHelper().jaas_login(string, string2, string3, subject) : (httpServletRequest == null ? this.getJaasLoginHelper().jaas_login(string, string2, string3, string4, subject) : this.getJaasLoginHelper().jaas_login(string, string2, string3, string4, httpServletRequest, httpServletResponse, map, subject));
                    this.processSubjectForPropagationAfterLogin(subject2, string4);
                    this.cache.insert(subject2, string2, string3, new Object[]{string5});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, password, auth_mech, . . .)");
                }
                return subject2;
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.auth.distContextManagerImpl.login", (String)"1077", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("login failed: " + wSLoginFailedException));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, password, auth_mech, . . .)");
                }
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.login", (String)"1087", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("login failed: " + this.dump(exception)));
                }
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, user, password, auth_mech, . . .)");
                }
                throw wSLoginFailedException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login(realm, user, password, auth_mech, . . .)");
        }
        return null;
    }

    public Subject login(String string, byte[] byArray) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login(realm, token, auth_mech)");
        }
        String string2 = null;
        if (this.secConfig != null) {
            string2 = this.secConfig.getAuthMechAuthAlias();
        }
        Subject subject = this.login(string, byArray, string2, null, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login(realm, token, auth_mech)");
        }
        return subject;
    }

    public Subject login(String string, byte[] byArray, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login(realm, token, auth_mech, . . ., null_subject)");
        }
        return this.login(string, byArray, string2, httpServletRequest, httpServletResponse, map, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Subject login(String string, byte[] byArray, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("login(realm, token, auth_mech, . . .) -> (" + string + ", token, " + string2 + ", . . .)"));
        }
        if (this.isCellSecurityEnabled() && byArray != null && byArray.length != 0) {
            if (this.secConfig == null || !this.secConfig.processIsServer()) {
                return null;
            }
            this.checkAuthRetryForThread();
            try {
                if (this.secConfig.processIsServer()) {
                    Subject subject2;
                    String string3;
                    block51: {
                        Object object;
                        ArrayList arrayList = null;
                        string3 = null;
                        subject2 = null;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Web inbound login config: " + this.secConfig.getWebInboundLoginConfig()));
                        }
                        if (this.secConfig.isRMIInboundPropagationEnabled() || this.secConfig.isRMIOutboundPropagationEnabled() || this.secConfig.isWebInboundPropagationEnabled()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Looking for opaque token on the thread before Subject cache lookup.");
                            }
                            if ((object = this.getSubjectFromTokenHolderCacheKey(byArray, arrayList = (ArrayList)this.get(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup()))) != null) {
                                subject2 = (Subject)object[0];
                                string3 = (String)object[1];
                            }
                        }
                        if (arrayList == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Looking for subject from cache using token as lookup.");
                            }
                            subject2 = this.cache.getSubject(byArray);
                        }
                        if (subject2 == null && this.secConfig.isWebInboundPropagationEnabled() && string2 != null && string2.startsWith(this.secConfig.getWebInboundLoginConfig())) {
                            object = this.getOpaqueTokenFromCacheOrOriginatingServer(byArray);
                            if (object != null) {
                                if (object instanceof GSSCredential) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Logging in with GSSCredential.");
                                    }
                                    if (subject != null) {
                                        if (!subject.getPrivateCredentials().contains(object)) {
                                            subject.getPrivateCredentials().add(object);
                                        }
                                    } else {
                                        subject = new Subject();
                                        subject.getPrivateCredentials().add(object);
                                    }
                                    subject2 = string2 == null ? this.getJaasLoginHelper().jaas_login(string, ((Object)((GSSCredential)object).getName()).toString(), null, subject) : (httpServletRequest == null ? this.getJaasLoginHelper().jaas_login(string, ((Object)((GSSCredential)object).getName()).toString(), null, string2, subject) : this.getJaasLoginHelper().jaas_login(string, ((Object)((GSSCredential)object).getName()).toString(), null, string2, httpServletRequest, httpServletResponse, map, subject));
                                } else if (object instanceof Subject) {
                                    subject2 = (Subject)object;
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Logging in with initial context token.");
                                    }
                                    byArray = (byte[])object;
                                }
                            }
                            if (subject2 == null) {
                                subject2 = string2 == null ? this.getJaasLoginHelper().jaas_login(byArray, subject) : (httpServletRequest == null ? this.getJaasLoginHelper().jaas_login(byArray, string2, subject) : this.getJaasLoginHelper().jaas_login(byArray, string2, httpServletRequest, httpServletResponse, map, subject));
                            }
                            if (subject2 != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Adding propagation login Subject to cache.");
                                }
                                if (string3 != null) {
                                    this.cache.insert(subject2, new Object[]{string3, byArray});
                                } else {
                                    this.cache.insert(subject2, new Object[]{byArray});
                                }
                            }
                        }
                        if (subject2 != null) {
                            try {
                                object = SubjectHelper.getWSCredentialFromSubject(subject2);
                                if (object != null) {
                                    boolean bl = object.isDestroyed();
                                    boolean bl2 = this.getWSCredTokenMapper().checkValidityOfAllTokens(subject2);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("login(realm, token, . . .): is subject valid? " + bl2));
                                    }
                                    if (bl || !bl2) {
                                        String string4 = object.getRealmName();
                                        String string5 = object.getSecurityName();
                                        this.cache.removeEntry(string4, string5);
                                        subject2 = null;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Credential has expired or is destroyed, logging in again.");
                                        }
                                        break block51;
                                    }
                                    if (tc.isEntryEnabled()) {
                                        Tr.exit((TraceComponent)tc, (String)"login(realm, token, auth_mech, . . .)");
                                    }
                                    return subject2;
                                }
                                subject2 = null;
                            }
                            catch (CredentialDestroyedException credentialDestroyedException) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Credential is destroyed.", (Object)new Object[]{credentialDestroyedException});
                                }
                                subject2 = null;
                            }
                            catch (CredentialExpiredException credentialExpiredException) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Credential has expired.", (Object)new Object[]{credentialExpiredException});
                                }
                                subject2 = null;
                            }
                        }
                    }
                    if (subject2 == null && (subject2 = string2 == null ? this.getJaasLoginHelper().jaas_login(byArray, subject) : (httpServletRequest == null ? this.getJaasLoginHelper().jaas_login(byArray, string2, subject) : this.getJaasLoginHelper().jaas_login(byArray, string2, httpServletRequest, httpServletResponse, map, subject))) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Adding new Subject to cache.");
                        }
                        if (string3 != null) {
                            this.cache.insert(subject2, new Object[]{string3, byArray});
                        } else {
                            this.cache.insert(subject2, new Object[]{byArray});
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"login(realm, token, auth_mech, . . .)");
                    }
                    return subject2;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, token, auth_mech, . . .)");
                }
                throw new WSLoginFailedException("Token can not be validated on a pure client or authentication target is basic authen");
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.auth.distContextManagerImpl.login", (String)"1333", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("login failed: " + wSLoginFailedException));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, token, auth_mech, . . .)");
                }
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.login", (String)"1340", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("login failed: " + this.dump(exception)));
                }
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(realm, token, auth_mech, . . .)");
                }
                throw wSLoginFailedException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login(realm, token, auth_mech, . . .)");
        }
        return null;
    }

    private void processSubjectForPropagationAfterLogin(Subject subject, String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processSubjectForPropagationAfterLogin");
        }
        try {
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            if (this.secConfig.isWebInboundPropagationEnabled() || "oid:1.2.840.113554.1.2.2".endsWith(wSCredential.getOID())) {
                if (wSCredential.isForwardable()) {
                    SingleSignonToken singleSignonToken = SubjectHelper.getDefaultSSOTokenFromSubject(subject);
                    if (singleSignonToken != null) {
                        Object object;
                        ByteArray byteArray = new ByteArray(singleSignonToken.getBytes());
                        long l = System.currentTimeMillis();
                        long l2 = wSCredential.getExpiration();
                        long l3 = l2 - l;
                        int n = (int)(l3 / 1000L);
                        if (this.secConfig.isWebInboundPropagationEnabled() && (object = (byte[])this.getDistributedObject(byteArray)) == null) {
                            object = WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromSubject(subject);
                            if (l3 > 0L && object != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Adding opaque token to distributed cache with timeToLive " + n + " seconds."));
                                }
                                this.putDistributedObject(byteArray, object, n);
                            }
                        }
                        if ("oid:1.2.840.113554.1.2.2".endsWith(wSCredential.getOID()) && (object = (Object)SubjectHelper.getGSSCredentialFromSubject(subject)) != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Adding GSSCredential to local cache with timeToLive " + n + " seconds."));
                            }
                            this.putDistributedObjectNotShared(byteArray, object, n);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Cannot find LtpaToken2, not adding opaque token to distributed cache.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WSCredential is not forwardable, not adding to distributed cache.");
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception adding opaque authz token to distributed cache.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.processSubjectForPropagationAfterLogin", (String)"1426", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processSubjectForPropagationAfterLogin");
        }
    }

    private Subject getSubjectFromHashtableCacheKey(Subject subject) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubjectFromHashtableCacheKey");
        }
        Subject subject2 = null;
        Object object = null;
        if (subject != null) {
            object = this.getWSCredTokenMapper().getCacheKeyFromHashtable(subject);
            if (object != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Looking for Subject using cacheKey (" + object + ") from hashtable."));
                }
                subject2 = object instanceof byte[] ? this.cache.getSubject((byte[])object) : this.cache.getSubject(object);
            }
            if (subject2 != null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found Subject using TAI cacheKey.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubjectFromHashtableCacheKey");
        }
        return subject2;
    }

    private Object[] getSubjectFromTokenHolderCacheKey(byte[] byArray, List list) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubjectFromTokenHolderCacheKey");
        }
        Subject subject = null;
        String string = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                boolean bl;
                TokenHolder tokenHolder = (TokenHolder)list.get(i);
                if (!tokenHolder.getName().equals("com.ibm.wsspi.security.cred.cacheKey")) continue;
                byte[] byArray2 = tokenHolder.getBytes();
                if (byArray2 != null) {
                    string = StringBytesConversion.getConvertedString(byArray2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found cache key from token holder list: " + string));
                    }
                    subject = this.cache.getSubject(string);
                }
                if (subject == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found Subject using cacheKey from prop token.");
                }
                if (byArray == null) continue;
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                SingleSignonToken singleSignonToken = SubjectHelper.getDefaultSSOTokenFromSubject(subject);
                boolean bl2 = bl = wSCredential != null && Arrays.equals(byArray, wSCredential.getCredentialToken()) || singleSignonToken != null && Arrays.equals(byArray, singleSignonToken.getBytes());
                if (bl) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Subject found from cacheKey does not have matching LTPA token.");
                }
                subject = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubjectFromTokenHolderCacheKey");
        }
        Object[] objectArray = null;
        if (subject != null) {
            objectArray = new Object[]{subject, string};
            return objectArray;
        }
        return objectArray;
    }

    private Object getOpaqueTokenFromCacheOrOriginatingServer(byte[] byArray) throws WSLoginFailedException {
        Object object;
        block44: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getOpaqueTokenFromCacheOrOriginatingServer");
            }
            Subject subject = null;
            object = null;
            try {
                Cloneable cloneable;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Getting distributed object from DynaCache.");
                }
                String[] stringArray = null;
                String[] stringArray2 = null;
                ByteArray byteArray = new ByteArray(byArray);
                byte[] byArray2 = (byte[])this.getDistributedObject(byteArray);
                Properties properties = new Properties();
                String[] stringArray3 = null;
                GSSCredential gSSCredential = (GSSCredential)this.getDistributedObjectNotShared(byteArray);
                if (gSSCredential != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Setting return_object = GSSCredential.");
                    }
                    object = gSSCredential;
                }
                if (byArray2 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Not found in DynaCache, getting distributed object using MBean.");
                    }
                    if ((stringArray = (cloneable = this.getWSCredTokenMapper().validateLTPAToken(byArray)).getAttributes("process.serverName")) != null && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("serverName is " + stringArray[0]));
                    }
                    stringArray2 = cloneable.getAttributes("hashed_uid");
                    String[] stringArray4 = cloneable.getAttributes("java.naming.provider.url");
                    String[] stringArray5 = cloneable.getAttributes("type");
                    String[] stringArray6 = cloneable.getAttributes("host");
                    String[] stringArray7 = cloneable.getAttributes("port");
                    stringArray3 = cloneable.getAttributes("security.authMechOID");
                    if (stringArray2 != null && stringArray2[0] != null) {
                        subject = this.cache.getSubject(stringArray2[0]);
                    }
                    if (subject != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Found subject using token unique ID: " + stringArray2));
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"getSubjectFromDynaCacheOrOriginatingServer");
                        }
                        return subject;
                    }
                    if (this.secConfig.getWebPropagationTransport().equals("IIOP") && stringArray4 != null) {
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        hashtable.put("java.naming.provider.url", stringArray4[0]);
                        hashtable.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
                        byArray2 = this.getOpaqueTokenFromCorbaObject(byteArray, hashtable);
                    } else if (byteArray != null && stringArray5 != null && stringArray6 != null && stringArray7 != null && stringArray != null && stringArray[0] != null) {
                        properties.setProperty("type", stringArray5[0]);
                        properties.setProperty("host", stringArray6[0]);
                        properties.setProperty("port", stringArray7[0]);
                        if (gSSCredential == null && stringArray3 != null && stringArray3[0] != null && "oid:1.2.840.113554.1.2.2".endsWith(stringArray3[0])) {
                            byte[] byArray3;
                            if (stringArray != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Get token from Mbean " + byteArray + stringArray[0]));
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"serverName is null");
                            }
                            if ((byArray3 = this.getInitialContextTokenFromMBean(byteArray, stringArray[0], properties)) == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Token is null");
                                }
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Setting return_object = initial context token.");
                                }
                                object = byArray3;
                            }
                        }
                        byArray2 = this.getOpaqueTokenFromMBean(byteArray, stringArray[0], properties);
                    }
                }
                if (byArray2 != null) {
                    cloneable = null;
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Getting token holder list from opaque token.");
                        }
                        if ((cloneable = WSOpaqueTokenHelper.getInstance().createTokenHolderListFromOpaqueToken(byArray2)) != null) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"Token holder list has been set on the thread.");
                            }
                            this.put(WSOpaqueTokenHelper.getInstance().getOpaqueTokenLookup(), cloneable);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Failed to get token holder list.");
                        }
                        break block44;
                    }
                    catch (WSSecurityException wSSecurityException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Failed to get token holder list.", (Object)new Object[]{wSSecurityException});
                        }
                        break block44;
                    }
                }
                if (stringArray2 != null && stringArray2[0] != null && this.secConfig.isWebChallengeIfCustomSubjectNotFound()) {
                    throw new WSLoginFailedException("SSO token uniqueID not null, but opaque token not found.  Need to re-challenge the user to login again.");
                }
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getSubjectFromDynaCacheOrOriginatingServer", (String)"1675", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception getting opaque token from originating server.", (Object)new Object[]{wSLoginFailedException});
                }
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getSubjectFromDynaCacheOrOriginatingServer", (String)"1681", (Object)this);
                if (!tc.isDebugEnabled()) break block44;
                Tr.debug((TraceComponent)tc, (String)"Exception getting opaque token from originating server.");
            }
        }
        if (object != null && object instanceof GSSCredential) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSubjectFromDynaCacheOrOriginatingServer (GSSCredential)");
            } else if (object != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getSubjectFromDynaCacheOrOriginatingServer (byte[])");
                } else if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getSubjectFromDynaCacheOrOriginatingServer (null)");
                }
            }
        }
        return object;
    }

    private byte[] getOpaqueTokenFromMBean(final ByteArray byteArray, final String string, final Properties properties) {
        byte[] byArray;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getOpaqueTokenFromMBean", (Object)new Object[]{string, properties});
            }
            byArray = null;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        return distContextManagerImpl.this.getWSCredTokenMapper().getOpaqueTokenFromMBean(byteArray, string, properties);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getOpaqueTokenFromMBean", (String)"1716", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Exception getting opaque token from originating server.");
                        }
                        return null;
                    }
                }
            };
            try {
                byArray = (byte[])this.runAsSystem(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.auth.distContextManagerImpl.getOpaqueTokenFromMBean", (String)"1731", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Exception getting opaque token from originating server.", (Object)new Object[]{privilegedActionException.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOpaqueTokenFromMBean");
        }
        return byArray;
    }

    private byte[] getOpaqueTokenFromCorbaObject(final ByteArray byteArray, final Hashtable hashtable) {
        byte[] byArray;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getOpaqueTokenFromCorbaObject", (Object)new Object[]{hashtable});
            }
            byArray = null;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    block4: {
                        try {
                            TokenHolder tokenHolder;
                            com.ibm.ws.security.server.SecurityServer securityServer;
                            InitialContext initialContext = new InitialContext(hashtable);
                            Object object = initialContext.lookup("SecurityServer");
                            if (object != null && (securityServer = (com.ibm.ws.security.server.SecurityServer)PortableRemoteObject.narrow((Object)object, (Class)(class$com$ibm$ws$security$server$SecurityServer == null ? (class$com$ibm$ws$security$server$SecurityServer = distContextManagerImpl.class$("com.ibm.ws.security.server.SecurityServer")) : class$com$ibm$ws$security$server$SecurityServer))) != null && (tokenHolder = securityServer.getOpaqueToken(byteArray)) != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Returning byte[] from getOpaqueTokenFromCorbaObject.");
                                }
                                return tokenHolder.getBytes();
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getOpaqueTokenFromCorbaObject", (String)"1779", (Object)this);
                            if (!tc.isDebugEnabled()) break block4;
                            Tr.debug((TraceComponent)tc, (String)"Exception getting opaque token from originating server.", (Object)new Object[]{exception});
                        }
                    }
                    return null;
                }
            };
            try {
                byArray = (byte[])this.runAsSpecified(this.getUnauthenticatedSubject(), privilegedExceptionAction);
            }
            catch (WSSecurityException wSSecurityException) {
                FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getOpaqueTokenFromCorbaObject", (String)"1794", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception getting opaque token from originating server.", (Object)new Object[]{wSSecurityException});
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.auth.distContextManagerImpl.getOpaqueTokenFromCorbaObject", (String)"1799", (Object)this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"Exception getting opaque token from originating server.", (Object)new Object[]{privilegedActionException.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOpaqueTokenFromCorbaObject");
        }
        return byArray;
    }

    private byte[] getInitialContextTokenFromMBean(final ByteArray byteArray, final String string, final Properties properties) {
        byte[] byArray;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getInitialContextTokenFromMBean", (Object)new Object[]{string, properties});
            }
            byArray = null;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        return distContextManagerImpl.this.getWSCredTokenMapper().getInitialContextTokenFromMBean(byteArray, string, properties);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getInitialContextTokenFromMBean", (String)"1827", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Exception getting initial context token from originating server.");
                        }
                        return null;
                    }
                }
            };
            try {
                byArray = (byte[])this.runAsSystem(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.auth.distContextManagerImpl.getInitialContextTokenFromMBean", (String)"1842", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Exception getting initial context token from originating server.", (Object)new Object[]{privilegedActionException.getException()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInitialContextTokenFromMBean");
        }
        return byArray;
    }

    public Subject login(String string, Object object, Subject subject) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login(auth_mech, protocolPolicy, invocation_subject)");
        }
        if (this.isCellSecurityEnabled() && object != null && subject != null) {
            if (this.secConfig == null || !this.secConfig.processIsServer()) {
                return null;
            }
            try {
                Subject subject2 = this.getJaasLoginHelper().jaas_login(string, object, subject);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(auth_mech, protocolPolicy, invocation_subject)");
                }
                return subject2;
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.auth.distContextManagerImpl.login", (String)"1871", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("login failed: " + wSLoginFailedException));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(auth_mech, protocolPolicy, invocation_subject)");
                }
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.login", (String)"1878", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("login failed: " + this.dump(exception)));
                }
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login(auth_mech, protocolPolicy, invocation_subject)");
                }
                throw wSLoginFailedException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login(auth_mech, protocolPolicy, invocation_subject)");
        }
        return null;
    }

    public WSCredential createBasicAuthCredential(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            return new WSCredentialImpl(this.getDefaultRealm(), string2, string3);
        }
        return new WSCredentialImpl(string, string2, string3);
    }

    public WSCredential authenticate(WSCredential wSCredential) throws AuthenticationFailedException {
        if (wSCredential == null) {
            Tr.debug((TraceComponent)tc, (String)"Credential passed in is null.");
            return null;
        }
        try {
            Subject subject = this.login(wSCredential);
            return SubjectHelper.getWSCredentialFromSubject(subject);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.auth.distContextManagerImpl.authenticate", (String)"1917", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authenticate failed: " + this.dump(wSLoginFailedException)));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(wSLoginFailedException.getMessage());
            authenticationFailedException.addException(wSLoginFailedException);
            throw authenticationFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.authenticate", (String)"1928", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authenticate failed: " + this.dump(exception)));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(exception.getMessage());
            authenticationFailedException.addException(exception);
            throw authenticationFailedException;
        }
    }

    public WSCredential authenticate(String string, String string2, String string3) throws AuthenticationFailedException {
        try {
            Subject subject = this.login(string, string2, string3);
            return SubjectHelper.getWSCredentialFromSubject(subject);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.auth.distContextManagerImpl.authenticate", (String)"1948", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authenticate failed: " + this.dump(wSLoginFailedException)));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(wSLoginFailedException.getMessage());
            authenticationFailedException.addException(wSLoginFailedException);
            throw authenticationFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.authenticate", (String)"1959", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authenticate failed: " + this.dump(exception)));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(exception.getMessage());
            authenticationFailedException.addException(exception);
            throw authenticationFailedException;
        }
    }

    public WSCredential authenticate(String string, byte[] byArray) throws AuthenticationFailedException {
        try {
            Subject subject = this.login(string, byArray);
            return SubjectHelper.getWSCredentialFromSubject(subject);
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, (String)"com.ibm.ws.security.auth.distContextManagerImpl.authenticate", (String)"1979", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authenticate failed: " + this.dump(loginException)));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(loginException.getMessage());
            authenticationFailedException.addException(loginException);
            throw authenticationFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.authenticate", (String)"1990", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authenticate failed: " + this.dump(exception)));
            }
            AuthenticationFailedException authenticationFailedException = new AuthenticationFailedException(exception.getMessage());
            authenticationFailedException.addException(exception);
            throw authenticationFailedException;
        }
    }

    public Subject getServerSubject() throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerSubject");
        }
        if (this.isCellSecurityEnabled()) {
            if (this.serverSubject == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"BOOTSTRAP MODE: Returning BasicAuth server subject.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getServerSubject");
                }
                return this.serverBASubject;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getServerSubject");
            }
            return this.getServerSubjectInternal();
        }
        return null;
    }

    public Subject getServerSubjectInternal() throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            block29: {
                if (this.secConfig == null || !this.secConfig.processIsServer()) {
                    return null;
                }
                if (this.getRegistryObject() == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"BOOTSTRAP MODE: Returning unauthenticated server subject.");
                    }
                    return this.getUnauthenticatedSubject();
                }
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                        Tr.debug((TraceComponent)tc, (String)("Expecting : " + GET_SERVER_CRED_PERM.toString()));
                    }
                    securityManager.checkPermission((Permission)GET_SERVER_CRED_PERM);
                }
                if (this.serverTokenCred != null && !this.serverTokenCred.isDestroyed()) {
                    boolean bl = true;
                    try {
                        long l = this.serverTokenCred.getExpiration();
                        if (l == -1L || l == 0L) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Server Subject does not expire.");
                            }
                            return this.serverSubject;
                        }
                        bl = this.getWSCredTokenMapper().checkCushionValidityOfAllTokens(this.serverSubject, this.cache.getCushion());
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Is server subject valid? " + bl));
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getServerCredential", (String)"2076");
                        Tr.error((TraceComponent)tc, (String)"security.SecurityContext.getActualCreds", (Object)new Object[]{exception});
                        throw new WSSecurityException(exception.getMessage(), exception);
                    }
                    if (bl) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Server Subject returned with sufficient time left.");
                        }
                        return this.serverSubject;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Server Subject expired, refreshing...");
                    }
                    try {
                        if (this.serverAuthToken != null) {
                            this.serverAuthToken = (AuthenticationToken)this.serverAuthToken.clone();
                        }
                        if (this.serverAuthzToken != null) {
                            this.serverAuthzToken = (AuthorizationToken)this.serverAuthzToken.clone();
                        }
                        if (this.serverSSOToken != null) {
                            this.serverSSOToken = (SingleSignonToken)this.serverSSOToken.clone();
                        }
                        if (this.serverAuthToken != null && this.serverAuthzToken != null) {
                            WSCredential wSCredential = this.getWSCredTokenMapper().createWSCredentialFromTokens(this.serverAuthToken.getBytes(), this.serverAuthzToken);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Updating server Subject with new wsCred token.");
                            }
                            ((WSCredentialImpl)this.serverTokenCred).refreshCred(wSCredential);
                        }
                        if (!this.secConfig.isRMIInboundPropagationEnabled() && !this.secConfig.isRMIOutboundPropagationEnabled() && !this.secConfig.isWebInboundPropagationEnabled()) break block29;
                        try {
                            final Subject subject = this.serverSubject;
                            final AuthorizationToken authorizationToken = this.serverAuthzToken;
                            final AuthenticationToken authenticationToken = this.serverAuthToken;
                            final SingleSignonToken singleSignonToken = this.serverSSOToken;
                            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                                public Object run() throws WSLoginFailedException, WSSecurityException {
                                    Iterator<Object> iterator = subject.getPrivateCredentials().iterator();
                                    while (iterator.hasNext()) {
                                        Object object = iterator.next();
                                        if (object instanceof AuthorizationToken) {
                                            ((AbstractTokenImpl)object).setToken(((AbstractTokenImpl)((Object)authorizationToken)).getToken());
                                            continue;
                                        }
                                        if (object instanceof AuthenticationToken) {
                                            ((AbstractTokenImpl)object).setToken(((AbstractTokenImpl)((Object)authenticationToken)).getToken());
                                            continue;
                                        }
                                        if (!(object instanceof SingleSignonToken)) continue;
                                        ((AbstractTokenImpl)object).setToken(((AbstractTokenImpl)((Object)singleSignonToken)).getToken());
                                    }
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.auth.distContextManagerImpl.getServerSubject", (String)"2148", (Object)this);
                            this.setRootException(privilegedActionException.getException());
                            throw new WSSecurityException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getServerCredential", (String)"2156");
                    }
                } else if (this.serverTokenCred == null) {
                    try {
                        WSCredential wSCredential;
                        Subject subject = this.login(this.getDefaultRealm(), this.secConfig.getloginUserid(), this.secConfig.getloginPassword());
                        this.cache.insert(subject, this.secConfig.getloginPassword(), new Object[]{this.secConfig.getloginUserid()});
                        this.serverTokenCred = wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                        this.serverSubject = subject;
                        this.serverSubject.setReadOnly();
                        ((WSCredentialImpl)this.serverTokenCred).markServerCred(scs.getEncryptedServerSigner());
                        if (this.serverTokenCred.isForwardable()) {
                            this.serverAuthToken = this.getWSCredTokenMapper().createAuthTokenFromWSCredential(this.serverTokenCred);
                            this.serverAuthzToken = this.getWSCredTokenMapper().createAuthzTokenFromWSCredential(this.serverTokenCred);
                            this.serverSSOToken = this.getWSCredTokenMapper().createSSOTokenFromWSCredential(this.serverTokenCred);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getServerCredential", (String)"109");
                        Tr.error((TraceComponent)tc, (String)"security.SecurityContext.getActualCreds", (Object)new Object[]{exception});
                        throw new WSSecurityException(exception.getMessage(), exception);
                    }
                }
            }
            return this.serverSubject;
        }
        return null;
    }

    public synchronized WSCredential getServerCredential() throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            if (this.secConfig == null || !this.secConfig.processIsServer()) {
                return null;
            }
            Subject subject = this.getServerSubject();
            return SubjectHelper.getWSCredentialFromSubject(subject);
        }
        return null;
    }

    public Subject pushInvocationSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                Subject subject2 = this.getInvocationSubject();
                this.setInvocationSubject(subject);
                return subject2;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.pushInvocationSubject", (String)"2224", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        return null;
    }

    public void popInvocationSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                this.setInvocationSubject(subject);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.popInvocationSubject", (String)"2242", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public Subject pushReceivedSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                Subject subject2 = this.getCallerSubject();
                this.setCallerSubject(subject);
                return subject2;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.pushReceivedSubject", (String)"2260", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        return null;
    }

    public void popReceivedSubject(Subject subject) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                this.setCallerSubject(subject);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.popReceivedSubject", (String)"2278", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public void clearRootException() {
        this.setRootException(null);
    }

    public void setRootException(Throwable throwable) {
        Throwable throwable2;
        if (this.getCurrent() != null && (throwable2 = this.getCurrent().getRootException()) == null) {
            this.getCurrent().setRootException(throwable);
        }
    }

    public Throwable getRootException() {
        if (this.getCurrent() != null) {
            return this.getCurrent().getRootException();
        }
        return null;
    }

    public Subject getCallerSubject() throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                return this.getCurrent().get_caller_subject();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getCallerSubject", (String)"2328", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getCallerSubject(): CurrentImpl is null");
        }
        return null;
    }

    public void setCallerSubject(Subject subject) throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                this.getCurrent().set_caller_subject(subject);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.setCallerSubject", (String)"2349", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public boolean callerSubjectIsServerIdentity() {
        Object object;
        WSCredential wSCredential = null;
        if (this.serverUniqueIdentity == null) {
            try {
                object = this.getServerSubject();
                WSCredential wSCredential2 = SubjectHelper.getWSCredentialFromSubject((Subject)object);
                this.serverUniqueIdentity = wSCredential2.getRealmUniqueSecurityName();
            }
            catch (WSSecurityException wSSecurityException) {
                FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.auth.distContextManagerImpl.callerSubjectIsServerIdentity", (String)"2364", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getServerSubject() failed; callerSubjectIsServerIdentity returning false", (Object)wSSecurityException);
                }
                return false;
            }
            catch (CredentialExpiredException credentialExpiredException) {
                FFDCFilter.processException((Throwable)credentialExpiredException, (String)"com.ibm.ws.security.auth.distContextManagerImpl.callerSubjectIsServerIdentity", (String)"2369", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getRealmUniqueSecurityName() on server credential failed; callerSubjectIsServerIdentity returning false", (Object)credentialExpiredException);
                }
                return false;
            }
        }
        try {
            object = this.getCallerSubject();
            wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)object);
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.auth.distContextManagerImpl.callerSubjectIsServerIdentity", (String)"2379", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getCallerSubject() failed; callerSubjectIsServerIdentity returning false", (Object)wSSecurityException);
            }
            return false;
        }
        if (wSCredential == null) {
            return false;
        }
        if (wSCredential.isCurrent() && !wSCredential.isUnauthenticated()) {
            try {
                object = wSCredential.getRealmUniqueSecurityName();
                if (object != null) {
                    if (((String)object).equals(this.serverUniqueIdentity)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"callerSubjectIsServerIdentity returning true");
                        }
                        return true;
                    }
                    if (((String)object).equalsIgnoreCase(this.serverUniqueIdentity) && this.isIgnoreCaseAuthorization()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"callerSubjectIsServerIdentity returning true");
                        }
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.callerSubjectIsServerIdentity", (String)"2406", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getRealmUniqueSecurityName() failed; callerSubjectIsServerIdentity returning false", (Object)exception);
                }
                return false;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"callerSubjectIsServerIdentity returning false");
        }
        return false;
    }

    public Subject getInvocationSubject() throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                return this.getCurrent().get_invocation_subject();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getInvocationSubject", (String)"2427", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getInvocationSubject(): CurrentImpl is null");
        }
        return null;
    }

    public void setInvocationSubject(Subject subject) throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                this.getCurrent().set_invocation_subject(subject);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.setInvocationSubject", (String)"2448", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public void addWSSubjectToCache(Subject subject) throws WSSecurityException {
        if (subject != null && this.processIsServer() && this.isWSSubject(subject)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Adding WSSubject to cache.");
            }
            this.cache.insert(subject, (Object[])null);
            this.processSubjectForPropagationAfterLogin(subject, this.secConfig.getAuthMechAuthAlias());
        }
    }

    public Subject getOwnSubject() throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                return this.getCurrent().get_own_subject();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getOwnSubject", (String)"2474", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getOwnSubject(): CurrentImpl is null");
        }
        return null;
    }

    public void setOwnSubject(Subject subject) throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                this.getCurrent().set_own_subject(subject);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.setOwnSubject", (String)"2495", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public WSCredential[] getCallerCredentials() throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                return this.getCurrent().get_ws_received_credentials();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getCallerCredentials", (String)"2512", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        return null;
    }

    public void setCallerCredentials(WSCredential[] wSCredentialArray) throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                this.getCurrent().set_ws_received_credentials(wSCredentialArray);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.setCallerCredentials", (String)"2530", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public WSCredential getInvocationCredential() throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                return this.getCurrent().get_ws_invocation_credentials();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getInvocationCredential", (String)"2546", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getInvocationCredential(): CurrentImpl is null");
        }
        return null;
    }

    public void setInvocationCredential(WSCredential wSCredential) throws WSSecurityException {
        if (this.getCurrent() != null) {
            try {
                this.getCurrent().set_ws_invocation_credentials(wSCredential);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.setInvocationCredential", (String)"2567", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    public WSCredential pushInvocationCredential(WSCredential wSCredential) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                WSCredential wSCredential2 = this.getInvocationCredential();
                this.setInvocationCredential(wSCredential);
                return wSCredential2;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.pushInvocationCredential", (String)"2585", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        return null;
    }

    public void popInvocationCredential(WSCredential wSCredential) throws WSSecurityException {
        if (this.isCellSecurityEnabled()) {
            try {
                this.setInvocationCredential(wSCredential);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.popInvocationCredential", (String)"2602", (Object)this);
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
    }

    private void checkAuthRetryForThread() {
        Boolean bl = (Boolean)this.get("wssecurity.disableauthretry");
        if (bl != null && bl.booleanValue()) {
            this.getCurrent().setAuthRetryForJAAS(false);
        }
    }

    public Object get(String string) {
        if (this.isCellSecurityEnabled()) {
            return this.getCurrent().getProperty(string);
        }
        return null;
    }

    public Object put(String string, Object object) {
        if (this.isCellSecurityEnabled()) {
            return this.getCurrent().setProperty(string, object);
        }
        return null;
    }

    public boolean contains(String string) {
        if (this.isCellSecurityEnabled()) {
            return this.getCurrent().containsProperty(string);
        }
        return false;
    }

    public Object runAsSystem(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return this.runAs(null, privilegedExceptionAction, "System");
    }

    public Object runAsReceivedClient(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return this.runAs(null, privilegedExceptionAction, "ReceivedClient");
    }

    public Object runAsClient(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return this.runAs(null, privilegedExceptionAction, "Client");
    }

    public Object runAsSpecified(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return this.runAs(subject, privilegedExceptionAction, "Specified");
    }

    public Object runAsSpecified(WSCredential wSCredential, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return this.runAs(SubjectHelper.createSubjectFromWSCredential(wSCredential), privilegedExceptionAction, "Specified");
    }

    private Object runAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, String string) throws PrivilegedActionException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("runAs(" + string + ")"));
        }
        String string2 = EMPTY;
        String string3 = "ContextManager.runAs";
        Subject subject2 = null;
        Subject subject3 = null;
        Object var8_8 = null;
        if (ConfigURLProperties.isSecurityEnabled()) {
            try {
                Subject subject4;
                Subject subject5 = null;
                if (string.equals("System")) {
                    subject5 = this.getServerSubject();
                    if (subject5 != null) {
                        subject3 = this.pushReceivedSubject(subject5);
                    }
                } else if (string.equals("Client")) {
                    subject4 = this.getCallerSubject();
                    subject5 = subject4 != null ? subject4 : this.getInvocationSubject();
                } else if (string.equals("ReceivedClient")) {
                    subject4 = this.getCallerSubject();
                    if (subject4 != null) {
                        subject5 = subject4;
                    }
                } else if (string.equals("Specified")) {
                    subject5 = subject;
                }
                subject2 = this.pushInvocationSubject(subject5);
            }
            catch (Exception exception) {
                try {
                    if (subject2 != null) {
                        this.popInvocationSubject(subject2);
                        subject2 = null;
                    }
                    if (subject3 != null) {
                        this.popReceivedSubject(subject3);
                        subject3 = null;
                    }
                }
                catch (Exception exception2) {
                    try {
                        if (subject3 != null) {
                            this.popReceivedSubject(subject3);
                            subject3 = null;
                        }
                    }
                    catch (Exception exception3) {
                        FFDCFilter.processException((Throwable)exception3, (String)"com.ibm.ws.security.auth.distContextManagerImpl.runAs", (String)"2767", (Object)this);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)("runAs(" + string + ") -> Exception occurred."), (Object)new Object[]{exception3});
                        }
                        throw new PrivilegedActionException(exception3);
                    }
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.runAs", (String)"2772", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("runAs(" + string + ") -> Exception occurred."), (Object)new Object[]{exception});
                }
                throw new PrivilegedActionException(exception);
            }
        }
        try {
            var8_8 = privilegedExceptionAction.run();
        }
        catch (Exception exception) {
            if (ConfigURLProperties.isSecurityEnabled()) {
                try {
                    if (subject2 != null) {
                        this.popInvocationSubject(subject2);
                        subject2 = null;
                    }
                    if (subject3 != null) {
                        this.popReceivedSubject(subject3);
                        subject3 = null;
                    }
                }
                catch (Exception exception4) {
                    try {
                        if (subject3 != null) {
                            this.popReceivedSubject(subject3);
                            subject3 = null;
                        }
                    }
                    catch (Exception exception5) {
                        FFDCFilter.processException((Throwable)exception5, (String)"com.ibm.ws.security.auth.distContextManagerImpl.runAs", (String)"2816", (Object)this);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)("runAs(" + string + ") -> Exception occurred."), (Object)new Object[]{exception5});
                        }
                        throw new PrivilegedActionException(exception5);
                    }
                }
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.runAs", (String)"2823", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("runAs(" + string + ") -> Exception occurred."), (Object)new Object[]{exception});
            }
            throw new PrivilegedActionException(exception);
        }
        if (ConfigURLProperties.isSecurityEnabled()) {
            try {
                this.popInvocationSubject(subject2);
                if (subject3 != null) {
                    this.popReceivedSubject(subject3);
                    subject3 = null;
                }
            }
            catch (Exception exception) {
                try {
                    if (subject2 != null) {
                        this.popInvocationSubject(subject2);
                        subject2 = null;
                    }
                    if (subject3 != null) {
                        this.popReceivedSubject(subject3);
                        subject3 = null;
                    }
                }
                catch (Exception exception6) {
                    FFDCFilter.processException((Throwable)exception6, (String)"com.ibm.ws.security.auth.distContextManagerImpl.runAs", (String)"2860", (Object)this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("runAs(" + string + ") -> Exception occurred."), (Object)new Object[]{exception6});
                    }
                    throw new PrivilegedActionException(exception6);
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.runAs", (String)"2865", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("runAs(" + string + ") -> Exception occurred."), (Object)new Object[]{exception});
                }
                throw new PrivilegedActionException(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("runAs(" + string + ")"));
        }
        return var8_8;
    }

    public WSPrincipal createPrincipal(WSCredential wSCredential) throws WSSecurityException {
        return SubjectHelper.createPrincipal(wSCredential);
    }

    public void initializeSystemContext() throws WSSecurityException {
        if (this.getCurrent() != null) {
            this.getCurrent().initialize_requestor_context(this.creds);
        }
    }

    public void initializeCallerContext(Subject subject) throws WSSecurityException {
        if (this.getCurrent() != null) {
            this.getCurrent().initialize_requestor_context(subject);
        }
    }

    public void initializeCallerContext(WSCredential[] wSCredentialArray) throws WSSecurityException {
        if (this.getCurrent() != null) {
            this.getCurrent().initialize_ws_requestor_context(wSCredentialArray);
        }
    }

    public void clearCallerContext() throws WSSecurityException {
        if (this.getCurrent() != null) {
            this.getCurrent().clear_ws_requestor_context();
        }
    }

    public boolean isCellSecurityEnabled() {
        return ConfigURLProperties.isSecurityEnabled();
    }

    public boolean isServerSecurityEnabled() {
        if (this.getCurrent() != null) {
            return this.getCurrent().isSecurityEnabled() && this.getCurrent().isSSLSecurityTagExported();
        }
        return false;
    }

    public String getClientUniqueIDForOutboundRequests(Subject subject) {
        WSCredentialTokenMapperInterface wSCredentialTokenMapperInterface = null;
        try {
            wSCredentialTokenMapperInterface = this.getWSCredTokenMapper();
            if (wSCredentialTokenMapperInterface != null && subject != null) {
                return wSCredentialTokenMapperInterface.createUniqueIDFromAllTokens(subject);
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getClientUniqueIDForOutboundRequests", (String)"2945");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught exception.", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    public byte[] getClientUniqueIDArrayForOutboundRequests(Subject subject) {
        Object var2_2 = null;
        byte[] byArray = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getClientUniqueIDArrayForOutboundRequests(" + subject + ")"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getClientUniqueIDArrayForOutboundRequests returns " + byArray));
        }
        return byArray;
    }

    public boolean getServerSecurityEnabled() {
        return this.serverSecurityEnabled;
    }

    public void setServerSecurityEnabled(boolean bl) {
        this.serverSecurityEnabled = bl;
    }

    public void setPlatformHelper(PlatformHelper platformHelper) {
        PlatformHelperFactory.setPlatformHelper((PlatformHelper)platformHelper);
    }

    public PlatformHelper getPlatformHelper() {
        return PlatformHelperFactory.getPlatformHelper();
    }

    public long getReqTimeout() {
        long l = this.theORB.getRequestTimeout() - 5000;
        return l;
    }

    public boolean isSynctoThreadEnabled() {
        return enableSyncOSThread;
    }

    public String getRegionId() {
        return this.regionUserid;
    }

    public String getDefaultSAFRealm() {
        return this.DefaultSAFRealm;
    }

    private String dump(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private SecurityServer getSecurityServer() throws AuthenticationFailedException {
        if (this.securityServer == null) {
            try {
                this.securityServer = this.vault.getSecurityServer();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getSecurityServer", (String)"3042");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)EMPTY, (Object)exception);
                }
                this.securityServer = null;
                throw new AuthenticationFailedException(exception.getMessage());
            }
        }
        return this.securityServer;
    }

    private JaasLoginHelper getJaasLoginHelper() throws WSSecurityException {
        if (this.jaasLoginHelper == null) {
            try {
                this.jaasLoginHelper = new JaasLoginHelper(this.secConfig.getAuthMechAuthAlias());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"JaasLoginHelper()");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManager.getJaasLoginHelper", (String)"3063");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)EMPTY, (Object)exception);
                }
                this.jaasLoginHelper = null;
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        }
        return this.jaasLoginHelper;
    }

    private CurrentImpl getCurrent() {
        block3: {
            if (this.current == null) {
                try {
                    this.init();
                }
                catch (WSSecurityException wSSecurityException) {
                    FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.auth.distContextManager.getCurrent", (String)"1736");
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"Error initializing security.", (Object)new Object[]{wSSecurityException});
                }
            }
        }
        return this.current;
    }

    private Object getDistributedObject(Object object) {
        try {
            return this.getWSCredTokenMapper().getDistributedObject(object);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManager.getDistributedObject", (String)"3121");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error getting distributed object.", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    private Object getDistributedObjectNotShared(Object object) {
        try {
            return this.getWSCredTokenMapper().getDistributedObjectNotShared(object);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManager.getDistributedObjectNotShared", (String)"3155");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error getting none shared distributed object.", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    private Object putDistributedObject(Object object, Object object2, int n) {
        try {
            return this.getWSCredTokenMapper().putDistributedObject(object, object2, n);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManager.getDistributedObject", (String)"3199");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error setting distributed object.", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    private Object putDistributedObjectNotShared(Object object, Object object2, int n) {
        try {
            return this.getWSCredTokenMapper().putDistributedObjectNotShared(object, object2, n);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManager.putDistributedObjectNotShared", (String)"3242");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error setting none shared distributed object.", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    private Object putDistributedObject(Object object, Object object2, int n, int n2, int n3, Object[] objectArray) {
        try {
            return this.getWSCredTokenMapper().putDistributedObject(object, object2, n, n2, n3, objectArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManager.getDistributedObject", (String)"3292");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error setting distributed object.", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    private Class getAuthCacheClass() {
        if (this._authCacheClass == null) {
            Class<?> clazz = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz = classLoader != null ? classLoader.loadClass(FACTORY_CLASS) : Class.forName(FACTORY_CLASS);
                this._authCacheClass = clazz;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(class$com$ibm$ws$security$auth$distContextManagerImpl == null ? (class$com$ibm$ws$security$auth$distContextManagerImpl = distContextManagerImpl.class$("com.ibm.ws.security.auth.distContextManagerImpl")) : class$com$ibm$ws$security$auth$distContextManagerImpl).getName(), (String)"3338");
                throw new UndeclaredThrowableException(exception);
            }
        }
        return this._authCacheClass;
    }

    private Method getAuthCacheGetInstanceMethod() {
        Class clazz;
        if (this._authCacheGetInstanceMethod == null && (clazz = this.getAuthCacheClass()) != null) {
            try {
                this._authCacheGetInstanceMethod = clazz.getMethod("getInstance", null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(class$com$ibm$ws$security$auth$distContextManagerImpl == null ? (class$com$ibm$ws$security$auth$distContextManagerImpl = distContextManagerImpl.class$("com.ibm.ws.security.auth.distContextManagerImpl")) : class$com$ibm$ws$security$auth$distContextManagerImpl).getName(), (String)"1813");
                throw new UndeclaredThrowableException(exception);
            }
        }
        return this._authCacheGetInstanceMethod;
    }

    private Class getSecurityServerImplClass() {
        if (this._securityServerImplClass == null) {
            Class<?> clazz = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz = classLoader != null ? classLoader.loadClass(SECURITY_SERVER_IMPL_CLASS) : Class.forName(SECURITY_SERVER_IMPL_CLASS);
                this._securityServerImplClass = clazz;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(class$com$ibm$ws$security$auth$distContextManagerImpl == null ? (class$com$ibm$ws$security$auth$distContextManagerImpl = distContextManagerImpl.class$("com.ibm.ws.security.auth.distContextManagerImpl")) : class$com$ibm$ws$security$auth$distContextManagerImpl).getName(), (String)"3391");
                throw new UndeclaredThrowableException(exception);
            }
        }
        return this._securityServerImplClass;
    }

    private Method getRegistryMethod() {
        Class clazz;
        if (this._getRegistryMethod == null && (clazz = this.getSecurityServerImplClass()) != null) {
            try {
                this._getRegistryMethod = clazz.getMethod("getRegistryImpl", class$java$lang$String == null ? (class$java$lang$String = distContextManagerImpl.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(class$com$ibm$ws$security$auth$distContextManagerImpl == null ? (class$com$ibm$ws$security$auth$distContextManagerImpl = distContextManagerImpl.class$("com.ibm.ws.security.auth.distContextManagerImpl")) : class$com$ibm$ws$security$auth$distContextManagerImpl).getName(), (String)"3412");
                throw new UndeclaredThrowableException(exception);
            }
        }
        return this._getRegistryMethod;
    }

    private Class getSecurityServerFactoryClass() {
        if (this._securityServerFactoryClass == null) {
            Class<?> clazz = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz = classLoader != null ? classLoader.loadClass(SECURITY_SERVER_FACTORY_CLASS) : Class.forName(SECURITY_SERVER_FACTORY_CLASS);
                this._securityServerFactoryClass = clazz;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(class$com$ibm$ws$security$auth$distContextManagerImpl == null ? (class$com$ibm$ws$security$auth$distContextManagerImpl = distContextManagerImpl.class$("com.ibm.ws.security.auth.distContextManagerImpl")) : class$com$ibm$ws$security$auth$distContextManagerImpl).getName(), (String)"3443");
                throw new UndeclaredThrowableException(exception);
            }
        }
        return this._securityServerFactoryClass;
    }

    private Method getSecurityServerCreateMethod() {
        Class clazz;
        if (this._getSecurityServerCreateMethod == null && (clazz = this.getSecurityServerFactoryClass()) != null) {
            try {
                this._getSecurityServerCreateMethod = clazz.getMethod("create", null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(class$com$ibm$ws$security$auth$distContextManagerImpl == null ? (class$com$ibm$ws$security$auth$distContextManagerImpl = distContextManagerImpl.class$("com.ibm.ws.security.auth.distContextManagerImpl")) : class$com$ibm$ws$security$auth$distContextManagerImpl).getName(), (String)"3464");
                throw new UndeclaredThrowableException(exception);
            }
        }
        return this._getSecurityServerCreateMethod;
    }

    private Object getRegistryObject() {
        Method method;
        if (this._registryObject == null && (method = this.getRegistryMethod()) != null) {
            try {
                this._registryObject = method.invoke(null, this.getDefaultRealm());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getRegistryObject", (String)"3488");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception getting registry instance during bootstrap check.", (Object)exception);
                }
                return null;
            }
        }
        if (this._registryObject == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Returning null registryObject, still in BOOTSTRAP mode.");
        }
        return this._registryObject;
    }

    public WSCredentialTokenMapperInterface getWSCredTokenMapper() throws WSSecurityException {
        if (this.wsCredTokenMapper == null) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object obj = clazz.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Got instance of WSCredTokenMapper.");
                }
                this.wsCredTokenMapper = (WSCredentialTokenMapperInterface)obj;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.auth.distContextManagerImpl.getWSCredTokenMapper", (String)"3517", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The following exception occurred in UserMappingImpl when loading the custom implementation: ", (Object)new Object[]{throwable});
                }
                throw new WSSecurityException(throwable.getMessage(), throwable);
            }
        }
        return this.wsCredTokenMapper;
    }

    private Class getWSAccessManagerClass() {
        if (this._WSAccessManager == null) {
            Class<?> clazz = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz = classLoader != null ? classLoader.loadClass(WAM_CLASS) : Class.forName(WAM_CLASS);
                this._WSAccessManager = clazz;
            }
            catch (Exception exception) {
                throw new UndeclaredThrowableException(exception);
            }
        }
        return this._WSAccessManager;
    }

    private Method getIgnoreCaseMethod() {
        Class clazz;
        if (this._isIgnoreCaseMethod == null && (clazz = this.getWSAccessManagerClass()) != null) {
            try {
                this._isIgnoreCaseMethod = clazz.getMethod("isIgnoreCase", null);
            }
            catch (Exception exception) {
                throw new UndeclaredThrowableException(exception);
            }
        }
        return this._isIgnoreCaseMethod;
    }

    private boolean isIgnoreCaseAuthorization() {
        block5: {
            Method method = this.getIgnoreCaseMethod();
            if (method != null) {
                try {
                    Boolean bl = (Boolean)method.invoke(null, null);
                    if (bl != null && bl.booleanValue()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"ignore case for authorization.");
                        }
                        return true;
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)"isIgnoreCaseAuthorization: ", (Object)exception);
                }
            }
        }
        return false;
    }

    public static synchronized void registerPackage(String string) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = System.getProperty(URL_HANDLER_PROP);
        if (string2 != null) {
            object = new StringTokenizer(string2, PKGNAME_DELIMITER);
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
        }
        if (arrayList.contains(string)) {
            return;
        }
        arrayList.add(string);
        object = new StringBuffer();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            ((StringBuffer)object).append(string3);
            if (!iterator.hasNext()) continue;
            ((StringBuffer)object).append('|');
        }
        System.setProperty(URL_HANDLER_PROP, ((StringBuffer)object).toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

