/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityUtilityImpl.AuthenticationTarget;
import com.ibm.ISecurityUtilityImpl.CSIv2Configuration;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.DelegationMode;
import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.MechanismFactory;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ISecurityUtilityImpl.SSLConfiguration;
import com.ibm.ISecurityUtilityImpl.SourceLocation;
import com.ibm.ISecurityUtilityImpl.StandardClaimQOPModels;
import com.ibm.ISecurityUtilityImpl.StandardPerformQOPModels;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.File;
import java.security.PrivilegedAction;

public class SecurityConfiguration {
    public static final String DefaultIBMSecurityTagCompatibility = "legacy";
    public static final String DefaultAuthMechAuthAlias = "system.SWAM";
    public static final boolean DefaultAuthenticationRetryEnabled = false;
    public static final int DefaultAuthenticationRetryCount = 3;
    public static final boolean DefaultIIOPSSLClientAuthentication = false;
    public static final boolean DefaultClaimClientAuthenticationRequired = true;
    public static final boolean DefaultClaimClientAuthenticationSupported = true;
    public static final boolean DefaultClaimMessageConfidentialityRequired = true;
    public static final boolean DefaultClaimMessageConfidentialitySupported = true;
    public static final boolean DefaultClaimMessageIntegrityRequired = true;
    public static final boolean DefaultClaimMessageIntegritySupported = true;
    public static final boolean DefaultClaimMessageOutOfSequenceDetectionRequired = false;
    public static final boolean DefaultClaimMessageOutOfSequenceDetectionSupported = false;
    public static final boolean DefaultClaimMessageReplayDetectionRequired = false;
    public static final boolean DefaultClaimMessageReplayDetectionSupported = false;
    public static final boolean DefaultClaimServerAuthenticationRequired = true;
    public static final boolean DefaultClaimServerAuthenticationSupported = true;
    public static final boolean DefaultConfigurationInitialized = false;
    public static final boolean DefaultDCEClientAssociationEnabled = false;
    public static final boolean DefaultDCEServerAssociationEnabled = false;
    public static final boolean DefaultKerberosClientAssociationEnabled = false;
    public static final boolean DefaultKerberosServerAssociationEnabled = false;
    public static final boolean DefaultLocalOSClientAssociationEnabled = false;
    public static final boolean DefaultLocalOSServerAssociationEnabled = false;
    public static final boolean DefaultLTPAClientAssociationEnabled = false;
    public static final boolean DefaultLTPAServerAssociationEnabled = false;
    public static final boolean DefaultPerformClientAuthentication = true;
    public static final boolean DefaultPerformMessageConfidentiality = false;
    public static final boolean DefaultPerformMessageIntegrity = false;
    public static final boolean DefaultPerformMessageOutOfSequenceDetection = true;
    public static final boolean DefaultPerformMessageReplayDetection = true;
    public static final boolean DefaultPerformServerAuthentication = true;
    public static final boolean DefaultSecurityEnabled = false;
    public static final boolean DefaultServerSecurityEnabled = false;
    public static final boolean DefaultSessionGCenabled = true;
    public static final boolean DefaultSSLCompoundTagEnabled = false;
    private static final String DefaultSSLServerKeyRing = "";
    public static final boolean DefaultSSLMessageLoggingEnabled = true;
    public static final boolean DefaultSSLTypeIClientAssociationEnabled = true;
    public static final boolean DefaultSSLTypeIServerAssociationEnabled = true;
    public static final boolean DefaultSSLTypeIIClientAssociationEnabled = false;
    public static final boolean DefaultSSLTypeIIServerAssociationEnabled = false;
    public static final boolean DefaultNotifyBrokenConnectionEnabled = true;
    public static final boolean DefaultDelegateBasicAuth = false;
    public static final boolean DefaultValidateBasicAuth = true;
    public static final boolean DefaultDebugJAASCredWithStack = false;
    public static final boolean DefaultProcessIsServer = false;
    public static final boolean DefaultUseDefaultSubjectForThreads = true;
    public static final boolean DefaultRMIOutboundPropagationEnabled = false;
    public static final boolean DefaultRMIInboundPropagationEnabled = false;
    public static final boolean DefaultWebInboundPropagationEnabled = false;
    public static final boolean DefaultSSOInteropModeEnabled = true;
    public static final boolean DefaultRMIOutboundLoginEnabled = false;
    public static final boolean DefaultvalidationEnabled = true;
    public static final boolean DefaultLTPASupportedWithKerberos = true;
    public static final boolean DefaultWebChallengeIfCustomSubjectNotFound = true;
    public static final int DefaultAuthenticationTarget = 2;
    public static final int DefaultDelegateCredentialsClient = 1;
    public static final int DefaultDelegateCredentialsServer = 5;
    public static final int DefaultLoginSource = 7;
    public static final int DefaultLoginSourceClient = 1;
    public static final int DefaultLoginSourceServer = 5;
    public static final int DefaultLoginTimeout = 300;
    public static final int MaximumLoginTimeout = 600;
    public static final int MinimumLoginTimeout = 0;
    public static final int DefaultSessionGCinterval = 300000;
    public static final int DefaultSessionGCdiscardunused = 900000;
    public static final int DefaultSSLCredentialsTimeout = 86400;
    public static final int MaximumSSLCredentialsTimeout = 31536000;
    public static final int MinimumSSLCredentialsTimeout = 0;
    public static final int DefaultSSLPort = 0;
    public static final int DefaultCSISSLPort = 0;
    public static final int DefaultCSIClientCertSSLPort = 0;
    public static final int DefaultSSLV3SessionTimeout = 86400;
    public static final int MaximumSSLV3SessionTimeout = 86400;
    public static final int MinimumSSLV3SessionTimeout = 0;
    public static final int DefaultStandardClaimQOPModels = 3;
    public static final int DefaultStandardPerformQOPModels = 3;
    public static final int DefaultVerificationLevel = 2;
    public static final int DefaultDaysBeforeExpireWarning = 60;
    public static final long DefaultRequestCredsExpiration = 0L;
    public static final long MaximumRequestCredsExpiration = 31449600L;
    public static final long MinimumRequestCredsExpiration = 600L;
    public static final long DefaultSecurityCacheTimeout = 600L;
    public static final String DefaultAuthenticationTargetString = "localos";
    public static final String DefaultDelegateCredentialsClientString = "none";
    public static final String DefaultDelegateCredentialsServerString = "methoddefined";
    public static final String DefaultKeyFileName = "";
    private static final String DefaultKeyRingPassword = "WebAS";
    public static final String DefaultKeytabFileName = "";
    private static final String DefaultLoginPassword = "";
    public static final String DefaultLoginSourceClientString = "prompt";
    public static final String DefaultLoginSourceServerString = "properties";
    public static final String DefaultLoginUserid = "";
    public static final String DefaultPrincipalName = "";
    public static final String DefaultSSLClientKeyRing = "";
    public static final String DefaultStandardClaimQOPModelsString = "authenticity";
    public static final String DefaultStandardPerformQOPModelsString = "authenticity";
    public static final String DefaultVerificationLevelString = "consistency";
    public static final String DefaultProtocol = "both";
    public static final String DefaultWSSecurityContextCustomOID = "oid:1.3.18.0.2.30.3";
    public static final String DefaultWSSecurityContextCustomClass = "com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextCustomImpl";
    public static final String DefaultWSSecurityContextActiveOID = "oid:1.3.18.0.2.30.2";
    public static final String DefaultWSSecurityContextActiveClass = "com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextLTPAImpl";
    public static final boolean DefaultWSSecurityContextActiveForwardable = false;
    public static final String DefaultSecurityServerHost = "";
    public static final String DefaultSecurityServerPort = "";
    public static final String DefaultActiveUserRegistry = "NONE";
    public static final String DefaultCellNodeServer = "client";
    public static final String DefaultRMIInboundLoginConfig = "system.LTPA";
    public static final String DefaultWebInboundLoginConfig = "system.LTPA_WEB";
    public static final String DefaultRMIOutboundLoginConfig = "system.RMI_OUTBOUND";
    public static final String DefaultSupportedTargetRealms = "";
    public static final String DefaultWebPropagationTransport = "IIOP";
    public static final int VerifyReportSev_Error = 1;
    public static final int VerifyReportSev_Observation = 0;
    public static final int VerifyResult_ConfigIncomplete = 1;
    public static final int VerifyResult_ConfigInconsistent = 2;
    public static final int VerifyResult_ConfigWrong = 3;
    public static final int VerifyResult_Success = 0;
    public static final int VerifyResult_Unknown = -1;
    private static ORB _orb = null;
    private static String componentLabel = "Configuration component ";
    private static String AuthMechAuthAlias = "system.SWAM";
    private static SecurityConnectionInterceptor securityConnectionInterceptor = null;
    private static MechanismFactory mechFactory = null;
    private static ConfigURLProperties securityProps = null;
    private static CSIv2Configuration csConfig = null;
    private static String IBMSecurityTagCompatibility = "legacy";
    private static boolean authenticationRetryEnabled = false;
    private static int authenticationRetryCount = 3;
    private static boolean IIOPSSLClientAuthentication = false;
    private static boolean claimClientAuthenticationRequired = true;
    private static boolean claimClientAuthenticationSupported = true;
    private static boolean claimMessageConfidentialityRequired = true;
    private static boolean claimMessageConfidentialitySupported = true;
    private static boolean claimMessageIntegrityRequired = true;
    private static boolean claimMessageIntegritySupported = true;
    private static boolean claimMessageOutOfSequenceDetectionRequired = false;
    private static boolean claimMessageOutOfSequenceDetectionSupported = false;
    private static boolean claimMessageReplayDetectionRequired = false;
    private static boolean claimMessageReplayDetectionSupported = false;
    private static boolean claimServerAuthenticationRequired = true;
    private static boolean claimServerAuthenticationSupported = true;
    private static boolean configurationInitialized = false;
    private static boolean DCEClientAssociationEnabled = false;
    private static boolean DCEServerAssociationEnabled = false;
    private static boolean KerberosClientAssociationEnabled = false;
    private static boolean KerberosServerAssociationEnabled = false;
    private static boolean LocalOSClientAssociationEnabled = false;
    private static boolean LocalOSServerAssociationEnabled = false;
    private static boolean LTPAClientAssociationEnabled = false;
    private static boolean LTPAServerAssociationEnabled = false;
    private static boolean performClientAuthentication = true;
    private static boolean performMessageConfidentiality = false;
    private static boolean performMessageIntegrity = false;
    private static boolean performMessageOutOfSequenceDetection = true;
    private static boolean performMessageReplayDetection = true;
    private static boolean performServerAuthentication = true;
    private static boolean securityEnabled = false;
    private static boolean serverSecurityEnabled = false;
    private static boolean sessionGCenabled = true;
    private static boolean SSLCompoundTagEnabled = false;
    private static boolean SSLMessageLoggingEnabled = true;
    private static boolean SSLTypeIClientAssociationEnabled = true;
    private static boolean SSLTypeIServerAssociationEnabled = true;
    private static boolean SSLTypeIIClientAssociationEnabled = false;
    private static boolean SSLTypeIIServerAssociationEnabled = false;
    private static boolean delegateBasicAuth = false;
    private static boolean validateBasicAuth = true;
    private static boolean debugJAASCredWithStack = false;
    private static boolean NotifyBrokenConnectionEnabled = true;
    private static boolean processIsServer = false;
    private static boolean useDefaultSubjectForThreads = true;
    private static boolean rmiOutboundPropagationEnabled = false;
    private static boolean rmiOutboundLoginEnabled = false;
    private static boolean rmiInboundPropagationEnabled = false;
    private static boolean webInboundPropagationEnabled = false;
    private static boolean ssoInteropModeEnabled = true;
    private static boolean validationEnabled = true;
    private static boolean ltpaSupportedWithKerberos = true;
    private static boolean assertLDAPShortName = false;
    private static boolean includeRunAsChangesInCallerList = false;
    private static boolean webChallengeIfCustomSubjectNotFound = true;
    private static int authenticationTarget = 2;
    private static int delegateCredentials = 1;
    private static int loginSource = 1;
    private static int loginTimeout = 300;
    private static int sessionGCinterval = 300000;
    private static int sessionGCdiscardunused = 900000;
    private static int SSLCredentialsTimeout = 86400;
    private static int SSLPort = 0;
    private static int CSISSLPort = 0;
    private static int CSIClientCertSSLPort = 0;
    private static int SSLV3SessionTimeout = 86400;
    private static int standardClaimQOPModels = 3;
    private static int standardPerformQOPModels = 3;
    private static int verificationLevel = 2;
    private static int daysBeforeExpireWarning = 60;
    private static long requestCredsExpiration = 0L;
    private static long securityCacheTimeout = 600L;
    private static String keyFileName = "";
    private static String keytabFileName = "";
    private static String loginPassword = "";
    private static String loginUserid = "";
    private static String soapLoginPassword = "";
    private static String soapLoginUserid = "";
    private static String principalName = "";
    private static String SSLClientKeyRing = "";
    private static String SSLClientKeyRingPassword = "WebAS";
    private static String SSLServerKeyRing = "";
    private static String SSLServerKeyRingPassword = "WebAS";
    private static String protocol = "both";
    private static String WSSecurityContextCustomOID = "oid:1.3.18.0.2.30.3";
    private static String WSSecurityContextCustomClass = "com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextCustomImpl";
    private static String WSSecurityContextActiveOID = "oid:1.3.18.0.2.30.2";
    private static String WSSecurityContextActiveClass = "com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextLTPAImpl";
    private static boolean WSSecurityContextActiveForwardable = false;
    private static String SecurityServerHost = "";
    private static String SecurityServerPort = "";
    private static String ActiveUserRegistry = "NONE";
    private static String CellNodeServer = "client";
    private static String rmiInboundLoginConfig = "system.LTPA";
    private static String webInboundLoginConfig = "system.LTPA_WEB";
    private static String rmiOutboundLoginConfig = "system.RMI_OUTBOUND";
    private static String supportedTargetRealms = "";
    private static String webPropagationTransport = "IIOP";
    private SSLConfiguration defaultSSLConfig = new SSLConfiguration(this);
    private SSLConfiguration sasOutboundSSLConfig = new SSLConfiguration(this);
    private SSLConfiguration sasInboundSSLConfig = new SSLConfiguration(this);
    private SSLConfiguration csiOutboundSSLConfig = new SSLConfiguration(this);
    private SSLConfiguration csiInboundSSLConfig = new SSLConfiguration(this);
    private static boolean secConfigInitialized = false;
    private static boolean enablePluggableAuthentication = false;

    private SecurityConfiguration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SecurityConfiguration(org.omg.CORBA.ORB oRB, ConfigURLProperties configURLProperties) {
        String string = null;
        String string2 = "SecurityConfiguration.SecurityConfiguration()";
        securityProps = configURLProperties;
        componentLabel = SecurityMessages.getMsgOrUseDefault("CompLabel", "Configuration component ");
        SecurityConfiguration securityConfiguration = this;
        synchronized (securityConfiguration) {
            if (oRB instanceof ORB) {
                _orb = (ORB)oRB;
                if (!ConfigURLProperties.isSecurityEnabled()) {
                    return;
                }
                if (!secConfigInitialized) {
                    this.initializeDefaultStaticFile();
                    this.reinitializeConfiguration();
                    secConfigInitialized = true;
                    if (csConfig == null) {
                        csConfig = authenticationTarget == 4 ? new CSIv2Configuration(oRB, configURLProperties, false) : new CSIv2Configuration(oRB, configURLProperties, true);
                    }
                }
            } else if (SecurityLogger.debugTraceEnabled) {
                string = "Unexpected ORB instance.";
                SecurityLogger.debugMessage(string2, string);
            }
        }
    }

    public CSIv2Configuration getCSIv2Configuration() {
        if (configurationInitialized && protocol.compareToIgnoreCase("ibm") != 0 && csConfig == null) {
            csConfig = authenticationTarget == 4 ? new CSIv2Configuration((org.omg.CORBA.ORB)_orb, securityProps, false) : new CSIv2Configuration((org.omg.CORBA.ORB)_orb, securityProps, true);
        }
        return csConfig;
    }

    public static String mask(String string) {
        String string2 = null;
        if (string != null) {
            char[] cArray = new char[string.length()];
            for (int i = 0; i < string.length(); ++i) {
                cArray[i] = 42;
            }
            string2 = new String(cArray);
        }
        return string2;
    }

    private synchronized boolean reinitializeConfiguration() {
        String string = "SecurityConfiguration.reinitializeConfiguration";
        String string2 = null;
        try {
            this.initializeProtocol();
            this.initializeAuthenticationProperties();
            this.initializeDelegateCredentials();
            this.initializeLoginProperties();
            this.initializeRequestCredsExpiration();
            this.initializeSecurityCacheTimeout();
            this.initializeSecurityEnabled();
            this.initializeSessionGC();
            this.initializeNotifyBrokenConnectionEnabled();
            this.initializeWSSecurtyContext();
            this.initializeSSLPort();
            this.initializeSSLProperties();
            this.initializeJSSEProperties();
            this.initializeClaimQOP();
            this.initializePerformQOP();
            this.initializeVerificationLevel();
            configurationInitialized = true;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.reinitializeConfiguration", (String)"528", (Object)this);
            string2 = "security.JSAS0413E";
            SecurityLogger.logError(string2, new Object[]{string, exception});
        }
        if (this.verifyConfiguration(verificationLevel) != 0) {
            string2 = "security.JSAS0414E";
            SecurityLogger.logError(string2, new Object[]{string});
        }
        return securityEnabled;
    }

    public int verifyConfiguration(int n) {
        int n2 = -1;
        if (n >= 1 && n2 <= 0) {
            n2 = this.verifyConfigurationCompleteness(n2);
        }
        if (n >= 2 && n2 <= 0) {
            n2 = this.verifyConfigurationConsistency(n2);
        }
        if (n >= 3 && n2 <= 0) {
            n2 = this.verifyConfigurationPassiveCorrectness(n2);
        }
        if (n >= 4 && n2 <= 0) {
            n2 = this.verifyConfigurationActiveCorrectness(n2);
        }
        return n2;
    }

    private void initializeProtocol() {
        String string = "CSIv2Configuration.initializeProtocol";
        String string2 = null;
        String string3 = null;
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.protocol"));
        if (string3 != null && string3.length() > 0) {
            if (string3.equalsIgnoreCase("csi")) {
                string3 = "csiv2";
            }
            if (string3.equalsIgnoreCase("sas")) {
                string3 = "ibm";
            }
            if (string3.equalsIgnoreCase("ibm") || string3.equalsIgnoreCase("csiv2") || string3.equalsIgnoreCase(DefaultProtocol)) {
                protocol = string3.toLowerCase();
            } else {
                string2 = "security.JSAS0627E";
                SecurityLogger.logError(string2, new Object[]{string, string3, DefaultProtocol});
                protocol = DefaultProtocol;
            }
        }
    }

    private synchronized void initializeAuthenticationProperties() {
        String string = "SecurityConfiguration.initializeAuthenticationProperties";
        String string2 = null;
        String string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.authenticationRetryEnabled"));
        if (string3 != null && string3.length() > 0) {
            authenticationRetryEnabled = this.checkTrueOrYes(string3);
        }
        boolean bl = false;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.authenticationRetryCount"));
        if (string3 != null && string3.length() > 0) {
            int n = -1;
            bl = false;
            try {
                n = new Integer(string3);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeAuthenticationProperties", (String)"640", (Object)this);
                string2 = "security.JSAS0628E";
                SecurityLogger.logError(string2, new Object[]{string, new Integer(3).toString()});
            }
            if (bl) {
                authenticationRetryCount = n;
            }
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.authenticationTarget"));
        if (string3 != null && string3.length() > 0) {
            if ((string3 = string3.toLowerCase()).equals("basicauth")) {
                authenticationTarget = 4;
                bl = true;
                DCEClientAssociationEnabled = false;
                DCEServerAssociationEnabled = false;
                KerberosClientAssociationEnabled = false;
                KerberosServerAssociationEnabled = false;
                LocalOSClientAssociationEnabled = false;
                LocalOSServerAssociationEnabled = false;
                LTPAClientAssociationEnabled = false;
                LTPAServerAssociationEnabled = false;
                SSLTypeIClientAssociationEnabled = true;
                SSLTypeIServerAssociationEnabled = true;
                SSLTypeIIClientAssociationEnabled = false;
                SSLTypeIIServerAssociationEnabled = false;
            } else if (string3.equals("dce")) {
                authenticationTarget = 3;
                bl = true;
                DCEClientAssociationEnabled = true;
                DCEServerAssociationEnabled = true;
                KerberosClientAssociationEnabled = false;
                KerberosServerAssociationEnabled = false;
                LocalOSClientAssociationEnabled = false;
                LocalOSServerAssociationEnabled = false;
                LTPAClientAssociationEnabled = false;
                LTPAServerAssociationEnabled = false;
                SSLTypeIClientAssociationEnabled = false;
                SSLTypeIServerAssociationEnabled = false;
                SSLTypeIIClientAssociationEnabled = false;
                SSLTypeIIServerAssociationEnabled = false;
            } else if (string3.equals("kerberos")) {
                authenticationTarget = 6;
                DCEClientAssociationEnabled = false;
                DCEServerAssociationEnabled = false;
                KerberosClientAssociationEnabled = true;
                KerberosServerAssociationEnabled = true;
                LocalOSClientAssociationEnabled = false;
                LocalOSServerAssociationEnabled = false;
                LTPAClientAssociationEnabled = false;
                LTPAServerAssociationEnabled = false;
                SSLTypeIClientAssociationEnabled = true;
                SSLTypeIServerAssociationEnabled = true;
                SSLTypeIIClientAssociationEnabled = false;
                SSLTypeIIServerAssociationEnabled = false;
            } else if (string3.equals(DefaultAuthenticationTargetString)) {
                authenticationTarget = 2;
                bl = true;
                DCEClientAssociationEnabled = false;
                DCEServerAssociationEnabled = false;
                KerberosClientAssociationEnabled = false;
                KerberosServerAssociationEnabled = false;
                LocalOSClientAssociationEnabled = true;
                LocalOSServerAssociationEnabled = true;
                LTPAClientAssociationEnabled = false;
                LTPAServerAssociationEnabled = false;
                SSLTypeIClientAssociationEnabled = true;
                SSLTypeIServerAssociationEnabled = true;
                SSLTypeIIClientAssociationEnabled = false;
                SSLTypeIIServerAssociationEnabled = false;
            } else if (string3.equals("custom")) {
                authenticationTarget = 8;
                bl = true;
                DCEClientAssociationEnabled = false;
                DCEServerAssociationEnabled = false;
                KerberosClientAssociationEnabled = false;
                KerberosServerAssociationEnabled = false;
                LocalOSClientAssociationEnabled = true;
                LocalOSServerAssociationEnabled = true;
                LTPAClientAssociationEnabled = false;
                LTPAServerAssociationEnabled = false;
                SSLTypeIClientAssociationEnabled = true;
                SSLTypeIServerAssociationEnabled = true;
                SSLTypeIIClientAssociationEnabled = false;
                SSLTypeIIServerAssociationEnabled = false;
            } else if (string3.equals("swam")) {
                authenticationTarget = 2;
                bl = true;
                DCEClientAssociationEnabled = false;
                DCEServerAssociationEnabled = false;
                KerberosClientAssociationEnabled = false;
                KerberosServerAssociationEnabled = false;
                LocalOSClientAssociationEnabled = true;
                LocalOSServerAssociationEnabled = true;
                LTPAClientAssociationEnabled = false;
                LTPAServerAssociationEnabled = false;
                SSLTypeIClientAssociationEnabled = true;
                SSLTypeIServerAssociationEnabled = true;
                SSLTypeIIClientAssociationEnabled = false;
                SSLTypeIIServerAssociationEnabled = false;
            } else if (string3.equals("ltpa")) {
                authenticationTarget = 1;
                bl = true;
                DCEClientAssociationEnabled = false;
                DCEServerAssociationEnabled = false;
                KerberosClientAssociationEnabled = false;
                KerberosServerAssociationEnabled = false;
                LocalOSClientAssociationEnabled = false;
                LocalOSServerAssociationEnabled = false;
                LTPAClientAssociationEnabled = true;
                LTPAServerAssociationEnabled = true;
                SSLTypeIClientAssociationEnabled = true;
                SSLTypeIServerAssociationEnabled = true;
                SSLTypeIIClientAssociationEnabled = false;
                SSLTypeIIServerAssociationEnabled = false;
            } else if (string3.equals("icsf")) {
                authenticationTarget = 9;
                bl = true;
                DCEClientAssociationEnabled = false;
                DCEServerAssociationEnabled = false;
                KerberosClientAssociationEnabled = false;
                KerberosServerAssociationEnabled = false;
                LocalOSClientAssociationEnabled = false;
                LocalOSServerAssociationEnabled = false;
                LTPAClientAssociationEnabled = false;
                LTPAServerAssociationEnabled = false;
                SSLTypeIClientAssociationEnabled = true;
                SSLTypeIServerAssociationEnabled = true;
                SSLTypeIIClientAssociationEnabled = false;
                SSLTypeIIServerAssociationEnabled = false;
            }
        }
        if (!bl) {
            DCEClientAssociationEnabled = false;
            DCEServerAssociationEnabled = false;
            KerberosClientAssociationEnabled = false;
            KerberosServerAssociationEnabled = false;
            LocalOSClientAssociationEnabled = false;
            LocalOSServerAssociationEnabled = false;
            LTPAClientAssociationEnabled = false;
            LTPAServerAssociationEnabled = false;
            SSLTypeIClientAssociationEnabled = true;
            SSLTypeIServerAssociationEnabled = true;
            SSLTypeIIClientAssociationEnabled = false;
            SSLTypeIIServerAssociationEnabled = false;
            string2 = "security.JSAS0051E";
            SecurityLogger.logError(string2, new Object[]{string});
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.DCEClientAssociationEnabled"));
        if (string3 != null && string3.length() > 0) {
            DCEClientAssociationEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.DCEServerAssociationEnabled"));
        if (string3 != null && string3.length() > 0) {
            DCEServerAssociationEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.KerberosClientAssociationEnabled"));
        if (string3 != null && string3.length() > 0) {
            KerberosClientAssociationEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.KerberosServerAssociationEnabled"));
        if (string3 != null && string3.length() > 0) {
            KerberosServerAssociationEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.LocalOSClientAssociationEnabled"));
        if (string3 != null && string3.length() > 0) {
            LocalOSClientAssociationEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.LocalOSServerAssociationEnabled"));
        if (string3 != null && string3.length() > 0) {
            LocalOSServerAssociationEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.LTPAClientAssociationEnabled"));
        if (string3 != null && string3.length() > 0) {
            LTPAClientAssociationEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.LTPAServerAssociationEnabled"));
        if (string3 != null && string3.length() > 0) {
            LTPAServerAssociationEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.SSLTypeIClientAssociationEnabled"));
        if (string3 != null && string3.length() > 0) {
            SSLTypeIClientAssociationEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.SSLTypeIServerAssociationEnabled"));
        if (string3 != null && string3.length() > 0) {
            SSLTypeIServerAssociationEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.SSLTypeIIClientAssociationEnabled"));
        if (string3 != null && string3.length() > 0) {
            SSLTypeIIClientAssociationEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.SSLTypeIIServerAssociationEnabled"));
        if (string3 != null && string3.length() > 0) {
            SSLTypeIIServerAssociationEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.authMechAuthAlias"));
        AuthMechAuthAlias = string3 != null && string3.length() > 0 ? string3 : DefaultAuthMechAuthAlias;
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("security.enablePluggableAuthentication"));
        enablePluggableAuthentication = string3 != null && string3.length() > 0 ? this.checkTrueOrYes(string3) : false;
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.activeUserRegistry"));
        ActiveUserRegistry = string3 != null && string3.length() > 0 ? string3 : DefaultActiveUserRegistry;
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.CellNodeServer"));
        CellNodeServer = string3 != null && string3.length() > 0 ? string3 : DefaultCellNodeServer;
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.rmiOutboundPropagationEnabled"));
        if (string3 != null && string3.length() > 0) {
            rmiOutboundPropagationEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.rmiInboundPropagationEnabled"));
        if (string3 != null && string3.length() > 0) {
            rmiInboundPropagationEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.ws.security.webInboundPropagationEnabled"));
        if (string3 != null && string3.length() > 0) {
            webInboundPropagationEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.ws.security.ssoInteropModeEnabled"));
        if (string3 != null && string3.length() > 0) {
            ssoInteropModeEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.ws.security.webChallengeIfCustomSubjectNotFound"));
        if (string3 != null && string3.length() > 0) {
            webChallengeIfCustomSubjectNotFound = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.rmiOutboundLoginEnabled"));
        if (string3 != null && string3.length() > 0) {
            rmiOutboundLoginEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.rmiInboundLoginConfig"));
        rmiInboundLoginConfig = string3 != null && string3.length() > 0 ? string3 : DefaultRMIInboundLoginConfig;
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.ws.security.webInboundLoginConfig"));
        webInboundLoginConfig = string3 != null && string3.length() > 0 ? string3 : DefaultWebInboundLoginConfig;
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.rmiOutboundLoginConfig"));
        rmiOutboundLoginConfig = string3 != null && string3.length() > 0 ? string3 : DefaultRMIOutboundLoginConfig;
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.supportedTargetRealms"));
        supportedTargetRealms = string3 != null && string3.length() > 0 ? string3 : "";
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.ws.security.webPropagationTransport"));
        webPropagationTransport = string3 != null && string3.length() > 0 ? string3 : DefaultWebPropagationTransport;
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.websphere.security.krb.support_ltpa"));
        if (string3 != null && string3.length() > 0) {
            ltpaSupportedWithKerberos = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.ws.security.assertLDAPShortName"));
        if (string3 != null && string3.length() > 0) {
            assertLDAPShortName = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.ws.security.includeRunAsChangesInCallerList"));
        if (string3 != null && string3.length() > 0) {
            includeRunAsChangesInCallerList = this.checkTrueOrYes(string3);
        }
    }

    private synchronized void initializeClaimQOP() {
        String string = "SecurityConfiguration.initializeClaimQOP";
        String string2 = null;
        String string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.claimClientAuthenticationRequired"));
        if (string3 != null && string3.length() > 0) {
            claimClientAuthenticationRequired = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.claimClientAuthenticationSupported"));
        if (string3 != null && string3.length() > 0) {
            claimClientAuthenticationSupported = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.claimMessageConfidentialityRequired"));
        if (string3 != null && string3.length() > 0) {
            claimMessageConfidentialityRequired = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.claimMessageConfidentialitySupported"));
        if (string3 != null && string3.length() > 0) {
            claimMessageConfidentialitySupported = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.claimMessageIntegrityRequired"));
        if (string3 != null && string3.length() > 0) {
            claimMessageIntegrityRequired = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.claimMessageIntegritySupported"));
        if (string3 != null && string3.length() > 0) {
            claimMessageIntegritySupported = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.claimMessageOutOfSequenceDetectionRequired"));
        if (string3 != null && string3.length() > 0) {
            claimMessageOutOfSequenceDetectionRequired = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.claimMessageOutOfSequenceDetectionSupported"));
        if (string3 != null && string3.length() > 0) {
            claimMessageOutOfSequenceDetectionSupported = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.claimMessageReplayDetectionRequired"));
        if (string3 != null && string3.length() > 0) {
            claimMessageReplayDetectionRequired = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.claimMessageReplayDetectionSupported"));
        if (string3 != null && string3.length() > 0) {
            claimMessageReplayDetectionSupported = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.claimServerAuthenticationRequired"));
        if (string3 != null && string3.length() > 0) {
            claimServerAuthenticationRequired = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.claimServerAuthenticationSupported"));
        if (string3 != null && string3.length() > 0) {
            claimServerAuthenticationSupported = this.checkTrueOrYes(string3);
        }
        boolean bl = false;
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.standardClaimQOPModels"));
        if ((string3 == null || string3.length() == 0) && this.defaultSSLConfig.getValidSSLSecurityLevel()) {
            string3 = this.defaultSSLConfig.getSSLSecurityLevel();
        }
        if (string3 != null && string3.length() > 0) {
            string3 = string3.toLowerCase();
            if (SSLTypeIServerAssociationEnabled || KerberosServerAssociationEnabled || LocalOSServerAssociationEnabled || LTPAServerAssociationEnabled) {
                if (string3.equals("confidentiality") || string3.equals("high")) {
                    bl = true;
                    standardClaimQOPModels = 3;
                    claimClientAuthenticationRequired = true;
                    claimClientAuthenticationSupported = true;
                    claimMessageConfidentialityRequired = true;
                    claimMessageConfidentialitySupported = true;
                    claimMessageIntegrityRequired = true;
                    claimMessageIntegritySupported = true;
                    claimMessageOutOfSequenceDetectionRequired = true;
                    claimMessageOutOfSequenceDetectionSupported = true;
                    claimMessageReplayDetectionRequired = true;
                    claimMessageReplayDetectionSupported = true;
                    claimServerAuthenticationRequired = true;
                    claimServerAuthenticationSupported = true;
                } else if (string3.equals("integrity") || string3.equals("medium")) {
                    bl = true;
                    standardClaimQOPModels = 2;
                    claimClientAuthenticationRequired = true;
                    claimClientAuthenticationSupported = true;
                    claimMessageConfidentialityRequired = false;
                    claimMessageConfidentialitySupported = false;
                    claimMessageIntegrityRequired = true;
                    claimMessageIntegritySupported = true;
                    claimMessageOutOfSequenceDetectionRequired = true;
                    claimMessageOutOfSequenceDetectionSupported = true;
                    claimMessageReplayDetectionRequired = true;
                    claimMessageReplayDetectionSupported = true;
                    claimServerAuthenticationRequired = true;
                    claimServerAuthenticationSupported = true;
                } else if (string3.equals("authenticity") || string3.equals("low")) {
                    bl = true;
                    standardClaimQOPModels = 1;
                    claimClientAuthenticationRequired = true;
                    claimClientAuthenticationSupported = true;
                    claimMessageConfidentialityRequired = false;
                    claimMessageConfidentialitySupported = false;
                    claimMessageIntegrityRequired = false;
                    claimMessageIntegritySupported = false;
                    claimMessageOutOfSequenceDetectionRequired = true;
                    claimMessageOutOfSequenceDetectionSupported = true;
                    claimMessageReplayDetectionRequired = true;
                    claimMessageReplayDetectionSupported = true;
                    claimServerAuthenticationRequired = true;
                    claimServerAuthenticationSupported = true;
                } else if (string3.equals("advanced")) {
                    bl = true;
                    standardClaimQOPModels = 4;
                } else {
                    string2 = "security.JSAS0402E";
                    SecurityLogger.logError(string2, new Object[]{string, "authenticity"});
                }
            } else if (DCEClientAssociationEnabled) {
                if (string3.equals("confidentiality") || string3.equals("high")) {
                    bl = true;
                    standardClaimQOPModels = 3;
                    claimClientAuthenticationRequired = true;
                    claimClientAuthenticationSupported = true;
                    claimMessageConfidentialityRequired = true;
                    claimMessageConfidentialitySupported = true;
                    claimMessageIntegrityRequired = true;
                    claimMessageIntegritySupported = true;
                    claimMessageOutOfSequenceDetectionRequired = false;
                    claimMessageOutOfSequenceDetectionSupported = false;
                    claimMessageReplayDetectionRequired = false;
                    claimMessageReplayDetectionSupported = false;
                    claimServerAuthenticationRequired = true;
                    claimServerAuthenticationSupported = true;
                } else if (string3.equals("integrity") || string3.equals("medium")) {
                    bl = true;
                    standardClaimQOPModels = 2;
                    claimClientAuthenticationRequired = true;
                    claimClientAuthenticationSupported = true;
                    claimMessageConfidentialityRequired = false;
                    claimMessageConfidentialitySupported = false;
                    claimMessageIntegrityRequired = true;
                    claimMessageIntegritySupported = true;
                    claimMessageOutOfSequenceDetectionRequired = false;
                    claimMessageOutOfSequenceDetectionSupported = false;
                    claimMessageReplayDetectionRequired = false;
                    claimMessageReplayDetectionSupported = false;
                    claimServerAuthenticationRequired = true;
                    claimServerAuthenticationSupported = true;
                } else if (string3.equals("authenticity") || string3.equals("low")) {
                    bl = true;
                    standardClaimQOPModels = 1;
                    claimClientAuthenticationRequired = true;
                    claimClientAuthenticationSupported = true;
                    claimMessageConfidentialityRequired = false;
                    claimMessageConfidentialitySupported = false;
                    claimMessageIntegrityRequired = false;
                    claimMessageIntegritySupported = false;
                    claimMessageOutOfSequenceDetectionRequired = false;
                    claimMessageOutOfSequenceDetectionSupported = false;
                    claimMessageReplayDetectionRequired = false;
                    claimMessageReplayDetectionSupported = false;
                    claimServerAuthenticationRequired = true;
                    claimServerAuthenticationSupported = true;
                } else if (string3.equals("advanced")) {
                    bl = true;
                    standardClaimQOPModels = 4;
                } else {
                    string2 = "security.JSAS0402E";
                    SecurityLogger.logError(string2, new Object[]{string, "authenticity"});
                }
            }
        }
        if (!bl) {
            standardClaimQOPModels = 3;
            claimClientAuthenticationRequired = true;
            claimClientAuthenticationSupported = true;
            claimMessageConfidentialityRequired = true;
            claimMessageConfidentialitySupported = true;
            claimMessageIntegrityRequired = true;
            claimMessageIntegritySupported = true;
            claimMessageOutOfSequenceDetectionRequired = true;
            claimMessageOutOfSequenceDetectionSupported = true;
            claimMessageReplayDetectionRequired = true;
            claimMessageReplayDetectionSupported = true;
            claimServerAuthenticationRequired = true;
            claimServerAuthenticationSupported = true;
        }
    }

    private synchronized void initializeDelegateCredentials() {
        String string = "SecurityConfiguration.initializeDelegateCredentials";
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.delegateCredentials"));
        if (string3 != null && string3.length() > 0) {
            if ((string3 = string3.toLowerCase()).equals(DefaultDelegateCredentialsServerString)) {
                delegateCredentials = 5;
                bl = true;
            } else if (string3.equals(DefaultDelegateCredentialsClientString)) {
                delegateCredentials = 1;
                bl = true;
            } else if (string3.equals("scoped")) {
                delegateCredentials = 3;
                bl = true;
            } else if (string3.equals("simple")) {
                delegateCredentials = 2;
                bl = true;
            } else if (string3.equals("traced")) {
                delegateCredentials = 4;
                bl = true;
            } else if (string3.equals("saf")) {
                delegateCredentials = 6;
                bl = true;
            } else if (authenticationTarget == 4) {
                string2 = "security.JSAS0403E";
                SecurityLogger.logError(string2, new Object[]{string, DefaultDelegateCredentialsClientString});
            } else {
                string2 = "security.JSAS0403E";
                SecurityLogger.logError(string2, new Object[]{string, DefaultDelegateCredentialsServerString});
            }
        }
        if (!bl && authenticationTarget != 4) {
            delegateCredentials = 5;
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.delegateBasicAuth"));
        delegateBasicAuth = string3 != null && string3.length() > 0 ? this.checkTrueOrYes(string3) : false;
    }

    private synchronized void initializeJSSEProperties() {
        PlatformHelper platformHelper;
        String string = "SecurityConfiguration.initializeJSSEProperties";
        String string2 = null;
        String string3 = null;
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.messageLoggingEnabled"));
        if (string3 != null && string3.length() > 0) {
            SSLMessageLoggingEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.ssl.daysBeforeExpireWarning"));
        if (string3 != null && string3.length() > 0) {
            int n = -1;
            try {
                daysBeforeExpireWarning = n = new Integer(string3).intValue();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeJSSEProperties", (String)"1313", (Object)this);
                string2 = "security.JSAS0405E";
                SecurityLogger.logError(string2, new Object[]{string, new Integer(60).toString()});
                daysBeforeExpireWarning = 60;
            }
        }
        this.defaultSSLConfig.initializeDefault(securityProps, _orb);
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.ssl.validationEnabled"));
        if (string3 != null && string3.length() > 0) {
            validationEnabled = this.checkTrueOrYes(string3);
        }
        if ((platformHelper = PlatformHelperFactory.getPlatformHelper()).isClientJvm() && platformHelper.isZOS()) {
            validationEnabled = false;
        }
        if (this.getProtocol().equalsIgnoreCase("ibm")) {
            this.sasOutboundSSLConfig.initializeSASOutbound(securityProps, this.defaultSSLConfig);
            if (validationEnabled) {
                try {
                    this.sasOutboundSSLConfig.validateSSLConfig();
                    this.sasOutboundSSLConfig.provideExpirationWarnings("sasOutboundSSLConfig", daysBeforeExpireWarning);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.sasInboundSSLConfig.initializeSASInbound(securityProps, this.defaultSSLConfig);
            if (processIsServer && validationEnabled) {
                try {
                    this.sasInboundSSLConfig.validateSSLConfig();
                    this.sasInboundSSLConfig.provideExpirationWarnings("sasInboundSSLConfig", daysBeforeExpireWarning);
                }
                catch (Exception exception) {}
            }
        } else if (this.getProtocol().equalsIgnoreCase("csiv2")) {
            this.csiOutboundSSLConfig.initializeCSIOutbound(securityProps, this.defaultSSLConfig);
            if (validationEnabled) {
                try {
                    this.csiOutboundSSLConfig.validateSSLConfig();
                    this.csiOutboundSSLConfig.provideExpirationWarnings("csiOutboundSSLConfig", daysBeforeExpireWarning);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.csiInboundSSLConfig.initializeCSIInbound(securityProps, this.defaultSSLConfig);
            if (processIsServer && validationEnabled) {
                try {
                    this.csiInboundSSLConfig.validateSSLConfig();
                    this.csiInboundSSLConfig.provideExpirationWarnings("csiInboundSSLConfig", daysBeforeExpireWarning);
                }
                catch (Exception exception) {}
            }
        } else {
            this.sasOutboundSSLConfig.initializeSASOutbound(securityProps, this.defaultSSLConfig);
            if (validationEnabled) {
                try {
                    this.sasOutboundSSLConfig.validateSSLConfig();
                    this.sasOutboundSSLConfig.provideExpirationWarnings("sasOutboundSSLConfig", daysBeforeExpireWarning);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.sasInboundSSLConfig.initializeSASInbound(securityProps, this.defaultSSLConfig);
            if (processIsServer && validationEnabled) {
                try {
                    this.sasInboundSSLConfig.validateSSLConfig();
                    this.sasInboundSSLConfig.provideExpirationWarnings("sasInboundSSLConfig", daysBeforeExpireWarning);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.csiOutboundSSLConfig.initializeCSIOutbound(securityProps, this.defaultSSLConfig);
            if (validationEnabled) {
                try {
                    this.csiOutboundSSLConfig.validateSSLConfig();
                    this.csiOutboundSSLConfig.provideExpirationWarnings("csiOutboundSSLConfig", daysBeforeExpireWarning);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.csiInboundSSLConfig.initializeCSIInbound(securityProps, this.defaultSSLConfig);
            if (processIsServer && validationEnabled) {
                try {
                    this.csiInboundSSLConfig.validateSSLConfig();
                    this.csiInboundSSLConfig.provideExpirationWarnings("csiInboundSSLConfig", daysBeforeExpireWarning);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private synchronized void initializeLoginProperties() {
        String string = "SecurityConfiguration.initializeLoginProperties";
        String string2 = null;
        String string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.validateBasicAuth"));
        if (string3 != null && string3.length() > 0) {
            validateBasicAuth = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.useDefaultSubjectForThreads"));
        if (string3 != null && string3.length() > 0) {
            useDefaultSubjectForThreads = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.processIsServer"));
        if (string3 != null && string3.length() > 0) {
            processIsServer = this.checkTrueOrYes(string3);
        }
        if ((string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.keyFileName"))) != null && string3.length() > 0) {
            keyFileName = string3;
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.keytabFileName"));
        if (string3 != null && string3.length() > 0) {
            keytabFileName = string3;
        }
        string3 = null;
        string3 = SecurityConfiguration.clean((String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return securityProps.getProperty("com.ibm.CORBA.loginPassword");
            }
        }));
        if (string3 != null && string3.length() > 0) {
            loginPassword = string3;
        }
        if (loginPassword != null && loginPassword.length() > 0) {
            try {
                loginPassword = PasswordUtil.decode((String)loginPassword);
            }
            catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                FFDCFilter.processException((Throwable)invalidPasswordDecodingException, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeLoginProperties", (String)"1272", (Object)this);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeLoginProperties", (String)"1277", (Object)this);
                string2 = "security.JSAS0484E";
                SecurityLogger.logError(string2, new Object[]{string, exception});
            }
        }
        string3 = null;
        string3 = SecurityConfiguration.clean((String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return securityProps.getProperty("com.ibm.SOAP.loginPassword");
            }
        }));
        if (string3 != null && string3.length() > 0) {
            soapLoginPassword = string3;
        }
        if (soapLoginPassword != null && soapLoginPassword.length() > 0) {
            try {
                soapLoginPassword = PasswordUtil.decode((String)soapLoginPassword);
            }
            catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                FFDCFilter.processException((Throwable)invalidPasswordDecodingException, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeLoginProperties", (String)"1302", (Object)this);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeLoginProperties", (String)"1307", (Object)this);
                string2 = "security.JSAS0484E";
                SecurityLogger.logError(string2, new Object[]{string, exception});
            }
        }
        boolean bl = false;
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.loginSource"));
        if (string3 != null && string3.length() > 0) {
            if ((string3 = string3.toLowerCase()).equals("environment")) {
                loginSource = 4;
                bl = true;
            } else if (string3.equals("key file")) {
                loginSource = 3;
                bl = true;
            } else if (string3.equals("key table")) {
                loginSource = 2;
                bl = true;
            } else if (string3.equals(DefaultDelegateCredentialsClientString)) {
                loginSource = 7;
                bl = true;
            } else if (string3.equals(DefaultLoginSourceClientString)) {
                loginSource = 1;
                bl = true;
            } else if (string3.equals(DefaultLoginSourceServerString)) {
                loginSource = 5;
                bl = true;
            } else if (string3.equals("stdin")) {
                loginSource = 6;
                bl = true;
            } else if (authenticationTarget == 4) {
                string2 = "security.JSAS0498E";
                SecurityLogger.logError(string2, new Object[]{string, DefaultLoginSourceClientString});
            } else {
                string2 = "security.JSAS0498E";
                SecurityLogger.logError(string2, new Object[]{string, DefaultLoginSourceServerString});
            }
        }
        if (!bl && authenticationTarget != 4) {
            loginSource = 5;
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.loginTimeout"));
        if (string3 != null && string3.length() > 0) {
            int n = -1;
            bl = false;
            try {
                n = new Integer(string3);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeLoginProperties", (String)"1361", (Object)this);
                string2 = "security.JSAS0405E";
                SecurityLogger.logError(string2, new Object[]{string, new Integer(300).toString()});
                loginTimeout = 300;
            }
            if (bl) {
                if (n < 0) {
                    n = 300;
                    bl = false;
                } else if (n > 600) {
                    n = 600;
                    bl = false;
                }
                if (!bl) {
                    string2 = "security.JSAS0404E";
                    SecurityLogger.logError(string2, new Object[]{string, new Integer(n).toString()});
                }
                loginTimeout = n;
            }
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.loginUserid"));
        if (string3 != null && string3.length() > 0) {
            loginUserid = string3;
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.SOAP.loginUserid"));
        if (string3 != null && string3.length() > 0) {
            soapLoginUserid = string3;
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.principalName"));
        if (string3 != null && string3.length() > 0) {
            principalName = string3;
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.securityServerPort"));
        if (string3 != null && string3.length() > 0) {
            SecurityServerPort = string3;
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.securityServerHost"));
        if (string3 != null && string3.length() > 0) {
            SecurityServerHost = string3;
        }
    }

    private synchronized void initializePerformQOP() {
        String string = "SecurityConfiguration.initializePerformQOP";
        String string2 = null;
        String string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.performClientAuthentication"));
        if (string3 != null && string3.length() > 0) {
            performClientAuthentication = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.performMessageConfidentiality"));
        if (string3 != null && string3.length() > 0) {
            performMessageConfidentiality = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.performMessageIntegrity"));
        if (string3 != null && string3.length() > 0) {
            performMessageIntegrity = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.performMessageOutOfSequenceDetection"));
        if (string3 != null && string3.length() > 0) {
            performMessageOutOfSequenceDetection = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.performMessageReplayDetection"));
        if (string3 != null && string3.length() > 0) {
            performMessageReplayDetection = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.performServerAuthentication"));
        if (string3 != null && string3.length() > 0) {
            performServerAuthentication = this.checkTrueOrYes(string3);
        }
        boolean bl = false;
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.standardPerformQOPModels"));
        if ((string3 == null || string3.length() == 0) && this.defaultSSLConfig.getValidSSLSecurityLevel()) {
            string3 = this.defaultSSLConfig.getSSLSecurityLevel();
        }
        if (string3 != null && string3.length() > 0) {
            string3 = string3.toLowerCase();
            if (SSLTypeIServerAssociationEnabled || KerberosServerAssociationEnabled || LocalOSServerAssociationEnabled || LTPAServerAssociationEnabled) {
                if (string3.equals("confidentiality") || string3.equals("high")) {
                    bl = true;
                    standardPerformQOPModels = 3;
                    performClientAuthentication = true;
                    performMessageConfidentiality = true;
                    performMessageIntegrity = true;
                    performMessageOutOfSequenceDetection = true;
                    performMessageReplayDetection = true;
                    performServerAuthentication = true;
                } else if (string3.equals("integrity") || string3.equals("medium")) {
                    bl = true;
                    standardPerformQOPModels = 2;
                    performClientAuthentication = true;
                    performMessageConfidentiality = false;
                    performMessageIntegrity = true;
                    performMessageOutOfSequenceDetection = true;
                    performMessageReplayDetection = true;
                    performServerAuthentication = true;
                } else if (string3.equals("authenticity") || string3.equals("low")) {
                    bl = true;
                    standardPerformQOPModels = 1;
                    performClientAuthentication = true;
                    performMessageConfidentiality = false;
                    performMessageIntegrity = false;
                    performMessageOutOfSequenceDetection = true;
                    performMessageReplayDetection = true;
                    performServerAuthentication = true;
                } else if (string3.equals("advanced")) {
                    bl = true;
                    standardPerformQOPModels = 4;
                } else {
                    string2 = "security.JSAS0406E";
                    SecurityLogger.logError(string2, new Object[]{string, "authenticity"});
                }
            } else if (DCEServerAssociationEnabled) {
                if (string3.equals("confidentiality") || string3.equals("high")) {
                    bl = true;
                    standardPerformQOPModels = 3;
                    performClientAuthentication = true;
                    performMessageConfidentiality = true;
                    performMessageIntegrity = true;
                    performMessageOutOfSequenceDetection = false;
                    performMessageReplayDetection = false;
                    performServerAuthentication = true;
                } else if (string3.equals("integrity") || string3.equals("medium")) {
                    bl = true;
                    standardPerformQOPModels = 2;
                    performClientAuthentication = true;
                    performMessageConfidentiality = false;
                    performMessageIntegrity = true;
                    performMessageOutOfSequenceDetection = false;
                    performMessageReplayDetection = false;
                    performServerAuthentication = true;
                } else if (string3.equals("authenticity") || string3.equals("low")) {
                    bl = true;
                    standardPerformQOPModels = 1;
                    performClientAuthentication = true;
                    performMessageConfidentiality = false;
                    performMessageIntegrity = false;
                    performMessageOutOfSequenceDetection = false;
                    performMessageReplayDetection = false;
                    performServerAuthentication = true;
                } else if (string3.equals("advanced")) {
                    bl = true;
                    standardPerformQOPModels = 4;
                } else {
                    string2 = "security.JSAS0406E";
                    SecurityLogger.logError(string2, new Object[]{string, "authenticity"});
                }
            }
        }
        if (!bl) {
            standardPerformQOPModels = 3;
            performClientAuthentication = true;
            performMessageConfidentiality = true;
            performMessageIntegrity = true;
            performMessageOutOfSequenceDetection = true;
            performMessageReplayDetection = true;
            performServerAuthentication = true;
        }
    }

    private synchronized void initializeRequestCredsExpiration() {
        String string = "SecurityConfiguration.initializeRequestCredsExpiration";
        String string2 = null;
        String string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.requestCredsExpiration"));
        if (string3 != null && string3.length() > 0) {
            long l = -1L;
            boolean bl = false;
            try {
                l = new Long(string3);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeRequestCredsExpiration", (String)"1592", (Object)this);
                string2 = "security.JSAS0471E";
                SecurityLogger.logError(string2, new Object[]{string, new Long(0L).toString()});
            }
            if (bl) {
                if (l != 0L) {
                    if (l < 600L) {
                        l = 600L;
                        bl = false;
                    } else if (l > 31449600L) {
                        l = 31449600L;
                        bl = false;
                    }
                }
                if (!bl) {
                    string2 = "security.JSAS0471E";
                    SecurityLogger.logError(string2, new Object[]{string, new Long(l).toString()});
                }
                requestCredsExpiration = l * 1000L;
            }
        }
    }

    private synchronized void initializeSecurityCacheTimeout() {
        String string = null;
        string = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.securityCacheTimeout"));
        if (string != null && string.length() > 0) {
            long l = -1L;
            boolean bl = false;
            try {
                l = new Long(string);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeSecurityCacheTimeout", (String)"1645", (Object)this);
                String string2 = "SecurityConfiguration.initializeSecurityCacheTimeout";
                String string3 = "security.JSAS0405E";
                SecurityLogger.logError(string3, new Object[]{string2, new Long(600L).toString()});
            }
            if (bl) {
                securityCacheTimeout = l;
            }
        }
    }

    private synchronized void initializeSecurityEnabled() {
        String string = null;
        string = securityProps.getProperty("com.ibm.CORBA.securityEnabled");
        if (string != null && string.length() > 0) {
            securityEnabled = this.checkTrueOrYes(string);
        }
        string = null;
        string = securityProps.getProperty("com.ibm.CORBA.serverSecurityEnabled");
        if (string != null && string.length() > 0) {
            serverSecurityEnabled = this.checkTrueOrYes(string);
        }
    }

    private synchronized void initializeSessionGC() {
        String string;
        String string2;
        boolean bl;
        int n;
        String string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.sessionGCenabled"));
        if (string3 != null && string3.length() > 0) {
            sessionGCenabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.sessionGCinterval"));
        if (string3 != null && string3.length() > 0) {
            n = -1;
            bl = false;
            try {
                n = new Integer(string3);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeSessionGC", (String)"1699", (Object)this);
                string2 = "SecurityConfiguration.initializeSessionGC";
                string = "security.JSAS0405E";
                SecurityLogger.logError(string, new Object[]{string2, new Integer(300000).toString()});
            }
            if (bl) {
                sessionGCinterval = n;
            }
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.sessionGCdiscardunused"));
        if (string3 != null && string3.length() > 0) {
            n = -1;
            bl = false;
            try {
                n = new Integer(string3);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeSessionGC", (String)"1725", (Object)this);
                string2 = "SecurityConfiguration.initializeSessionGC";
                string = "security.JSAS0405E";
                SecurityLogger.logError(string, new Object[]{string2, new Integer(900000).toString()});
            }
            if (bl) {
                sessionGCdiscardunused = n;
            }
        }
    }

    private synchronized void initializeNotifyBrokenConnectionEnabled() {
        String string = null;
        string = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.NotifyBrokenConnectionEnabled"));
        if (string != null && string.length() > 0) {
            NotifyBrokenConnectionEnabled = this.checkTrueOrYes(string);
        }
    }

    private synchronized void initializeWSSecurtyContext() {
        String string = null;
        string = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.WSSecurityContextCustomOID"));
        if (string != null && string.length() > 0) {
            WSSecurityContextCustomOID = string;
        }
        string = null;
        string = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.WSSecurityContextCustomClass"));
        if (string != null && string.length() > 0) {
            WSSecurityContextCustomClass = string;
        }
        string = null;
        string = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.WSSecurityContextActiveForwardable"));
        if (string != null && string.length() > 0) {
            WSSecurityContextActiveForwardable = this.checkTrueOrYes(string);
        }
        string = null;
        string = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.WSSecurityContextActiveOID"));
        if (string != null && string.length() > 0) {
            WSSecurityContextActiveOID = string;
        }
        string = null;
        string = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.WSSecurityContextActiveClass"));
        if (string != null && string.length() > 0) {
            WSSecurityContextActiveClass = string;
        }
    }

    private synchronized void initializeSSLPort() {
        boolean bl;
        int n;
        String string = "SecurityConfiguration.initializeSSLPort";
        String string2 = null;
        String string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.SSLPort"));
        if (string3 != null && string3.length() > 0) {
            n = -1;
            bl = false;
            try {
                n = new Integer(string3);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeSSLPort", (String)"1795", (Object)this);
                string2 = "security.JSAS0410E";
                SecurityLogger.logError(string2, new Object[]{string, new Integer(0).toString()});
            }
            if (bl) {
                SSLPort = n;
            }
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.SSLPort"));
        if (string3 != null && string3.length() > 0) {
            n = -1;
            bl = false;
            try {
                n = new Integer(string3);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeSSLPort", (String)"1820", (Object)this);
                string2 = "security.JSAS0410E";
                SecurityLogger.logError(string2, new Object[]{string, new Integer(0).toString()});
            }
            if (bl) {
                CSISSLPort = n;
            }
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.ClientCertSSLPort"));
        if (string3 != null && string3.length() > 0) {
            n = -1;
            bl = false;
            try {
                n = new Integer(string3);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeSSLPort", (String)"1846", (Object)this);
                string2 = "security.JSAS0410E";
                SecurityLogger.logError(string2, new Object[]{string, new Integer(0).toString()});
            }
            if (bl) {
                CSIClientCertSSLPort = n;
            }
        }
    }

    private synchronized void initializeSSLProperties() {
        boolean bl;
        String string = "SecurityConfiguration.initializeSSLProperties";
        String string2 = null;
        String string3 = null;
        string3 = SecurityConfiguration.clean(_orb.getProperty("com.ibm.CORBA.SSLClientAuthentication"));
        if (string3 != null && string3.length() > 0) {
            IIOPSSLClientAuthentication = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.SSLClientKeyRing"));
        if (string3 == null || string3.length() == 0) {
            string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.SSLKeyRing"));
        }
        if (string3 == null || string3.length() == 0) {
            string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.SSLKeyRingFile"));
        }
        if (string3 != null && string3.length() > 0) {
            SSLClientKeyRing = string3;
        }
        string3 = null;
        string3 = SecurityConfiguration.clean((String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return securityProps.getProperty("com.ibm.CORBA.SSLClientKeyRingPassword");
            }
        }));
        if (string3 == null || string3.length() == 0) {
            string3 = SecurityConfiguration.clean((String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return securityProps.getProperty("com.ibm.CORBA.SSLKeyRingPassword");
                }
            }));
        }
        if (string3 != null && string3.length() > 0) {
            SSLClientKeyRingPassword = string3;
        }
        if (SSLClientKeyRingPassword != null && SSLClientKeyRingPassword.length() > 0) {
            try {
                SSLClientKeyRingPassword = PasswordUtil.decode((String)SSLClientKeyRingPassword);
            }
            catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeSSLProperties", (String)"1900", (Object)this);
                string2 = "security.JSAS0485E";
                SecurityLogger.logError(string2, new Object[]{string, exception});
            }
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.IIOP.SSL_COMPOUND_TAG"));
        if (string3 != null && string3.length() > 0) {
            SSLCompoundTagEnabled = this.checkTrueOrYes(string3);
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.SSLCredentialsTimeout"));
        if (string3 != null && string3.length() > 0) {
            int n = -1;
            bl = false;
            try {
                n = new Integer(string3);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeSSLProperties", (String)"1928", (Object)this);
                string2 = "security.JSAS0409E";
                SecurityLogger.logError(string2, new Object[]{string, new Integer(86400).toString()});
            }
            if (bl) {
                if (n < 0) {
                    n = 0;
                    bl = false;
                } else if (n > 31536000) {
                    n = 31536000;
                    bl = false;
                }
                if (!bl) {
                    string2 = "security.JSAS0408E";
                    SecurityLogger.logError(string2, new Object[]{string, new Integer(86400).toString()});
                }
                SSLCredentialsTimeout = n;
            }
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.SSLServerKeyRing"));
        if (string3 == null || string3.length() == 0) {
            string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.SSLKeyRing"));
        }
        if (string3 == null || string3.length() == 0) {
            string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.SSLKeyRingFile"));
        }
        if (string3 != null && string3.length() > 0) {
            SSLServerKeyRing = string3;
        }
        string3 = null;
        string3 = SecurityConfiguration.clean((String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return securityProps.getProperty("com.ibm.CORBA.SSLServerKeyRingPassword");
            }
        }));
        if (string3 == null || string3.length() == 0) {
            string3 = SecurityConfiguration.clean((String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return securityProps.getProperty("com.ibm.CORBA.SSLKeyRingPassword");
                }
            }));
        }
        if (string3 != null && string3.length() > 0) {
            SSLServerKeyRingPassword = string3;
        }
        if (SSLServerKeyRingPassword != null && SSLServerKeyRingPassword.length() > 0) {
            try {
                SSLServerKeyRingPassword = PasswordUtil.decode((String)SSLServerKeyRingPassword);
            }
            catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeSSLProperties", (String)"1985", (Object)this);
                string2 = "security.JSAS0486E";
                SecurityLogger.logError(string2, new Object[]{string, exception});
            }
        }
        string3 = null;
        string3 = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.SSLV3SessionTimeout"));
        if (string3 != null && string3.length() > 0) {
            int n = -1;
            bl = false;
            try {
                n = new Integer(string3);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ISecurityUtilityImpl.SecurityConfiguration.initializeSSLProperties", (String)"2007", (Object)this);
                string2 = "security.JSAS0412E";
                SecurityLogger.logError(string2, new Object[]{string, new Integer(0).toString()});
            }
            if (bl) {
                if (n < 0) {
                    n = 0;
                    bl = false;
                } else if (n > 86400) {
                    n = 86400;
                    bl = false;
                }
                if (!bl) {
                    string2 = "security.JSAS0411E";
                    SecurityLogger.logError(string2, new Object[]{string, new Integer(86400).toString()});
                }
                SSLV3SessionTimeout = n;
            }
        }
    }

    private final void initializeDefaultStaticFile() {
        if (_orb != null) {
            keyFileName = _orb.getProperty("${WAS_PROPS_DIR}") + File.separator + "wsserver.key";
            keytabFileName = _orb.getProperty("${WAS_ETC_DIR}") + File.separator + "keytab5";
            SSLClientKeyRing = _orb.getProperty("${WAS_ETC_DIR}") + File.separator + "DummyKeyring.jks";
            SSLServerKeyRing = _orb.getProperty("${WAS_ETC_DIR}") + File.separator + "DummyKeyring.jks";
        }
    }

    private synchronized void initializeVerificationLevel() {
        String string = null;
        string = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CORBA.verificationLevel"));
        if (string != null && string.length() > 0) {
            if ((string = string.toLowerCase()).equals("activelycorrect")) {
                verificationLevel = 4;
            } else if (string.equals("completeness")) {
                verificationLevel = 1;
            } else if (string.equals(DefaultVerificationLevelString)) {
                verificationLevel = 2;
            } else if (string.equals("passivelycorrect")) {
                verificationLevel = 3;
            } else {
                String string2 = "SecurityConfiguration.initializeVerificationLevel";
                String string3 = "security.JSAS0623E";
                SecurityLogger.logError(string3, new Object[]{string2, DefaultVerificationLevelString});
            }
        }
        if ((string = SecurityConfiguration.clean(securityProps.getProperty("com.ibm.CSI.debugJAASCredWithStack"))) != null && string.length() > 0) {
            debugJAASCredWithStack = this.checkTrueOrYes(string);
        }
    }

    private boolean isValidClaimQOP() {
        return true;
    }

    private boolean isValidPerformQOP() {
        return true;
    }

    private void reportVerificationAnalysis(String string, String string2, int n) {
        if (SecurityLogger.debugTraceEnabled) {
            String string3 = "SecurityConfiguration.reportVerificationAnalysis";
            String string4 = null;
            switch (n) {
                case 0: {
                    string4 = SecurityMessages.getMsgOrUseDefault(string, string2);
                    SecurityLogger.logActivity(string3, 0, string4);
                    break;
                }
                case 1: {
                    SecurityLogger.logError("security." + string, new Object[]{string3});
                }
            }
        }
    }

    private void reportVerificationAnalysis(String string, String string2, String string3, String string4, int n) {
        if (SecurityLogger.debugTraceEnabled) {
            String string5 = "SecurityConfiguration.reportVerificationAnalysis";
            String string6 = null;
            switch (n) {
                case 0: {
                    string6 = componentLabel + ": " + string3 + " == " + string4;
                    SecurityLogger.logActivity(string5, 0, string6);
                    break;
                }
                case 1: {
                    SecurityLogger.logError("security." + string, new Object[]{string5});
                    string6 = componentLabel + string3 + " == " + string4;
                    SecurityLogger.debugMessage(string5, string6);
                }
            }
        }
    }

    private int verifyConfigurationActiveCorrectness(int n) {
        String string = "SecurityConfiguration.verifyConfigurationActiveCorrectness";
        String string2 = null;
        int n2 = -1;
        n2 = n == -1 ? 0 : n;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Verifying the configuration for active correctness.";
            SecurityLogger.debugMessage(string, string2);
        }
        if (n2 == 0) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS1400I", "JSAS1400I: The configuration appears to be actively correct.");
            SecurityLogger.logActivity(string, 0, string2);
        } else if (n2 == 3) {
            string2 = "security.JSAS0415E";
            SecurityLogger.logError(string2, new Object[]{string});
        } else if (n2 == -1) {
            string2 = "security.JSAS0416E";
            SecurityLogger.logError(string2, new Object[]{string});
        } else {
            string2 = "security.JSAS0417E";
            SecurityLogger.logError(string2, new Object[]{string, new Integer(n2).toString()});
        }
        return n2;
    }

    private int verifyConfigurationCompleteness(int n) {
        String string = "SecurityConfiguration.verifyConfigurationCompleteness";
        String string2 = null;
        int n2 = -1;
        n2 = n == -1 ? 0 : n;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Verifying the configuration for completeness.";
            SecurityLogger.debugMessage(string, string2);
        }
        if (configurationInitialized) {
            this.reportVerificationAnalysis("JSAS1401I", "JSAS1401I: The configuration has been initialized.", 0);
        } else {
            n2 = 1;
            string2 = "security.JSAS0418E";
            SecurityLogger.logError(string2, new Object[]{string});
        }
        if (securityEnabled) {
            this.reportVerificationAnalysis("JSAS1402I", "JSAS1402I: Security has been enabled.", 0);
            this.reportVerificationAnalysis("JSAS1419I", "JSAS1419I: The authentication target has been set:", "authenticationTarget", (String)AuthenticationTarget.strings.get(new Integer(authenticationTarget)), 0);
            this.reportVerificationAnalysis("JSAS1404I", "JSAS1404I: The login source has been set:", "loginSource", (String)SourceLocation.strings.get(new Integer(loginSource)), 0);
            if (loginSource == 3) {
                if (keyFileName != null && keyFileName.length() > 0) {
                    this.reportVerificationAnalysis("JSAS1408I", "JSAS1408I: The key file name has been set:", "keyFileName", keyFileName, 0);
                }
            } else if (loginSource == 2) {
                if (keytabFileName != null && keytabFileName.length() > 0) {
                    this.reportVerificationAnalysis("JSAS1407I", "JSAS1407I: The keytab file name has been set:", "keytabFileName", keytabFileName, 0);
                }
            } else if (loginSource == 5) {
                if (loginUserid != null && loginUserid.length() > 0) {
                    this.reportVerificationAnalysis("JSAS1405I", "JSAS1405I: The login userid has been set:", "loginUserid", loginUserid, 0);
                }
                if (loginPassword != null && loginPassword.length() > 0) {
                    this.reportVerificationAnalysis("JSAS1406I", "JSAS1406I: The login password has been set:", "loginPassword", SecurityConfiguration.mask(loginPassword), 0);
                }
            }
            if (principalName != null && principalName.length() > 0) {
                this.reportVerificationAnalysis("JSAS1409I", "JSAS1409I: The principal has been set:", "principalName", principalName, 0);
            } else if (authenticationTarget != 4) {
                this.reportVerificationAnalysis("JSAS1410I", "JSAS1410I: The principal was not set:", 0);
            }
            if (SSLTypeIClientAssociationEnabled || SSLTypeIServerAssociationEnabled || DCEClientAssociationEnabled || DCEServerAssociationEnabled || KerberosClientAssociationEnabled || KerberosServerAssociationEnabled || LocalOSClientAssociationEnabled || LocalOSServerAssociationEnabled || LTPAClientAssociationEnabled || LTPAServerAssociationEnabled) {
                if (SSLTypeIClientAssociationEnabled) {
                    this.reportVerificationAnalysis("JSAS1413I", "JSAS1413I: SSL Type-I client-association has been enabled.", 0);
                }
                if (SSLTypeIServerAssociationEnabled) {
                    this.reportVerificationAnalysis("JSAS1414I", "JSAS1414I: SSL Type-I server-association has been enabled.", 0);
                }
                if (DCEClientAssociationEnabled) {
                    this.reportVerificationAnalysis("JSAS1411I", "JSAS1411I: DCE client-association has been enabled.", 0);
                }
                if (DCEServerAssociationEnabled) {
                    this.reportVerificationAnalysis("JSAS1412I", "JSAS1412I: DCE server-association has been enabled.", 0);
                }
                if (LocalOSClientAssociationEnabled) {
                    this.reportVerificationAnalysis("JSAS1417I", "JSAS1417I: Local operating system client-association has been enabled.", 0);
                }
                if (LocalOSServerAssociationEnabled) {
                    this.reportVerificationAnalysis("JSAS1418I", "JSAS1418I: Local operating system server-association has been enabled.", 0);
                }
                if (LTPAClientAssociationEnabled) {
                    this.reportVerificationAnalysis("JSAS1415I", "JSAS1415I: LTPA client-association has been enabled.", 0);
                }
                if (LTPAServerAssociationEnabled) {
                    this.reportVerificationAnalysis("JSAS1416I", "JSAS1416I: LTPA server-association has been enabled.", 0);
                }
            } else {
                n2 = 1;
                string2 = "security.JSAS0420E";
                SecurityLogger.logError(string2, new Object[]{string});
            }
            this.reportVerificationAnalysis("JSAS1425I", "JSAS1425I: The SSL port has been set:", "SSLPort", Integer.toString(SSLPort), 0);
            this.reportVerificationAnalysis("JSAS1422I", "JSAS1422I: The SSL session timeout has been set:", "SSLV3SessionTimeout", Integer.toString(SSLV3SessionTimeout), 0);
            this.reportVerificationAnalysis("JSAS1423I", "JSAS1423I: The SSL credentials timeout has been set:", "SSLCredentialsTimeout", Integer.toString(SSLCredentialsTimeout), 0);
            this.reportVerificationAnalysis("JSAS1433I", "JSAS1433I: The standard claim-QOP model has been set:", "standardClaimQOPModels", (String)StandardClaimQOPModels.strings.get(new Integer(standardClaimQOPModels)), 0);
            if (standardClaimQOPModels == 4) {
                this.reportVerificationAnalysis("JSAS1434I", "JSAS1434I: The claim client-authentication required has been set:", "claimClientAuthenticationRequired", SecurityConfiguration.booleanString(claimClientAuthenticationRequired), 0);
                this.reportVerificationAnalysis("JSAS1440I", "JSAS1440I: The claim client-authentication supported has been set:", "claimClientAuthenticationSupported", SecurityConfiguration.booleanString(claimClientAuthenticationSupported), 0);
                this.reportVerificationAnalysis("JSAS1439I", "JSAS1439I: The claim message confidentiality required has been set:", "claimMessageConfidentialityRequired", SecurityConfiguration.booleanString(claimMessageConfidentialityRequired), 0);
                this.reportVerificationAnalysis("JSAS1445I", "JSAS1445I: The claim message confidentiality supported has been set:", "claimMessageConfidentialitySupported", SecurityConfiguration.booleanString(claimMessageConfidentialitySupported), 0);
                this.reportVerificationAnalysis("JSAS1438I", "JSAS1438I: The claim message integrity required has been set:", "claimMessageIntegrityRequired", SecurityConfiguration.booleanString(claimMessageIntegrityRequired), 0);
                this.reportVerificationAnalysis("JSAS1444I", "JSAS1444I: The claim message integrity supported has been set:", "claimMessageIntegritySupported", SecurityConfiguration.booleanString(claimMessageIntegritySupported), 0);
                this.reportVerificationAnalysis("JSAS1437I", "JSAS1437I: The claim message out-of-sequence detection required has been set:", "claimMessageOutOfSequenceDetectionRequired", SecurityConfiguration.booleanString(claimMessageOutOfSequenceDetectionRequired), 0);
                this.reportVerificationAnalysis("JSAS1443I", "JSAS1443I: The claim message out-of-sequence detection supported has been set:", "claimMessageOutOfSequenceDetectionSupported", SecurityConfiguration.booleanString(claimMessageOutOfSequenceDetectionSupported), 0);
                this.reportVerificationAnalysis("JSAS1436I", "JSAS1436I: The claim message replay detection required has been set:", "claimMessageReplayDetectionRequired", SecurityConfiguration.booleanString(claimMessageReplayDetectionRequired), 0);
                this.reportVerificationAnalysis("JSAS1442I", "JSAS1442I: The claim message replay detection supported has been set:", "claimMessageReplayDetectionSupported", SecurityConfiguration.booleanString(claimMessageReplayDetectionSupported), 0);
                this.reportVerificationAnalysis("JSAS1435I", "JSAS1435I: The claim server-authentication required has been set:", "claimServerAuthenticationRequired", SecurityConfiguration.booleanString(claimServerAuthenticationRequired), 0);
                this.reportVerificationAnalysis("JSAS1441I", "JSAS1441I: The claim server-authentication supported has been set:", "claimServerAuthenticationSupported", SecurityConfiguration.booleanString(claimServerAuthenticationSupported), 0);
            }
            this.reportVerificationAnalysis("JSAS1426I", "JSAS1426I: The standard perform-QOP model has been set:", "standardPerformQOPModels", (String)StandardPerformQOPModels.strings.get(new Integer(standardPerformQOPModels)), 0);
            if (standardPerformQOPModels == 4) {
                this.reportVerificationAnalysis("JSAS1427I", "JSAS1427I: The perform client-authentication has been set:", "performClientAuthentication", SecurityConfiguration.booleanString(performClientAuthentication), 0);
                this.reportVerificationAnalysis("JSAS1432I", "JSAS1432I: The perform message confidentiality has been set:", "performMessageConfidentiality", SecurityConfiguration.booleanString(performMessageConfidentiality), 0);
                this.reportVerificationAnalysis("JSAS1431I", "JSAS1431I: The perform message integrity has been set:", "performMessageIntegrity", SecurityConfiguration.booleanString(performMessageIntegrity), 0);
                this.reportVerificationAnalysis("JSAS1430I", "JSAS1430I: The perform message out-of-sequence detection has been set:", "performMessageOutOfSequenceDetection", SecurityConfiguration.booleanString(performMessageOutOfSequenceDetection), 0);
                this.reportVerificationAnalysis("JSAS1429I", "JSAS1429I: The perform message replay detection has been set:", "performMessageReplayDetection", SecurityConfiguration.booleanString(performMessageReplayDetection), 0);
                this.reportVerificationAnalysis("JSAS1428I", "JSAS1428I: The perform server-authentication has been set:", "performServerAuthentication", SecurityConfiguration.booleanString(performServerAuthentication), 0);
            }
            this.reportVerificationAnalysis("JSAS1446I", "JSAS1446I: The delegation mode has been set:", "delegateCredentials", (String)DelegationMode.strings.get(new Integer(delegateCredentials)), 0);
            if (requestCredsExpiration == 0L) {
                this.reportVerificationAnalysis("JSAS1458I", "JSAS1458I: Local credentials (basic auth. & op. sys.) will not expire.", 0);
            } else {
                this.reportVerificationAnalysis("JSAS1459I", "JSAS1459I: Local credentials (basic auth. & op. sys.) expiration has been set:", "requestCredsExpiration", Long.toString(requestCredsExpiration / 1000L), 0);
            }
            if (SSLCompoundTagEnabled) {
                this.reportVerificationAnalysis("JSAS1461I", "JSAS1461I: SSL security compound tag will be exported.", 0);
            }
        }
        if (SecurityLogger.debugTraceEnabled) {
            if (n2 == 0) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS1449I", "JSAS1449I: The configuration appears to be complete.");
                SecurityLogger.logActivity(string, 0, string2);
            } else if (n2 == 1) {
                string2 = "security.JSAS0422E";
                SecurityLogger.logError(string2, new Object[]{string});
            } else if (n2 == -1) {
                string2 = "security.JSAS0416E";
                SecurityLogger.logError(string2, new Object[]{string});
            } else {
                string2 = "security.JSAS0423E";
                SecurityLogger.logError(string2, new Object[]{string, new Integer(n2).toString()});
            }
        }
        return n2;
    }

    private int verifyConfigurationConsistency(int n) {
        String string;
        String string2 = "SecurityConfiguration.verifyConfigurationConsistency";
        String string3 = null;
        int n2 = -1;
        n2 = n == -1 ? 0 : n;
        if (SecurityLogger.debugTraceEnabled) {
            string3 = "Verifying the configuration for consistency.";
            SecurityLogger.debugMessage(string2, string3);
        }
        boolean bl = false;
        String string4 = System.getProperty("os.name");
        if (("z/OS".equalsIgnoreCase(string4) || "OS/390".equalsIgnoreCase(string4)) && (string = ContextManagerFactory.getInstance().getProperty("security.use.localos.userregistry")) != null && string.equalsIgnoreCase("true")) {
            bl = true;
        }
        if (!(bl || loginSource != 5 || loginUserid != null && loginUserid.length() != 0 && loginPassword != null && loginPassword.length() != 0)) {
            n2 = 2;
            string3 = "security.JSAS0424E";
            SecurityLogger.logError(string3, new Object[]{string2});
        } else if (loginSource == 2 && (keytabFileName == null || keytabFileName.length() == 0)) {
            n2 = 2;
            string3 = "security.JSAS0425E";
            SecurityLogger.logError(string3, new Object[]{string2});
        }
        if (!(!performClientAuthentication || SSLTypeIServerAssociationEnabled || DCEServerAssociationEnabled || KerberosServerAssociationEnabled || LocalOSServerAssociationEnabled || LTPAServerAssociationEnabled)) {
            n2 = 2;
            string3 = "security.JSAS0433E";
            SecurityLogger.logError(string3, new Object[]{string2});
        }
        if (standardClaimQOPModels == 4 && !this.isValidClaimQOP()) {
            n2 = 2;
            string3 = "security.JSAS0428E";
            SecurityLogger.logError(string3, new Object[]{string2});
        }
        if (standardPerformQOPModels == 4 && !this.isValidPerformQOP()) {
            n2 = 2;
            string3 = "security.JSAS0427E";
            SecurityLogger.logError(string3, new Object[]{string2});
        }
        if (requestCredsExpiration != 0L && requestCredsExpiration < (long)_orb.getRequestTimeout()) {
            string3 = "security.JSAS0472E";
            SecurityLogger.logError(string3, new Object[]{string2});
        }
        if (SecurityLogger.debugTraceEnabled) {
            if (n2 == 0) {
                string3 = SecurityMessages.getMsgOrUseDefault("JSAS1450I", "JSAS1450I: The configuration appears to be consistent.");
                SecurityLogger.logActivity(string2, 0, string3);
            } else if (n2 == 2) {
                string3 = "security.JSAS0429E";
                SecurityLogger.logError(string3, new Object[]{string2});
            } else if (n2 == -1) {
                string3 = "security.JSAS0416E";
                SecurityLogger.logError(string3, new Object[]{string2});
            } else {
                string3 = "security.JSAS0430E";
                SecurityLogger.logError(string3, new Object[]{string2, new Integer(n2).toString()});
            }
        }
        return n2;
    }

    private int verifyConfigurationPassiveCorrectness(int n) {
        String string = "SecurityConfiguration.verifyConfigurationPassiveCorrectness";
        String string2 = null;
        int n2 = -1;
        n2 = n == -1 ? 0 : n;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Verifying the configuration for passive correctness.";
            SecurityLogger.debugMessage(string, string2);
        }
        if (n2 == 0) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS1451I", "JSAS1451I: The configuration appears to be passively correct.");
            SecurityLogger.logActivity(string, 0, string2);
        } else if (n2 == 3) {
            string2 = "security.JSAS0415E";
            SecurityLogger.logError(string2, new Object[]{string});
        } else if (n2 == -1) {
            string2 = "security.JSAS0416E";
            SecurityLogger.logError(string2, new Object[]{string});
        } else {
            string2 = "security.JSAS0431E";
            SecurityLogger.logError(string2, new Object[]{string, new Integer(n2).toString()});
        }
        return n2;
    }

    private static String booleanString(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        return bl2.toString();
    }

    private boolean checkTrueOrYes(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    private static String clean(String string) {
        String string2 = null;
        if (string != null && ((string2 = string.trim()).startsWith("\"") && string2.endsWith("\"") || string2.startsWith("'") && string2.endsWith("'"))) {
            string2 = string2.substring(1, string2.length() - 1).trim();
        }
        return string2;
    }

    public final SSLConfiguration getDefaultSSLConfig() {
        return this.defaultSSLConfig;
    }

    public final SSLConfiguration getSASOutboundSSLConfig() {
        return this.sasOutboundSSLConfig;
    }

    public final SSLConfiguration getSASInboundSSLConfig() {
        return this.sasInboundSSLConfig;
    }

    public final SSLConfiguration getCSIOutboundSSLConfig() {
        return this.csiOutboundSSLConfig;
    }

    public final SSLConfiguration getCSIInboundSSLConfig() {
        return this.csiInboundSSLConfig;
    }

    public final String getRealmName() {
        return csConfig.getRealmName();
    }

    public final boolean getCSIv2ClaimStateful() {
        return csConfig.getCSIv2ClaimStateful();
    }

    public final String getCSIv2TrustedPrincipalList() {
        return csConfig.getCSIv2TrustedPrincipalList();
    }

    public final boolean getCSIv2ClaimTransportAssocSSLTLSRequired() {
        return csConfig.getCSIv2ClaimTransportAssocSSLTLSRequired();
    }

    public final boolean getCSIv2ClaimTransportAssocSSLTLSSupported() {
        return csConfig.getCSIv2ClaimTransportAssocSSLTLSSupported();
    }

    public final boolean getCSIv2ClaimMessageConfidentialityRequired() {
        return csConfig.getCSIv2ClaimMessageConfidentialityRequired();
    }

    public final boolean getCSIv2ClaimMessageConfidentialitySupported() {
        return csConfig.getCSIv2ClaimMessageConfidentialitySupported();
    }

    public final boolean getCSIv2ClaimMessageIntegrityRequired() {
        return csConfig.getCSIv2ClaimMessageIntegrityRequired();
    }

    public final boolean getCSIv2ClaimMessageIntegritySupported() {
        return csConfig.getCSIv2ClaimMessageIntegritySupported();
    }

    public final boolean getCSIv2ClaimTLClientAuthenticationRequired() {
        return csConfig.getCSIv2ClaimTLClientAuthenticationRequired();
    }

    public final boolean getCSIv2ClaimTLClientAuthenticationSupported() {
        return csConfig.getCSIv2ClaimTLClientAuthenticationSupported();
    }

    public final boolean getCSIv2ClaimClientAuthenticationRequired() {
        return csConfig.getCSIv2ClaimClientAuthenticationRequired();
    }

    public final boolean getCSIv2ClaimClientAuthenticationSupported() {
        return csConfig.getCSIv2ClaimClientAuthenticationSupported();
    }

    public final boolean getCSIv2ClaimIdentityAssertionSupported() {
        return csConfig.getCSIv2ClaimIdentityAssertionSupported();
    }

    public final boolean getCSIv2PerformStateful() {
        return csConfig.getCSIv2PerformStateful();
    }

    public final boolean getCSIv2PerformTransportAssocSSLTLSRequired() {
        return csConfig.getCSIv2PerformTransportAssocSSLTLSRequired();
    }

    public final boolean getCSIv2PerformTransportAssocSSLTLSSupported() {
        return csConfig.getCSIv2PerformTransportAssocSSLTLSSupported();
    }

    public final boolean getCSIv2PerformMessageConfidentialityRequired() {
        return csConfig.getCSIv2PerformMessageConfidentialityRequired();
    }

    public final boolean getCSIv2PerformMessageConfidentialitySupported() {
        return csConfig.getCSIv2PerformMessageConfidentialitySupported();
    }

    public final boolean getCSIv2PerformMessageIntegrityRequired() {
        return csConfig.getCSIv2PerformMessageIntegrityRequired();
    }

    public final boolean getCSIv2PerformMessageIntegritySupported() {
        return csConfig.getCSIv2PerformMessageIntegritySupported();
    }

    public final boolean getCSIv2PerformTLClientAuthenticationRequired() {
        return csConfig.getCSIv2PerformTLClientAuthenticationRequired();
    }

    public final boolean getCSIv2PerformTLClientAuthenticationSupported() {
        return csConfig.getCSIv2PerformTLClientAuthenticationSupported();
    }

    public final boolean getCSIv2PerformClientAuthenticationRequired() {
        return csConfig.getCSIv2PerformClientAuthenticationRequired();
    }

    public final boolean getCSIv2PerformClientAuthenticationSupported() {
        return csConfig.getCSIv2PerformClientAuthenticationSupported();
    }

    public final boolean getCSIv2PerformIdentityAssertionRequired() {
        return csConfig.getCSIv2PerformIdentityAssertionRequired();
    }

    public final boolean getCSIv2PerformIdentityAssertionSupported() {
        return csConfig.getCSIv2PerformIdentityAssertionSupported();
    }

    public final int getCSIv2StandardClaimQOPModels() {
        return csConfig.getCSIv2StandardClaimQOPModels();
    }

    public final int getCSIv2StandardPerformQOPModels() {
        return csConfig.getCSIv2StandardPerformQOPModels();
    }

    public final boolean getCSIv2PerformTransportAssocSECIOPRequired() {
        return csConfig.getCSIv2PerformTransportAssocSECIOPRequired();
    }

    public final boolean getCSIv2PerformTransportAssocSECIOPSupported() {
        return csConfig.getCSIv2PerformTransportAssocSECIOPSupported();
    }

    public final boolean getCSIv2ClaimTransportAssocSECIOP() {
        return csConfig.getCSIv2ClaimTransportAssocSECIOP();
    }

    public final boolean getCSIv2ClaimMessageMisorderingDetectionRequired() {
        return csConfig.getCSIv2ClaimMessageMisorderingDetectionRequired();
    }

    public final boolean getCSIv2ClaimMessageMisorderingDetectionSupported() {
        return csConfig.getCSIv2ClaimMessageMisorderingDetectionSupported();
    }

    public final boolean getCSIv2ClaimMessageReplayDetectionRequired() {
        return csConfig.getCSIv2ClaimMessageReplayDetectionRequired();
    }

    public final boolean getCSIv2ClaimMessageReplayDetectionSupported() {
        return csConfig.getCSIv2ClaimMessageReplayDetectionSupported();
    }

    public final boolean getCSIv2ClaimTLServerAuthenticationSupported() {
        return csConfig.getCSIv2ClaimTLServerAuthenticationSupported();
    }

    public final boolean getCSIv2ClaimServerAuthenticationRequired() {
        return csConfig.getCSIv2ClaimServerAuthenticationRequired();
    }

    public final boolean getCSIv2ClaimServerAuthenticationSupported() {
        return csConfig.getCSIv2ClaimServerAuthenticationSupported();
    }

    public final boolean getCSIv2ClaimDelegationByClientRequired() {
        return csConfig.getCSIv2ClaimDelegationByClientRequired();
    }

    public final boolean getCSIv2ClaimDelegationByClientSupported() {
        return csConfig.getCSIv2ClaimDelegationByClientSupported();
    }

    public final boolean getCSIv2PerformMessageMisorderingDetectionRequired() {
        return csConfig.getCSIv2PerformMessageMisorderingDetectionRequired();
    }

    public final boolean getCSIv2PerformMessageMisorderingDetectionSupported() {
        return csConfig.getCSIv2PerformMessageMisorderingDetectionSupported();
    }

    public final boolean getCSIv2PerformMessageReplayDetectionRequired() {
        return csConfig.getCSIv2PerformMessageReplayDetectionRequired();
    }

    public final boolean getCSIv2PerformMessageReplayDetectionSupported() {
        return csConfig.getCSIv2PerformMessageReplayDetectionSupported();
    }

    public final boolean getCSIv2PerformTLServerAuthenticationRequired() {
        return csConfig.getCSIv2PerformTLServerAuthenticationRequired();
    }

    public final boolean getCSIv2PerformTLServerAuthenticationSupported() {
        return csConfig.getCSIv2PerformTLServerAuthenticationSupported();
    }

    public final int getCSIv2PerformIdentityAssertionType() {
        return csConfig.getCSIv2PerformIdentityAssertionType();
    }

    public final int getCSIv2PerformIdentityAssertionMechanism() {
        return csConfig.getCSIv2PerformIdentityAssertionMechanism();
    }

    public final boolean getCSIv2PerformDelegationByClientRequired() {
        return csConfig.getCSIv2PerformDelegationByClientRequired();
    }

    public final boolean getCSIv2PerformDelegationByClientSupported() {
        return csConfig.getCSIv2PerformDelegationByClientSupported();
    }

    public final boolean getCSIv2KerberosClientAssociationRequired() {
        return csConfig.getCSIv2KerberosClientAssociationRequired();
    }

    public final boolean getCSIv2KerberosServerAssociationRequired() {
        return csConfig.getCSIv2KerberosServerAssociationRequired();
    }

    public final boolean getCSIv2KerberosClientAssociationSupported() {
        return csConfig.getCSIv2KerberosClientAssociationSupported();
    }

    public final boolean getCSIv2KerberosServerAssociationSupported() {
        return csConfig.getCSIv2KerberosServerAssociationSupported();
    }

    public final boolean getCSIv2LocalOSClientAssociationRequired() {
        return csConfig.getCSIv2LocalOSClientAssociationRequired();
    }

    public final boolean getCSIv2LocalOSServerAssociationRequired() {
        return csConfig.getCSIv2LocalOSServerAssociationRequired();
    }

    public final boolean getCSIv2LocalOSClientAssociationSupported() {
        return csConfig.getCSIv2LocalOSClientAssociationSupported();
    }

    public final boolean getCSIv2LocalOSServerAssociationSupported() {
        return csConfig.getCSIv2LocalOSServerAssociationSupported();
    }

    public final boolean getCSIv2LTPAClientAssociationRequired() {
        return csConfig.getCSIv2LTPAClientAssociationRequired();
    }

    public final boolean getCSIv2LTPAServerAssociationRequired() {
        return csConfig.getCSIv2LTPAServerAssociationRequired();
    }

    public final boolean getCSIv2LTPAClientAssociationSupported() {
        return csConfig.getCSIv2LTPAClientAssociationSupported();
    }

    public final boolean getCSIv2LTPAServerAssociationSupported() {
        return csConfig.getCSIv2LTPAServerAssociationSupported();
    }

    public static final boolean secConfigInitialized() {
        return secConfigInitialized;
    }

    public static final String getSOAPUserid() {
        return soapLoginUserid;
    }

    public static final String getSOAPPassword() {
        return soapLoginPassword;
    }

    public final String getProtocol() {
        return protocol;
    }

    public final int getdelegateCredentials() {
        return delegateCredentials;
    }

    public final String getprincipalName() {
        return principalName;
    }

    public final boolean securityEnabled() {
        return securityEnabled;
    }

    public final boolean SSLTypeIClientAssociationEnabled() {
        return SSLTypeIClientAssociationEnabled;
    }

    public final int getauthenticationTarget() {
        return authenticationTarget;
    }

    public final String getWSSecurityContextCustomOID() {
        return WSSecurityContextCustomOID;
    }

    public final boolean sessionGCenabled() {
        return sessionGCenabled;
    }

    public final int getsessionGCinterval() {
        return sessionGCinterval;
    }

    public final int getloginSource() {
        return loginSource;
    }

    public final int getloginTimeout() {
        return loginTimeout;
    }

    public final String getloginUserid() {
        return loginUserid;
    }

    public final String getloginPassword() {
        return loginPassword;
    }

    public final boolean authenticationRetryEnabled() {
        return authenticationRetryEnabled;
    }

    public final boolean performClientAuthentication() {
        return performClientAuthentication;
    }

    public final boolean performServerAuthentication() {
        return performServerAuthentication;
    }

    public final boolean performMessageReplayDetection() {
        return performMessageReplayDetection;
    }

    public final boolean performMessageOutOfSequenceDetection() {
        return performMessageOutOfSequenceDetection;
    }

    public final boolean performMessageIntegrity() {
        return performMessageIntegrity;
    }

    public final boolean performMessageConfidentiality() {
        return performMessageConfidentiality;
    }

    public final boolean delegateBasicAuth() {
        return delegateBasicAuth;
    }

    public final boolean NotifyBrokenConnectionEnabled() {
        return NotifyBrokenConnectionEnabled;
    }

    public final boolean claimClientAuthenticationRequired() {
        return claimClientAuthenticationRequired;
    }

    public final boolean claimServerAuthenticationRequired() {
        return claimServerAuthenticationRequired;
    }

    public final boolean claimMessageReplayDetectionRequired() {
        return claimMessageReplayDetectionRequired;
    }

    public final boolean claimMessageOutOfSequenceDetectionRequired() {
        return claimMessageOutOfSequenceDetectionRequired;
    }

    public final boolean claimMessageIntegrityRequired() {
        return claimMessageIntegrityRequired;
    }

    public final boolean claimMessageConfidentialityRequired() {
        return claimMessageConfidentialityRequired;
    }

    public final boolean claimClientAuthenticationSupported() {
        return claimClientAuthenticationSupported;
    }

    public final boolean claimServerAuthenticationSupported() {
        return claimServerAuthenticationSupported;
    }

    public final boolean claimMessageReplayDetectionSupported() {
        return claimMessageReplayDetectionSupported;
    }

    public final boolean claimMessageOutOfSequenceDetectionSupported() {
        return claimMessageOutOfSequenceDetectionSupported;
    }

    public final boolean claimMessageIntegritySupported() {
        return claimMessageIntegritySupported;
    }

    public final boolean claimMessageConfidentialitySupported() {
        return claimMessageConfidentialitySupported;
    }

    public final int getSSLPort() {
        return SSLPort;
    }

    public final int getSSLV3SessionTimeout() {
        return SSLV3SessionTimeout;
    }

    public final boolean SSLMessageLoggingEnabled() {
        return SSLMessageLoggingEnabled;
    }

    public final int getCSISSLPort() {
        return CSISSLPort;
    }

    public final int getCSIClientCertSSLPort() {
        return CSIClientCertSSLPort;
    }

    public final boolean SSLTypeIServerAssociationEnabled() {
        return SSLTypeIServerAssociationEnabled;
    }

    public final long getrequestCredsExpiration() {
        return requestCredsExpiration;
    }

    public final String getkeyFileName() {
        return keyFileName;
    }

    public final long getsecurityCacheTimeout() {
        return securityCacheTimeout;
    }

    public final long getMinimumRequestCredsExpiration() {
        return 600L;
    }

    public final int getauthenticationRetryCount() {
        return authenticationRetryCount;
    }

    public final int getsessionGCdiscardunused() {
        return sessionGCdiscardunused;
    }

    public final boolean validateBasicAuth() {
        return validateBasicAuth;
    }

    public final void setValidateBasicAuth(boolean bl) {
        if (SecurityLogger.debugTraceEnabled) {
            String string = "SecurityConfiguration.setValidateBasicAuth";
            String string2 = "validateBasicAuth set to " + bl + ".";
            SecurityLogger.debugMessage(string, string2);
        }
        validateBasicAuth = bl;
    }

    public final boolean DCEClientAssociationEnabled() {
        return DCEClientAssociationEnabled;
    }

    public final String IBMSecurityTagCompatibility() {
        return IBMSecurityTagCompatibility;
    }

    public final String getWSSecurityContextCustomClass() {
        return WSSecurityContextCustomClass;
    }

    public final String getWSSecurityContextActiveClass() {
        return WSSecurityContextActiveClass;
    }

    public final String getWSSecurityContextActiveOID() {
        return WSSecurityContextActiveOID;
    }

    public final boolean getWSSecurityContextActiveForwardable() {
        return WSSecurityContextActiveForwardable;
    }

    public String getSecurityServerHost() {
        return SecurityServerHost;
    }

    public String getSecurityServerPort() {
        return SecurityServerPort;
    }

    public void setSecurityServerHost(String string) {
        SecurityServerHost = string;
    }

    public void setSecurityServerPort(String string) {
        SecurityServerPort = string;
    }

    public boolean getSecurityServerEnabled() {
        return serverSecurityEnabled;
    }

    public boolean processIsServer() {
        return processIsServer;
    }

    public int getDaysBeforeExpireWarning() {
        return daysBeforeExpireWarning;
    }

    public String getAuthMechAuthAlias() {
        return AuthMechAuthAlias;
    }

    public String getActiveUserRegistry() {
        return ActiveUserRegistry;
    }

    public boolean getIIOPSSLClientAuthentication() {
        return IIOPSSLClientAuthentication;
    }

    public boolean useDefaultSubjectForThreads() {
        return useDefaultSubjectForThreads;
    }

    public boolean isPluggableAuthenticationEnabled() {
        return enablePluggableAuthentication;
    }

    public boolean isRMIOutboundPropagationEnabled() {
        return rmiOutboundPropagationEnabled;
    }

    public boolean isRMIInboundPropagationEnabled() {
        return rmiInboundPropagationEnabled;
    }

    public boolean isWebInboundPropagationEnabled() {
        return webInboundPropagationEnabled;
    }

    public boolean isSSOInteropModeEnabled() {
        return ssoInteropModeEnabled;
    }

    public boolean isRMIOutboundLoginEnabled() {
        return rmiOutboundLoginEnabled;
    }

    public boolean isWebChallengeIfCustomSubjectNotFound() {
        return webChallengeIfCustomSubjectNotFound;
    }

    public String getCellNodeServerName() {
        return CellNodeServer;
    }

    public String getRMIInboundLoginConfig() {
        return rmiInboundLoginConfig;
    }

    public String getWebInboundLoginConfig() {
        return webInboundLoginConfig;
    }

    public String getRMIOutboundLoginConfig() {
        return rmiOutboundLoginConfig;
    }

    public String getSupportedTargetRealms() {
        return supportedTargetRealms;
    }

    public String getWebPropagationTransport() {
        return webPropagationTransport;
    }

    public boolean getLTPASupportedWithKerberos() {
        return ltpaSupportedWithKerberos;
    }

    public boolean includeRunAsChangesInCallerList() {
        return includeRunAsChangesInCallerList;
    }

    public boolean assertLDAPShortName() {
        return assertLDAPShortName;
    }
}

