/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.IExtendedSecurityReplaceablePriv.Vault;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectBasicAuthImpl.PrincipalAuthenticatorImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityLocalObjectLTPAImpl.CredentialsImpl;
import com.ibm.ISecurityLocalObjectTokenBaseImpl.SecurityContextImpl;
import com.ibm.ISecurityUtilityImpl.MechanismAmbiguityException;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.VaultConstants;
import org.omg.SecurityLevel2.Credentials;
import org.omg.SecurityLevel2.PrincipalAuthenticator;
import org.omg.SecurityReplaceable.SecurityContext;

public class MechanismFactory {
    private SecurityConfiguration secConfig = null;
    private VaultImpl vault = null;
    public static final String BasicAuthOverSSL = "1.1";
    public static final String BasicAuthOverSSLtoLTPA = "1.1.1";
    public static final String BasicAuthOverSSLtoLocalOS = "1.1.2";
    public static final String BasicAuthOverSSLtoDCE = "1.1.3";
    public static final String BasicAuthOverSSLtoCustom = "1.1.4";
    public static final String MutualSSL = "1.2";
    public static final String LTPAoverSSL = "1.3";
    public static final String LocalOSoverSSL = "1.4";
    public static final String GSSUPOverSSL = "1.5";
    public static final String GSSUPOverSSLtoLTPA = "1.5.1";
    public static final String GSSUPOverSSLtoLocalOS = "1.5.2";
    public static final String GSSUPOverSSLtoDCE = "1.5.3";
    public static final String GSSUPOverSSLtoCustom = "1.5.4";
    public static final String GSSUPOverSSLtoKRB5 = "1.5.5";
    public static final String Kerberos5overSSL = "1.6";
    public static final String CustomoverSSL = "1.7";
    public static final String BasicAuthOverIPSec = "2.1";
    public static final String MutualIPSec = "2.2";
    public static final String DCEKerberos = "3.1";
    public static final String ClientCerttoDCEKerberos = "3.2";
    public static final String Kerberos5 = "4.1";
    public static final String ClientCerttoKerberos5 = "4.2";
    public static final String ClientCerttoCustom = "4.3";
    public static final String LTPAoverTCP = "5.1";
    public static final String LocalOSoverTCP = "5.2";
    public static final String BasicAuthOverTCPtoLTPA = "5.3";
    public static final String BasicAuthOverTCPtoLocalOS = "5.4";
    public static final String BasicAuthOverTCPtoDCE = "5.5";
    public static final String BasicAuthOverTCP = "5.6";
    public static final String GSSUPOverTCPtoLTPA = "5.7.1";
    public static final String GSSUPOverTCPtoLocalOS = "5.7.2";
    public static final String GSSUPOverTCPtoDCE = "5.7.3";
    public static final String GSSUPOverTCP = "5.7.4";
    public static final String GSSUPOverTCPtoCustom = "5.7.5";
    public static final String GSSUPOverTCPtoKRB5 = "5.7.6";
    public static final String Kerberos5overTCP = "5.8";
    public static final String CustomoverTCP = "5.9";
    public static final String UnauthenticatedOverSSL = "6.1";

    protected MechanismFactory() {
    }

    public MechanismFactory(SecurityConfiguration securityConfiguration) {
        this.secConfig = securityConfiguration;
    }

    public VaultImpl getVault() {
        if (this.vault == null) {
            this.vault = VaultImpl.getInstance();
        }
        return this.vault;
    }

    public String getMechanismTypeIdentity() throws MechanismAmbiguityException {
        if (this.secConfig.getProtocol().equalsIgnoreCase("ibm")) {
            return this.getMechanismTypeIdentity(1);
        }
        if (this.secConfig.getProtocol().equalsIgnoreCase("csiv2")) {
            return this.getMechanismTypeIdentity(2);
        }
        return this.getMechanismTypeIdentity(1);
    }

    public String getMechanismTypeIdentity(int n) throws MechanismAmbiguityException {
        String string = "MechanismFactory.getMechanismTypeIdentity";
        Object var3_3 = null;
        return this.getMechanismTypeIdentity(n, "oid:2.23.130.1.1.1");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getMechanismTypeIdentity(int n, String string) throws MechanismAmbiguityException {
        String string2 = "MechanismFactory.getMechanismTypeIdentity";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (n == 1) {
            if (this.secConfig.SSLTypeIClientAssociationEnabled()) {
                if (this.secConfig.getauthenticationTarget() == 1 && string.compareTo("oid:1.3.18.0.2.30.2") == 0) {
                    string4 = LTPAoverSSL;
                    string5 = "LTPAoverSSL";
                } else if (this.secConfig.getauthenticationTarget() == 1 && string.compareTo("oid:2.23.130.1.1.1") == 0) {
                    string4 = BasicAuthOverSSLtoLTPA;
                    string5 = "BasicAuthOverSSLtoLTPA";
                } else if (this.secConfig.getauthenticationTarget() == 2) {
                    string4 = BasicAuthOverSSLtoLocalOS;
                    string5 = "BasicAuthOverSSLtoLocalOS";
                } else {
                    if (this.secConfig.getauthenticationTarget() != 4) throw new MechanismAmbiguityException();
                    string4 = BasicAuthOverSSL;
                    string5 = "BasicAuthOverSSL";
                }
            } else if (this.secConfig.getauthenticationTarget() == 1 && string.compareTo("oid:1.3.18.0.2.30.2") == 0) {
                string4 = LTPAoverTCP;
                string5 = "LTPAoverTCP";
            } else if (this.secConfig.getauthenticationTarget() == 1 && string.compareTo("oid:2.23.130.1.1.1") == 0) {
                string4 = BasicAuthOverTCPtoLTPA;
                string5 = "BasicAuthOverTCPtoLTPA";
            } else if (this.secConfig.getauthenticationTarget() == 2) {
                string4 = BasicAuthOverTCPtoLocalOS;
                string5 = "BasicAuthOverTCPtoLocalOS";
            } else {
                if (this.secConfig.getauthenticationTarget() != 4) throw new MechanismAmbiguityException();
                string4 = BasicAuthOverTCP;
                string5 = "BasicAuthOverTCP";
            }
        } else if (n == 2) {
            if (this.secConfig.getCSIv2ClaimTransportAssocSSLTLSRequired() || this.secConfig.getCSIv2ClaimTransportAssocSSLTLSSupported()) {
                if (this.secConfig.getauthenticationTarget() == 1 && string.compareTo("oid:1.3.18.0.2.30.2") == 0) {
                    string4 = LTPAoverSSL;
                    string5 = "LTPAoverSSL";
                } else if (this.secConfig.getauthenticationTarget() == 1 && string.compareTo("oid:2.23.130.1.1.1") == 0) {
                    string4 = GSSUPOverSSLtoLTPA;
                    string5 = "GSSUPOverSSLtoLTPA";
                } else if (this.secConfig.getauthenticationTarget() == 2) {
                    string4 = GSSUPOverSSLtoLocalOS;
                    string5 = "GSSUPOverSSLtoLocalOS";
                } else if (this.secConfig.getauthenticationTarget() == 4) {
                    string4 = GSSUPOverSSL;
                    string5 = "GSSUPOverSSL";
                } else if (this.secConfig.getauthenticationTarget() == 8) {
                    string4 = GSSUPOverSSLtoCustom;
                    string5 = "GSSUPOverSSLtoCustom";
                } else if (this.secConfig.getauthenticationTarget() == 6) {
                    string4 = GSSUPOverSSLtoKRB5;
                    string5 = "GSSUPOverSSLtoKRB5";
                } else {
                    if (this.secConfig.getauthenticationTarget() != 9) throw new MechanismAmbiguityException();
                    string4 = CustomoverSSL;
                    string5 = "CustomoverSSL";
                }
            } else if (this.secConfig.getauthenticationTarget() == 1 && string.compareTo("oid:1.3.18.0.2.30.2") == 0) {
                string4 = LTPAoverTCP;
                string5 = "LTPAoverTCP";
            } else if (this.secConfig.getauthenticationTarget() == 1 && string.compareTo("oid:2.23.130.1.1.1") == 0) {
                string4 = GSSUPOverTCPtoLTPA;
                string5 = "GSSUPOverTCPtoLTPA";
            } else if (this.secConfig.getauthenticationTarget() == 2) {
                string4 = GSSUPOverTCPtoLocalOS;
                string5 = "GSSUPOverTCPtoLocalOS";
            } else if (this.secConfig.getauthenticationTarget() == 4) {
                string4 = GSSUPOverTCP;
                string5 = "GSSUPOverTCP";
            } else if (this.secConfig.getauthenticationTarget() == 8) {
                string4 = GSSUPOverTCPtoCustom;
                string5 = "GSSUPOverTCPtoCustom";
            } else {
                if (this.secConfig.getauthenticationTarget() != 6) throw new MechanismAmbiguityException();
                string4 = GSSUPOverTCPtoKRB5;
                string5 = "GSSUPOverTCPtoKRB5";
            }
        } else {
            if (!SecurityLogger.debugTraceEnabled) throw new MechanismAmbiguityException();
            string3 = "A specific protocol must be passed into this method, type \"both\" is not allowed here.";
            SecurityLogger.debugMessage(string2, string3);
            throw new MechanismAmbiguityException();
        }
        if (!SecurityLogger.debugTraceEnabled) return string4;
        string3 = "Returning mechanism type: " + string5;
        SecurityLogger.debugMessage(string2, string3);
        return string4;
    }

    public PrincipalAuthenticator getPrincipalAuthenticator(Vault vault) throws MechanismAmbiguityException {
        if (this.secConfig.getProtocol().equalsIgnoreCase("ibm")) {
            return this.getPrincipalAuthenticator(1);
        }
        if (this.secConfig.getProtocol().equalsIgnoreCase("csiv2")) {
            return this.getPrincipalAuthenticator(2);
        }
        return this.getPrincipalAuthenticator(2);
    }

    public PrincipalAuthenticator getPrincipalAuthenticator(int n) throws MechanismAmbiguityException {
        String string = "MechanismFactory.getPrincipalAuthenticator";
        String string2 = null;
        PrincipalAuthenticatorImpl principalAuthenticatorImpl = null;
        if (n == 1) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Returning BasicAuth PrincipalAuthenticator.";
                SecurityLogger.debugMessage(string, string2);
            }
            principalAuthenticatorImpl = new PrincipalAuthenticatorImpl(this.getVault());
        } else if (n == 2) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Returning GSSUP PrincipalAuthenticator.";
                SecurityLogger.debugMessage(string, string2);
            }
            principalAuthenticatorImpl = new PrincipalAuthenticatorImpl(this.getVault());
        } else {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "A specific protocol must be passed into this method, type \"both\" is not allowed here.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new MechanismAmbiguityException();
        }
        return principalAuthenticatorImpl;
    }

    public PrincipalAuthenticator getPrincipalAuthenticator(Vault vault, int n) throws MechanismAmbiguityException {
        if (this.secConfig.getProtocol().equalsIgnoreCase("ibm")) {
            return this.getPrincipalAuthenticator(n, 1);
        }
        if (this.secConfig.getProtocol().equalsIgnoreCase("csiv2")) {
            return this.getPrincipalAuthenticator(n, 2);
        }
        return this.getPrincipalAuthenticator(n, 2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public PrincipalAuthenticator getPrincipalAuthenticator(int n, int n2) throws MechanismAmbiguityException {
        void var5_11;
        String string = "MechanismFactory.getPrincipalAuthenticator";
        String string2 = null;
        Object var5_5 = null;
        if (n == 2) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Returning LocalOS PrincipalAuthenticator.";
                SecurityLogger.debugMessage(string, string2);
            }
            com.ibm.ISecurityLocalObjectLocalOSImpl.PrincipalAuthenticatorImpl principalAuthenticatorImpl = new com.ibm.ISecurityLocalObjectLocalOSImpl.PrincipalAuthenticatorImpl(this.getVault());
            return var5_11;
        }
        if (n == 4) {
            if (n2 == 1) {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Returning BasicAuth PrincipalAuthenticator.";
                    SecurityLogger.debugMessage(string, string2);
                }
                PrincipalAuthenticatorImpl principalAuthenticatorImpl = new PrincipalAuthenticatorImpl(this.getVault());
                return var5_11;
            }
            if (n2 != 2) {
                if (!SecurityLogger.debugTraceEnabled) throw new MechanismAmbiguityException();
                string2 = "A specific protocol must be passed into this method, type \"both\" is not allowed here.";
                SecurityLogger.debugMessage(string, string2);
                throw new MechanismAmbiguityException();
            }
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Returning GSSUP PrincipalAuthenticator.";
                SecurityLogger.debugMessage(string, string2);
            }
            PrincipalAuthenticatorImpl principalAuthenticatorImpl = new PrincipalAuthenticatorImpl(this.getVault());
            return var5_11;
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Returning TokenBase PrincipalAuthenticator.";
            SecurityLogger.debugMessage(string, string2);
        }
        if (n2 != 2 && n2 != 3) {
            com.ibm.ISecurityLocalObjectLTPAImpl.PrincipalAuthenticatorImpl principalAuthenticatorImpl = new com.ibm.ISecurityLocalObjectLTPAImpl.PrincipalAuthenticatorImpl(this.getVault());
            return var5_11;
        }
        com.ibm.ISecurityLocalObjectTokenBaseImpl.PrincipalAuthenticatorImpl principalAuthenticatorImpl = new com.ibm.ISecurityLocalObjectTokenBaseImpl.PrincipalAuthenticatorImpl(this.getVault(), n);
        return var5_11;
    }

    public SecurityContext getSecurityContext(Vault vault, Credentials credentials, String string) throws MechanismAmbiguityException {
        return this.getSecurityContext(vault, credentials, string, 1);
    }

    public SecurityContext getSecurityContext(Vault vault, Credentials credentials, String string, int n) throws MechanismAmbiguityException {
        String string2 = "MechanismFactory.getSecurityContext";
        String string3 = null;
        com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl securityContextImpl = null;
        if (credentials instanceof com.ibm.ISecurityLocalObjectBasicAuthImpl.CredentialsImpl) {
            if (n == 1) {
                if (SecurityLogger.debugTraceEnabled) {
                    string3 = "Returning BasicAuth SecurityContext.";
                    SecurityLogger.debugMessage(string2, string3);
                }
                securityContextImpl = new com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl(this.getVault(), string);
            } else if (n == 2) {
                if (SecurityLogger.debugTraceEnabled) {
                    string3 = "Returning GSSUP SecurityContext.";
                    SecurityLogger.debugMessage(string2, string3);
                }
                securityContextImpl = OID.compareOIDs(((com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl)credentials).getOID(), "oid:2.23.130.1.1.1") ? new com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl(this.getVault(), string) : new SecurityContextImpl(this.getVault(), string);
            }
        } else if (credentials instanceof CredentialsImpl) {
            string3 = "Returning LTPA SecurityContext.";
            SecurityLogger.debugMessage(string2, string3);
            securityContextImpl = n == 2 ? new SecurityContextImpl(this.getVault(), string) : new com.ibm.ISecurityLocalObjectLTPAImpl.SecurityContextImpl(this.getVault(), string);
        } else if (credentials instanceof com.ibm.ISecurityLocalObjectTokenBaseImpl.CredentialsImpl) {
            string3 = "Returning TokenBase SecurityContext.";
            SecurityLogger.debugMessage(string2, string3);
            securityContextImpl = n == 2 ? new SecurityContextImpl(this.getVault(), string) : new com.ibm.ISecurityLocalObjectLTPAImpl.SecurityContextImpl(this.getVault(), string);
        } else if (credentials instanceof com.ibm.ISecurityLocalObjectLocalOSImpl.CredentialsImpl) {
            string3 = "Returning LocalOS SecurityContext.";
            SecurityLogger.debugMessage(string2, string3);
            securityContextImpl = n == 2 ? new SecurityContextImpl(this.getVault(), string) : new com.ibm.ISecurityLocalObjectLocalOSImpl.SecurityContextImpl(this.getVault(), string);
        } else {
            throw new MechanismAmbiguityException();
        }
        return securityContextImpl;
    }

    public SecurityContext getSecurityContext(Vault vault, String string, String string2) throws MechanismAmbiguityException {
        if (this.secConfig.getProtocol().equalsIgnoreCase("ibm")) {
            return this.getSecurityContext(string, string2, 1);
        }
        if (this.secConfig.getProtocol().equalsIgnoreCase("csiv2")) {
            return this.getSecurityContext(string, string2, 2);
        }
        return this.getSecurityContext(string, string2, 1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public SecurityContext getSecurityContext(String string, String string2, int n) throws MechanismAmbiguityException {
        void var6_16;
        String string3 = "MechanismFactory.getSecurityContext";
        String string4 = null;
        Object var6_6 = null;
        if (string.equals(VaultConstants.LTPA_MECH_TYPE)) {
            if (n == 2) {
                if (SecurityLogger.debugTraceEnabled) {
                    string4 = "Returning Token Base SecurityContext.";
                    SecurityLogger.debugMessage(string3, string4);
                }
                SecurityContextImpl securityContextImpl = new SecurityContextImpl(this.getVault(), string2, string);
                return var6_16;
            }
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Returning LTPA SecurityContext.";
                SecurityLogger.debugMessage(string3, string4);
            }
            com.ibm.ISecurityLocalObjectLTPAImpl.SecurityContextImpl securityContextImpl = new com.ibm.ISecurityLocalObjectLTPAImpl.SecurityContextImpl(this.getVault(), string2);
            return var6_16;
        }
        if (string.equals(VaultConstants.LOCAL_OS_MECH_TYPE)) {
            if (n == 2) {
                if (SecurityLogger.debugTraceEnabled) {
                    string4 = "Returning Token Base SecurityContext.";
                    SecurityLogger.debugMessage(string3, string4);
                }
                SecurityContextImpl securityContextImpl = new SecurityContextImpl(this.getVault(), string2, string);
                return var6_16;
            }
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Returning LocalOS SecurityContext.";
                SecurityLogger.debugMessage(string3, string4);
            }
            com.ibm.ISecurityLocalObjectLocalOSImpl.SecurityContextImpl securityContextImpl = new com.ibm.ISecurityLocalObjectLocalOSImpl.SecurityContextImpl(this.getVault(), string2);
            return var6_16;
        }
        if (string.equals(VaultConstants.CUSTOM_MECH_TYPE)) {
            if (n != 2) {
                if (!SecurityLogger.debugTraceEnabled) throw new MechanismAmbiguityException();
                string4 = "The custom mechanism is not supported for the IBM protocol.";
                SecurityLogger.debugMessage(string3, string4);
                throw new MechanismAmbiguityException();
            }
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Returning Token Base SecurityContext.";
                SecurityLogger.debugMessage(string3, string4);
            }
            SecurityContextImpl securityContextImpl = new SecurityContextImpl(this.getVault(), string2, string);
            return var6_16;
        }
        if (string.equals(VaultConstants.KRB5_MECH_TYPE)) {
            if (n != 2) {
                if (!SecurityLogger.debugTraceEnabled) throw new MechanismAmbiguityException();
                string4 = "Kerberos mechanism is not supported.";
                SecurityLogger.debugMessage(string3, string4);
                throw new MechanismAmbiguityException();
            }
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Returning Token Base SecurityContext.";
                SecurityLogger.debugMessage(string3, string4);
            }
            SecurityContextImpl securityContextImpl = new SecurityContextImpl(this.getVault(), string2, string);
            return var6_16;
        }
        if (string.equals(VaultConstants.CLIENT_CERT_MECH_TYPE)) {
            if (n != 2) {
                if (!SecurityLogger.debugTraceEnabled) throw new MechanismAmbiguityException();
                string4 = "Client certificate type mechanism is not supported.";
                SecurityLogger.debugMessage(string3, string4);
                throw new MechanismAmbiguityException();
            }
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Returning TokenBase SecurityContext.";
                SecurityLogger.debugMessage(string3, string4);
            }
            SecurityContextImpl securityContextImpl = new SecurityContextImpl(this.getVault(), string2, string);
            return var6_16;
        }
        if (n == 1) {
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "Returning BasicAuth SecurityContext.";
                SecurityLogger.debugMessage(string3, string4);
            }
            com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl securityContextImpl = new com.ibm.ISecurityLocalObjectBasicAuthImpl.SecurityContextImpl(this.getVault(), string2);
            return var6_16;
        }
        if (n != 2) {
            if (!SecurityLogger.debugTraceEnabled) throw new MechanismAmbiguityException();
            string4 = "A specific protocol must be passed into this method, type \"both\" is not allowed here.";
            SecurityLogger.debugMessage(string3, string4);
            throw new MechanismAmbiguityException();
        }
        if (SecurityLogger.debugTraceEnabled) {
            string4 = "Returning GSSUP SecurityContext.";
            SecurityLogger.debugMessage(string3, string4);
        }
        com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl securityContextImpl = new com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl(this.getVault(), string2);
        return var6_16;
    }
}

