/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectCSIv2UtilityImpl;

import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSEncodeDecodeException;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.VaultConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public final class GSSFactory {
    private OID _theOID = null;
    private static byte[] asn = new byte[]{96};
    private static byte[] EXPORT_NAME_TAG = new byte[]{4, 1};

    public static String getMechOIDFromExportedName(byte[] byArray) throws GSSEncodeDecodeException {
        int n;
        String string = "GSSFactory.getMechOIDFromExportedName";
        String string2 = null;
        int n2 = 0;
        if (byArray.length < 2) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid length for exported target name.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(1);
        }
        if (byArray[0] != EXPORT_NAME_TAG[0] || byArray[1] != EXPORT_NAME_TAG[1]) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid tag for exported target name.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(1);
        }
        if (byArray.length < (n2 += 2) + 2) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid length for exported target name.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(1);
        }
        if (byArray.length < (n2 += 2) + (n = (byArray[n2] << 8) + (byArray[n2 + 1] << 0))) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid length for exported target name.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(1);
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        try {
            OID oID = new OID(byArray2);
            if (oID != null) {
                return "oid:" + oID.toString();
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory.getMechOIDFromExportedName", (String)"141");
            throw new GSSEncodeDecodeException(99, exception.getMessage());
        }
    }

    public static String getMechOIDFromGSSToken(byte[] byArray) throws GSSEncodeDecodeException {
        String string = "GSSFactory.getMechOIDFromGSSToken";
        String string2 = null;
        if (byArray == null || byArray.length == 0) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid token form encountered.";
                SecurityLogger.debugMessage(string, string2);
            }
            return null;
        }
        int n = 0;
        int n2 = 0;
        if (byArray[n] != asn[0]) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid token form encountered.";
                SecurityLogger.debugMessage(string, string2);
            }
            return null;
        }
        if (byArray[++n] == -127) {
            n2 = byArray[n + 1] & 0xFF;
            n += 2;
        } else if (byArray[n] == -126) {
            n2 = ((byArray[n + 1] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
            n += 3;
        } else if (byArray[n] == -125) {
            n2 = ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
            n += 4;
        } else if (byArray[n] == -124) {
            n2 = ((byArray[n + 1] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 8) + (byArray[n + 4] & 0xFF);
            n += 5;
        } else {
            n2 = byArray[n];
            ++n;
        }
        if (n2 > 0) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Full token length: " + n2;
                SecurityLogger.debugMessage(string, string2);
            }
        } else {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid full token length: " + n2;
                SecurityLogger.debugMessage(string, string2);
            }
            return null;
        }
        if (byArray[n] != 6) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid OID encountered.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(2);
        }
        int n3 = n++;
        int n4 = 0;
        if (byArray[n] == -127) {
            n4 = byArray[n + 1] & 0xFF;
            n += 2;
        } else if (byArray[n] == -126) {
            n4 = ((byArray[n + 1] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
            n += 3;
        } else if (byArray[n] == -125) {
            n4 = ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
            n += 4;
        } else if (byArray[n] == -124) {
            n4 = ((byArray[n + 1] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 8) + (byArray[n + 4] & 0xFF);
            n += 5;
        } else {
            n4 = byArray[n];
            ++n;
        }
        if (n4 > 0) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "OID length: " + n4;
                SecurityLogger.debugMessage(string, string2);
            }
        } else {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid OID length: " + n4;
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(2);
        }
        byte[] byArray2 = new byte[n4 + 2];
        System.arraycopy(byArray, n3, byArray2, 0, n4 + 2);
        try {
            OID oID = new OID(byArray2);
            if (oID != null) {
                return "oid:" + oID.toString();
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory.getMechOIDFromGSSToken", (String)"313");
            throw new GSSEncodeDecodeException(99, exception.getMessage());
        }
    }

    public String getOIDName() {
        if (this._theOID != null) {
            return "oid:" + this._theOID.toString();
        }
        return null;
    }

    public GSSFactory(String string) {
        try {
            this._theOID = new OID(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory.GSSFactory", (String)"345", (Object)this);
        }
    }

    public GSSFactory(byte[] byArray) {
        try {
            this._theOID = new OID(byArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory.GSSFactory", (String)"362", (Object)this);
        }
    }

    public String decodeExportedTargetName(byte[] byArray) throws GSSEncodeDecodeException {
        int n;
        int n2;
        String string = "GSSFactory.decodeExportedTargetName";
        String string2 = null;
        String string3 = null;
        int n3 = 0;
        if (byArray.length < 2) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid length for exported target name.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(1);
        }
        if (byArray[0] != EXPORT_NAME_TAG[0] || byArray[1] != EXPORT_NAME_TAG[1]) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid tag for exported target name.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(1);
        }
        if (byArray.length < (n3 += 2) + 2) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid length for exported target name.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(3);
        }
        if (byArray.length < (n3 += 2) + (n2 = (byArray[n3] << 8) + (byArray[n3 + 1] << 0))) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid length for exported target name.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(3);
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
        n3 += n2;
        OID oID = null;
        try {
            oID = new OID(byArray2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory.decodeExportedTargetName", (String)"445", (Object)this);
            throw new GSSEncodeDecodeException(99, exception.getMessage());
        }
        if (oID == null) {
            return string3;
        }
        if (this._theOID != null) {
            if (!OID.compareOIDs(this._theOID.toString(), oID.toString())) {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Invalid OID for this factory: " + oID.toString();
                    SecurityLogger.debugMessage(string, string2);
                }
                throw new GSSEncodeDecodeException(2);
            }
        } else {
            this._theOID = oID;
        }
        if (byArray.length < n3 + 4) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid length for exported target name.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(3);
        }
        if (byArray.length < (n3 += 4) + (n = (byArray[n3] << 24) + (byArray[n3 + 1] << 16) + (byArray[n3 + 2] << 8) + (byArray[n3 + 3] << 0))) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid length for exported target name.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(3);
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, n3, byArray3, 0, n);
        try {
            string3 = new String(byArray3, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory.decodeExportedTargetName", (String)"503", (Object)this);
            throw new GSSEncodeDecodeException(99, unsupportedEncodingException.getMessage());
        }
        if (string3 != null && SecurityLogger.debugTraceEnabled) {
            string2 = "Found exported target name: " + string3;
            SecurityLogger.debugMessage(string, string2);
        }
        return string3;
    }

    public byte[] encodeExportedTargetName(String string) throws GSSEncodeDecodeException {
        String string2 = "GSSFactory.encodeExportedTargetName";
        String string3 = null;
        try {
            if (string == null || string.length() == 0) {
                if (SecurityLogger.debugTraceEnabled) {
                    string3 = "Invalid name form encountered.";
                    SecurityLogger.debugMessage(string2, string3);
                }
                return null;
            }
            byte[] byArray = this._theOID.getDER();
            byte[] byArray2 = string.getBytes("UTF-8");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(EXPORT_NAME_TAG, 0, EXPORT_NAME_TAG.length);
            byteArrayOutputStream.write(byArray.length >>> 8 & 0xFF);
            byteArrayOutputStream.write(byArray.length >>> 0 & 0xFF);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            byteArrayOutputStream.write(byArray2.length >>> 24 & 0xFF);
            byteArrayOutputStream.write(byArray2.length >>> 16 & 0xFF);
            byteArrayOutputStream.write(byArray2.length >>> 8 & 0xFF);
            byteArrayOutputStream.write(byArray2.length >>> 0 & 0xFF);
            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory.encodeExportedTargetName", (String)"576", (Object)this);
            throw new GSSEncodeDecodeException(99, exception.getMessage());
        }
    }

    public byte[] decodeGSSToken(byte[] byArray) throws GSSEncodeDecodeException {
        int n;
        String string = "GSSFactory.decodeGSSToken";
        String string2 = null;
        if (byArray == null || byArray.length == 0) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid token form encountered.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(5);
        }
        int n2 = 0;
        int n3 = 0;
        if (byArray[n2] != asn[0]) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid token form encountered.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(5);
        }
        if (byArray[++n2] == -127) {
            n3 = byArray[n2 + 1] & 0xFF;
            n2 += 2;
        } else if (byArray[n2] == -126) {
            n3 = ((byArray[n2 + 1] & 0xFF) << 8) + (byArray[n2 + 2] & 0xFF);
            n2 += 3;
        } else if (byArray[n2] == -125) {
            n3 = ((byArray[n2 + 1] & 0xFF) << 16) + ((byArray[n2 + 2] & 0xFF) << 8) + (byArray[n2 + 3] & 0xFF);
            n2 += 4;
        } else if (byArray[n2] == -124) {
            n3 = ((byArray[n2 + 1] & 0xFF) << 24) + ((byArray[n2 + 2] & 0xFF) << 16) + ((byArray[n2 + 3] & 0xFF) << 8) + (byArray[n2 + 4] & 0xFF);
            n2 += 5;
        } else {
            n3 = byArray[n2];
            ++n2;
        }
        if (n3 > 0) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Full token length: " + n3;
                SecurityLogger.debugMessage(string, string2);
            }
        } else {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid full token length: " + n3;
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(5);
        }
        if (byArray[n2] != 6) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid OID encountered.";
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(2);
        }
        int n4 = n2++;
        int n5 = 0;
        if (byArray[n2] == -127) {
            n5 = byArray[n2 + 1] & 0xFF;
            n2 += 2;
        } else if (byArray[n2] == -126) {
            n5 = ((byArray[n2 + 1] & 0xFF) << 8) + (byArray[n2 + 2] & 0xFF);
            n2 += 3;
        } else if (byArray[n2] == -125) {
            n5 = ((byArray[n2 + 1] & 0xFF) << 16) + ((byArray[n2 + 2] & 0xFF) << 8) + (byArray[n2 + 3] & 0xFF);
            n2 += 4;
        } else if (byArray[n2] == -124) {
            n5 = ((byArray[n2 + 1] & 0xFF) << 24) + ((byArray[n2 + 2] & 0xFF) << 16) + ((byArray[n2 + 3] & 0xFF) << 8) + (byArray[n2 + 4] & 0xFF);
            n2 += 5;
        } else {
            n5 = byArray[n2];
            ++n2;
        }
        if (n5 > 0) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "OID length: " + n5;
                SecurityLogger.debugMessage(string, string2);
            }
        } else {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid OID length: " + n5;
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(2);
        }
        n2 += n5;
        byte[] byArray2 = new byte[n5 + 2];
        System.arraycopy(byArray, n4, byArray2, 0, n5 + 2);
        OID oID = null;
        try {
            oID = new OID(byArray2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory.decodeGSSToken", (String)"744", (Object)this);
            throw new GSSEncodeDecodeException(99, exception.getMessage());
        }
        if (this._theOID != null) {
            if (!OID.compareOIDs(this._theOID.toString(), oID.toString())) {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Invalid OID for this factory: " + oID.toString();
                    SecurityLogger.debugMessage(string, string2);
                }
                throw new GSSEncodeDecodeException(2);
            }
        } else {
            this._theOID = oID;
        }
        if ((n = n3 - (n5 + 2)) > 0) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "GSS initial context token length: " + n;
                SecurityLogger.debugMessage(string, string2);
            }
        } else {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid GSS initial context token length: " + n;
                SecurityLogger.debugMessage(string, string2);
            }
            throw new GSSEncodeDecodeException(4);
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, n2, byArray3, 0, n);
        return byArray3;
    }

    public byte[] encodeGSSToken(byte[] byArray) {
        String string = "GSSFactory.encodeGSSToken";
        String string2 = null;
        if (byArray == null || byArray.length == 0) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Invalid GSS initial token form encountered.";
                SecurityLogger.debugMessage(string, string2);
            }
            return null;
        }
        byte[] byArray2 = this._theOID.getDER();
        int n = byArray2.length + byArray.length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(asn, 0, asn.length);
        if (n < 128) {
            byteArrayOutputStream.write((byte)n);
        } else if (n < 256) {
            byteArrayOutputStream.write(-127);
            byteArrayOutputStream.write((byte)n);
        } else if (n < 65536) {
            byteArrayOutputStream.write(-126);
            byteArrayOutputStream.write((byte)(n >> 8));
            byteArrayOutputStream.write((byte)n);
        } else if (n < 0x1000000) {
            byteArrayOutputStream.write(-125);
            byteArrayOutputStream.write((byte)(n >> 16));
            byteArrayOutputStream.write((byte)(n >> 8));
            byteArrayOutputStream.write((byte)n);
        } else {
            byteArrayOutputStream.write(-124);
            byteArrayOutputStream.write((byte)(n >> 24));
            byteArrayOutputStream.write((byte)(n >> 16));
            byteArrayOutputStream.write((byte)(n >> 8));
            byteArrayOutputStream.write((byte)n);
        }
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        return byteArrayOutputStream.toByteArray();
    }

    public static final String mapOidToMechType(String string) {
        String string2 = "GSSFactory.mapOidToMechType";
        String string3 = null;
        SecurityConfiguration securityConfiguration = VaultImpl.getSecurityConfiguration();
        if (string != null && string.length() != 0) {
            if (securityConfiguration != null && OID.compareOIDs(string, securityConfiguration.getWSSecurityContextCustomOID())) {
                return VaultConstants.CUSTOM_MECH_TYPE;
            }
            if (OID.compareOIDs(string, "oid:1.3.18.0.2.30.2")) {
                return VaultConstants.LTPA_MECH_TYPE;
            }
            if (OID.compareOIDs(string, "oid:1.2.840.113554.1.2.2")) {
                return VaultConstants.KRB5_MECH_TYPE;
            }
            if (OID.compareOIDs(string, "oid:2.23.130.1.1.1")) {
                return VaultConstants.GSSUP_MECH_TYPE;
            }
            return VaultConstants.LOCAL_OS_MECH_TYPE;
        }
        if (SecurityLogger.debugTraceEnabled) {
            string3 = "Unknown security mechanism type.";
            SecurityLogger.debugMessage(string2, string3);
        }
        return null;
    }

    public static final String mapMechTypeToOid(String string) {
        String string2 = "GSSFactory.mapMechTypeToOid";
        String string3 = null;
        SecurityConfiguration securityConfiguration = VaultImpl.getSecurityConfiguration();
        if (string != null && string.length() != 0) {
            if (string.equals(VaultConstants.LTPA_MECH_TYPE)) {
                return "oid:1.3.18.0.2.30.2";
            }
            if (string.equals("1.3")) {
                return "oid:1.3.18.0.2.30.2";
            }
            if (string.equals("5.1")) {
                return "oid:1.3.18.0.2.30.2";
            }
            if (string.equals(VaultConstants.CUSTOM_MECH_TYPE)) {
                return securityConfiguration.getWSSecurityContextCustomOID();
            }
            if (string.equals("1.7")) {
                return securityConfiguration.getWSSecurityContextCustomOID();
            }
            if (string.equals("5.9")) {
                return securityConfiguration.getWSSecurityContextCustomOID();
            }
            if (string.equals(VaultConstants.LOCAL_OS_MECH_TYPE)) {
                return null;
            }
            if (string.equals("1.4")) {
                return null;
            }
            if (string.equals("5.2")) {
                return null;
            }
            if (string.equals(VaultConstants.KRB5_MECH_TYPE)) {
                return "oid:1.2.840.113554.1.2.2";
            }
            if (string.equals("1.6")) {
                return "oid:1.2.840.113554.1.2.2";
            }
            if (string.equals("5.8")) {
                return "oid:1.2.840.113554.1.2.2";
            }
            if (string.equals("4.1")) {
                return "oid:1.2.840.113554.1.2.2";
            }
            if (string.equals(VaultConstants.GSSUP_MECH_TYPE)) {
                return "oid:2.23.130.1.1.1";
            }
            if (string.equals("1.5")) {
                return "oid:2.23.130.1.1.1";
            }
            if (string.equals("1.5.1")) {
                return "oid:2.23.130.1.1.1";
            }
            if (string.equals("1.5.2")) {
                return "oid:2.23.130.1.1.1";
            }
            if (string.equals("5.7.4")) {
                return "oid:2.23.130.1.1.1";
            }
            if (string.equals("5.7.1")) {
                return "oid:2.23.130.1.1.1";
            }
            if (string.equals("5.7.2")) {
                return "oid:2.23.130.1.1.1";
            }
            if (string.equals("1.1")) {
                return "oid:2.23.130.1.1.1";
            }
            if (string.equals("1.1.1")) {
                return "oid:2.23.130.1.1.1";
            }
            if (string.equals("1.1.2")) {
                return "oid:2.23.130.1.1.1";
            }
            if (string.equals("5.6")) {
                return "oid:2.23.130.1.1.1";
            }
            if (string.equals("5.3")) {
                return "oid:2.23.130.1.1.1";
            }
            if (string.equals("5.4")) {
                return "oid:2.23.130.1.1.1";
            }
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "Unknown security mechanism type.";
                SecurityLogger.debugMessage(string2, string3);
            }
            return null;
        }
        if (SecurityLogger.debugTraceEnabled) {
            string3 = "Unknown security mechanism type.";
            SecurityLogger.debugMessage(string2, string3);
        }
        return null;
    }

    public OID getOID() {
        return this._theOID;
    }

    public void setOID(String string) throws GSSEncodeDecodeException {
        this._theOID = new OID(string);
    }

    public GSSFactory(OID oID) {
        this._theOID = oID;
    }

    private GSSFactory() {
    }
}

