/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectCSIv2UtilityImpl;

import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.IExtendedSecurityPriv.ComponentData;
import com.ibm.IExtendedSecurityPriv.ComponentDataHolder;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSEncodeDecodeException;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.CSIv2Configuration;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.SecurityTaggedComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.orbssl.SSLServerConnectionData;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.ByteArray;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.AS_ContextSecHolder;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechHolder;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.SAS_ContextSecHolder;
import org.omg.CSIIOP.SECIOP_SEC_TRANSHelper;
import org.omg.CSIIOP.SECIOP_SEC_TRANSHolder;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.CSIIOP.TLS_SEC_TRANSHolder;
import org.omg.CSIIOP.TransportAddress;
import org.omg.CSIIOP.TransportAddressHolder;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.TaggedComponent;

public final class CSIv2TaggedComponent
extends SecurityTaggedComponent {
    private static String hostname = CSIv2TaggedComponent.getHostName();
    private static Hashtable csiv2TagCache = new Hashtable();
    private boolean _stateful = true;
    private int transport_tagID = 0;
    private String serviceConfigList = null;
    private TLS_SEC_TRANSHolder transport_mech_TLSHolder = null;
    private SECIOP_SEC_TRANSHolder transport_mech_SECIOPHolder = null;
    private AS_ContextSecHolder as_context_mech_holder = null;
    private SAS_ContextSecHolder sas_context_mech_holder = null;
    private Profile profile = null;
    private TransportAddressHolder tAddrH = null;

    public TransportAddressHolder get_Transport_Address() {
        return this.tAddrH;
    }

    public int get_Transport_tagID() {
        return this.transport_tagID;
    }

    public String get_Service_Configuration_List() {
        return this.serviceConfigList;
    }

    private void setTransport_mech_holder(Object object, int n) {
        if (n == 36) {
            this.transport_mech_TLSHolder = (TLS_SEC_TRANSHolder)object;
        } else if (n == 35) {
            this.transport_mech_SECIOPHolder = (SECIOP_SEC_TRANSHolder)object;
        } else {
            this.transport_mech_TLSHolder = null;
            this.transport_mech_SECIOPHolder = null;
        }
    }

    private CSIv2TaggedComponent(CompoundSecMechHolder compoundSecMechHolder, boolean bl, ORB oRB, Profile profile) {
        this.initialize(compoundSecMechHolder, bl, oRB, profile);
    }

    public void initialize(CompoundSecMechHolder compoundSecMechHolder, boolean bl, ORB oRB, Profile profile) {
        String string = "CSIv2TaggedComponent.initialize";
        String string2 = null;
        Object var7_7 = null;
        VaultImpl.getInstance();
        SecurityConfiguration securityConfiguration = VaultImpl.getSecurityConfiguration();
        this.profile = profile;
        CSIUtil cSIUtil = new CSIUtil();
        short s = 0;
        short s2 = 0;
        try {
            Object object;
            this.set_tagID(33);
            this._stateful = bl;
            TaggedComponent taggedComponent = compoundSecMechHolder.value.transport_mech;
            if (taggedComponent != null) {
                this.transport_tagID = taggedComponent.tag;
                if (this.transport_tagID == 36) {
                    object = null;
                    try {
                        object = cSIUtil.getCodec().decode_value(taggedComponent.component_data, TLS_SEC_TRANSHelper.type());
                    }
                    catch (MARSHAL mARSHAL) {
                        FFDCFilter.processException((Throwable)mARSHAL, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", (String)"234", (Object)this);
                        SecurityLogger.logException(string, (Exception)((Object)mARSHAL), 0, 0);
                    }
                    catch (BAD_OPERATION bAD_OPERATION) {
                        FFDCFilter.processException((Throwable)bAD_OPERATION, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", (String)"239", (Object)this);
                        SecurityLogger.logException(string, (Exception)((Object)bAD_OPERATION), 0, 0);
                    }
                    catch (FormatMismatch formatMismatch) {
                        FFDCFilter.processException((Throwable)formatMismatch, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", (String)"244", (Object)this);
                        SecurityLogger.logException(string, (Exception)((Object)formatMismatch), 0, 0);
                    }
                    catch (TypeMismatch typeMismatch) {
                        FFDCFilter.processException((Throwable)typeMismatch, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", (String)"249", (Object)this);
                        SecurityLogger.logException(string, (Exception)((Object)typeMismatch), 0, 0);
                    }
                    this.transport_mech_TLSHolder = new TLS_SEC_TRANSHolder(TLS_SEC_TRANSHelper.extract((Any)object));
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "CSI Security Transport values, transport layer: TLS, target requires = " + this.transport_mech_TLSHolder.value.target_requires + " target supports = " + this.transport_mech_TLSHolder.value.target_supports;
                        SecurityLogger.debugMessage(string, string2);
                    }
                    s = (short)(s | this.transport_mech_TLSHolder.value.target_requires);
                    s2 = (short)(s2 | this.transport_mech_TLSHolder.value.target_supports);
                    if (this.transport_mech_TLSHolder.value.addresses != null || this.transport_mech_TLSHolder.value.addresses.length != 0) {
                        this.tAddrH = new TransportAddressHolder(this.transport_mech_TLSHolder.value.addresses[0]);
                    }
                } else if (this.transport_tagID == 35) {
                    object = null;
                    try {
                        object = cSIUtil.getCodec().decode_value(taggedComponent.component_data, SECIOP_SEC_TRANSHelper.type());
                    }
                    catch (MARSHAL mARSHAL) {
                        FFDCFilter.processException((Throwable)mARSHAL, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", (String)"283", (Object)this);
                        SecurityLogger.logException(string, (Exception)((Object)mARSHAL), 0, 0);
                    }
                    catch (BAD_OPERATION bAD_OPERATION) {
                        FFDCFilter.processException((Throwable)bAD_OPERATION, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", (String)"288", (Object)this);
                        SecurityLogger.logException(string, (Exception)((Object)bAD_OPERATION), 0, 0);
                    }
                    catch (FormatMismatch formatMismatch) {
                        FFDCFilter.processException((Throwable)formatMismatch, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", (String)"293", (Object)this);
                        SecurityLogger.logException(string, (Exception)((Object)formatMismatch), 0, 0);
                    }
                    catch (TypeMismatch typeMismatch) {
                        FFDCFilter.processException((Throwable)typeMismatch, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", (String)"298", (Object)this);
                        SecurityLogger.logException(string, (Exception)((Object)typeMismatch), 0, 0);
                    }
                    this.transport_mech_SECIOPHolder = new SECIOP_SEC_TRANSHolder(SECIOP_SEC_TRANSHelper.extract((Any)object));
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "CSI Security Transport values, transport layer: SECIOP, target requires = " + this.transport_mech_SECIOPHolder.value.target_requires + " target supports = " + this.transport_mech_SECIOPHolder.value.target_supports;
                        SecurityLogger.debugMessage(string, string2);
                    }
                    s = (short)(s | this.transport_mech_SECIOPHolder.value.target_requires);
                    s2 = (short)(s2 | this.transport_mech_SECIOPHolder.value.target_supports);
                    if (this.transport_mech_SECIOPHolder.value.addresses != null && this.transport_mech_SECIOPHolder.value.addresses.length != 0) {
                        this.tAddrH = new TransportAddressHolder(this.transport_mech_SECIOPHolder.value.addresses[0]);
                    }
                } else if (SecurityLogger.debugTraceEnabled) {
                    string2 = "CSI Security Transport values, transport layer: NULL";
                    SecurityLogger.debugMessage(string, string2);
                }
            } else if (SecurityLogger.debugTraceEnabled) {
                string2 = "CSI Security Transport values, transport layer: NULL";
                SecurityLogger.debugMessage(string, string2);
            }
            if (compoundSecMechHolder.value.as_context_mech != null) {
                this.as_context_mech_holder = new AS_ContextSecHolder(compoundSecMechHolder.value.as_context_mech);
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "CSI Client Authentication values, client auth layer: target_requires =  " + this.as_context_mech_holder.value.target_requires + " target_supports = " + this.as_context_mech_holder.value.target_supports;
                    SecurityLogger.debugMessage(string, string2);
                }
                s = (short)(s | this.as_context_mech_holder.value.target_requires);
                s2 = (short)(s2 | this.as_context_mech_holder.value.target_supports);
                if (compoundSecMechHolder.value.as_context_mech.target_name != null && compoundSecMechHolder.value.as_context_mech.client_authentication_mech != null && ((Any)(object = (Object)compoundSecMechHolder.value.as_context_mech.target_name)).length != 0) {
                    try {
                        GSSFactory gSSFactory = new GSSFactory(compoundSecMechHolder.value.as_context_mech.client_authentication_mech);
                        this.set_targetCompleteName(gSSFactory.decodeExportedTargetName((byte[])object));
                    }
                    catch (GSSEncodeDecodeException gSSEncodeDecodeException) {
                        FFDCFilter.processException((Throwable)gSSEncodeDecodeException, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", (String)"380", (Object)this);
                        string2 = "security.JSAS0622E";
                        SecurityLogger.logError(string2, new Object[]{string, gSSEncodeDecodeException});
                    }
                }
            } else if (SecurityLogger.debugTraceEnabled) {
                string2 = "CSI Client Authentication values, client auth layer: NULL";
                SecurityLogger.debugMessage(string, string2);
            }
            if (compoundSecMechHolder.value.sas_context_mech != null) {
                this.sas_context_mech_holder = new SAS_ContextSecHolder(compoundSecMechHolder.value.sas_context_mech);
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "CSI Security Attribute values, attribute layer: target_requires = " + this.sas_context_mech_holder.value.target_requires + " target_supports = " + this.sas_context_mech_holder.value.target_supports;
                    SecurityLogger.debugMessage(string, string2);
                }
                s = (short)(s | this.sas_context_mech_holder.value.target_requires);
                s2 = (short)(s2 | this.sas_context_mech_holder.value.target_supports);
            } else if (SecurityLogger.debugTraceEnabled) {
                string2 = "CSI Security Attribute values, attribute layer: NULL";
                SecurityLogger.debugMessage(string, string2);
            }
            this.set_targetCoalescedReqQOP(s);
            this.set_targetCoalescedSuppQOP(s2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", (String)"458", (Object)this);
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Exception creating new CSIv2 Tagged Component.";
                SecurityLogger.debugMessage(string, string2);
            }
            SecurityLogger.logException(string, exception, 0, 0);
        }
    }

    public TLS_SEC_TRANSHolder getTLS_SEC_TRANS() {
        return this.transport_mech_TLSHolder;
    }

    public SECIOP_SEC_TRANSHolder getSECIOP_SEC_TRANS() {
        return this.transport_mech_SECIOPHolder;
    }

    private void setSAS_context_mech_holder(SAS_ContextSecHolder sAS_ContextSecHolder) {
        this.sas_context_mech_holder = sAS_ContextSecHolder;
    }

    private void setAS_context_mech_holder(AS_ContextSecHolder aS_ContextSecHolder) {
        this.as_context_mech_holder = aS_ContextSecHolder;
    }

    public static synchronized CSIv2TaggedComponent[] getCSIv2TaggedComponentList(Profile profile, IOR iOR) {
        CSIv2TaggedComponent[] cSIv2TaggedComponentArray;
        ByteArray byteArray;
        String string;
        String string2;
        block22: {
            string2 = "CSIv2TaggedComponent.getCSIv2TaggedComponentList";
            string = null;
            byte[] byArray = null;
            CSIUtil cSIUtil = new CSIUtil();
            ORB oRB = VaultImpl.getInstance().getORB();
            Any any = null;
            byteArray = null;
            cSIv2TaggedComponentArray = null;
            try {
                Profile profile2;
                byArray = profile.getTaggedComponent(33);
                if (byArray == null && iOR != null) {
                    profile2 = iOR.getProfile(0);
                    byArray = profile2.getTaggedComponent(33);
                }
                if (byArray != null) {
                    byteArray = new ByteArray(byArray);
                    cSIv2TaggedComponentArray = (CSIv2TaggedComponent[])csiv2TagCache.get(byteArray);
                    if (cSIv2TaggedComponentArray != null) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string = "Returning existing CSIv2 tag list from the cache (size=" + csiv2TagCache.size() + ").";
                            SecurityLogger.debugMessage(string2, string);
                        }
                        return cSIv2TaggedComponentArray;
                    }
                    try {
                        any = cSIUtil.getCodec().decode_value(byArray, CompoundSecMechListHelper.type());
                    }
                    catch (MARSHAL mARSHAL) {
                        FFDCFilter.processException((Throwable)mARSHAL, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", (String)"516");
                        SecurityLogger.logException(string2, (Exception)((Object)mARSHAL), 0, 0);
                    }
                    catch (BAD_OPERATION bAD_OPERATION) {
                        FFDCFilter.processException((Throwable)bAD_OPERATION, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", (String)"521");
                        SecurityLogger.logException(string2, (Exception)((Object)bAD_OPERATION), 0, 0);
                    }
                    catch (FormatMismatch formatMismatch) {
                        FFDCFilter.processException((Throwable)formatMismatch, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", (String)"526");
                        SecurityLogger.logException(string2, (Exception)((Object)formatMismatch), 0, 0);
                    }
                    catch (TypeMismatch typeMismatch) {
                        FFDCFilter.processException((Throwable)typeMismatch, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", (String)"531");
                        SecurityLogger.logException(string2, (Exception)((Object)typeMismatch), 0, 0);
                    }
                    profile2 = CompoundSecMechListHelper.extract((Any)any);
                    if (profile2.mechanism_list != null) {
                        CompoundSecMechHolder compoundSecMechHolder = new CompoundSecMechHolder();
                        cSIv2TaggedComponentArray = new CSIv2TaggedComponent[profile2.mechanism_list.length];
                        if (SecurityLogger.debugTraceEnabled) {
                            string = profile2.mechanism_list.length + " CompoundSecMechanism(s) in Tagged Component.";
                            SecurityLogger.debugMessage(string2, string);
                        }
                        for (int i = 0; i < profile2.mechanism_list.length; ++i) {
                            if (SecurityLogger.debugTraceEnabled) {
                                string = "*** READING CSIv2 TAG " + (i + 1) + " of " + profile2.mechanism_list.length + " ***";
                                SecurityLogger.debugMessage(string2, string);
                            }
                            compoundSecMechHolder.value = profile2.mechanism_list[i];
                            cSIv2TaggedComponentArray[i] = new CSIv2TaggedComponent(compoundSecMechHolder, profile2.stateful, oRB, profile);
                        }
                        if (SecurityLogger.debugTraceEnabled) {
                            string = "*** COMPLETED ADDING CSIv2 TAGS ***";
                            SecurityLogger.debugMessage(string2, string);
                        }
                    }
                    break block22;
                }
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Tagged component is null.";
                    SecurityLogger.debugMessage(string2, string);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", (String)"581");
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Java Exception getting CSIv2TaggedComponent.";
                    SecurityLogger.debugMessage(string2, string);
                    SecurityLogger.logException(string2, exception, 0, 0);
                }
                return null;
            }
        }
        if (byteArray != null && cSIv2TaggedComponentArray != null) {
            if (csiv2TagCache.size() > 50) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Clearing CSIv2 Tag cache, larger than 50 objects.";
                    SecurityLogger.debugMessage(string2, string);
                }
                csiv2TagCache.clear();
            }
            csiv2TagCache.put(byteArray, cSIv2TaggedComponentArray);
            if (SecurityLogger.debugTraceEnabled) {
                string = "Added CSIv2 tag to the cache (size=" + csiv2TagCache.size() + ").";
                SecurityLogger.debugMessage(string2, string);
            }
        }
        return cSIv2TaggedComponentArray;
    }

    public static final synchronized ComponentDataHolder getCSIv2ComponentData(CSIv2Configuration cSIv2Configuration, SecurityConnectionInterceptor securityConnectionInterceptor, String string) {
        String string2 = "CSIv2TaggedComponent.getCSIv2ComponentData";
        String string3 = null;
        try {
            ORB oRB = VaultImpl.getInstance().getORB();
            VaultImpl.getInstance();
            SecurityConfiguration securityConfiguration = VaultImpl.getSecurityConfiguration();
            Any any = null;
            CDROutputStream cDROutputStream = null;
            CSIUtil cSIUtil = new CSIUtil();
            int n = 0;
            int n2 = 1;
            TransportAddress[] transportAddressArray = new TransportAddress[n2];
            TLS_SEC_TRANS tLS_SEC_TRANS = null;
            TaggedComponent taggedComponent = null;
            AS_ContextSec aS_ContextSec = null;
            ServiceConfiguration[] serviceConfigurationArray = null;
            SAS_ContextSec sAS_ContextSec = null;
            CompoundSecMech compoundSecMech = null;
            CompoundSecMech[] compoundSecMechArray = null;
            boolean bl = true;
            CompoundSecMechList compoundSecMechList = null;
            n = securityConfiguration.getauthenticationTarget() == 6 ? 2 : (securityConfiguration.getauthenticationTarget() == 8 ? 2 : (securityConfiguration.getauthenticationTarget() == 1 ? 2 : 1));
            if ((securityConfiguration.getCSIv2ClaimTransportAssocSSLTLSRequired() || securityConfiguration.getCSIv2ClaimTransportAssocSSLTLSSupported()) && securityConfiguration.getCSIv2ClaimTLClientAuthenticationSupported() && !securityConfiguration.getCSIv2ClaimTLClientAuthenticationRequired()) {
                n *= 2;
            }
            compoundSecMechArray = new CompoundSecMech[n];
            for (int i = 0; i < n; ++i) {
                if (SecurityLogger.debugTraceEnabled) {
                    string3 = "*** ADDING CSIv2 TAG " + (i + 1) + " of " + n + " ***";
                    SecurityLogger.debugMessage(string2, string3);
                }
                short s = 0;
                short s2 = 0;
                short s3 = 0;
                short s4 = 0;
                if (securityConfiguration.getCSIv2ClaimTransportAssocSSLTLSRequired() || securityConfiguration.getCSIv2ClaimTransportAssocSSLTLSSupported()) {
                    SSLServerConnectionData sSLServerConnectionData;
                    if (securityConfiguration.getCSIv2ClaimMessageIntegrityRequired()) {
                        s3 = (short)(s3 | 2);
                        s2 = (short)(s2 | 2);
                    }
                    if (securityConfiguration.getCSIv2ClaimMessageConfidentialityRequired()) {
                        s3 = (short)(s3 | 4);
                        s2 = (short)(s2 | 4);
                    }
                    if (securityConfiguration.getCSIv2ClaimMessageIntegritySupported()) {
                        s2 = (short)(s2 | 2);
                    }
                    if (securityConfiguration.getCSIv2ClaimMessageConfidentialitySupported()) {
                        s2 = (short)(s2 | 4);
                    }
                    s2 = (short)(s2 | 0x20);
                    if (securityConfiguration.getCSIv2ClaimTLClientAuthenticationSupported() && !securityConfiguration.getCSIv2ClaimTLClientAuthenticationRequired()) {
                        if (i % 2 == 1) {
                            s3 = (short)(s3 | 0x40);
                            s2 = (short)(s2 | 0x40);
                            sSLServerConnectionData = securityConnectionInterceptor.getCSIClientCertRegisteredSSLServerConnectionDataObject();
                            if (sSLServerConnectionData != null) {
                                s4 = (short)sSLServerConnectionData.getServerPort();
                                if (s4 == 0) {
                                    string3 = "security.JSAS0446E";
                                    SecurityLogger.logError(string3, new Object[]{string2});
                                }
                            } else {
                                s4 = (short)securityConfiguration.getCSIClientCertSSLPort();
                                if (s4 == 0 && SecurityLogger.debugTraceEnabled) {
                                    string3 = "security.JSAS0446E";
                                    SecurityLogger.logError(string3, new Object[]{string2});
                                }
                            }
                        } else {
                            sSLServerConnectionData = securityConnectionInterceptor.getCSIRegisteredSSLServerConnectionDataObject();
                            if (sSLServerConnectionData != null) {
                                s4 = (short)sSLServerConnectionData.getServerPort();
                                if (s4 == 0) {
                                    string3 = "security.JSAS0446E";
                                    SecurityLogger.logError(string3, new Object[]{string2});
                                }
                            } else {
                                s4 = (short)securityConfiguration.getCSISSLPort();
                                if (s4 == 0) {
                                    string3 = "security.JSAS0446E";
                                    SecurityLogger.logError(string3, new Object[]{string2});
                                }
                            }
                        }
                    } else if (securityConfiguration.getCSIv2ClaimTLClientAuthenticationRequired()) {
                        s3 = (short)(s3 | 0x40);
                        s2 = (short)(s2 | 0x40);
                        sSLServerConnectionData = securityConnectionInterceptor.getCSIClientCertRegisteredSSLServerConnectionDataObject();
                        if (sSLServerConnectionData != null) {
                            s4 = (short)sSLServerConnectionData.getServerPort();
                            if (s4 == 0) {
                                string3 = "security.JSAS0446E";
                                SecurityLogger.logError(string3, new Object[]{string2});
                            }
                        } else {
                            s4 = (short)securityConfiguration.getCSIClientCertSSLPort();
                            if (s4 == 0) {
                                string3 = "security.JSAS0446E";
                                SecurityLogger.logError(string3, new Object[]{string2});
                            }
                        }
                    } else {
                        sSLServerConnectionData = securityConnectionInterceptor.getCSIRegisteredSSLServerConnectionDataObject();
                        if (sSLServerConnectionData != null) {
                            s4 = (short)sSLServerConnectionData.getServerPort();
                            if (s4 == 0) {
                                string3 = "security.JSAS0446E";
                                SecurityLogger.logError(string3, new Object[]{string2});
                            }
                        } else {
                            s4 = (short)securityConfiguration.getCSISSLPort();
                            if (s4 == 0 && SecurityLogger.debugTraceEnabled) {
                                string3 = "security.JSAS0446E";
                                SecurityLogger.logError(string3, new Object[]{string2});
                            }
                        }
                    }
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "Transport security target_requires for CSIv2: " + s3 + ". Transport security target_supports for CSIv2: " + s2;
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    for (int j = 0; j < n2; ++j) {
                        transportAddressArray[j] = new TransportAddress(hostname, s4);
                        if (!SecurityLogger.debugTraceEnabled) continue;
                        string3 = "Configured hostname at transport layer for CSIv2: " + hostname + ". Configured port at transport layer for CSIv2: " + s4;
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    tLS_SEC_TRANS = new TLS_SEC_TRANS(s2, s3, transportAddressArray);
                    any = oRB.create_any();
                    TLS_SEC_TRANSHelper.insert((Any)any, (TLS_SEC_TRANS)tLS_SEC_TRANS);
                    byte[] byArray = null;
                    try {
                        byArray = cSIUtil.getCodec().encode_value(any);
                    }
                    catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                        FFDCFilter.processException((Throwable)invalidTypeForEncoding, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", (String)"906");
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "An InvalidTypeForEncoding exception occurred.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        SecurityLogger.logException(string2, (Exception)((Object)invalidTypeForEncoding), 0, 0);
                    }
                    taggedComponent = new TaggedComponent(36, byArray);
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "SSL/TLS transport security mechanism exported for CSIv2.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                } else {
                    taggedComponent = new TaggedComponent(34, new byte[0]);
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "No transport security mechanism exported for CSIv2.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                }
                short s5 = 0;
                short s6 = 0;
                byte[] byArray = null;
                byte[] byArray2 = null;
                GSSFactory gSSFactory = null;
                if (securityConfiguration.getCSIv2ClaimClientAuthenticationRequired()) {
                    s6 = 64;
                    s5 = 64;
                }
                if (securityConfiguration.getauthenticationTarget() == 7) {
                    gSSFactory = new GSSFactory("oid:2.23.130.1.1.1");
                } else if (n == 1 || n == 2 && i == 1 || n == 4 && i > 1) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "GSSUP authentication mechanism exported.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    gSSFactory = new GSSFactory("oid:2.23.130.1.1.1");
                } else if (securityConfiguration.getauthenticationTarget() == 6) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "Kerberos authentication mechanism exported.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    gSSFactory = new GSSFactory("oid:1.2.840.113554.1.2.2");
                } else if (securityConfiguration.getauthenticationTarget() == 8) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "Custom authentication mechanism exported.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    gSSFactory = new GSSFactory(securityConfiguration.getWSSecurityContextCustomOID());
                } else if (securityConfiguration.getauthenticationTarget() == 1) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "LTPA authentication mechanism exported.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    gSSFactory = new GSSFactory("oid:1.3.18.0.2.30.2");
                } else {
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "GSSUP authentication mechanism exported.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    gSSFactory = new GSSFactory("oid:2.23.130.1.1.1");
                }
                if (securityConfiguration.getCSIv2ClaimClientAuthenticationSupported()) {
                    s5 = 64;
                }
                String string4 = null;
                if (securityConfiguration.getCSIv2ClaimClientAuthenticationSupported() || securityConfiguration.getCSIv2ClaimClientAuthenticationRequired()) {
                    byArray = gSSFactory.getOID().getDER();
                    string4 = "oid:1.2.840.113554.1.2.2".endsWith(securityConfiguration.getWSSecurityContextActiveOID()) ? securityConfiguration.getprincipalName() : RealmSecurityName.getRealm(securityConfiguration.getprincipalName());
                    if (string4 == null || string4.length() == 0) {
                        string4 = securityConfiguration.getRealmName();
                    }
                    if ((byArray2 = gSSFactory.encodeExportedTargetName(string4)) == null) {
                        byArray2 = new byte[]{};
                    }
                    aS_ContextSec = new AS_ContextSec(s5, s6, byArray, byArray2);
                } else {
                    aS_ContextSec = new AS_ContextSec(0, 0, new byte[0], new byte[0]);
                }
                if (SecurityLogger.debugTraceEnabled) {
                    if (s5 != 0) {
                        if (string4 != null && string4.length() != 0) {
                            string3 = "Exported target name object: " + string4;
                            SecurityLogger.debugMessage(string2, string3);
                        } else {
                            string3 = "No exported target name object exported for CSIv2.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        string3 = "Client auth target_requires for CSIv2: " + s6 + ". Client auth target_supports for CSIv2: " + s5;
                        SecurityLogger.debugMessage(string2, string3);
                    } else {
                        string3 = "No client auth security mechanism exported for CSIv2.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                }
                short s7 = 0;
                short s8 = 0;
                boolean bl2 = false;
                byte[] byArray3 = null;
                serviceConfigurationArray = new ServiceConfiguration[]{new ServiceConfiguration(0, byArray3)};
                Object var37_46 = null;
                byte[][] byArrayArray = new byte[][]{};
                int n3 = 0;
                if (securityConfiguration.getCSIv2ClaimIdentityAssertionSupported() || securityConfiguration.isRMIInboundPropagationEnabled()) {
                    if (securityConfiguration.getCSIv2ClaimIdentityAssertionSupported()) {
                        int n4 = 1;
                        byArrayArray = new byte[n4][];
                        byArrayArray[0] = gSSFactory.getOID().getDER();
                        n3 = 15;
                        s7 = (short)(s7 | 0x400);
                    }
                    if (securityConfiguration.isRMIInboundPropagationEnabled()) {
                        cDROutputStream = ORB.createCDROutputStream((ORB)oRB);
                        cDROutputStream.write_string(RealmSecurityName.getRealm(securityConfiguration.getprincipalName()));
                        byArray3 = cDROutputStream.toByteArray();
                        serviceConfigurationArray = new ServiceConfiguration[]{new ServiceConfiguration(1229066446, byArray3)};
                    } else {
                        cDROutputStream = ORB.createCDROutputStream((ORB)oRB);
                        cDROutputStream.write_string("");
                        byArray3 = cDROutputStream.toByteArray();
                        serviceConfigurationArray = new ServiceConfiguration[]{new ServiceConfiguration(0, byArray3)};
                    }
                    sAS_ContextSec = new SAS_ContextSec(s7, s8, serviceConfigurationArray, (byte[][])byArrayArray, n3);
                } else {
                    sAS_ContextSec = new SAS_ContextSec(0, 0, new ServiceConfiguration[0], (byte[][])new byte[0][], 0);
                }
                if (SecurityLogger.debugTraceEnabled) {
                    if ((s7 & 0x400) != 0) {
                        string3 = "Identity assertion exported for CSIv2.";
                        SecurityLogger.debugMessage(string2, string3);
                    } else {
                        string3 = "No identity assertion exported for CSIv2.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                }
                s = (short)(s3 | s6 | s8);
                if (SecurityLogger.debugTraceEnabled) {
                    string3 = "Base target_requires exported for CSIv2: " + s;
                    SecurityLogger.debugMessage(string2, string3);
                }
                compoundSecMechArray[i] = compoundSecMech = new CompoundSecMech(s, taggedComponent, aS_ContextSec, sAS_ContextSec);
            }
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "*** COMPLETED ADDING CSIv2 TAGS ***";
                SecurityLogger.debugMessage(string2, string3);
            }
            compoundSecMechList = new CompoundSecMechList(securityConfiguration.getCSIv2ClaimStateful(), compoundSecMechArray);
            any = oRB.create_any();
            CompoundSecMechListHelper.insert((Any)any, (CompoundSecMechList)compoundSecMechList);
            byte[] byArray = null;
            try {
                byArray = cSIUtil.getCodec().encode_value(any);
            }
            catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                FFDCFilter.processException((Throwable)invalidTypeForEncoding, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", (String)"1164");
                if (SecurityLogger.debugTraceEnabled) {
                    string3 = "An InvalidTypeForEncoding exception occurred.";
                    SecurityLogger.debugMessage(string2, string3);
                }
                SecurityLogger.logException(string2, (Exception)((Object)invalidTypeForEncoding), 0, 0);
            }
            ComponentDataHolder componentDataHolder = new ComponentDataHolder();
            componentDataHolder.value = new ComponentData(33, byArray);
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "CSI Tagged Component exported.";
                SecurityLogger.debugMessage(string2, string3);
            }
            return componentDataHolder;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", (String)"1190");
            SecurityLogger.logException(string2, exception, 0, 0);
            return null;
        }
    }

    public boolean isStateFul() {
        return this._stateful;
    }

    public AS_ContextSecHolder getAS_context_mech_holder() {
        return this.as_context_mech_holder;
    }

    public SAS_ContextSecHolder getSAS_context_mech_holder() {
        return this.sas_context_mech_holder;
    }

    public Profile getIORProfile() {
        return this.profile;
    }

    public static synchronized IOR changeSSLPortForWLM(IOR iOR, String string, short s, short s2) {
        if (!ConfigURLProperties.isSecurityEnabled()) {
            return null;
        }
        String string2 = "CSIv2TaggedComponent.changeSSLPortForWLM";
        String string3 = null;
        byte[] byArray = null;
        CSIUtil cSIUtil = new CSIUtil();
        Object var8_8 = null;
        ORB oRB = VaultImpl.getInstance().getORB();
        Any any = null;
        Profile profile = null;
        try {
            if (iOR == null) {
                if (SecurityLogger.debugTraceEnabled) {
                    string3 = "WLM Failover: IOR passed in is null.";
                    SecurityLogger.debugMessage(string2, string3);
                }
                return null;
            }
            profile = iOR.getProfile(0);
            byArray = profile.getTaggedComponent(33);
            if (byArray != null) {
                Any any2;
                TaggedComponent taggedComponent;
                try {
                    any = cSIUtil.getCodec().decode_value(byArray, CompoundSecMechListHelper.type());
                }
                catch (MARSHAL mARSHAL) {
                    FFDCFilter.processException((Throwable)mARSHAL, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.changeSSLPortForWLM", (String)"1304");
                    SecurityLogger.logException(string2, (Exception)((Object)mARSHAL), 0, 0);
                }
                catch (BAD_OPERATION bAD_OPERATION) {
                    FFDCFilter.processException((Throwable)bAD_OPERATION, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.changeSSLPortForWLM", (String)"1309");
                    SecurityLogger.logException(string2, (Exception)((Object)bAD_OPERATION), 0, 0);
                }
                catch (FormatMismatch formatMismatch) {
                    FFDCFilter.processException((Throwable)formatMismatch, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.changeSSLPortForWLM", (String)"1314");
                    SecurityLogger.logException(string2, (Exception)((Object)formatMismatch), 0, 0);
                }
                catch (TypeMismatch typeMismatch) {
                    FFDCFilter.processException((Throwable)typeMismatch, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.changeSSLPortForWLM", (String)"1319");
                    SecurityLogger.logException(string2, (Exception)((Object)typeMismatch), 0, 0);
                }
                CompoundSecMechList compoundSecMechList = null;
                if (any != null) {
                    compoundSecMechList = CompoundSecMechListHelper.extract((Any)any);
                }
                if (compoundSecMechList != null && compoundSecMechList.mechanism_list != null) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "WLM Failover: " + compoundSecMechList.mechanism_list.length + " CompoundSecMechanism(s) in Tagged Component.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    for (int i = 0; i < compoundSecMechList.mechanism_list.length; ++i) {
                        taggedComponent = compoundSecMechList.mechanism_list[i].transport_mech;
                        if (taggedComponent == null || taggedComponent.tag != 36) continue;
                        any2 = null;
                        try {
                            any2 = cSIUtil.getCodec().decode_value(taggedComponent.component_data, TLS_SEC_TRANSHelper.type());
                        }
                        catch (MARSHAL mARSHAL) {
                            FFDCFilter.processException((Throwable)mARSHAL, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.CSIv2TaggedComponent", (String)"185");
                            SecurityLogger.logException(string2, (Exception)((Object)mARSHAL), 0, 0);
                        }
                        catch (BAD_OPERATION bAD_OPERATION) {
                            FFDCFilter.processException((Throwable)bAD_OPERATION, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.CSIv2TaggedComponent", (String)"190");
                            SecurityLogger.logException(string2, (Exception)((Object)bAD_OPERATION), 0, 0);
                        }
                        catch (FormatMismatch formatMismatch) {
                            FFDCFilter.processException((Throwable)formatMismatch, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.CSIv2TaggedComponent", (String)"195");
                            SecurityLogger.logException(string2, (Exception)((Object)formatMismatch), 0, 0);
                        }
                        catch (TypeMismatch typeMismatch) {
                            FFDCFilter.processException((Throwable)typeMismatch, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.CSIv2TaggedComponent", (String)"200");
                            SecurityLogger.logException(string2, (Exception)((Object)typeMismatch), 0, 0);
                        }
                        TLS_SEC_TRANSHolder tLS_SEC_TRANSHolder = new TLS_SEC_TRANSHolder(TLS_SEC_TRANSHelper.extract((Any)any2));
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "WLM Failover: CSI Security Transport values, transport layer: TLS, target requires = " + tLS_SEC_TRANSHolder.value.target_requires + " target supports = " + tLS_SEC_TRANSHolder.value.target_supports;
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        if (tLS_SEC_TRANSHolder.value.addresses != null || tLS_SEC_TRANSHolder.value.addresses.length != 0) {
                            if (SecurityLogger.debugTraceEnabled) {
                                string3 = "WLM Failover: Old Host = " + tLS_SEC_TRANSHolder.value.addresses[0].host_name + ", New Host = " + string;
                                SecurityLogger.debugMessage(string2, string3);
                            }
                            if ((tLS_SEC_TRANSHolder.value.target_requires & 0x40) != 0) {
                                if (SecurityLogger.debugTraceEnabled) {
                                    string3 = "WLM Failover: ClientCert Req: Old Port = " + tLS_SEC_TRANSHolder.value.addresses[0].port + ", New Port = " + s2;
                                    SecurityLogger.debugMessage(string2, string3);
                                }
                                tLS_SEC_TRANSHolder.value.addresses[0].port = s2;
                                tLS_SEC_TRANSHolder.value.addresses[0].host_name = string;
                            } else if ((tLS_SEC_TRANSHolder.value.target_supports & 0x40) != 0) {
                                if (i == 0) {
                                    if (SecurityLogger.debugTraceEnabled) {
                                        string3 = "WLM Failover: ClientCert Supt1: Old Port = " + tLS_SEC_TRANSHolder.value.addresses[0].port + ", New Port = " + s;
                                        SecurityLogger.debugMessage(string2, string3);
                                    }
                                    tLS_SEC_TRANSHolder.value.addresses[0].port = s;
                                    tLS_SEC_TRANSHolder.value.addresses[0].host_name = string;
                                } else {
                                    if (SecurityLogger.debugTraceEnabled) {
                                        string3 = "WLM Failover: ClientCert Supt2: Old Port = " + tLS_SEC_TRANSHolder.value.addresses[0].port + ", New Port = " + s2;
                                        SecurityLogger.debugMessage(string2, string3);
                                    }
                                    tLS_SEC_TRANSHolder.value.addresses[0].port = s2;
                                    tLS_SEC_TRANSHolder.value.addresses[0].host_name = string;
                                }
                            } else {
                                if (SecurityLogger.debugTraceEnabled) {
                                    string3 = "WLM Failover: ClientCert NotSupt: Old Port = " + tLS_SEC_TRANSHolder.value.addresses[0].port + ", New Port = " + s;
                                    SecurityLogger.debugMessage(string2, string3);
                                }
                                tLS_SEC_TRANSHolder.value.addresses[0].port = s;
                                tLS_SEC_TRANSHolder.value.addresses[0].host_name = string;
                            }
                        }
                        any2 = oRB.create_any();
                        TLS_SEC_TRANSHelper.insert((Any)any2, (TLS_SEC_TRANS)tLS_SEC_TRANSHolder.value);
                        byte[] byArray2 = null;
                        try {
                            byArray2 = cSIUtil.getCodec().encode_value(any2);
                        }
                        catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                            FFDCFilter.processException((Throwable)invalidTypeForEncoding, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", (String)"906");
                            if (SecurityLogger.debugTraceEnabled) {
                                string3 = "An InvalidTypeForEncoding exception occurred.";
                                SecurityLogger.debugMessage(string2, string3);
                            }
                            SecurityLogger.logException(string2, (Exception)((Object)invalidTypeForEncoding), 0, 0);
                        }
                        compoundSecMechList.mechanism_list[i].transport_mech = new TaggedComponent(36, byArray2);
                    }
                } else {
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "WLM Failover: No CSIv2 CompoundSecMech structures in tagged component.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    return null;
                }
                any = oRB.create_any();
                try {
                    CompoundSecMechListHelper.insert((Any)any, (CompoundSecMechList)compoundSecMechList);
                }
                catch (SystemException systemException) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "WLM Failover: Error inserting CSIv2 CompoundSecMech into Any.";
                        SecurityLogger.debugMessage(string2, string3);
                        SecurityLogger.logException(string2, (Exception)((Object)systemException), 0, 0);
                    }
                    return null;
                }
                byte[] byArray3 = null;
                try {
                    byArray3 = cSIUtil.getCodec().encode_value(any);
                }
                catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                    FFDCFilter.processException((Throwable)invalidTypeForEncoding, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", (String)"1164");
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "WLM Failover: An InvalidTypeForEncoding exception occurred.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    SecurityLogger.logException(string2, (Exception)((Object)invalidTypeForEncoding), 0, 0);
                }
                taggedComponent = new ComponentDataHolder();
                taggedComponent.value = new ComponentData(33, byArray3);
                if (SecurityLogger.debugTraceEnabled) {
                    string3 = "WLM Failover: CSI Tagged Component exported.";
                    SecurityLogger.debugMessage(string2, string3);
                }
                any2 = null;
                if (taggedComponent.value != null) {
                    string3 = "WLM Failover: Adding tagged component ID: " + taggedComponent.value.componentID;
                    SecurityLogger.debugMessage(string2, string3);
                    any2 = new TaggedComponent(taggedComponent.value.componentID, taggedComponent.value.componentBodyValue);
                } else if (SecurityLogger.debugTraceEnabled) {
                    string3 = "WLM Failover: No security tagged components applied to IOR during create.";
                    SecurityLogger.debugMessage(string2, string3);
                }
                if (any2 != null) {
                    profile.putTaggedComponent(33, any2.component_data);
                    iOR.putProfile(profile);
                    return iOR;
                }
                return null;
            }
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "WLM Failover: No CSIv2 tagged component exists in IOR.";
                SecurityLogger.debugMessage(string2, string3);
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", (String)"581");
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "WLM Failover: Java Exception getting CSIv2TaggedComponent.";
                SecurityLogger.debugMessage(string2, string3);
                SecurityLogger.logException(string2, exception, 0, 0);
            }
            return null;
        }
    }

    private static String getHostName() {
        String string;
        String string2 = "CSIv2TaggedComponent.getHostName";
        if (!ConfigURLProperties.isSecurityEnabled()) {
            return null;
        }
        try {
            string = VaultImpl.getInstance().getORB().getLocalHost();
            try {
                final String string3 = string;
                string = (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws UnknownHostException {
                        InetAddress inetAddress = InetAddress.getByName(string3);
                        return inetAddress.getHostAddress();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getHostName", (String)"1747");
                string = "localhost";
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getHostName", (String)"1754");
            if (SecurityLogger.debugTraceEnabled) {
                String string4 = "Exception getting hostname for transport address.";
                SecurityLogger.debugMessage(string2, string4);
            }
            SecurityLogger.logException(string2, exception, 0, 0);
            string = null;
        }
        if (string == null || string.length() == 0) {
            string = "localHost";
        }
        return string;
    }
}

