/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectCSIv2UtilityImpl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CSIv2Security.CSIv2RequirementsNotSatisfied;
import com.ibm.CSIv2Security.CSIv2RequirementsNotSatisfiedReason;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponentHolder;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ClientSessionKey;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.AS_ContextSecHolder;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.SAS_ContextSecHolder;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.CSIIOP.TLS_SEC_TRANSHolder;

public final class CSIv2EffectivePerformPolicy {
    protected static ORB _orb = null;
    protected static SecurityConfiguration secConfig = null;
    protected String _protocol = "csiv2";
    protected boolean _stateful = false;
    protected long _stateful_context_id = 0L;
    protected ClientSessionKey _client_session_key = null;
    protected String _mechTypeIdentity = "";
    protected boolean _performTLClientAuth = false;
    protected boolean _performTLServerAuth = false;
    protected boolean _performMsgDetectReplay = false;
    protected boolean _performMsgDetectMisordering = false;
    protected boolean _performMsgIntegrity = false;
    protected boolean _performMsgConfidentiality = false;
    protected boolean _performSSLTLS = false;
    protected boolean _performSECIOP = false;
    protected String _performSECIOPMechOID = "";
    protected String _targetHostName = "";
    protected int _targetTCPPort = 0;
    protected int _targetSSLPort = 0;
    protected boolean _performClientAuth = false;
    protected boolean _claimClientAuthRequired = false;
    protected String _performClientAuthMechOID = "";
    protected String _targetSecurityName = "";
    protected boolean _performIDAssertion = false;
    protected String[] _performIDANamingMechList = null;
    protected int _performIdentityTokenType = 0;
    protected String _performServiceCfgList = null;
    protected boolean _performAuthorizationToken = false;
    protected boolean _performDelegationByClient = false;
    protected CSIv2TaggedComponentHolder savedCSIv2Tag = null;
    protected static Hashtable csiv2EffectivePolicyCache = new Hashtable();

    public String[] getPerformIDANamingMechList() {
        return this._performIDANamingMechList;
    }

    public int getPerformIdentityTokenType() {
        return this._performIdentityTokenType;
    }

    public boolean performIdentityAssertion() {
        return this._performIDAssertion;
    }

    public boolean performDelegationByClient() {
        return this._performDelegationByClient;
    }

    public boolean performAuthorizationToken() {
        return this._performAuthorizationToken;
    }

    public String getServiceCfgList() {
        return this._performServiceCfgList;
    }

    public String getPerformClientAuthMechOID() {
        return this._performClientAuthMechOID;
    }

    public boolean performClientAuthentication() {
        return this._performClientAuth;
    }

    public boolean claimClientAuthenticationRequired() {
        return this._claimClientAuthRequired;
    }

    public String getTargetSecurityName() {
        return this._targetSecurityName;
    }

    public String getTargetHostName() {
        return this._targetHostName;
    }

    public int getTargetTCPPort() {
        return this._targetTCPPort;
    }

    public int getTargetSSLPort() {
        return this._targetSSLPort;
    }

    public String getMechanismTypeIdentity() {
        if (this._performClientAuth) {
            if (this._performSSLTLS) {
                if (OID.compareOIDs(this._performClientAuthMechOID, "oid:2.23.130.1.1.1")) {
                    return "1.5";
                }
                if (OID.compareOIDs(this._performClientAuthMechOID, "oid:1.2.840.113554.1.2.2")) {
                    // empty if block
                }
            } else {
                if (OID.compareOIDs(this._performClientAuthMechOID, "oid:2.23.130.1.1.1")) {
                    return "5.7.4";
                }
                if (OID.compareOIDs(this._performClientAuthMechOID, "oid:1.2.840.113554.1.2.2")) {
                    // empty if block
                }
            }
        }
        return this._mechTypeIdentity;
    }

    public String getPerformSECIOPMechOID() {
        return this._performSECIOPMechOID;
    }

    public boolean performSSLTLS() {
        return this._performSSLTLS;
    }

    public boolean performSECIOP() {
        return this._performSECIOP;
    }

    public boolean performMsgConfidentiality() {
        return this._performMsgConfidentiality;
    }

    public boolean performMsgIntegrity() {
        return this._performMsgIntegrity;
    }

    public boolean performMsgDetectMisordering() {
        return this._performMsgDetectMisordering;
    }

    public boolean performMsgDetectReplay() {
        return this._performMsgDetectReplay;
    }

    public boolean performTLClientAuth() {
        return this._performTLClientAuth;
    }

    public boolean performTLServerAuth() {
        return this._performTLServerAuth;
    }

    private void evaluateStatefulness(boolean bl, Vector vector) throws CSIv2RequirementsNotSatisfied {
        String string = "CSIv2EffectivePerformPolicy.evaluateStatefulness";
        String string2 = null;
        boolean bl2 = this._stateful = bl && secConfig.getCSIv2PerformStateful();
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Stateful request? " + this._stateful;
            SecurityLogger.debugMessage(string, string2);
        }
    }

    private void evaluateTransportLayer(CSIv2TaggedComponent cSIv2TaggedComponent, Vector vector, int n) throws CSIv2RequirementsNotSatisfied {
        String string = "CSIv2EffectivePerformPolicy.evaluateTransportLayer";
        String string2 = null;
        boolean bl = false;
        if (cSIv2TaggedComponent == null) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0600E", "JSAS0600E: CSIv2 Tagged Component is NULL.");
            vector.addElement(string2);
            bl = true;
        }
        int n2 = cSIv2TaggedComponent.get_Transport_tagID();
        TLS_SEC_TRANSHolder tLS_SEC_TRANSHolder = null;
        Object var9_9 = null;
        short s = 0;
        short s2 = 0;
        if (n2 == 36) {
            tLS_SEC_TRANSHolder = cSIv2TaggedComponent.getTLS_SEC_TRANS();
            s = tLS_SEC_TRANSHolder.value.target_supports;
            s2 = tLS_SEC_TRANSHolder.value.target_requires;
            this._targetHostName = tLS_SEC_TRANSHolder.value.addresses[0].host_name;
            this._targetSSLPort = tLS_SEC_TRANSHolder.value.addresses[0].port;
            this._targetTCPPort = cSIv2TaggedComponent.getIORProfile().getPort();
            this._performSSLTLS = secConfig.getCSIv2PerformTransportAssocSSLTLSSupported() || secConfig.getCSIv2PerformTransportAssocSSLTLSRequired();
        } else {
            if (n2 == 34) {
                s = 0;
                s2 = 0;
                this._targetHostName = cSIv2TaggedComponent.getIORProfile().getHost();
                this._targetTCPPort = cSIv2TaggedComponent.getIORProfile().getPort();
                this._performSSLTLS = false;
                this._performTLClientAuth = false;
                this._performMsgIntegrity = false;
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Perform SSL/TLS: " + this._performSSLTLS + ", Perform client auth at transport layer: " + this._performTLClientAuth + ", Perform integrity at transport layer: " + this._performMsgIntegrity + ", Perform confidentiality at transport layer: " + this._performMsgConfidentiality + ", Target Host: " + this._targetHostName + ", Target TCP Port: " + this._targetTCPPort + ", Target SSL Port: " + this._targetSSLPort;
                    SecurityLogger.debugMessage(string, string2);
                }
                if (secConfig.getCSIv2PerformTransportAssocSSLTLSRequired()) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0603E", "JSAS0603E: The server does not support SSL/TLS, but the client is configured to require it.");
                    vector.addElement(string2);
                    bl = true;
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0550I", "JSAS0550I: Evaluation of the transport layer failed.");
                    throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByClient, string2);
                }
                return;
            }
            if (n2 == 35) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0601E", "JSAS0601E: The CSIv2 client configuration does not support SECIOP.");
                vector.addElement(string2);
                bl = true;
            } else {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0602E", "JSAS0602E: No valid transport tagged components exist in the IOR.");
                vector.addElement(string2);
                bl = true;
            }
        }
        if (s2 == 0 && s == 0 && secConfig.getCSIv2PerformTransportAssocSSLTLSRequired()) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0603E", "JSAS0603E: The server does not support SSL/TLS, but the client is configured to require it.");
            vector.addElement(string2);
            bl = true;
        }
        if (!secConfig.getCSIv2PerformTransportAssocSSLTLSSupported() && !secConfig.getCSIv2PerformTransportAssocSSLTLSRequired() && this._targetTCPPort == 0) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0608E", "JSAS0608E: The server requires SSL Confidentiality but the client does not support it.");
            vector.addElement(string2);
            bl = true;
        }
        if (secConfig.getCSIv2PerformTLClientAuthenticationRequired() && this._performSSLTLS) {
            if ((s2 & 0x40) == 0 && (s & 0x40) == 0) {
                if (n > 1) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0604E", "JSAS0604E: The client is configured to require SSL client authentication but the server does not support it.");
                    vector.addElement(string2);
                    bl = true;
                } else {
                    this._performTLClientAuth = false;
                }
            } else {
                this._performTLClientAuth = true;
            }
        } else if (secConfig.getCSIv2PerformTLClientAuthenticationSupported() && this._performSSLTLS) {
            if ((s2 & 0x40) == 0 && (s & 0x40) == 0) {
                if (n > 1) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0605E", "JSAS0605E: The client is configured to support SSL client certificate authentication, however the server does not accept them.");
                    vector.addElement(string2);
                    bl = true;
                } else {
                    this._performTLClientAuth = false;
                }
            } else {
                this._performTLClientAuth = true;
            }
        } else {
            if ((s2 & 0x40) != 0) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0606E", "JSAS0606E: The server is configured to require SSL client certificate authentication but the client does not support it.");
                vector.addElement(string2);
                bl = true;
            }
            this._performTLClientAuth = false;
        }
        this._performTLServerAuth = true;
        if (secConfig.getCSIv2PerformMessageConfidentialityRequired() && this._performSSLTLS) {
            if ((s2 & 4) == 0 && (s & 4) == 0) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0607E", "JSAS0607E: The client is configured to require SSL Confidentiality but the server does not support it.");
                vector.addElement(string2);
                bl = true;
            } else {
                this._performMsgConfidentiality = true;
            }
        } else if (secConfig.getCSIv2PerformMessageConfidentialitySupported() && this._performSSLTLS) {
            this._performMsgConfidentiality = (s2 & 4) != 0 || (s & 4) != 0;
        } else {
            if ((s2 & 4) != 0) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0608E", "JSAS0608E: The server is configured to require Confidentiality but the client does not support it.");
                vector.addElement(string2);
                bl = true;
            }
            this._performMsgConfidentiality = false;
        }
        if (secConfig.getCSIv2PerformMessageIntegrityRequired() && this._performSSLTLS) {
            if ((s2 & 2) == 0 && (s & 2) == 0) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0609E", "JSAS0609E: The client is configured to require SSL Integrity but the server does not support it.");
                vector.addElement(string2);
                bl = true;
            } else {
                this._performMsgIntegrity = true;
            }
        } else if (secConfig.getCSIv2PerformMessageIntegritySupported() && this._performSSLTLS) {
            this._performMsgIntegrity = (s2 & 2) != 0 || (s & 2) != 0;
        } else {
            if ((s2 & 2) != 0 && this._performSSLTLS) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0610E", "JSAS0610E: The server is configured to require SSL Integrity but the client does not support it.");
                vector.addElement(string2);
                bl = true;
            }
            this._performMsgIntegrity = false;
        }
        this._performMsgDetectReplay = true;
        this._performMsgDetectMisordering = true;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Perform SSL/TLS: " + this._performSSLTLS + ", Perform client auth at transport layer: " + this._performTLClientAuth + ", Perform integrity at transport layer: " + this._performMsgIntegrity + ", Perform confidentiality at transport layer: " + this._performMsgConfidentiality + ", Target Host: " + this._targetHostName + ", Target TCP Port: " + this._targetTCPPort + ", Target SSL Port: " + this._targetSSLPort;
            SecurityLogger.debugMessage(string, string2);
        }
        if (bl) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0550I", "JSAS0550I: Evaluation of the transport layer failed.");
            throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByClient, string2);
        }
    }

    private void evaluateClientAuthLayer(AS_ContextSecHolder aS_ContextSecHolder, Vector vector) throws CSIv2RequirementsNotSatisfied {
        String string = "CSIv2EffectivePerformPolicy.evaluateClientAuthLayer";
        String string2 = null;
        boolean bl = false;
        if (aS_ContextSecHolder == null || aS_ContextSecHolder.value == null) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0611E", "JSAS0611E: No authentication mechanism is defined at client authentication layer.");
            vector.addElement(string2);
            bl = true;
        }
        AS_ContextSec aS_ContextSec = aS_ContextSecHolder.value;
        CSIUtil cSIUtil = new CSIUtil();
        short s = 0;
        short s2 = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (aS_ContextSec == null) {
            if (secConfig.getCSIv2PerformClientAuthenticationRequired()) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0611E", "JSAS0611E: No authentication mechanism is defined at client authentication layer.");
                vector.addElement(string2);
                bl = true;
            }
        } else {
            s = aS_ContextSec.target_supports;
            s2 = aS_ContextSec.target_requires;
            byArray = aS_ContextSec.client_authentication_mech;
            byArray2 = aS_ContextSec.target_name;
            if ((s2 & 0x40) != 0) {
                this._claimClientAuthRequired = true;
            }
            if (secConfig.getCSIv2PerformClientAuthenticationRequired()) {
                if ((s & 0x40) == 0 && (s2 & 0x40) == 0) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0612E", "JSAS0612E: The client requires client authentication (e.g., userid/password), but the server does not support it.");
                    vector.addElement(string2);
                    bl = true;
                }
                this._performClientAuth = true;
            } else if (secConfig.getCSIv2PerformClientAuthenticationSupported()) {
                if ((s & 0x40) == 0 && (s2 & 0x40) == 0) {
                    this._performClientAuth = false;
                    if (s == 0) {
                        return;
                    }
                } else {
                    this._performClientAuth = true;
                }
            } else if ((s2 & 0x40) != 0) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0613E", "JSAS0613E: The server requires client authentication (e.g., userid/password), but the client does not support it.");
                vector.addElement(string2);
                bl = true;
            } else {
                this._performClientAuth = false;
            }
            if (this._performClientAuth) {
                Object object;
                if (byArray2 == null) {
                    this._performClientAuth = false;
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0618E", "JSAS0618E: The target security name is NULL in CSIv2 tagged component.");
                    vector.addElement(string2);
                    bl = true;
                } else if (this.savedCSIv2Tag != null && this.savedCSIv2Tag.value != null) {
                    this._targetSecurityName = this.savedCSIv2Tag.value.get_targetCompleteName();
                }
                String string3 = secConfig.getSupportedTargetRealms();
                boolean bl2 = true;
                if (string3 != null && !string3.equals("")) {
                    object = new StringTokenizer(string3, "|");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string4 = ((StringTokenizer)object).nextToken();
                        if (!this._targetSecurityName.startsWith(string4)) continue;
                        bl2 = false;
                    }
                }
                object = new GSSFactory(byArray);
                this._performClientAuthMechOID = ((GSSFactory)object).getOIDName();
                if (bl2) {
                    if (byArray == null) {
                        this._performClientAuth = false;
                        string2 = SecurityMessages.getMsgOrUseDefault("JSAS0611E", "JSAS0611E: No authentication mechanism is defined at client authentication layer.");
                        vector.addElement(string2);
                        bl = true;
                    } else if (!(OID.compareOIDs(this._performClientAuthMechOID, "oid:2.23.130.1.1.1") || OID.compareOIDs(this._performClientAuthMechOID, "oid:1.2.840.113554.1.2.2") || OID.compareOIDs(this._performClientAuthMechOID, "oid:1.3.18.0.2.30.2") || OID.compareOIDs(this._performClientAuthMechOID, secConfig.getWSSecurityContextCustomOID()))) {
                        this._performClientAuth = false;
                        this._performClientAuthMechOID = null;
                        string2 = SecurityMessages.getMsgOrUseDefault("JSAS0614E", "JSAS0614E: The OID supplied by the server is an unsupported OID for this WebSphere release.");
                        vector.addElement(string2);
                        bl = true;
                    } else if (!this.performIdentityAssertion()) {
                        if (!OID.compareOIDs(this._performClientAuthMechOID, "oid:1.2.840.113554.1.2.2") && secConfig.getauthenticationTarget() == 6) {
                            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0615E", "JSAS0615E: The client configuration specifies the Kerberos authentication mechanism, but the server does not support it.");
                            vector.addElement(string2);
                            bl = true;
                        } else if (!OID.compareOIDs(this._performClientAuthMechOID, "oid:1.3.18.0.2.30.2") && secConfig.getauthenticationTarget() == 1) {
                            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0616E", "JSAS0616E: The client configuration specifies the LTPA authentication mechanism, but the server does not support it.");
                            vector.addElement(string2);
                            bl = true;
                        } else if (!OID.compareOIDs(this._performClientAuthMechOID, secConfig.getWSSecurityContextCustomOID()) && secConfig.getauthenticationTarget() == 8) {
                            boolean bl3 = secConfig.getLTPASupportedWithKerberos();
                            if (!OID.compareOIDs(this._performClientAuthMechOID, "oid:1.3.18.0.2.30.2") && !bl3) {
                                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0617E", "JSAS0617E: The client configuration specifies the Custom authentication mechanism, but the server does not support it.");
                                vector.addElement(string2);
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Perform client authentication at message layer: " + this._performClientAuth + ", Perform client auth mechanism: " + this._performClientAuthMechOID + ", Target Name at message layer: " + this._targetSecurityName;
            SecurityLogger.debugMessage(string, string2);
        }
        if (bl) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0551I", "JSAS0551I: Evaluation of the message layer failed.");
            throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByClient, string2);
        }
    }

    private void evaluateAttributeLayer(SAS_ContextSecHolder sAS_ContextSecHolder, Vector vector) throws CSIv2RequirementsNotSatisfied {
        String string = "CSIv2EffectivePerformPolicy.evaluateAttributeLayer";
        String string2 = null;
        boolean bl = false;
        SAS_ContextSec sAS_ContextSec = sAS_ContextSecHolder.value;
        short s = 0;
        short s2 = 0;
        byte[][] byArray = null;
        int n = 0;
        ServiceConfiguration[] serviceConfigurationArray = null;
        if (sAS_ContextSec == null) {
            if (secConfig.getCSIv2PerformIdentityAssertionRequired()) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0619E", "JSAS0619E: The sending server requires Identity Assertion but the receiving server does not support it.");
                vector.addElement(string2);
                bl = true;
            }
        } else {
            GSSFactory gSSFactory;
            Object object;
            s = sAS_ContextSec.target_supports;
            s2 = sAS_ContextSec.target_requires;
            byArray = sAS_ContextSec.supported_naming_mechanisms;
            n = sAS_ContextSec.supported_identity_types;
            serviceConfigurationArray = sAS_ContextSec.privilege_authorities;
            if (secConfig.getCSIv2PerformIdentityAssertionRequired()) {
                if (byArray == null || byArray.length == 0) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0620E", "JSAS0620E: No supported naming mechanisms are defined in attribute layer for Identity Assertion.");
                    vector.addElement(string2);
                    bl = true;
                }
                if (n == 0) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0621E", "JSAS0621E: The target server does not support any identity token types.");
                    vector.addElement(string2);
                    bl = true;
                }
                if ((s & 0x400) == 0 && (s2 & 0x400) == 0) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0619E", "JSAS0619E: The sending server requires Identity Assertion but the receiving server does not support it.");
                    vector.addElement(string2);
                    bl = true;
                }
                if (!bl) {
                    this._performIDAssertion = true;
                }
            } else if (secConfig.getCSIv2PerformIdentityAssertionSupported() && ((s & 0x400) != 0 || (s2 & 0x400) != 0)) {
                if (n != 0 && byArray != null && byArray.length > 0) {
                    this._performIDAssertion = true;
                } else if (n == 0) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0621E", "JSAS0621E: The target server does not support any identity token types.");
                    vector.addElement(string2);
                    bl = true;
                } else if (byArray == null || byArray.length == 0) {
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0620E", "JSAS0620E: No supported naming mechanisms are defined in attribute layer for Identity Assertion.");
                    vector.addElement(string2);
                    bl = true;
                }
            }
            if (this._performIDAssertion) {
                int n2;
                Vector<ServiceConfiguration> vector2 = new Vector<ServiceConfiguration>();
                object = null;
                gSSFactory = null;
                for (n2 = 0; n2 < byArray.length; ++n2) {
                    gSSFactory = new GSSFactory(byArray[n2]);
                    object = gSSFactory.getOIDName();
                    if (OID.compareOIDs((String)object, "oid:1.2.840.113554.1.2.2")) {
                        if (secConfig.getCSIv2PerformIdentityAssertionMechanism() != 6) continue;
                        vector2.addElement((ServiceConfiguration)object);
                        continue;
                    }
                    if (OID.compareOIDs((String)object, "oid:2.23.130.1.1.1")) {
                        if (secConfig.getCSIv2PerformIdentityAssertionMechanism() != 4 && secConfig.getCSIv2PerformIdentityAssertionMechanism() != 6 && secConfig.getCSIv2PerformIdentityAssertionMechanism() != 2 && secConfig.getCSIv2PerformIdentityAssertionMechanism() != 1) continue;
                        vector2.addElement((ServiceConfiguration)object);
                        continue;
                    }
                    if (OID.compareOIDs((String)object, "oid:1.3.18.0.2.30.2")) {
                        if (secConfig.getCSIv2PerformIdentityAssertionMechanism() != 1) continue;
                        vector2.addElement((ServiceConfiguration)object);
                        continue;
                    }
                    if (OID.compareOIDs((String)object, secConfig.getWSSecurityContextCustomOID())) {
                        if (secConfig.getCSIv2PerformIdentityAssertionMechanism() != 8) continue;
                        vector2.addElement((ServiceConfiguration)object);
                        continue;
                    }
                    string2 = SecurityMessages.getMsgOrUseDefault("JSAS0620E", "JSAS0620E: No supported naming mechanisms are defined in attribute layer for Identity Assertion.");
                    vector.addElement(string2);
                    bl = true;
                }
                if (vector2.size() != 0) {
                    this._performIDANamingMechList = new String[vector2.size()];
                    for (n2 = 0; n2 < vector2.size(); ++n2) {
                        this._performIDANamingMechList[n2] = (String)vector2.elementAt(n2);
                    }
                }
                this._performIdentityTokenType = secConfig.getCSIv2PerformIdentityAssertionType() & n;
                this._performIDAssertion = true;
            }
            if (secConfig.isRMIOutboundPropagationEnabled() && serviceConfigurationArray != null) {
                for (int i = 0; i < serviceConfigurationArray.length; ++i) {
                    object = serviceConfigurationArray[i];
                    if (object.name == null) continue;
                    gSSFactory = ORB.createCDRInputStream((ORB)_orb, (byte[])object.name, (int)object.name.length);
                    String string3 = gSSFactory.read_string();
                    if (ContextManagerFactory.getInstance().processIsServer() && string3.equals(ContextManagerFactory.getInstance().getDefaultRealm())) {
                        this._performAuthorizationToken = true;
                    } else if (!ContextManagerFactory.getInstance().processIsServer()) {
                        this._performAuthorizationToken = true;
                    } else {
                        String string4 = secConfig.getSupportedTargetRealms();
                        if (string4 != null && !string4.equals("")) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string4, "|");
                            while (stringTokenizer.hasMoreTokens()) {
                                String string5 = stringTokenizer.nextToken();
                                if (!string5.equalsIgnoreCase(string3)) continue;
                                this._performAuthorizationToken = true;
                                break;
                            }
                        }
                        if (!this._performAuthorizationToken) {
                            string2 = "security.JSAS1479W";
                            SecurityLogger.logWarning(string2, new Object[]{string3, ContextManagerFactory.getInstance().getDefaultRealm()});
                        }
                    }
                    this._performServiceCfgList = i == 0 ? string3 : this._performServiceCfgList + "|" + string3;
                }
            }
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Perform identity assertion at attribute layer: " + this._performIDAssertion + ", Perform authorization token at attribute layer: " + this._performAuthorizationToken + ", Authorization service configuration names: " + this._performServiceCfgList;
            SecurityLogger.debugMessage(string, string2);
        }
        if (bl) {
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0552I", "JSAS0552I: Evaluation of the attribute layer failed.");
            throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByClient, string2);
        }
    }

    public final synchronized CSIv2EffectivePerformPolicy getEffectivePolicy(CSIv2TaggedComponent[] cSIv2TaggedComponentArray) throws CSIv2RequirementsNotSatisfied {
        String string = "";
        String string2 = "CSIv2EffectivePerformPolicy.getEffectivePolicy";
        Object var4_4 = null;
        CSIv2TaggedComponent cSIv2TaggedComponent = null;
        CSIv2TaggedComponentHolder cSIv2TaggedComponentHolder = null;
        string = "Enter getEffectivePolicy.";
        SecurityLogger.debugMessage(string2, string);
        if (cSIv2TaggedComponentArray.length > 0) {
            int n;
            Vector vector = null;
            for (int i = 0; i < cSIv2TaggedComponentArray.length; ++i) {
                n = 1;
                cSIv2TaggedComponent = cSIv2TaggedComponentArray[i];
                cSIv2TaggedComponentHolder = new CSIv2TaggedComponentHolder(cSIv2TaggedComponent);
                vector = new Vector();
                try {
                    if (SecurityLogger.debugTraceEnabled) {
                        string = "Evaluating CSIv2 tag " + (i + 1) + " of " + cSIv2TaggedComponentArray.length;
                        SecurityLogger.debugMessage(string2, string);
                    }
                    n = this.evaluate(cSIv2TaggedComponentHolder, this, vector, cSIv2TaggedComponentArray.length - i);
                }
                catch (CSIv2RequirementsNotSatisfied cSIv2RequirementsNotSatisfied) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string = "CSIv2 tag " + i + " failed evaluation.";
                        SecurityLogger.debugMessage(string2, string);
                    }
                    FFDCFilter.processException((Throwable)cSIv2RequirementsNotSatisfied, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.getEffectivePolicy", (String)"1278");
                    n = 0;
                }
                if (n == 0) continue;
                if (SecurityLogger.debugTraceEnabled) {
                    string = "CSIv2 tag " + (i + 1) + " evaluation succeeded.";
                    SecurityLogger.debugMessage(string2, string);
                }
                if (csiv2EffectivePolicyCache.size() > 50) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string = "Clearing effective policy cache, size > 50";
                        SecurityLogger.debugMessage(string2, string);
                    }
                    csiv2EffectivePolicyCache.clear();
                }
                csiv2EffectivePolicyCache.put(cSIv2TaggedComponentArray, this);
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Size of effective policy cache = " + csiv2EffectivePolicyCache.size();
                    SecurityLogger.debugMessage(string2, string);
                }
                return this;
            }
            if (vector == null) {
                throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByTarget, "SECURITY CLIENT/SERVER CONFIG MISMATCH:  The server does not support the client configuration.");
            }
            if (vector.isEmpty()) {
                throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByTarget, "SECURITY CLIENT/SERVER CONFIG MISMATCH:  The server does not support the client configuration.");
            }
            StringBuffer stringBuffer = new StringBuffer(500);
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append(SecurityMessages.getMsgOrUseDefault("JSAS1477W", "JSAS1477W: SECURITY CLIENT/SERVER CONFIG MISMATCH:  The client security configuration (sas.client.props or outbound settings in GUI) does not support the server security configuration for the following reasons: "));
            n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("     ");
                stringBuffer.append(SecurityMessages.getMsgOrUseDefault("Error", "ERROR "));
                stringBuffer.append(++n);
                stringBuffer.append(": ");
                stringBuffer.append(string3);
            }
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append(System.getProperty("line.separator"));
            string = stringBuffer.toString();
            SecurityLogger.logWarning(string2, string);
            throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByTarget, stringBuffer.toString());
        }
        throw new CSIv2RequirementsNotSatisfied(CSIv2RequirementsNotSatisfiedReason.NotSatisfiedByTarget, "There are no CSIv2 Tagged Components in the List.");
    }

    private final boolean evaluate(CSIv2TaggedComponentHolder cSIv2TaggedComponentHolder, CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy, Vector vector, int n) throws CSIv2RequirementsNotSatisfied {
        block13: {
            String string = "";
            String string2 = "CSIv2EffectivePerformPolicy.evaluate";
            try {
                if (secConfig == null) {
                    VaultImpl.getInstance();
                    secConfig = VaultImpl.getSecurityConfiguration();
                }
                if (cSIv2TaggedComponentHolder != null && cSIv2TaggedComponentHolder.value != null) {
                    CSIv2TaggedComponent cSIv2TaggedComponent = cSIv2TaggedComponentHolder.value;
                    this.savedCSIv2Tag = cSIv2TaggedComponentHolder;
                    if (cSIv2EffectivePerformPolicy != null) {
                        boolean bl = false;
                        try {
                            cSIv2EffectivePerformPolicy.evaluateStatefulness(cSIv2TaggedComponent.isStateFul(), vector);
                        }
                        catch (CSIv2RequirementsNotSatisfied cSIv2RequirementsNotSatisfied) {
                            FFDCFilter.processException((Throwable)cSIv2RequirementsNotSatisfied, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.evaluate", (String)"1395");
                            bl = true;
                        }
                        try {
                            cSIv2EffectivePerformPolicy.evaluateAttributeLayer(cSIv2TaggedComponent.getSAS_context_mech_holder(), vector);
                        }
                        catch (CSIv2RequirementsNotSatisfied cSIv2RequirementsNotSatisfied) {
                            FFDCFilter.processException((Throwable)cSIv2RequirementsNotSatisfied, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.evaluate", (String)"1406");
                            bl = true;
                        }
                        try {
                            cSIv2EffectivePerformPolicy.evaluateClientAuthLayer(cSIv2TaggedComponent.getAS_context_mech_holder(), vector);
                        }
                        catch (CSIv2RequirementsNotSatisfied cSIv2RequirementsNotSatisfied) {
                            FFDCFilter.processException((Throwable)cSIv2RequirementsNotSatisfied, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.evaluate", (String)"1417");
                            bl = true;
                        }
                        try {
                            cSIv2EffectivePerformPolicy.evaluateTransportLayer(cSIv2TaggedComponent, vector, n);
                        }
                        catch (CSIv2RequirementsNotSatisfied cSIv2RequirementsNotSatisfied) {
                            FFDCFilter.processException((Throwable)cSIv2RequirementsNotSatisfied, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.evaluate", (String)"1429");
                            bl = true;
                        }
                        return !bl;
                    }
                    string = "Effective policy object is null.";
                    SecurityLogger.debugMessage(string2, string);
                    vector.addElement(string);
                    break block13;
                }
                string = "CSIv2TagHolder is null or the value inside is null.";
                SecurityLogger.debugMessage(string2, string);
                vector.addElement(string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy.evaluate", (String)"1452");
                string = "Exception in getEffectivePolicy, probably CSIv2RequirementsNotSatisfied.";
                SecurityLogger.debugMessage(string2, string);
                SecurityLogger.logException(string2, exception, 0, 0);
            }
        }
        return false;
    }

    public boolean isStateful() {
        return this._stateful;
    }

    public long getStatefulContextID() {
        return this._stateful_context_id;
    }

    public void setStatefulContextID(long l) {
        this._stateful_context_id = l;
    }

    public ClientSessionKey getClientSessionKey() {
        return this._client_session_key;
    }

    public void setClientSessionKey(ClientSessionKey clientSessionKey) {
        this._client_session_key = clientSessionKey;
    }

    private CSIv2EffectivePerformPolicy() {
    }

    public static CSIv2EffectivePerformPolicy getInstance(CSIv2TaggedComponent[] cSIv2TaggedComponentArray) {
        String string = null;
        String string2 = "CSIv2EffectivePerformPolicy.getInstance";
        CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy = (CSIv2EffectivePerformPolicy)csiv2EffectivePolicyCache.get(cSIv2TaggedComponentArray);
        if (cSIv2EffectivePerformPolicy != null) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Returning policy from cache for CSIv2TagList: " + cSIv2TaggedComponentArray;
                SecurityLogger.debugMessage(string2, string);
            }
            return (CSIv2EffectivePerformPolicy)cSIv2EffectivePerformPolicy.clone();
        }
        return null;
    }

    public static CSIv2EffectivePerformPolicy getInstance() {
        return new CSIv2EffectivePerformPolicy();
    }

    public CSIv2TaggedComponentHolder getCSIv2TaggedComponent() {
        return this.savedCSIv2Tag;
    }

    protected Object clone() {
        CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy = new CSIv2EffectivePerformPolicy();
        cSIv2EffectivePerformPolicy._client_session_key = null;
        cSIv2EffectivePerformPolicy._stateful_context_id = 0L;
        cSIv2EffectivePerformPolicy._claimClientAuthRequired = this._claimClientAuthRequired;
        cSIv2EffectivePerformPolicy._mechTypeIdentity = this._mechTypeIdentity;
        cSIv2EffectivePerformPolicy._performAuthorizationToken = this._performAuthorizationToken;
        cSIv2EffectivePerformPolicy._performClientAuth = this._performClientAuth;
        cSIv2EffectivePerformPolicy._performClientAuthMechOID = this._performClientAuthMechOID;
        cSIv2EffectivePerformPolicy._performDelegationByClient = this._performDelegationByClient;
        cSIv2EffectivePerformPolicy._performIDANamingMechList = this._performIDANamingMechList;
        cSIv2EffectivePerformPolicy._performIDAssertion = this._performIDAssertion;
        cSIv2EffectivePerformPolicy._performIdentityTokenType = this._performIdentityTokenType;
        cSIv2EffectivePerformPolicy._performMsgConfidentiality = this._performMsgConfidentiality;
        cSIv2EffectivePerformPolicy._performMsgDetectMisordering = this._performMsgDetectMisordering;
        cSIv2EffectivePerformPolicy._performMsgDetectReplay = this._performMsgDetectReplay;
        cSIv2EffectivePerformPolicy._performMsgIntegrity = this._performMsgIntegrity;
        cSIv2EffectivePerformPolicy._performSECIOP = this._performSECIOP;
        cSIv2EffectivePerformPolicy._performSECIOPMechOID = this._performSECIOPMechOID;
        cSIv2EffectivePerformPolicy._performServiceCfgList = this._performServiceCfgList;
        cSIv2EffectivePerformPolicy._performSSLTLS = this._performSSLTLS;
        cSIv2EffectivePerformPolicy._performTLClientAuth = this._performTLClientAuth;
        cSIv2EffectivePerformPolicy._performTLServerAuth = this._performTLServerAuth;
        cSIv2EffectivePerformPolicy._protocol = this._protocol;
        cSIv2EffectivePerformPolicy._stateful = this._stateful;
        cSIv2EffectivePerformPolicy._targetHostName = this._targetHostName;
        cSIv2EffectivePerformPolicy._targetSecurityName = this._targetSecurityName;
        cSIv2EffectivePerformPolicy._targetSSLPort = this._targetSSLPort;
        cSIv2EffectivePerformPolicy._targetTCPPort = this._targetTCPPort;
        cSIv2EffectivePerformPolicy.savedCSIv2Tag = this.savedCSIv2Tag;
        return cSIv2EffectivePerformPolicy;
    }
}

