/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.IExtendedSecurityReplaceablePriv.SessionEntry;
import com.ibm.IExtendedSecurityReplaceablePriv.SessionEntryHolder;
import com.ibm.IExtendedSecurityReplaceablePriv.VaultPackage.SessionDoesNotExist;
import com.ibm.IExtendedSecurityReplaceablePriv._OrbRequestHolder;
import com.ibm.IExtendedSecurityReplaceablePrivImpl.OrbRequestHolderImpl;
import com.ibm.ISecurityL13SupportImpl.RetryPanel;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.ClientExceptionRI;
import com.ibm.ISecurityLocalObjectBaseL13Impl.ClientFlow;
import com.ibm.ISecurityLocalObjectBaseL13Impl.ClientNonMarshaledDataRI;
import com.ibm.ISecurityLocalObjectBaseL13Impl.ContextState;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.RequestHolder;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.ServerExceptionRI;
import com.ibm.ISecurityLocalObjectBaseL13Impl.ServerFlow;
import com.ibm.ISecurityLocalObjectBaseL13Impl.ServerNonMarshaledDataRI;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.CDRInputMessage;
import com.ibm.ISecurityUtilityImpl.CredentialsHelper;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.VaultConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.ConnectionDataCarrier;
import com.ibm.ws.security.orbssl.ExtendedSSLConnectionData;
import com.ibm.ws.security.orbssl.SSLConnectionDataImpl;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.swing.JFrame;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.Security.AssociationStatus;
import org.omg.Security.CredentialType;
import org.omg.Security.InvalidCredentialType;
import org.omg.Security.OpaqueHolder;
import org.omg.Security.QOP;
import org.omg.SecurityLevel2.Credentials;
import org.omg.SecurityLevel2.InvalidCredential;
import org.omg.SecurityLevel2.LoginFailed;
import org.omg.SecurityReplaceable.InvalidToken;
import org.omg.SecurityReplaceable.SecurityContextHolder;

public final class SecureAssociationInterceptorImpl
implements ClientNonMarshaledDataRI,
ClientExceptionRI,
ServerNonMarshaledDataRI,
ServerExceptionRI {
    public static final int NO_RETRY = -99;
    private static int ownedServiceDataID = -99;
    private VaultImpl vault = null;
    private SecurityConfiguration secConfig = null;
    private ORB orb = null;
    private CurrentImpl current = null;
    private SecurityConnectionInterceptor connectionInterceptor = null;

    public SecureAssociationInterceptorImpl(ORB oRB, boolean bl, VaultImpl vaultImpl) {
        String string = "SecureAssociationInterceptorImpl.SecureAssociationInterceptorImpl";
        String string2 = null;
        this.orb = oRB;
        if (vaultImpl != null) {
            this.vault = vaultImpl;
            if (vaultImpl.securityContextKey == 0) {
                vaultImpl.securityContextKey = RequestHolder.getServiceDataKey();
            }
            this.secConfig = vaultImpl.getSecurityConfiguration();
            this.connectionInterceptor = vaultImpl.getSecurityConnectionInterceptor();
        } else {
            string2 = "security.JSAS0010E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
        }
    }

    public void client_demarshalled_response(RequestHolder requestHolder) throws SystemException {
        CDRInputMessage cDRInputMessage;
        String string = "SecureAssociationInterceptorImpl.client_demarshalled_response";
        String string2 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "client_demarshalled_response invoked with request holder " + requestHolder + " on ORB " + this.orb;
            SecurityLogger.debugMessage(string, string2);
        }
        if (!(cDRInputMessage = new CDRInputMessage(requestHolder, true)).secCtxFound()) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "No security context in message.  Must not be for SAS interceptor.";
                SecurityLogger.debugMessage(string, string2);
            }
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string);
            }
            return;
        }
        if (SecurityLogger.traceEnabled) {
            string2 = "*** RECEIVING REPLY ***";
            SecurityLogger.traceMessage(string, string2);
        }
        switch (cDRInputMessage.msgType()) {
            case 6: {
                this.handleAssocCompleteResponse();
                break;
            }
            case 4: {
                this.handleAssocAcceptResponse(cDRInputMessage);
                break;
            }
            case 5: {
                this.handleAssocRejectResponse(cDRInputMessage);
                break;
            }
            case 7: {
                this.handleAssocSourceErrorResponse(cDRInputMessage);
                break;
            }
            default: {
                string2 = "security.JSAS0300E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                this.handleAssocRejectResponse(cDRInputMessage);
            }
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
    }

    public void client_system_exception(RequestHolder requestHolder, ClientFlow clientFlow) {
        String string = "SecureAssociationInterceptorImpl.client_system_exception";
        String string2 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "client_system_exception invoked on operation " + requestHolder.operation() + " with request holder " + requestHolder + " on ORB " + this.orb;
            SecurityLogger.debugMessage(string, string2);
        }
        Credentials credentials = null;
        CredentialsImpl credentialsImpl = null;
        try {
            credentials = (Credentials)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public java.lang.Object run() throws InvalidCredentialType {
                    Credentials credentials = SecureAssociationInterceptorImpl.this.current().get_credentials(CredentialType.SecInvocationCredentials, false, null);
                    if (credentials == null) {
                        credentials = SecureAssociationInterceptorImpl.this.current().get_credentials(CredentialType.SecOwnCredentials, false, null);
                    }
                    return credentials;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.client_system_exception", (String)"330", (java.lang.Object)this);
            InvalidCredentialType invalidCredentialType = (InvalidCredentialType)((java.lang.Object)privilegedActionException.getException());
            SecurityLogger.logException(string, (Exception)((java.lang.Object)invalidCredentialType), 0, 0);
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Unable to get client credentials for validating rejection from target.";
                SecurityLogger.debugMessage(string, string2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.client_system_exception", (String)"324", (java.lang.Object)this);
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Unable to get client credentials for validating rejection from target.";
                SecurityLogger.debugMessage(string, string2);
            }
            SecurityLogger.logException(string, exception, 0, 0);
        }
        CDRInputMessage cDRInputMessage = new CDRInputMessage(requestHolder, true);
        if (cDRInputMessage.returnErrorToClient() && SecurityLogger.debugTraceEnabled) {
            string2 = "NO_PERMISSION returned, failure reason: " + cDRInputMessage.subMsg();
            SecurityLogger.debugMessage(string, string2);
        }
        if (credentials != null && credentials instanceof CredentialsImpl && (credentialsImpl = (CredentialsImpl)credentials).isInvalidByRejection()) {
            try {
                this.current().setSecurityContext(null, "ibm");
            }
            catch (NullPointerException nullPointerException) {
                FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.client_system_exception", (String)"363", (java.lang.Object)this);
                string2 = "security.JSAS0030E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string, nullPointerException});
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.client_system_exception", (String)"370", (java.lang.Object)this);
                string2 = "security.JSAS0439E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string, exception});
            }
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string);
            }
            return;
        }
        if (clientFlow.client_demarshalled_responseCalled() == 1) {
            this.client_demarshalled_response(requestHolder);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
    }

    public void client_unmarshalled_request(RequestHolder requestHolder) throws SystemException {
        ConnectionData connectionData;
        String string = "SecureAssociationInterceptorImpl.client_unmarshalled_request";
        String string2 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        ExtendedSSLConnectionData extendedSSLConnectionData = null;
        SecurityContextImpl securityContextImpl = null;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "client_unmarshalled_request invoked with request holder " + requestHolder + " on ORB " + this.orb;
            SecurityLogger.debugMessage(string, string2);
        }
        if ((connectionData = requestHolder.connectionData()) == null) {
            if (SecurityLogger.traceEnabled) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0040W", "JSAS0040W: No ConnectionData object attached to RequestHolder.");
                SecurityLogger.traceMessage(string, string2);
            }
            if (SecurityLogger.traceEnabled) {
                string2 = "**** THROWING INTERNAL EXCEPTION ****";
                SecurityLogger.debugMessage(string, string2);
            }
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0040W", "JSAS0040W: No ConnectionData object attached to RequestHolder.");
            throw new INTERNAL(string2, 0, CompletionStatus.COMPLETED_NO);
        }
        if (connectionData instanceof SSLConnectionDataImpl) {
            extendedSSLConnectionData = (ExtendedSSLConnectionData)requestHolder.connectionData();
            securityContextImpl = (SecurityContextImpl)this.current().getSecurityContext("ibm");
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "After getting security context.";
                SecurityLogger.debugMessage(string, string2);
            }
        } else {
            if (SecurityLogger.traceEnabled) {
                string2 = SecurityMessages.getMsgOrUseDefault("JSAS0040W", "JSAS0040W: No ConnectionData object attached to RequestHolder.");
                SecurityLogger.traceMessage(string, string2);
            }
            if (SecurityLogger.traceEnabled) {
                string2 = "**** SENDING INSECURE REQUEST MESSAGE ****";
                SecurityLogger.debugMessage(string, string2);
            }
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string);
            }
            return;
        }
        if (securityContextImpl == null) {
            Credentials credentials = null;
            java.lang.Object var8_9 = null;
            try {
                credentials = (Credentials)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public java.lang.Object run() throws InvalidCredentialType {
                        Credentials credentials = SecureAssociationInterceptorImpl.this.current().get_credentials(CredentialType.SecInvocationCredentials, false, null);
                        if (credentials == null) {
                            credentials = SecureAssociationInterceptorImpl.this.current().get_credentials(CredentialType.SecOwnCredentials, false, null);
                        }
                        return credentials;
                    }
                });
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "After getting Invocation credential.";
                    SecurityLogger.debugMessage(string, string2);
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.client_unmarshalled_request", (String)"527", (java.lang.Object)this);
                InvalidCredentialType invalidCredentialType = (InvalidCredentialType)((java.lang.Object)privilegedActionException.getException());
                SecurityLogger.logException(string, (Exception)((java.lang.Object)invalidCredentialType), 0, 0);
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Unable to get client credentials for validating rejection from target.";
                    SecurityLogger.debugMessage(string, string2);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.client_unmarshalled_request", (String)"535", (java.lang.Object)this);
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "Unable to get client credentials for validating rejection from target.";
                    SecurityLogger.debugMessage(string, string2);
                }
                SecurityLogger.logException(string, exception, 0, 0);
            }
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "No security context, communication to target will be insecure.";
                SecurityLogger.debugMessage(string, string2);
            }
            if (SecurityLogger.traceEnabled) {
                string2 = "**** SENDING INSECURE REQUEST MESSAGE ****";
                SecurityLogger.traceMessage(string, string2);
            }
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string);
            }
            return;
        }
        OrbRequestHolderImpl orbRequestHolderImpl = new OrbRequestHolderImpl();
        orbRequestHolderImpl.setRequestHolder(requestHolder);
        OpaqueHolder opaqueHolder = new OpaqueHolder();
        OpaqueHolder opaqueHolder2 = new OpaqueHolder();
        QOP qOP = null;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Before preprotect.";
            SecurityLogger.debugMessage(string, string2);
        }
        boolean bl = securityContextImpl.preprotect_message((_OrbRequestHolder)orbRequestHolderImpl, qOP, opaqueHolder2, opaqueHolder);
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "After preprotect.";
            SecurityLogger.debugMessage(string, string2);
        }
        if (!bl) {
            string2 = "security.JSAS0060W";
            SecurityLogger.logWarning(string2, new java.lang.Object[]{string});
        }
        this.current().setSecurityContext(null, "ibm");
        if (SecurityLogger.traceEnabled) {
            string2 = "*** SENDING REQUEST ***";
            SecurityLogger.traceMessage(string, string2);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
    }

    public void client_user_exception(RequestHolder requestHolder) {
        String string = "SecureAssociationInterceptorImpl.client_user_exception";
        String string2 = null;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "client_user_exception invoked on operation " + requestHolder.operation() + " with request holder " + requestHolder + " on ORB " + this.orb;
            SecurityLogger.debugMessage(string, string2);
        }
        this.client_demarshalled_response(requestHolder);
    }

    private CurrentImpl current() {
        String string = "SecureAssociationInterceptorImpl.current";
        String string2 = null;
        if (this.current != null) {
            return this.current;
        }
        try {
            this.current = (CurrentImpl)this.orb.resolve_initial_references("SecurityCurrent");
            return this.current;
        }
        catch (InvalidName invalidName) {
            FFDCFilter.processException((Throwable)invalidName, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.current", (String)"677", (java.lang.Object)this);
            string2 = "security.JSAS0438E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string, invalidName});
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.current", (String)"685", (java.lang.Object)this);
            string2 = "security.JSAS0030E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string, exception});
            return null;
        }
    }

    public void handleAssocAcceptResponse(CDRInputMessage cDRInputMessage) {
        String string = "SecureAssociationInterceptorImpl.handleAssocAcceptResponse";
        String string2 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        SecurityContextImpl securityContextImpl = null;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "MsgType is ASSOC_ACCEPT ";
            SecurityLogger.debugMessage(string, string2);
        }
        try {
            securityContextImpl = (SecurityContextImpl)this.vault.get_security_context(cDRInputMessage.sessionID(), "C");
        }
        catch (SessionDoesNotExist sessionDoesNotExist) {
            FFDCFilter.processException((Throwable)sessionDoesNotExist, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.handleAssocAcceptResponse", (String)"725", (java.lang.Object)this);
            string2 = "Failed mutual authentication handshake.  Session does not exist in the session table.";
            SecurityLogger.debugMessage(string, string2);
            SecurityLogger.logException(string, (Exception)((java.lang.Object)sessionDoesNotExist), 0, 0);
            throw new NO_PERMISSION("Failed mutual authentication handshake.  Session does not exist in the session table.");
        }
        OpaqueHolder opaqueHolder = new OpaqueHolder();
        AssociationStatus associationStatus = AssociationStatus.SecAssocSuccess;
        associationStatus = securityContextImpl.continue_security_context(cDRInputMessage.sessionBytes(), opaqueHolder);
        if (associationStatus == AssociationStatus.SecAssocFailure) {
            string2 = "security.JSAS0070E";
            SecurityLogger.logError(string2, new java.lang.Object[]{string});
            throw new NO_PERMISSION("Failed mutual authentication handshake.  Unable to complete secure association at the client.");
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
    }

    public void handleAssocCompleteResponse() {
        String string = "SecureAssociationInterceptorImpl.handleAssocCompleteResponse";
        String string2 = null;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "MsgType is ASSOC_COMPLETE ";
            SecurityLogger.debugMessage(string, string2);
        }
    }

    public void handleAssocRejectResponse(CDRInputMessage cDRInputMessage) {
        String string = "SecureAssociationInterceptorImpl.handleAssocRejectResponse";
        String string2 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        java.lang.Object var4_4 = null;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "MsgType is ASSOC_REJECT ";
            SecurityLogger.debugMessage(string, string2);
        }
        string2 = "security.JSAS0200E";
        SecurityLogger.logError(string2, new java.lang.Object[]{string, cDRInputMessage.subMsg(), new Short(cDRInputMessage.errorCode()).toString()});
        int n = 0;
        RetryPanel retryPanel = null;
        JFrame jFrame = null;
        if (this.secConfig.authenticationRetryEnabled()) {
            if (this.secConfig.getloginSource() == 1) {
                jFrame = new JFrame();
                retryPanel = new RetryPanel(string2, jFrame);
                n = retryPanel.showPanel();
            } else {
                n = -99;
            }
        } else {
            n = -99;
        }
        Credentials credentials = null;
        try {
            credentials = (Credentials)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public java.lang.Object run() throws InvalidCredentialType {
                    Credentials credentials = SecureAssociationInterceptorImpl.this.current().get_credentials(CredentialType.SecInvocationCredentials, false, null);
                    if (credentials == null) {
                        credentials = SecureAssociationInterceptorImpl.this.current().get_credentials(CredentialType.SecOwnCredentials, false, null);
                    }
                    return credentials;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.handleAssocRejectResponse", (String)"902", (java.lang.Object)this);
            InvalidCredentialType invalidCredentialType = (InvalidCredentialType)((java.lang.Object)privilegedActionException.getException());
            SecurityLogger.logException(string, (Exception)((java.lang.Object)invalidCredentialType), 0, 0);
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Unable to get client credentials.";
                SecurityLogger.debugMessage(string, string2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.handleAssocRejectResponse", (String)"916", (java.lang.Object)this);
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Unable to get client credentials.";
                SecurityLogger.debugMessage(string, string2);
            }
            SecurityLogger.logException(string, exception, 0, 0);
        }
        CredentialsImpl credentialsImpl = null;
        if (credentials != null && credentials instanceof CredentialsImpl) {
            credentialsImpl = (CredentialsImpl)credentials;
        }
        if (n == 2) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Destroying client credentials, user will re-enter user id and password.";
                SecurityLogger.debugMessage(string, string2);
            }
            if (credentialsImpl != null) {
                if (!VaultImpl.isServerCred((Credentials)credentialsImpl)) {
                    credentialsImpl.destroy();
                }
            }
        }
        if (jFrame != null) {
            jFrame.dispose();
            jFrame = null;
        }
        if (n == -99) {
            if (cDRInputMessage.failedAuthn()) {
                string2 = "No RETRY is configured. NO_PERMISSION exception is raised.";
                SecurityLogger.debugMessage(string, string2);
                try {
                    this.current.set_credentials(CredentialType.SecInvocationCredentials, null);
                }
                catch (InvalidCredential invalidCredential) {
                    FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.handleAssocRejectResponse", (String)"955", (java.lang.Object)this);
                    SecurityLogger.logException(string, (Exception)((java.lang.Object)invalidCredential), 0, 0);
                }
                catch (InvalidCredentialType invalidCredentialType) {
                    FFDCFilter.processException((Throwable)invalidCredentialType, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.handleAssocRejectResponse", (String)"960", (java.lang.Object)this);
                    SecurityLogger.logException(string, (Exception)((java.lang.Object)invalidCredentialType), 0, 0);
                }
                if (SecurityLogger.debugEntryEnabled) {
                    SecurityLogger.debugExit(string);
                }
                throw new NO_PERMISSION(cDRInputMessage.subMsg());
            }
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string);
            }
            throw new INTERNAL(cDRInputMessage.subMsg());
        }
        retryPanel.dispose();
        retryPanel = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
    }

    public void handleAssocSourceErrorResponse(CDRInputMessage cDRInputMessage) {
        String string = "SecureAssociationInterceptorImpl.handleAssocSourceErrorResponse";
        String string2 = null;
        string2 = "security.JSAS0250E";
        SecurityLogger.logError(string2, new java.lang.Object[]{string, cDRInputMessage.subMsg(), new Short(cDRInputMessage.errorCode()).toString()});
        throw new NO_PERMISSION(string2);
    }

    public void server_demarshalled_request(RequestHolder requestHolder) throws SystemException {
        String string = "SecureAssociationInterceptorImpl.server_demarshalled_request";
        String string2 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "*** RECEIVING REQUEST ***";
            SecurityLogger.traceMessage(string, string2);
        }
        final CurrentImpl currentImpl = this.current();
        CDRInputMessage cDRInputMessage = new CDRInputMessage(requestHolder, false);
        if (!cDRInputMessage.secCtxFound()) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "No security context in RequestHolder.";
                SecurityLogger.debugMessage(string, string2);
            }
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "***** BEGIN PREINVOKE *****";
                SecurityLogger.debugMessage(string, string2);
            }
            if (SecurityLogger.debugEntryEnabled) {
                SecurityLogger.debugExit(string);
            }
            return;
        }
        SecurityContextImpl securityContextImpl = null;
        java.lang.Object var7_7 = null;
        Credentials[] credentialsArray = null;
        Credentials credentials = null;
        int n = 0;
        SessionEntryHolder sessionEntryHolder = new SessionEntryHolder();
        SessionEntry sessionEntry = null;
        switch (cDRInputMessage.msgType()) {
            case 6: {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "MsgType is ASSOC_COMPLETE ";
                    SecurityLogger.debugMessage(string, string2);
                }
                try {
                    securityContextImpl = (SecurityContextImpl)this.vault.get_security_context(cDRInputMessage.sessionID(), "S");
                }
                catch (SessionDoesNotExist sessionDoesNotExist) {
                    FFDCFilter.processException((Throwable)sessionDoesNotExist, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_demarshalled_request", (String)"1075", (java.lang.Object)this);
                    string2 = "Failed mutual authentication handshake.  Session does not exist in the session table.";
                    SecurityLogger.debugMessage(string, string2);
                    SecurityLogger.logException(string, (Exception)((java.lang.Object)sessionDoesNotExist), 0, 0);
                    throw new NO_PERMISSION("Failed mutual authentication handshake.  Session does not exist in the session table.");
                }
                securityContextImpl.setSecServiceID(cDRInputMessage.serviceContextID());
                n = securityContextImpl.getContextState();
                if (n == 2 || n == 3) {
                    securityContextImpl.setContextState(3);
                    credentialsArray = securityContextImpl.received_credentials();
                    Object object = requestHolder.proxy();
                    if (object != null) {
                        string2 = "Server invoking operation: " + object.getClass().getName() + "." + requestHolder.operation() + ", associated user credentials are: " + CredentialsHelper.getUserName((CredentialsImpl)credentialsArray[0]);
                        SecurityLogger.debugMessage(string, string2);
                    } else {
                        string2 = "Server invoking operation: " + requestHolder.operation() + ", associated user credentials are: " + CredentialsHelper.getUserName((CredentialsImpl)credentialsArray[0]);
                        SecurityLogger.debugMessage(string, string2);
                    }
                    if (credentialsArray == null) {
                        string2 = "security.JSAS0439E";
                        SecurityLogger.logError(string2, new java.lang.Object[]{string});
                        throw new NO_PERMISSION(string2);
                    }
                    try {
                        this.vault.get_session(securityContextImpl.get_session_handle(), sessionEntryHolder);
                        sessionEntry = sessionEntryHolder.value;
                        sessionEntry.target_seq_num = cDRInputMessage.seqNum();
                        this.vault.update_session(securityContextImpl.get_session_handle(), sessionEntry);
                    }
                    catch (SessionDoesNotExist sessionDoesNotExist) {
                        FFDCFilter.processException((Throwable)sessionDoesNotExist, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_demarshalled_request", (String)"1145", (java.lang.Object)this);
                        if (SecurityLogger.debugTraceEnabled) {
                            string2 = "Session was thought to exist but get_session failed.";
                            SecurityLogger.debugMessage(string, string2);
                        }
                        SecurityLogger.logException(string, (Exception)((java.lang.Object)sessionDoesNotExist), 0, 0);
                    }
                    if (currentImpl != null) {
                        currentImpl.initialize_requestor_context(credentialsArray);
                    }
                } else {
                    string2 = "security.JSAS0200E";
                    SecurityLogger.logError(string2, new java.lang.Object[]{string, ContextState.get_context_state_string(n)});
                    throw new INTERNAL();
                }
                try {
                    RequestHolder.serviceData.put(Integer.toString(requestHolder.requestInfo().request_id()), securityContextImpl);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_demarshalled_request", (String)"1181", (java.lang.Object)this);
                    string2 = "security.JSAS0443E";
                    SecurityLogger.logError(string2, new java.lang.Object[]{string, exception});
                    throw new INTERNAL();
                }
                if (!SecurityLogger.debugTraceEnabled) break;
                string2 = "***** BEGIN PREINVOKE *****";
                SecurityLogger.debugMessage(string, string2);
                break;
            }
            case 4: {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "MsgType is ASSOC_ACCEPT ";
                    SecurityLogger.debugMessage(string, string2);
                }
                string2 = "security.JSAS0441E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                throw new INTERNAL();
            }
            case 5: {
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "MsgType is ASSOC_REJECT ";
                    SecurityLogger.debugMessage(string, string2);
                }
                string2 = "security.JSAS0442E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string});
                throw new INTERNAL();
            }
            case 7: {
                string2 = "security.JSAS0250E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string, cDRInputMessage.subMsg(), new Short(cDRInputMessage.errorCode()).toString()});
                throw new NO_PERMISSION(string2);
            }
            case 2: {
                java.lang.Object object;
                credentials = null;
                Credentials[] credentialsArray2 = new Credentials[1];
                byte[] byArray = null;
                byte[] byArray2 = null;
                OpaqueHolder opaqueHolder = new OpaqueHolder();
                SecurityContextHolder securityContextHolder = new SecurityContextHolder();
                AssociationStatus associationStatus = null;
                try {
                    credentials = (Credentials)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public java.lang.Object run() throws InvalidCredentialType {
                            return SecureAssociationInterceptorImpl.this.current().get_credentials(CredentialType.SecOwnCredentials);
                        }
                    });
                    if (credentials == null) {
                        try {
                            credentials = (Credentials)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                                public java.lang.Object run() throws LoginFailed {
                                    return ((LoginHelperImpl)currentImpl.login_helper()).request_login_controlled(RealmSecurityName.getSecurityName(SecureAssociationInterceptorImpl.this.secConfig.getprincipalName()), RealmSecurityName.getRealm(SecureAssociationInterceptorImpl.this.secConfig.getprincipalName()), null, null, null, true, false);
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_demarshalled_request", (String)"1324", (java.lang.Object)this);
                            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0240E", "JSAS0240E: Login failed.  Verify the userid/password is correct.  Check the properties file to ensure the login source is valid.  If this error occurs on the server, check the server properties to ensure the principalName has a valid realm and userid.");
                            throw (LoginFailed)((java.lang.Object)privilegedActionException.getException());
                        }
                    }
                    if ((object = requestHolder.proxy()) != null) {
                        string2 = "Server invoking operation: " + object.getClass().getName() + "." + requestHolder.operation() + ", associated system credentials are: " + CredentialsHelper.getUserName((CredentialsImpl)credentials);
                        SecurityLogger.debugMessage(string, string2);
                    } else {
                        string2 = "Server invoking operation: " + requestHolder.operation() + ", associated system credentials are: " + CredentialsHelper.getUserName((CredentialsImpl)credentials);
                        SecurityLogger.debugMessage(string, string2);
                    }
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_demarshalled_request", (String)"1335", (java.lang.Object)this);
                    Exception exception = privilegedActionException.getException();
                    string2 = "security.JSAS0110E";
                    SecurityLogger.logError(string2, new java.lang.Object[]{string, exception});
                    throw new INTERNAL();
                }
                catch (LoginFailed loginFailed) {
                    FFDCFilter.processException((Throwable)loginFailed, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_demarshalled_request", (String)"1291", (java.lang.Object)this);
                    string2 = "security.JSAS0439E";
                    SecurityLogger.logError(string2, new java.lang.Object[]{string, loginFailed});
                }
                catch (NullPointerException nullPointerException) {
                    FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_demarshalled_request", (String)"1297", (java.lang.Object)this);
                    string2 = "security.JSAS0030E";
                    SecurityLogger.logError(string2, new java.lang.Object[]{string, nullPointerException});
                }
                credentialsArray2[0] = credentials;
                object = requestHolder.connectionData().getConnectionKey();
                CDROutputStream cDROutputStream = ORB.createCDROutputStream((ORB)this.orb);
                try {
                    cDROutputStream.write_string((String)object);
                    cDROutputStream.write_string(cDRInputMessage.sessionID());
                    cDROutputStream.write_string(cDRInputMessage.hostName());
                }
                catch (DATA_CONVERSION dATA_CONVERSION) {
                    FFDCFilter.processException((Throwable)dATA_CONVERSION, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_demarshalled_request", (String)"1319", (java.lang.Object)this);
                    string2 = "security.JSAS0027E";
                    SecurityLogger.logError(string2, new java.lang.Object[]{string, dATA_CONVERSION});
                    throw dATA_CONVERSION;
                }
                cDROutputStream.write_short((short)0);
                try {
                    cDROutputStream.write_string(cDRInputMessage.mechType());
                }
                catch (DATA_CONVERSION dATA_CONVERSION) {
                    FFDCFilter.processException((Throwable)dATA_CONVERSION, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_demarshalled_request", (String)"1342", (java.lang.Object)this);
                    string2 = "security.JSAS0027E";
                    SecurityLogger.logError(string2, new java.lang.Object[]{string, dATA_CONVERSION});
                    throw dATA_CONVERSION;
                }
                byArray = cDROutputStream.toByteArray();
                CDROutputStream cDROutputStream2 = ORB.createCDROutputStream((ORB)this.orb);
                try {
                    cDROutputStream2.write_string(cDRInputMessage.secName());
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "securityName: " + cDRInputMessage.secName();
                        SecurityLogger.debugMessage(string, string2);
                    }
                }
                catch (DATA_CONVERSION dATA_CONVERSION) {
                    FFDCFilter.processException((Throwable)dATA_CONVERSION, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_demarshalled_request", (String)"1368", (java.lang.Object)this);
                    string2 = "security.JSAS0027E";
                    SecurityLogger.logError(string2, new java.lang.Object[]{string, dATA_CONVERSION});
                    throw dATA_CONVERSION;
                }
                if (cDRInputMessage.mechType().equals(VaultConstants.LOCAL_OS_MECH_TYPE)) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "Checking LocalOS Boundary - Target Host: " + cDRInputMessage.hostName() + ", Client Host: " + cDRInputMessage.clientHostName();
                        SecurityLogger.debugMessage(string, string2);
                    }
                    if (!cDRInputMessage.hostName().startsWith(cDRInputMessage.clientHostName())) {
                        string2 = "security.JSAS0241E";
                        SecurityLogger.logError(string2, new java.lang.Object[]{string});
                        throw new NO_PERMISSION(string2);
                    }
                    try {
                        byte[] byArray3 = cDRInputMessage.accessID();
                        if (byArray3 == null) {
                            byArray3 = new byte[]{};
                        }
                        cDROutputStream2.write_ulong(byArray3.length);
                        cDROutputStream2.write_octet_array(byArray3, 0, byArray3.length);
                        byte[] byArray4 = cDRInputMessage.primaryGroupID();
                        if (byArray4 == null) {
                            byArray4 = new byte[]{};
                        }
                        cDROutputStream2.write_ulong(byArray4.length);
                        cDROutputStream2.write_octet_array(byArray4, 0, byArray4.length);
                        byte[] byArray5 = cDRInputMessage.groupIDBytes();
                        if (byArray5 == null) {
                            byArray5 = new byte[]{};
                        }
                        cDROutputStream2.write_ulong(byArray5.length);
                        cDROutputStream2.write_octet_array(byArray5, 0, byArray5.length);
                        cDROutputStream2.write_string(cDRInputMessage.role());
                        cDROutputStream2.write_string(cDRInputMessage.clientHostName());
                        byArray2 = cDROutputStream2.toByteArray();
                    }
                    catch (DATA_CONVERSION dATA_CONVERSION) {
                        FFDCFilter.processException((Throwable)dATA_CONVERSION, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_demarshalled_request", (String)"1428", (java.lang.Object)this);
                        string2 = "security.JSAS0027E";
                        SecurityLogger.logError(string2, new java.lang.Object[]{string, dATA_CONVERSION});
                        throw dATA_CONVERSION;
                    }
                } else {
                    cDROutputStream2.write_long(cDRInputMessage.credToken().length);
                    cDROutputStream2.write_octet_array(cDRInputMessage.credToken(), 0, cDRInputMessage.credToken().length);
                    byArray2 = cDROutputStream2.toByteArray();
                }
                try {
                    associationStatus = this.vault.accept_security_context(credentialsArray2, byArray, byArray2, opaqueHolder, securityContextHolder);
                }
                catch (InvalidCredential invalidCredential) {
                    FFDCFilter.processException((Throwable)invalidCredential, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_demarshalled_request", (String)"1455", (java.lang.Object)this);
                    string2 = "security.JSAS0435E";
                    SecurityLogger.logError(string2, new java.lang.Object[]{string, invalidCredential});
                }
                catch (InvalidToken invalidToken) {
                    FFDCFilter.processException((Throwable)invalidToken, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_demarshalled_request", (String)"1461", (java.lang.Object)this);
                    string2 = "security.JSAS0052E";
                    SecurityLogger.logError(string2, new java.lang.Object[]{string, invalidToken});
                }
                securityContextImpl = (SecurityContextImpl)securityContextHolder.value;
                if (securityContextImpl != null) {
                    securityContextImpl.setSecServiceID(cDRInputMessage.serviceContextID());
                }
                if (associationStatus == AssociationStatus.SecAssocSuccess) {
                    credentialsArray = securityContextImpl.received_credentials();
                    if (credentialsArray == null) {
                        string2 = "security.JSAS0439E";
                        SecurityLogger.logError(string2, new java.lang.Object[]{string});
                        throw new NO_PERMISSION(string2);
                    }
                    currentImpl.initialize_requestor_context(credentialsArray);
                } else if (associationStatus == AssociationStatus.SecAssocContinue) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "accept_security_context returned AssociationStatus == Continue";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    currentImpl.initialize_requestor_context(null);
                } else {
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "accept_security_context returned AssociationStatus == Failure";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    currentImpl.initialize_requestor_context(null);
                }
                try {
                    if (securityContextImpl != null) {
                        RequestHolder.serviceData.put(Integer.toString(requestHolder.requestInfo().request_id()), securityContextImpl);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_demarshalled_request", (String)"1521", (java.lang.Object)this);
                    string2 = "security.JSAS0443E";
                    SecurityLogger.logError(string2, new java.lang.Object[]{string, exception});
                    throw new INTERNAL();
                }
                if (!SecurityLogger.debugTraceEnabled) break;
                string2 = "***** BEGIN PREINVOKE *****";
                SecurityLogger.debugMessage(string, string2);
                break;
            }
            default: {
                string2 = "security.JSAS0300E";
                SecurityLogger.logError(string2, new java.lang.Object[]{string, cDRInputMessage.subMsg(), new Short(cDRInputMessage.errorCode()).toString()});
                throw new NO_PERMISSION(string2);
            }
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
    }

    public void server_system_exception(RequestHolder requestHolder, ServerFlow serverFlow) {
        String string = "SecureAssociationInterceptorImpl.server_system_exception";
        String string2 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        try {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "server_system_exception invoked on operation " + requestHolder.operation();
                SecurityLogger.debugMessage(string, string2);
            }
            RequestHolder.serviceData.remove(Integer.toString(requestHolder.requestInfo().request_id()));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_system_exception", (String)"1577", (java.lang.Object)this);
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0208E", "JSAS0208E: Internal error: system exception.  Take down all the error information and contact support for more assistance.");
            SecurityLogger.debugMessage(string, string2);
            if (SecurityLogger.traceEnabled) {
                SecurityLogger.traceException(string, throwable, 0, 0);
            }
            throw new INTERNAL("Unexpected Java Exception: " + throwable.toString());
        }
        if (SecurityLogger.traceEnabled) {
            string2 = "*** SENDING EXCEPTION ***";
            SecurityLogger.traceMessage(string, string2);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
    }

    public void send_other(RequestHolder requestHolder) {
        String string = "SecureAssociationInterceptorImpl.send_other";
        String string2 = null;
        try {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "send_other invoked on operation " + requestHolder.operation() + " with request holder " + requestHolder + " on ORB " + this.orb;
                SecurityLogger.debugMessage(string, string2);
            }
            RequestHolder.serviceData.remove(Integer.toString(requestHolder.requestInfo().request_id()));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.send_other", (String)"1625", (java.lang.Object)this);
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0208E", "JSAS0208E: Internal error: system exception.  Take down all the error information and contact support for more assistance.");
            SecurityLogger.debugMessage(string, string2);
            if (SecurityLogger.traceEnabled) {
                SecurityLogger.traceException(string, throwable, 0, 0);
            }
            throw new INTERNAL("Unexpected Java Exception: " + throwable.toString());
        }
        if (SecurityLogger.traceEnabled) {
            string2 = "*** SENDING OTHER ***";
            SecurityLogger.traceMessage(string, string2);
        }
    }

    public void server_unmarshalled_response(RequestHolder requestHolder) throws SystemException {
        String string = "SecureAssociationInterceptorImpl.server_unmarshalled_response";
        String string2 = null;
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string);
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "***** END POSTINVOKE *****";
            SecurityLogger.debugMessage(string, string2);
        }
        java.lang.Object var4_4 = null;
        SecurityContextImpl securityContextImpl = null;
        try {
            securityContextImpl = (SecurityContextImpl)((java.lang.Object)RequestHolder.serviceData.get(Integer.toString(requestHolder.requestInfo().request_id())));
            if (securityContextImpl != null) {
                RequestHolder.serviceData.remove(Integer.toString(requestHolder.requestInfo().request_id()));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_unmarshalled_response", (String)"1679", (java.lang.Object)this);
        }
        if (securityContextImpl == null) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "No security context, communication to client will be insecure.";
                SecurityLogger.debugMessage(string, string2);
            }
        } else {
            OrbRequestHolderImpl orbRequestHolderImpl = new OrbRequestHolderImpl();
            orbRequestHolderImpl.setRequestHolder(requestHolder);
            OpaqueHolder opaqueHolder = new OpaqueHolder();
            OpaqueHolder opaqueHolder2 = new OpaqueHolder();
            QOP qOP = null;
            boolean bl = securityContextImpl.preprotect_message((_OrbRequestHolder)orbRequestHolderImpl, qOP, opaqueHolder2, opaqueHolder);
            if (!bl) {
                string2 = "security.JSAS0060W";
                SecurityLogger.logWarning(string2, new java.lang.Object[]{string});
            }
            this.current().clear_requestor_context();
        }
        if (SecurityLogger.traceEnabled) {
            string2 = "*** SENDING REPLY ***";
            SecurityLogger.traceMessage(string, string2);
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string);
        }
    }

    public void server_user_exception(RequestHolder requestHolder) {
        String string = "SecureAssociationInterceptorImpl.server_user_exception";
        String string2 = null;
        try {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "server_user_exception invoked on operation " + requestHolder.operation();
                SecurityLogger.debugMessage(string, string2);
            }
            RequestHolder.serviceData.remove(Integer.toString(requestHolder.requestInfo().request_id()));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecureAssociationInterceptorImpl.server_user_exception", (String)"1763", (java.lang.Object)this);
            string2 = SecurityMessages.getMsgOrUseDefault("JSAS0208E", "JSAS0208E: Internal error: system exception.  Take down all the error information and contact support for more assistance.");
            SecurityLogger.debugMessage(string, string2);
            if (SecurityLogger.traceEnabled) {
                SecurityLogger.traceException(string, throwable, 0, 0);
            }
            throw new INTERNAL("Unexpected Java Exception: " + throwable.toString());
        }
        if (SecurityLogger.traceEnabled) {
            string2 = "*** SENDING EXCEPTION ***";
            SecurityLogger.traceMessage(string, string2);
        }
    }

    boolean getLocalConnectionKey(RequestHolder requestHolder) {
        ConnectionDataCarrier connectionDataCarrier = new ConnectionDataCarrier();
        return true;
    }
}

