/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.UpdateClusterScheduler;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class UpdateClusterTask
extends AbstractTask
implements NotificationListener {
    private static TraceComponent tc = Tr.register((Class)UpdateClusterTask.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private String waitObject = null;
    private String waitTarget = null;
    private static final long WAIT_TIME = 600000L;
    private String waitResult = null;
    private boolean waitStarting = false;
    private int launchTimeout;
    private Map autoSyncMap = new HashMap();

    public UpdateClusterTask() {
        this.waitObject = new String("UpdateClusterTaskWaitObject");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performTask() throws AdminException {
        Iterator iterator;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performTask");
        }
        boolean bl = true;
        try {
            try {
                Object object;
                RepositoryContext repositoryContext;
                Vector vector = this.getTargetServers(((UpdateClusterScheduler)this.scheduler).getAppNames());
                if (vector.size() <= 0) {
                    bl = false;
                    this.sendNotification("ADMA8021I", "InProgress", this.scheduler.getAppName());
                    throw new AdminException("Target server for a given list of applications is not found");
                }
                Hashtable hashtable = ConfigRepoHelper.getNodeServerRelation(this.scheduler.getWorkSpace(), vector);
                Enumeration enumeration = hashtable.keys();
                Set set = hashtable.keySet();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    repositoryContext = (RepositoryContext)iterator2.next();
                    object = this.getAutoSyncEnabled(repositoryContext.getName());
                    if (object != null && Boolean.TRUE.equals(object)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Disabling Sync for Node: " + repositoryContext.getName()));
                        }
                        this.setAutoSyncEnabled(repositoryContext.getName(), Boolean.FALSE);
                    }
                    this.autoSyncMap.put(repositoryContext.getName(), object);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("performing cluster update" + hashtable));
                }
                while (enumeration.hasMoreElements()) {
                    String string;
                    int n;
                    repositoryContext = (RepositoryContext)enumeration.nextElement();
                    object = repositoryContext.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Node Name: " + (String)object));
                    }
                    Hashtable hashtable2 = this.getServerTypes(repositoryContext);
                    boolean bl2 = this.zosPauseResume(repositoryContext);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("For node " + (String)object + ", zosPauseNodes = " + bl2));
                    }
                    Vector vector2 = (Vector)hashtable.get(repositoryContext);
                    Vector vector3 = new Vector(vector2);
                    for (n = 0; n < vector2.size(); ++n) {
                        String string2;
                        string = ((RepositoryContext)vector2.elementAt(n)).getName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("stopping " + string));
                        }
                        if ((string2 = (String)hashtable2.get(string)) != null && string2.equals("APPLICATION_SERVER")) {
                            this.setClusterMemberEnabled((RepositoryContext)vector2.elementAt(n), repositoryContext, Boolean.FALSE);
                            if (bl2) {
                                this.sendNotification("ADMA8022I", "ServerStopping", string);
                                if (this.pauseServer((RepositoryContext)vector2.elementAt(n), repositoryContext.getName(), string)) {
                                    this.sendNotification("ADMA8023I", "ServerStopped", string);
                                    continue;
                                }
                                this.sendNotification("ADMA8026I", "ServerStopFailed", string);
                                vector3.remove(vector2.elementAt(n));
                                continue;
                            }
                            this.sendNotification("ADMA8003I", "ServerStopping", string);
                            if (this.stopServer(repositoryContext.getName(), string)) {
                                this.sendNotification("ADMA8004I", "ServerStopped", string);
                                continue;
                            }
                            this.sendNotification("ADMA8009I", "ServerStopFailed", string);
                            vector3.remove(vector2.elementAt(n));
                            continue;
                        }
                        Tr.audit((TraceComponent)tc, (String)("Server " + string + " is not an Application Server. This server will not be restarted during application ripple of application" + this.scheduler.getAppName() + "."));
                        vector3.remove(vector2.elementAt(n));
                    }
                    if (bl2) {
                        Thread.sleep(10000L);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("syncing  " + repositoryContext.getName()));
                    }
                    this.sendNotification("ADMA8005I", "NodeSyncInitiated", repositoryContext.getName());
                    if (this.synchNode(repositoryContext.getName())) {
                        this.sendNotification("ADMA8006I", "NodeSyncComplete", repositoryContext.getName());
                    } else {
                        this.sendNotification("ADMA8011I", "NodeSyncFailed", repositoryContext.getName());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("synced  " + repositoryContext.getName()));
                    }
                    this.establishLaunchTimeout();
                    for (n = 0; n < vector3.size(); ++n) {
                        string = ((RepositoryContext)vector3.elementAt(n)).getName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("starting " + string));
                        }
                        if (bl2) {
                            this.sendNotification("ADMA8024I", "ServerStarting", string);
                            if (this.resumeServer((RepositoryContext)vector3.elementAt(n), repositoryContext.getName(), string)) {
                                this.sendNotification("ADMA8025I", "ServerStarted", string);
                                this.setClusterMemberEnabled((RepositoryContext)vector3.elementAt(n), repositoryContext, Boolean.TRUE);
                                continue;
                            }
                            bl = false;
                            this.sendNotification("ADMA8027I", "ServerStartFailed", string);
                            continue;
                        }
                        this.sendNotification("ADMA8007I", "ServerStarting", string);
                        if (this.startServer(repositoryContext.getName(), string)) {
                            this.sendNotification("ADMA8008I", "ServerStarted", string);
                            if (!this.applicationsStarted(repositoryContext.getName(), string)) {
                                this.sendNotification("ADMA8020I", "InProgress", string);
                            }
                            this.setClusterMemberEnabled((RepositoryContext)vector3.elementAt(n), repositoryContext, Boolean.TRUE);
                            continue;
                        }
                        bl = false;
                        this.sendNotification("ADMA8010I", "ServerStartFailed", string);
                    }
                    n = 60;
                    try {
                        string = System.getProperty("com.ibm.ws.management.application.clusterupdate.nodedelay");
                        if (string != null) {
                            n = Integer.parseInt(string);
                        }
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)" invalid delay specified, using default delay of 60 secs");
                        }
                        n = 60;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("waiting for " + new Integer(n) + " secs before rippling the next node"));
                    }
                    if (n > 0) {
                        Thread.sleep(n * 1000);
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"done wait. Started ripple of next node");
                }
                Object var17_19 = null;
                Set set2 = this.autoSyncMap.entrySet();
                iterator = set2.iterator();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Cluster Update of cluster failed for applicaiton " + this.scheduler.getAppName()));
                }
                Tr.info((TraceComponent)tc, (String)AppUtils.getMessage(this.getResourceBundle(), "ADMA8014I", new String[]{this.scheduler.getAppName()}));
                Tr.error((TraceComponent)tc, (String)"ADMA8015I", (Object)new Object[]{this.scheduler.getAppName(), exception});
                boolean bl5 = bl = false;
                Object var17_20 = null;
                Set set = this.autoSyncMap.entrySet();
                Iterator iterator4 = set.iterator();
                while (true) {
                    Boolean bl6;
                    if (!iterator4.hasNext()) {
                        return bl5;
                    }
                    Map.Entry entry = iterator4.next();
                    if (entry == null || entry.getValue() == null || !(entry.getValue() instanceof Boolean) || (bl6 = (Boolean)entry.getValue()) == null || !Boolean.TRUE.equals(bl6)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Re-enabling Sync for Node: " + (String)entry.getKey()));
                    }
                    this.setAutoSyncEnabled((String)entry.getKey(), bl6);
                }
            }
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            Set set = this.autoSyncMap.entrySet();
            Iterator iterator3 = set.iterator();
            while (true) {
                Boolean bl3;
                if (!iterator3.hasNext()) {
                    throw throwable;
                }
                Map.Entry entry = iterator3.next();
                if (entry == null || entry.getValue() == null || !(entry.getValue() instanceof Boolean) || (bl3 = (Boolean)entry.getValue()) == null || !Boolean.TRUE.equals(bl3)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Re-enabling Sync for Node: " + (String)entry.getKey()));
                }
                this.setAutoSyncEnabled((String)entry.getKey(), bl3);
            }
        }
        while (iterator.hasNext()) {
            Boolean bl4;
            Map.Entry entry = iterator.next();
            if (entry == null || entry.getValue() == null || !(entry.getValue() instanceof Boolean) || (bl4 = (Boolean)entry.getValue()) == null || !Boolean.TRUE.equals(bl4)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Re-enabling Sync for Node: " + (String)entry.getKey()));
            }
            this.setAutoSyncEnabled((String)entry.getKey(), bl4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performTask");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClusterMemberEnabled(RepositoryContext repositoryContext, RepositoryContext repositoryContext2, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setClusterMemberEnabled", (Object)new Object[]{repositoryContext, repositoryContext2, bl});
        }
        URI uRI = URI.createURI((String)"server.xml");
        Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
        Server server = (Server)resource.getContents().get(0);
        String string = server.getClusterName();
        String string2 = repositoryContext.getName();
        String string3 = repositoryContext2.getName();
        ObjectName objectName = this.getClusterObjectName(string);
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ClusterMbean", (Object)new Object[]{objectName});
        }
        if (objectName != null) {
            try {
                String string4 = this.waitObject;
                synchronized (string4) {
                    if (Boolean.TRUE.equals(bl)) {
                        AdminServiceFactory.getAdminService().invoke(objectName, "setAvailable", new Object[]{string2, string3}, new String[]{"java.lang.String", "java.lang.String"});
                    } else {
                        AdminServiceFactory.getAdminService().invoke(objectName, "setUnavailable", new Object[]{string2, string3}, new String[]{"java.lang.String", "java.lang.String"});
                    }
                }
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)"ADMA8015I", (Object)new Object[]{this.scheduler.getAppName(), exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setClusterMemberEnabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean getAutoSyncEnabled(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAutoSyncEnabled", (Object)new Object[]{string});
        }
        Boolean bl = null;
        ObjectName objectName = this.getNodesyncObjectName(string);
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"NodeSyncMbean", (Object)new Object[]{objectName});
        }
        if (objectName != null) {
            try {
                String string2 = this.waitObject;
                synchronized (string2) {
                    bl = (Boolean)AdminServiceFactory.getAdminService().invoke(objectName, "getAutoSyncEnabled", new Object[0], new String[0]);
                }
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)"ADMA8015I", (Object)new Object[]{this.scheduler.getAppName(), exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAutoSyncEnabled", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean setAutoSyncEnabled(String string, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setAutoSyncEnabled", (Object)new Object[]{string, bl});
        }
        Boolean bl2 = null;
        ObjectName objectName = this.getNodesyncObjectName(string);
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"NodeSyncMbean", (Object)new Object[]{objectName});
        }
        if (objectName != null) {
            try {
                String string2 = this.waitObject;
                synchronized (string2) {
                    AdminServiceFactory.getAdminService().invoke(objectName, "setAutoSyncEnabled", new Object[]{bl}, new String[]{Boolean.class.getName()});
                }
                bl2 = Boolean.TRUE;
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)"ADMA8015I", (Object)new Object[]{this.scheduler.getAppName(), exception});
                bl2 = Boolean.FALSE;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAutoSyncEnabled", (Object)new Object[]{bl});
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean stopServer(String string, String string2) {
        boolean bl;
        block18: {
            bl = true;
            ObjectName objectName = this.getNodeagentObjectName(string);
            ObjectName objectName2 = this.getServerObjectName(string, string2);
            String string3 = "UpdateCluster:" + string + ":" + string2;
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("websphere.process.stopped");
            notificationFilterSupport.enableType("websphere.process.failed");
            notificationFilterSupport.enableType("websphere.process.starting");
            notificationFilterSupport.enableType("websphere.process.stopping");
            notificationFilterSupport.enableType("websphere.process.running");
            AdminServiceFactory.getAdminService().addNotificationListener(objectName, this, notificationFilterSupport, string3);
            String string4 = this.waitObject;
            synchronized (string4) {
                AdminServiceFactory.getAdminService().invoke(objectName2, "stop", new Object[0], new String[0]);
                this.waitTarget = string2;
                this.waitObject.wait(600000L);
                if (this.waitTarget != null) {
                    Tr.info((TraceComponent)tc, (String)AppUtils.getMessage(this.getResourceBundle(), "ADMA8009I", new String[]{string2}));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"timed out waiting for server to stop ", (Object)new String[]{string2});
                    }
                    bl = false;
                }
            }
            Object var11_11 = null;
            try {
                if (objectName != null) {
                    AdminServiceFactory.getAdminService().removeNotificationListener(objectName, this);
                }
                break block18;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to remove notification listener");
                }
                break block18;
            }
            {
                catch (Exception exception) {
                    Tr.info((TraceComponent)tc, (String)AppUtils.getMessage(this.getResourceBundle(), "ADMA8009I", new String[]{string2}));
                    bl = false;
                    Object var11_12 = null;
                    try {
                        if (objectName != null) {
                            AdminServiceFactory.getAdminService().removeNotificationListener(objectName, this);
                        }
                        break block18;
                    }
                    catch (Exception exception2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Failed to remove notification listener");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block19: {
                    Object var11_13 = null;
                    try {
                        if (objectName != null) {
                            AdminServiceFactory.getAdminService().removeNotificationListener(objectName, this);
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block19;
                        Tr.debug((TraceComponent)tc, (String)"Failed to remove notification listener");
                    }
                }
                throw throwable;
            }
        }
        Tr.info((TraceComponent)tc, (String)AppUtils.getMessage(this.getResourceBundle(), "ADMA8004I", new String[]{string2}));
        return bl;
    }

    private boolean pauseServer(RepositoryContext repositoryContext, String string, String string2) {
        boolean bl;
        block6: {
            bl = false;
            URI uRI = URI.createURI((String)"server.xml");
            Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
            Server server = (Server)resource.getContents().get(0);
            String string3 = "MODIFY " + server.getShortName() + ",PAUSELISTENERS";
            ObjectName objectName = this.getMVSServericesObjectName(string);
            if (objectName != null) {
                try {
                    AdminServiceFactory.getAdminService().invoke(objectName, "issueCommand", new Object[]{string3}, new String[]{String.class.getName()});
                    bl = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("pauseServer() successfull for node:server " + string + ":" + string2));
                    }
                    break block6;
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"pauseServer() Exception invoking MVSServices MBean ");
                        exception.printStackTrace();
                    }
                    break block6;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"pauseServer() could not find MVSServices MBean ");
            }
        }
        return bl;
    }

    private boolean resumeServer(RepositoryContext repositoryContext, String string, String string2) {
        boolean bl;
        block6: {
            bl = false;
            URI uRI = URI.createURI((String)"server.xml");
            Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
            Server server = (Server)resource.getContents().get(0);
            String string3 = "MODIFY " + server.getShortName() + ",RESUMELISTENERS";
            ObjectName objectName = this.getMVSServericesObjectName(string);
            if (objectName != null) {
                try {
                    AdminServiceFactory.getAdminService().invoke(objectName, "issueCommand", new Object[]{string3}, new String[]{String.class.getName()});
                    bl = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("resumeServer() successfull for node:server " + string + ":" + string2));
                    }
                    break block6;
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"resumeServer() Exception invoking MVSServices MBean ");
                        exception.printStackTrace();
                    }
                    break block6;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"resumeServer() could not find MVSServices MBean ");
            }
        }
        return bl;
    }

    private boolean zosPauseResume(RepositoryContext repositoryContext) {
        boolean bl;
        block21: {
            Object object;
            String string;
            Object object2;
            EList eList;
            Collection collection;
            RepositoryContextType repositoryContextType;
            Server server;
            block20: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"zosPauseResume");
                }
                bl = false;
                server = null;
                try {
                    repositoryContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("servers");
                    collection = repositoryContext.findContext(repositoryContextType);
                    eList = collection.iterator();
                    while (eList.hasNext()) {
                        object2 = (RepositoryContext)eList.next();
                        string = object2.getName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Found Repository Context for " + string));
                        }
                        if (string == null || !string.equalsIgnoreCase("nodeagent")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"NodeAgent Server Repository Context found");
                        }
                        object = object2.getResourceSet();
                        Resource resource = null;
                        Object var11_13 = null;
                        String string2 = "server.xml";
                        try {
                            if (!object2.isExtracted(string2)) {
                                object2.extract(string2, false);
                            }
                            resource = object.createResource(URI.createURI((String)string2));
                            resource.load(new HashMap());
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)"Exception loading NodeAgent server.xml");
                            exception.printStackTrace();
                            continue;
                        }
                        EList eList2 = resource.getContents();
                        Iterator iterator = eList2.iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            if (!(e instanceof Server)) continue;
                            server = (Server)e;
                            break;
                        }
                        if (server == null) continue;
                        break;
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug((TraceComponent)tc, (String)"Exception finding NodeAgent Server object");
                    exception.printStackTrace();
                }
            }
            if (server == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to find NodeAgent server.xml");
                }
            } else {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Found Server object in the NodeAgent server.xml file");
                    }
                    repositoryContextType = null;
                    collection = null;
                    eList = server.getServices();
                    object2 = eList.iterator();
                    while (object2.hasNext()) {
                        repositoryContextType = (Service)object2.next();
                        if (!(repositoryContextType instanceof AdminService)) continue;
                        collection = repositoryContextType.getProperties();
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)("Found AdminService properties " + collection));
                        break;
                    }
                    object2 = collection.iterator();
                    while (object2.hasNext()) {
                        string = (Property)object2.next();
                        object = string.getName();
                        if (!"com.ibm.websphere.zos.rollout.pauseresume".equals(object) || !"true".equalsIgnoreCase(string.getValue())) continue;
                        bl = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Pause/Resume enabled");
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug((TraceComponent)tc, (String)"Exception finding Pause/Resume property");
                    exception.printStackTrace();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"zosPauseResume");
        }
        return bl;
    }

    private ObjectName getMVSServericesObjectName(String string) {
        try {
            String string2 = "WebSphere:type=MVSServices,node=" + string + ",*";
            ObjectName objectName = new ObjectName(string2);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ObjectName objectName2 = (ObjectName)iterator.next();
            return objectName2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting MVSServices object");
                exception.printStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean startServer(String string, String string2) {
        boolean bl;
        block35: {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("UpdateClusterTask.startServer node: " + string + " Server: " + string2));
            }
            ObjectName objectName = this.getNodeagentObjectName(string);
            com.ibm.websphere.management.AdminService adminService = AdminServiceFactory.getAdminService();
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("websphere.process.running");
            notificationFilterSupport.enableType("websphere.process.failed");
            notificationFilterSupport.enableType("websphere.process.starting");
            String string3 = "UpdateCluster:" + string + ":" + string2;
            try {
                this.waitResult = null;
                this.waitTarget = string2;
                this.waitStarting = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("startServer adds listener & launches thread... " + string3));
                }
                adminService.addNotificationListener(objectName, this, notificationFilterSupport, string3);
                LaunchThread launchThread = new LaunchThread(string, string2, this.launchTimeout);
                launchThread.setDaemon(true);
                launchThread.start();
            }
            catch (Exception exception) {
                block34: {
                    Tr.info((TraceComponent)tc, (String)AppUtils.getMessage(this.getResourceBundle(), "ADMA8010I", new String[]{string2}));
                    try {
                        if (objectName != null) {
                            adminService.removeNotificationListener(objectName, this);
                        }
                    }
                    catch (Exception exception2) {
                        if (!tc.isDebugEnabled()) break block34;
                        Tr.debug((TraceComponent)tc, (String)"Failed to remove notification listener");
                    }
                }
                return false;
            }
            bl = false;
            String string4 = this.waitObject;
            synchronized (string4) {
                if (!this.waitStarting) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Wait for STARTING status first....");
                    }
                    this.waitObject.wait();
                }
                if (this.waitResult == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Waiting for server to complete START: ", (Object)new String[]{string2});
                    }
                    this.waitObject.wait(this.launchTimeout * 1000);
                    if (this.waitTarget != null) {
                        this.waitResult = "LaunchProcess timeout occurred.";
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"timed out waiting for server to start ", (Object)new String[]{string2});
                        }
                    }
                }
            }
            Object var11_14 = null;
            try {
                if (objectName != null) {
                    adminService.removeNotificationListener(objectName, this);
                }
                break block35;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to remove notification listener");
                }
                break block35;
            }
            {
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception while launchThread was waiting" + exception));
                    }
                    this.waitResult = "Exception occurred while launchThread was waiting.";
                    exception.printStackTrace();
                    Object var11_15 = null;
                    try {
                        if (objectName != null) {
                            adminService.removeNotificationListener(objectName, this);
                        }
                        break block35;
                    }
                    catch (Exception exception3) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Failed to remove notification listener");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block36: {
                    Object var11_16 = null;
                    try {
                        if (objectName != null) {
                            adminService.removeNotificationListener(objectName, this);
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block36;
                        Tr.debug((TraceComponent)tc, (String)"Failed to remove notification listener");
                    }
                }
                throw throwable;
            }
        }
        if (this.waitResult != null) {
            if (this.waitResult.equals("websphere.process.running")) {
                bl = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("launchProcess result: " + this.waitResult));
            }
        }
        if (bl) {
            Tr.info((TraceComponent)tc, (String)AppUtils.getMessage(this.getResourceBundle(), "ADMA8008I", new String[]{string2}));
        }
        return bl;
    }

    private boolean applicationsStarted(String string, String string2) {
        if (this.scheduler instanceof UpdateClusterScheduler) {
            String[] stringArray = ((UpdateClusterScheduler)this.scheduler).getAppNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.appStarted(string, string2, stringArray[i])) continue;
                return false;
            }
            return true;
        }
        return this.appStarted(string, string2, this.scheduler.getAppName());
    }

    private boolean appStarted(String string, String string2, String string3) {
        String string4 = "WebSphere:type=Application,node=" + string + ",process=" + string2 + ",name=" + string3 + ",*";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appStarted: query = " + string4));
        }
        try {
            ObjectName objectName = new ObjectName(string4);
            int n = 120000;
            for (int i = 10000; i <= n; i += 10000) {
                if (AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator().hasNext()) {
                    return true;
                }
                Thread.sleep(i);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.application.task.UpdateClusterTask.appStarted", (String)"402", (Object)this);
        }
        return false;
    }

    private boolean synchNode(String string) {
        try {
            ObjectName objectName = this.getNodesyncObjectName(string);
            AdminServiceFactory.getAdminService().invoke(objectName, "sync", null, null);
        }
        catch (Exception exception) {
            Tr.info((TraceComponent)tc, (String)AppUtils.getMessage(this.getResourceBundle(), "ADMA8011I", new String[]{string}));
            return false;
        }
        Tr.info((TraceComponent)tc, (String)AppUtils.getMessage(this.getResourceBundle(), "ADMA8006I", new String[]{string, this.scheduler.getAppName()}));
        return true;
    }

    private ObjectName getServerObjectName(String string, String string2) {
        String string3 = "WebSphere:type=Server,node=" + string + ",process=" + string2 + ",*";
        try {
            ObjectName objectName = new ObjectName(string3);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ObjectName objectName2 = (ObjectName)iterator.next();
            return objectName2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception is " + exception));
            }
            return null;
        }
    }

    private ObjectName getNodeagentObjectName(String string) {
        try {
            String string2 = "WebSphere:type=NodeAgent,node=" + string + ",*";
            ObjectName objectName = new ObjectName(string2);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ObjectName objectName2 = (ObjectName)iterator.next();
            return objectName2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception is " + exception));
            }
            return null;
        }
    }

    private ObjectName getClusterObjectName(String string) {
        try {
            String string2 = "WebSphere:type=Cluster,name=" + string + ",*";
            ObjectName objectName = new ObjectName(string2);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ObjectName objectName2 = (ObjectName)iterator.next();
            return objectName2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception is " + exception));
            }
            return null;
        }
    }

    private ObjectName getNodesyncObjectName(String string) {
        try {
            String string2 = "WebSphere:type=NodeSync,node=" + string + ",*";
            ObjectName objectName = new ObjectName(string2);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ObjectName objectName2 = (ObjectName)iterator.next();
            return objectName2;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception is " + exception));
            }
            return null;
        }
    }

    private void sendNotification(String string, String string2, String string3) {
        AppNotification appNotification = this.createNotification(string2, string, new String[]{string3, this.scheduler.getAppName()});
        this.scheduler.propagateTaskEvent(appNotification);
    }

    private Vector getTargetServers(String[] stringArray) throws Exception {
        Vector vector = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(string, this.scheduler.getWorkSpace(), this.scheduler.getProperties());
            if (repositoryContext == null) continue;
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
            Vector vector2 = new Vector();
            Vector vector3 = ConfigRepoHelper.getServersForAppDeployment(applicationDeployment, vector2, this.scheduler.getCellContext(), this.scheduler.getWorkSpace(), true);
            if (vector2.size() != 0) {
                this.scheduler.propagateTaskEvent(this.createNotification("InProgress", "ADMA8016I", new Object[]{vector2}));
                Tr.info((TraceComponent)tc, (String)AppUtils.getMessage(this.getResourceBundle(), "ADMA8016I", new Object[]{vector2}));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("target servers are " + vector3));
            }
            for (int j = 0; j < vector3.size(); ++j) {
                if (vector.contains(vector3.get(j))) continue;
                vector.add(vector3.get(j));
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("handleNotification" + notification + " " + object));
        }
        Properties properties = null;
        if (notification == null) {
            return;
        }
        String string = notification.getType();
        Object object2 = notification.getUserData();
        if ((string.equals("websphere.process.stopped") || string.equals("websphere.process.failed") || string.equals("websphere.process.running") || string.equals("websphere.process.starting")) && object2 != null) {
            properties = (Properties)object2;
            String string2 = properties.getProperty("processName");
            String string3 = this.waitObject;
            synchronized (string3) {
                if (string2.equals(this.waitTarget)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("got notification " + string));
                    }
                    if (string.equals("websphere.process.starting")) {
                        this.waitStarting = true;
                    } else {
                        this.waitTarget = null;
                        this.waitResult = string;
                    }
                    this.waitObject.notifyAll();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleNotification");
        }
    }

    private Hashtable getServerTypes(RepositoryContext repositoryContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerTypes");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        URI uRI = URI.createURI((String)"serverindex.xml");
        Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            String string = serverEntry.getServerName();
            String string2 = serverEntry.getServerType();
            hashtable.put(string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerTypes");
        }
        return hashtable;
    }

    private void establishLaunchTimeout() {
        Integer n = UpdateClusterScheduler.DEFAULT_LAUNCH_TIMEOUT;
        Object v = this.scheduler.getProperties().get("LAUNCH_TIMEOUT");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"time", v);
        }
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        this.launchTimeout = n;
    }

    private class LaunchThread
    extends Thread {
        String launchNode;
        String launchServer;
        int timeout;

        public LaunchThread(String string, String string2, int n) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"LaunchThread");
            }
            this.launchNode = string;
            this.launchServer = string2;
            this.timeout = n;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"LaunchThread");
            }
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"run");
            }
            com.ibm.websphere.management.AdminService adminService = AdminServiceFactory.getAdminService();
            ObjectName objectName = UpdateClusterTask.this.getNodeagentObjectName(this.launchNode);
            ObjectName objectName2 = UpdateClusterTask.this.getServerObjectName(this.launchNode, this.launchServer);
            Object var4_4 = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Initiating launch for " + this.launchNode + "/" + this.launchServer));
                }
                AdminServiceFactory.getAdminService().invoke(objectName, "launchProcess", new Object[]{this.launchServer, new Integer(this.timeout)}, new String[]{"java.lang.String", "java.lang.Integer"});
            }
            catch (Exception exception) {
                Tr.info((TraceComponent)tc, (String)AppUtils.getMessage(UpdateClusterTask.this.getResourceBundle(), "ADMA8010I", new String[]{this.launchServer}));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception invoking launchProcess" + exception));
                }
                exception.printStackTrace();
                return;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"run");
            }
        }
    }
}

