/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.application.WebModule;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.ModuleRef;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUpdate;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.UpdateSchedulerImpl;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class FileMergeTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register((Class)FileMergeTask.class, null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    UpdateSchedulerImpl _scheduler;
    String _appName;
    String _operation;
    String _contentURI;
    String _contentType;
    String _origContentType;
    String _tempDir;
    RepositoryContext _appC;
    EARFile _ear;
    AppUpdateHelper _aHelper;
    List _modURIs;
    private static final String ADD = "add";
    private static final String DELETE = "delete";
    private static final String UPDATE = "update";
    private static final String ADDUPDATE = "addupdate";
    private static final String SEP = File.separator;

    private void init() throws Exception {
        this._scheduler = (UpdateSchedulerImpl)this.scheduler;
        this._appName = this._scheduler.getAppName();
        this._operation = this._scheduler.getOperation();
        this._contentURI = this._scheduler.getContentURI();
        this._contentType = this._scheduler.getContentType();
        this._origContentType = this._scheduler.getOrigContentType();
        this._tempDir = AppUtils.getAppTempExtractDir(this._scheduler);
        this._appC = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
        this._aHelper = new AppUpdateHelper();
        this._ear = null;
        this._modURIs = new ArrayList();
        ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(this._appC);
        EList eList = applicationDeployment.getModules();
        for (int i = 0; i < eList.size(); ++i) {
            this._modURIs.add(((ModuleDeployment)eList.get(i)).getUri());
        }
    }

    public boolean performTask() throws AdminException {
        boolean bl;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"performTask");
            }
            try {
                this.init();
                boolean bl2 = this.checkPartialMode();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("partial mode = " + bl2));
                }
                ArrayList arrayList = new ArrayList();
                this._scheduler.getProperties().put("DeltaDataTask.DelFiles", arrayList);
                ArrayList arrayList2 = new ArrayList();
                this._scheduler.getProperties().put("DeltaDataTask.AddFiles", arrayList2);
                ArrayList arrayList3 = new ArrayList();
                this._scheduler.getProperties().put("DeltaDataTask.UpdateFiles", arrayList3);
                this._ear = ConfigRepoHelper.getEarFileFromBinaries(this._appC, this._scheduler.getWorkSpace(), this.getResourceBundle(), null, bl2);
                if (bl2) {
                    AppUtils.dbg(tc, "Added files from partial ear: " + arrayList2);
                    this.handlePartialEar(arrayList, arrayList2, arrayList3, this._ear);
                } else {
                    this.handleModuleFile(arrayList, arrayList2, arrayList3);
                }
                this._ear.rollUpRoles();
                if (bl2) {
                    this._ear.saveAs(this._appC.getParent().getPath() + "/" + this._appC.getParent().getName());
                } else {
                    this._ear.save();
                }
                this._appC.getParent().notifyChanged(1, this._appC.getParent().getName());
                this.scheduler.propagateTaskEvent(this.createNotification("Completed", "ADMA5064I", new String[]{this.scheduler.getAppName()}));
                bl = true;
                Object var7_7 = null;
                if (this._ear == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.task.FileMergeTask.performTask", (String)"130", (Object)this);
                    this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5065E", new String[]{throwable.toString()}));
                    throw new AdminException(throwable, "Exception merging files");
                }
                catch (Throwable throwable2) {
                    block13: {
                        Object var7_8 = null;
                        if (this._ear != null) {
                            this._ear.close();
                            this._ear = null;
                        }
                        if (!tc.isEntryEnabled()) break block13;
                        Tr.exit((TraceComponent)tc, (String)"performTask");
                    }
                    throw throwable2;
                }
            }
            this._ear.close();
            this._ear = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performTask");
        }
        return bl;
    }

    private boolean checkPartialMode() throws Exception {
        boolean bl = this._contentType.equals("file") || this._contentType.equals("partialapp") || this._contentType.equals("modulefile") && (this._operation.equals(UPDATE) || this._operation.equals(ADDUPDATE) && this._modURIs.contains(this._contentURI));
        return bl;
    }

    private void handlePartialEar(List list, List list2, List list3, EARFile eARFile) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handlePartialEar");
        }
        String string = AppUtils.getAppTempMergeDir(this._scheduler);
        new File(string).mkdirs();
        this._ear.extractTo(string, 0);
        this._ear.close();
        this._ear = null;
        this._aHelper.setLists(list, list2, list3);
        this._aHelper.mergeFiles(this._contentType.equals("partialapp") ? ADDUPDATE : this._scheduler.getOperation(), this._tempDir, string);
        this._ear = AppInstallHelper.getEarFile(string, false, true, this.getResourceBundle());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handlePartialEar");
        }
    }

    private String getPropFileArchiveURI(String string) {
        String string2 = "";
        int n = string.indexOf("META-INF/ibm-partialapp-delete.props");
        if (n != 0) {
            string2 = string.substring(0, n - 1);
        }
        return string2.trim();
    }

    private void handleModuleFile(List list, List list2, List list3) throws Exception {
        if (this._operation.equals(DELETE)) {
            int n;
            EList eList = this._ear.getModuleRefs();
            String string = "moduletype.unknown";
            ArrayList<ModuleRef> arrayList = new ArrayList<ModuleRef>();
            for (n = 0; n < eList.size(); ++n) {
                ModuleRef moduleRef = (ModuleRef)eList.get(n);
                if (!this._contentURI.equals(moduleRef.getUri())) continue;
                moduleRef.getModuleFile();
                arrayList.add(moduleRef);
                string = ConfigRepoHelper.getModuleType(moduleRef);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                this._ear.remove((ModuleRef)arrayList.get(n));
            }
            if (arrayList.size() > 0) {
                list.add(this._contentURI);
                this.scheduler.getProperties().put("moduletype", string);
            }
        } else {
            ModuleFile moduleFile = (ModuleFile)this._scheduler.getContentAsArchive();
            ModuleRef moduleRef = this._ear.addCopyRef(moduleFile);
            moduleRef.setURI(this._contentURI);
            if (moduleRef.isWeb()) {
                String string = (String)this._scheduler.getProperties().get("contextroot");
                if (string == null) {
                    string = "/";
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Setting contextroot to / since it is passed in as null.");
                    }
                }
                ((WebModule)moduleRef.getModule()).setContextRoot(string);
            }
            list2.add(this._contentURI);
        }
        list3.add("META-INF/application.xml");
    }

    private boolean containsModuleFile(String string) throws Exception {
        ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(this._appC);
        EList eList = applicationDeployment.getModules();
        for (int i = 0; i < eList.size(); ++i) {
            if (!((ModuleDeployment)eList.get(i)).getUri().equals(string)) continue;
            return true;
        }
        return false;
    }

    public List getFiles(RepositoryContext repositoryContext, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = repositoryContext.getFiles().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.matches(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private class AppUpdateHelper
    extends AppUpdate {
        private AppUpdateHelper() {
        }

        public List getURIs() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getURIs");
            }
            List list = AppUtils.getURIs(FileMergeTask.this._tempDir);
            if (FileMergeTask.DELETE.equals(FileMergeTask.this._operation) && "file".equals(FileMergeTask.this._contentType)) {
                list.add(FileMergeTask.this._contentURI);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getURIs");
            }
            return list;
        }

        public List getURIsNoDelete() {
            if (FileMergeTask.DELETE.equals(FileMergeTask.this._operation) && "file".equals(FileMergeTask.this._contentType)) {
                return new ArrayList();
            }
            List list = this.getURIs();
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                if (!((String)list.get(i)).endsWith("META-INF/ibm-partialapp-delete.props")) continue;
                arrayList.add(list.get(i));
            }
            list.removeAll(arrayList);
            return list;
        }

        public InputStream getContentAsInputStream(String string) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("getContentAsInputStream: " + string));
            }
            FileInputStream fileInputStream = null;
            try {
                File file = new File(FileMergeTask.this._tempDir + "/" + string);
                fileInputStream = new FileInputStream(file);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getContentAsInputStream");
            }
            return fileInputStream;
        }

        protected boolean addToCollapse(String string) throws Exception {
            return !FileMergeTask.this._modURIs.contains(string);
        }
    }
}

