/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ExtractionTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register((Class)ExtractionTask.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performTask");
        }
        Hashtable hashtable = this.scheduler.getProperties();
        String string = null;
        try {
            string = AppUtils.getAppTempExtractDir(this.scheduler);
            new File(string).mkdirs();
            if (this.scheduler instanceof InstallScheduler) {
                AppUtils.dbg(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA6013I", new Object[]{string}));
                EarUtils.extractEar(((InstallScheduler)this.scheduler).getEarFile(false, true), string, true);
                ((InstallScheduler)this.scheduler).setEarPath(string);
            } else if (this.scheduler instanceof UpdateScheduler) {
                UpdateScheduler updateScheduler = (UpdateScheduler)this.scheduler;
                boolean bl = false;
                if (updateScheduler.getContentType().equals("partialapp")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Expanding partial ear to: " + string));
                    }
                    this.extractZip(updateScheduler.getContentPath(), string);
                    updateScheduler.setContentPath(string);
                    if (updateScheduler.getOrigContentType().equals("modulefile") && AppUtils.isPreCompileJSPs(updateScheduler)) {
                        String string2;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Expanding module " + updateScheduler.getContentURI() + " from partial ear to: " + string));
                        }
                        if (new File(string2 = string + File.separator + updateScheduler.getContentURI()).exists()) {
                            Archive archive = AppInstallHelper.getArchive(string2, false, true, this.getResourceBundle(), false);
                            if (archive.isWARFile()) {
                                archive.extractNoReopen(2);
                                bl = true;
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Not a war in partial app");
                            }
                            archive.close();
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("ExtractionTask:Error " + string2 + " does not exist"));
                        }
                    }
                } else if (updateScheduler.getContentType().equals("modulefile") && !updateScheduler.getOperation().equals("delete")) {
                    string = string + "/" + updateScheduler.getContentURI();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Copying modulefile to: " + string));
                    }
                    Archive archive = updateScheduler.getContentAsArchive();
                    if (AppUtils.isPreCompileJSPs(updateScheduler) && archive.isWARFile()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Expanding modulefile to: " + string));
                        }
                        File file = new File(string);
                        file.mkdirs();
                        archive.extractTo(string, 2);
                        bl = true;
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Copying modulefile to: " + string));
                        }
                        archive.saveAs(string);
                    }
                    updateScheduler.setContentPath(string);
                } else if (updateScheduler.getContentType().equals("file") && !updateScheduler.getOperation().equals("delete")) {
                    AppUtils.copyFile(new File(updateScheduler.getContentPath()), string + "/" + updateScheduler.getContentURI());
                    updateScheduler.setContentPath(string);
                }
                if (!bl) {
                    this.scheduler.getProperties().remove("preCompileJSPs");
                }
            }
            this.scheduler.propagateTaskEvent(this.createNotification("Completed", "ADMA5009I", new String[]{string}));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"performTask");
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.task.ExtractionTask.performTask", (String)"96", (Object)this);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5010E", new String[]{string, throwable.toString()}));
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, AppUtils.getMessage(this.getResourceBundle(), "ADMA0064E"));
        }
    }

    public Vector extractZip(String string, String string2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        Vector vector = this.extractZip(fileInputStream, string2);
        fileInputStream.close();
        return vector;
    }

    private Vector extractZip(InputStream inputStream, String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"extractZip");
        }
        FileOutputStream fileOutputStream = null;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        File file = null;
        File file2 = null;
        Vector<String> vector = new Vector<String>();
        byte[] byArray = null;
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                String string3 = (string + File.separator + string2).replace('/', File.separatorChar);
                file = new File(string3);
                file2 = new File(file.getParent());
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                if (zipEntry.isDirectory()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("extracted: " + string2));
                }
                vector.addElement(string2);
                fileOutputStream = new FileOutputStream(file);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipInputStream);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = bufferedInputStream.read();
                while (n != -1) {
                    fileOutputStream.write(n);
                    byteArrayOutputStream.write(n);
                    n = bufferedInputStream.read();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (byteArrayOutputStream == null) continue;
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
            }
        }
        catch (IOException iOException) {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"extractZip");
        }
        return vector;
    }
}

