/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.deployment.deploywrapper.DeployOptions;
import com.ibm.ejs.util.deployment.deploywrapper.DeployUtil;
import com.ibm.etools.ejbdeploy.IStatusMonitor;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.Container;
import com.ibm.etools.j2ee.commonarchivecore.ModuleRef;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.PlatformUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class DeployEJBTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register((Class)DeployEJBTask.class, null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static String EJBCALLER = "EJBCALLER";
    private static String WEBSPHERE = "WEBSPHERE";
    private static String EXPANDPATH = "EXP";

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private void expandDependentClassJars(Container container, Archive archive, List list, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("expandDependentClassJars: Container= " + container + ", archive= " + archive + ", paths= " + list));
        }
        AppUtils.dbg(tc, "expandDependentClassJars: Container= " + container + ", archive= " + archive + ", paths= " + list);
        String string2 = "";
        String[] stringArray = archive.getManifest().getClassPathTokenized();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            try {
                Object[] objectArray = AppUtils.getContainerAndOffset(container, string3);
                com.ibm.etools.j2ee.commonarchivecore.File file = ((Container)objectArray[0]).getFile((String)objectArray[1]);
                if (file == null || list.contains(string2 = string + "/" + file.getURI())) continue;
                if (file.isArchive()) {
                    this.expandDependentClassJars((Container)objectArray[0], (Archive)file, list, string);
                }
                AppUtils.dbg(tc, "Dependent Class: " + string3);
                AppUtils.copyFile(file.getInputStream(), string2);
                list.add(string2);
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.task.DeployEJBTask.expandDependentClassJars", (String)"98", (Object)this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"expandDependentClassJars");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performTask() throws AdminException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performTask");
        }
        StatusMonitorImpl statusMonitorImpl = new StatusMonitorImpl();
        String string = AppUtils.getAppTempDeployDir(this.scheduler);
        String string2 = string + File.separator + AppUtils.getAppDeployFileName(this.scheduler.getAppName());
        ArrayList arrayList = null;
        Hashtable<String, String> hashtable = null;
        Hashtable hashtable2 = (Hashtable)this.scheduler.getProperties().get("moduleToServer");
        boolean bl2 = false;
        try {
            String string3;
            String string4;
            Object object;
            Scheduler scheduler;
            Hashtable hashtable3 = this.scheduler.getProperties();
            hashtable3 = (Hashtable)hashtable3.get("deployejb.options");
            if (hashtable3 == null) {
                throw new AdminException(AppUtils.getMessage(this.getResourceBundle(), "ADMA0062E"));
            }
            Object object2 = null;
            if (this.scheduler instanceof InstallScheduler) {
                scheduler = (InstallScheduler)this.scheduler;
                string2 = string2 + ".ear";
                object = new File(scheduler.getEarPath());
                if (((File)object).isDirectory()) {
                    string4 = string + File.separator + AppUtils.getPreAppDeployFileName(scheduler.getAppName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Copying source dir to an ear: " + string4));
                    }
                    scheduler.getEarFile(false, true).saveAs(string4);
                    scheduler.setEarPath(string4);
                }
                object2 = scheduler.getEarFile(false, true);
                if (hashtable2 != null) {
                    string4 = scheduler.getEarFile(false, true).getModuleRefs();
                    for (int i = 0; i < string4.size(); ++i) {
                        com.ibm.etools.commonarchive.ModuleRef moduleRef = (com.ibm.etools.commonarchive.ModuleRef)string4.get(i);
                        if (!moduleRef.isEJB() || moduleRef.getAltDeploymentDescriptor() == null) continue;
                        if (hashtable == null) {
                            hashtable = new Hashtable<String, String>();
                        }
                        string3 = util.createUniqueModuleName(ConfigRepoHelper.getDDUri((ModuleRef)moduleRef), moduleRef.getModule().getUri());
                        hashtable.put(moduleRef.getModule().getUri(), string3);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("altDDMods: " + hashtable));
                    }
                }
            } else if (this.scheduler instanceof UpdateScheduler) {
                scheduler = (UpdateScheduler)this.scheduler;
                string2 = string2 + ".jar";
                if (scheduler.getContentType().equals("modulefile") && !"delete".equals(scheduler.getOperation())) {
                    object = scheduler.getContentAsArchive();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Update module is: " + object));
                    }
                    if (object.isEJBJarFile()) {
                        object2 = object;
                        string4 = null;
                        try {
                            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
                            string4 = ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, scheduler.getWorkSpace(), this.getResourceBundle(), null, true);
                            arrayList = new ArrayList();
                            this.expandDependentClassJars((Container)string4, (Archive)object, arrayList, string + File.separator + EXPANDPATH);
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.task.DeployEJBTask.performTask", (String)"217", (Object)this);
                            AppUtils.dbg(tc, "WARNING: ExpandDepedentClasses failed.");
                        }
                        finally {
                            if (string4 != null) {
                                string4.close();
                            }
                        }
                    }
                }
                if (scheduler.getContentType().equals("partialapp") && scheduler.getOrigContentType().equals("modulefile")) {
                    object = scheduler.getContentPath() + File.separator + scheduler.getContentURI();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Module file in partial app is: " + (String)object));
                    }
                    if ((string4 = AppInstallHelper.getArchive((String)object, false, true, this.getResourceBundle(), false)).isEJBJarFile()) {
                        object2 = string4;
                        bl2 = true;
                    } else {
                        string4.close();
                    }
                }
            }
            if (object2 == null) {
                throw new AdminException("No EJB or EAR file found to process.");
            }
            scheduler = new DeployOptions();
            scheduler.setInputModuleName(object2.getURI());
            scheduler.setDeployedModuleName(string2);
            scheduler.setWorkingDirectory(string);
            object = (String)hashtable3.get("deployejb.rmic");
            if (!this.isEmpty((String)object)) {
                scheduler.setRMICOptions((String)object);
            }
            object = (String)hashtable3.get("deployejb.classpath");
            if (arrayList != null) {
                if (object == null) {
                    object = "";
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    object = (String)object + arrayList.get(i) + File.pathSeparator;
                }
            }
            AppUtils.dbg(tc, "setClasspath = " + (String)object);
            if (!this.isEmpty((String)object)) {
                object = ((String)object).replace('/', File.separatorChar);
                object = ((String)object).replace('\\', File.separatorChar);
                scheduler.setClasspath((String)object);
            }
            if ((object = (Boolean)hashtable3.get("deployejb.codegen")) != null) {
                scheduler.setCodegenOnly((Boolean)object);
            }
            if (!this.isEmpty((String)(object = (String)hashtable3.get("deployejb.dbtype")))) {
                scheduler.setDatabaseType((String)object);
            }
            if (!this.isEmpty((String)(object = (String)hashtable3.get("deployejb.dbschema")))) {
                scheduler.setSchemaName((String)object);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Options are: " + scheduler));
            }
            if (!((File)(object = new File(string))).exists()) {
                ((File)object).mkdirs();
            }
            this.scheduler.propagateTaskEvent(this.createNotification("InProgress", "ADMA5018I", new String[]{object2.getURI()}));
            if (AdminHelper.getPlatformHelper().isZOS()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"z specifc ejbdeploy setup..");
                }
                PlatformUtils platformUtils = AdminServiceImpl.getPlatformUtils();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("platformutil: " + platformUtils));
                }
                if (platformUtils != null) {
                    platformUtils.setenv(EJBCALLER, WEBSPHERE);
                    String string5 = platformUtils.getenv(EJBCALLER);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("after getenv: " + string5));
                    }
                }
            }
            DeployUtil.deploy((Archive)object2, (DeployOptions)scheduler, (IStatusMonitor)statusMonitorImpl);
            this.scheduler.propagateTaskEvent(this.createNotification("Completed", "ADMA5007I", new String[]{string2}));
            if (statusMonitorImpl.getErrors().size() != 0) {
                Vector vector = statusMonitorImpl.getErrors();
                if (bl2 && object2 != null) {
                    object2.close();
                }
                throw new AdminException(AppUtils.getMessage(this.getResourceBundle(), "ADMA0063E", new Object[]{vector}));
            }
            if (this.scheduler instanceof InstallScheduler) {
                InstallScheduler installScheduler = (InstallScheduler)this.scheduler;
                installScheduler.setEarPath(string2);
                if (hashtable != null) {
                    EList eList = installScheduler.getEarFile(false, true).getModuleRefs();
                    for (int i = 0; i < eList.size(); ++i) {
                        String string6;
                        String string7;
                        string3 = (com.ibm.etools.commonarchive.ModuleRef)eList.get(i);
                        if (!string3.isEJB() || (string7 = (String)hashtable2.get(string6 = (String)hashtable.get(string3.getModule().getUri()))) == null) continue;
                        String string8 = util.createUniqueModuleName(ConfigRepoHelper.getDDUri((ModuleRef)string3), string3.getModule().getUri());
                        hashtable2.remove(string6);
                        hashtable2.put(string8, string7);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Removed: " + string6 + " .. added: " + string8 + " = " + string7));
                    }
                }
            } else if (this.scheduler instanceof UpdateScheduler) {
                UpdateScheduler updateScheduler = (UpdateScheduler)this.scheduler;
                String string9 = object2.getURI();
                if (updateScheduler.getContentType().equals("modulefile")) {
                    updateScheduler.setContentPath(string2);
                } else if (updateScheduler.getContentType().equals("partialapp")) {
                    object2.close();
                }
                boolean bl3 = new File(string9).delete();
                AppUtils.dbg(tc, "Deleted " + string9 + " = " + bl3);
                AppUtils.copyFile(new File(string2), string9);
                AppUtils.dbg(tc, "Copied: " + string2 + " to " + string9 + " = " + bl3);
                if (updateScheduler.getContentType().equals("modulefile")) {
                    updateScheduler.setContentPath(string9);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"performTask");
            }
            bl = true;
            Object var20_35 = null;
        }
        catch (Throwable throwable) {
            try {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.task.DeployEJBTask.performTask", (String)"160", (Object)this);
                this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5008E", new String[]{string2, throwable.toString()}));
                Tr.error((TraceComponent)tc, (String)"ADMA0086E", (Object)new Object[]{throwable, "-"});
                if (throwable instanceof AdminException) {
                    throw (AdminException)((Object)throwable);
                }
                Vector vector = statusMonitorImpl.getErrors();
                throw new AdminException(throwable, AppUtils.getMessage(this.getResourceBundle(), "ADMA0063E", new Object[]{vector}));
            }
            catch (Throwable throwable2) {
                block67: {
                    Object var20_36 = null;
                    if (!AdminHelper.getPlatformHelper().isZOS()) break block67;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"z specifc ejbdeploy setup..");
                    }
                    PlatformUtils platformUtils = AdminServiceImpl.getPlatformUtils();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("platformutil: " + platformUtils));
                    }
                    if (platformUtils != null) {
                        platformUtils.setenv(EJBCALLER, "");
                        String string10 = platformUtils.getenv(EJBCALLER);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("after getenv: " + string10));
                        }
                    }
                }
                throw throwable2;
            }
        }
        if (AdminHelper.getPlatformHelper().isZOS()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"z specifc ejbdeploy setup..");
            }
            PlatformUtils platformUtils = AdminServiceImpl.getPlatformUtils();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("platformutil: " + platformUtils));
            }
            if (platformUtils != null) {
                platformUtils.setenv(EJBCALLER, "");
                String string11 = platformUtils.getenv(EJBCALLER);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("after getenv: " + string11));
                }
            }
        }
        return bl;
    }

    class StatusMonitorImpl
    implements IStatusMonitor {
        Vector errors = new Vector();

        StatusMonitorImpl() {
        }

        public void errorMessage(String string, int n) {
            switch (n) {
                case 2: {
                    this.errors.addElement(string);
                    AppUtils.dbg(tc, "\t[EJBDeploy] " + string + " [Severity " + n + "]");
                    Tr.error((TraceComponent)tc, (String)"ADMA0086E", (Object)new Object[]{string, new Integer(n)});
                    DeployEJBTask.this.scheduler.propagateTaskEvent(DeployEJBTask.this.createTranslatedNotification("InProgress", string, null));
                }
                case 1: {
                    AppUtils.dbg(tc, "\t[EJBDeploy] " + string + " [Severity " + n + "]");
                    Tr.warning((TraceComponent)tc, (String)"ADMA0087W", (Object)new Object[]{string, new Integer(n)});
                    DeployEJBTask.this.scheduler.propagateTaskEvent(DeployEJBTask.this.createTranslatedNotification("InProgress", string, null));
                }
            }
            AppUtils.dbg(tc, "\t[EJBDeploy] " + string + " [Severity " + n + "]");
            Tr.warning((TraceComponent)tc, (String)"ADMA0087W", (Object)new Object[]{string, new Integer(n)});
        }

        public Vector getErrors() {
            return this.errors;
        }

        public boolean isCanceled() {
            return false;
        }

        public void subtaskMessage(String string) {
            Tr.info((TraceComponent)tc, (String)"ADMA0144I", (Object)new Object[]{string});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("\t[EJBDeploy] " + string));
            }
        }

        public void taskMessage(String string) {
            Tr.info((TraceComponent)tc, (String)"ADMA0144I", (Object)new Object[]{string});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("\t[EJBDeploy] " + string));
            }
            DeployEJBTask.this.scheduler.propagateTaskEvent(DeployEJBTask.this.createTranslatedNotification("InProgress", string, null));
        }
    }
}

