/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class DeleteAppConfigTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register((Class)DeleteAppConfigTask.class);

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performTask");
        }
        try {
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("About to delete appContext: " + repositoryContext));
            }
            boolean bl = true;
            List list = repositoryContext.getParentContext().getChildren(AppUtils.getContextType("deployments"));
            if (list.size() > 1) {
                bl = false;
            }
            if (bl) {
                repositoryContext.getParentContext().delete(true);
            } else {
                String string = EditionHelper.getAppEarName(this.scheduler.getAppName(), this.scheduler.getProperties());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("delete ear: " + string));
                }
                if (repositoryContext.getParent().isAvailable(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Available hence delete: " + string));
                    }
                    repositoryContext.getParent().delete(string);
                }
                try {
                    Properties properties = AppUtils.getEditionProps(repositoryContext);
                    String string2 = EditionHelper.getEditionPropSuffix(repositoryContext.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("key marker is " + string2));
                    }
                    Enumeration<Object> enumeration = properties.keys();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        String[] stringArray = EditionHelper.getAppAndEdition(string3);
                        if (string2.length() == 0) {
                            if (stringArray[1].trim().length() != 0) continue;
                            arrayList.add(string3);
                            continue;
                        }
                        if (!string3.endsWith(string2)) continue;
                        arrayList.add(string3);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("remove keys: " + arrayList));
                    }
                    if (arrayList.size() > 0) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            properties.remove(arrayList.get(i));
                        }
                        AppUtils.setEditionProps(repositoryContext, properties);
                    }
                }
                catch (AdminException adminException) {
                    FFDCFilter.processException((Throwable)((Object)adminException), (String)"com.ibm.ws.management.application.task.DeleteAppConfigTask.performTask", (String)"79", (Object)this);
                    this.scheduler.propagateTaskEvent(this.createNotification("InProgress", "ADMA5109E", new String[]{adminException.toString(), this.scheduler.getAppName()}));
                }
                repositoryContext.delete(true);
            }
            this.scheduler.propagateTaskEvent(this.createNotification("Completed", "ADMA5102I", new String[]{this.scheduler.getAppName()}));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"performTask");
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.task.DeleteAppConfigTask.performTask", (String)"92", (Object)this);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5103E", new String[]{this.scheduler.getAppName()}));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error deleting app binaries: " + throwable));
            }
            return true;
        }
    }
}

