/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public class AppSyncEventsTask
extends AbstractAppSyncTask {
    private static TraceComponent tc = Tr.register((Class)AppSyncEventsTask.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String[] NTFY_PARAMS = new String[]{"java.lang.String", "java.lang.String", "java.lang.Object"};
    private Hashtable _props;
    private AppData _cachedAd;
    private AppData _newAd;

    public boolean performTask(AppData appData, AppData appData2, Hashtable hashtable) throws Exception {
        if (this._isLocal) {
            return true;
        }
        if (!this.appIsDeployedOnNode(appData2.getAppName()) && !this.appWasDeployedOnNode(appData.getAppName())) {
            return true;
        }
        this._cachedAd = appData;
        this._newAd = appData2;
        String string = "";
        int n = this._newAd.getOperations();
        string = (n & 1) != 0 ? "installsync" : ((n & 0x10) != 0 ? "uninstallsync" : "updatesync");
        if (hashtable == null) {
            throw new Exception("props is null");
        }
        this._props = hashtable;
        String string2 = (Boolean)hashtable.get("syncstatus") != false ? "Completed" : "Failed";
        String string3 = (Boolean)hashtable.get("syncstatus") != false ? "completed" : "failed";
        this.propagateEvent(appData.getAppName(), new AppNotification(string, "", string2, "", string3), string3);
        return true;
    }

    private void propagateEvent(String string, AppNotification appNotification, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"propagateTaskEvent");
        }
        Properties properties = null;
        if (appNotification.props != null) {
            properties = appNotification.props;
        } else {
            properties = new Properties();
            appNotification.setProperties(properties);
        }
        properties.put("appname", string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Sending notification: " + appNotification));
        }
        this.emitNotification(string2, appNotification);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"propagateTaskEvent");
        }
    }

    private void emitNotification(String string, AppNotification appNotification) {
        String string2 = "WebSphere:*,type=NotificationService,process=" + AdminServiceFactory.getAdminService().getProcessName();
        try {
            Set set = AdminServiceFactory.getAdminService().queryNames(new ObjectName(string2), null);
            if (set.isEmpty()) {
                Tr.error((TraceComponent)tc, (String)"ADMU0008E", (Object)new Object[]{string2, "none"});
            }
            AdminServiceFactory.getAdminService().invoke((ObjectName)set.iterator().next(), "emitNotification", new Object[]{"websphere.admin.appmgmt.sync", string, appNotification}, NTFY_PARAMS);
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"ADMU0008E", (Object)new Object[]{string2, exception});
        }
    }
}

