/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.RARFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUpdate;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.ObjectName;

public class AddBinaryTask
extends AbstractAppSyncTask {
    private static TraceComponent tc = Tr.register((Class)AddBinaryTask.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private AppUpdateHelper _aHelper;
    private ArrayList deleted = new ArrayList();
    private ArrayList added = new ArrayList();
    private ArrayList updated = new ArrayList();
    private Hashtable _props;
    private AppData _cachedAd;
    private AppData _newAd;

    public AddBinaryTask() {
        this._aHelper = new AppUpdateHelper();
        this._aHelper.setLists(this.deleted, this.added, this.updated);
        this._aHelper.setSyncMode(true);
    }

    public boolean performTask(AppData appData, AppData appData2, Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performTask");
        }
        if (!this.appIsDeployedOnNode(appData.getAppName())) {
            return true;
        }
        if (!appData2.isDistEnabled()) {
            return true;
        }
        this._cachedAd = appData;
        this._newAd = appData2;
        this._props = hashtable;
        int n = this._newAd.getOperations();
        if ((n & 1) != 0 || (n & 0x10000) != 0 || (n & 0x1000) != 0 || !this.appWasDeployedOnNode(appData.getAppName())) {
            this.fullUpdate(this._newAd.getBinURL(), hashtable);
        } else if ((n & 0x100000) != 0) {
            return this.fineGrainUpdate();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performTask");
        }
        return true;
    }

    private boolean fullUpdate(String string, Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fullUpdate");
        }
        String string2 = "";
        try {
            AppUtils.deleteDirTree(string, false);
            EarUtils.extractEar(this._newAd.getEAR(), string, false);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"expanded ear");
            }
            Vector vector = (Vector)this._newSIMap.get(this._cachedAd.getAppName());
            for (int i = 0; i < vector.size(); ++i) {
                string2 = (String)vector.elementAt(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Install J2EEApplication on application: " + this._cachedAd.getAppName() + " ,process: " + string2));
                }
                this.installJ2EEApplication(this._cachedAd.getAppName(), string2);
            }
        }
        catch (Throwable throwable) {
            hashtable.put("expansionFailue", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fullUpdate");
        }
        return true;
    }

    private boolean fineGrainUpdate() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fineGrainUpdate");
        }
        String string = "";
        try {
            String string2 = this._cachedAd.getEarURI().substring(0, this._cachedAd.getEarURI().lastIndexOf(47));
            String string3 = this._cachedAd.getBinURL();
            this._aHelper.mergeFiles("add", string2, string3);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"fineGrainUpdate");
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.sync.AddBinaryTask.fineGrainUpdate", (String)"105", (Object)this);
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, "AddBinaryTask failed on fineGrainUpdate.");
        }
    }

    private String getKey(String string, String string2) {
        String string3 = string.substring(string.indexOf("applications") + "applications".length() + 1);
        string3 = string3.substring(0, string3.indexOf(47) + 1);
        string3 = string3 + "deployments" + "/" + string2;
        return string3;
    }

    private void installJ2EEApplication(String string, String string2) {
        if (this._isLocal) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"installJ2EEApplication");
        }
        ObjectName objectName = null;
        try {
            Iterator iterator;
            String string3 = "WebSphere:type=ApplicationManager,node=" + this._nodeName + ",process=" + string2 + ",*";
            ObjectName objectName2 = new ObjectName(string3);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Query for: " + string3));
            }
            if ((iterator = AdminServiceFactory.getAdminService().queryNames(objectName2, null).iterator()) == null || !iterator.hasNext()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Could not find: " + string3));
                }
                return;
            }
            objectName = (ObjectName)iterator.next();
            AdminServiceFactory.getAdminService().invoke(objectName, "_applicationInstalled", new Object[]{string}, new String[]{String.class.getName()});
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error installing J2EEApplication at app: " + string + " on process: " + string2 + " by: " + objectName));
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.sync.AppBinThread.installJ2EEApplication", (String)"857", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"installJ2EEApplication");
        }
    }

    private class AppUpdateHelper
    extends AppUpdate {
        private AppUpdateHelper() {
        }

        public List getURIs() {
            if (tc.isDebugEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getURIs");
            }
            List list = (List)AddBinaryTask.this._newAd.getPartialUpdateDetails().get("DOCSADDED_KEY");
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getURIs:" + list));
            }
            return list;
        }

        public InputStream getContentAsInputStream(String string) {
            if (tc.isDebugEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("getContentAsInputStream: uri = " + string));
            }
            InputStream inputStream = null;
            try {
                Object[] objectArray = (Object[])((Hashtable)AddBinaryTask.this._props.get("filestbl")).get(string);
                if (tc.isDebugEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getContentAsInputStream");
                }
                Archive archive = (Archive)objectArray[1];
                Tr.debug((TraceComponent)tc, (String)("getting inputstream on container: " + archive + ", and offset: " + (String)objectArray[2]));
                inputStream = archive.getInputStream((String)objectArray[2]);
                return inputStream;
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)tc, (String)"AppBinaryTask.getContentAsInputStream failed");
                if (tc.isDebugEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getContentAsInputStream");
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void mergeFiles(String string, String string2, String string3) throws Exception {
            com.ibm.etools.j2ee.commonarchivecore.File file;
            Object object;
            super.mergeFiles(string, string2, string3);
            ArrayList<String> arrayList = new ArrayList<String>();
            Hashtable hashtable = (Hashtable)AddBinaryTask.this._props.get("filestbl");
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                object = (Object[])hashtable.get(string4);
                if ("delete".equals(object[0]) || !(object[1] instanceof EARFile)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Content change at EAR: " + string4));
                }
                if (!((file = ((EARFile)object[1]).getFile((String)object[2])) instanceof WARFile) && !(file instanceof RARFile)) continue;
                arrayList.add((String)object[2]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Expand list: " + arrayList));
            }
            int i = 0;
            while (true) {
                block13: {
                    if (i >= arrayList.size()) {
                        return;
                    }
                    object = new File(AddBinaryTask.this._cachedAd.getBinURL() + "/" + arrayList.get(i));
                    if (((File)object).exists() && ((File)object).isFile()) {
                        block14: {
                            Object var12_12;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Expanding: " + arrayList.get(i)));
                            }
                            file = null;
                            try {
                                try {
                                    file = AppInstallHelper.getArchive(((File)object).getPath(), false, true, this.getResourceBundle(), false);
                                    file.extract(66);
                                }
                                catch (Throwable throwable) {
                                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.sync.AddBinaryTask.AppUpdateHelper.mergeFiles", (String)"362", (Object)this);
                                    Tr.debug((TraceComponent)tc, (String)("Exception in extracting: " + object + ": " + throwable));
                                    var12_12 = null;
                                    if (file != null) {
                                        file.close();
                                    }
                                    file = null;
                                    break block13;
                                }
                                var12_12 = null;
                                if (file == null) break block14;
                            }
                            catch (Throwable throwable) {
                                var12_12 = null;
                                if (file != null) {
                                    file.close();
                                }
                                file = null;
                                throw throwable;
                            }
                            file.close();
                        }
                        file = null;
                    }
                }
                ++i;
            }
        }
    }
}

