/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.j2ee.deploy.spi.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.j2ee.deploy.spi.DeploymentManagerImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.TargetModuleIDImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.status.DeploymentStatusImpl;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;

public class ProgressObjectImpl
implements ProgressObject {
    Vector progressListeners = new Vector();
    CommandType command = null;
    DeploymentStatusImpl deploymentStatus = null;
    private int eventCounter = 0;
    private ResourceBundle resBundle = null;
    protected Vector successfulTargetMods = null;
    protected Vector failedTargetMods = null;
    private TargetModuleID[] resultTargetModuleIDs = null;
    private boolean notified = false;
    private static TraceComponent tc = Tr.register((Class)ProgressObjectImpl.class, (String)"Admin", (String)"com.ibm.ws.management.resources.J2eeDeploymentMessages");

    public ProgressObjectImpl(CommandType commandType, ResourceBundle resourceBundle) {
        this(commandType);
        this.resBundle = resourceBundle;
    }

    public ProgressObjectImpl(CommandType commandType) {
        this.command = commandType;
        ResourceBundle resourceBundle = AppUtils.getBundle("com.ibm.ws.management.resources.J2eeDeploymentMessages", Locale.getDefault());
        this.deploymentStatus = new DeploymentStatusImpl(commandType.getValue(), StateType.RUNNING.getValue(), ActionType.EXECUTE.getValue(), resourceBundle, this);
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResultTargetModuleIDs");
        }
        if (this.resultTargetModuleIDs == null && this.successfulTargetMods != null && this.successfulTargetMods.size() > 0 || this.resultTargetModuleIDs != null && this.successfulTargetMods != null && this.successfulTargetMods.size() > 0 && this.resultTargetModuleIDs.length != this.successfulTargetMods.size()) {
            this.resultTargetModuleIDs = new TargetModuleID[this.successfulTargetMods.size()];
            for (int i = 0; i < this.resultTargetModuleIDs.length; ++i) {
                this.resultTargetModuleIDs[i] = (TargetModuleID)this.successfulTargetMods.elementAt(i);
            }
        } else if (this.resultTargetModuleIDs == null) {
            this.resultTargetModuleIDs = new TargetModuleID[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getResultTargetModuleIDs. " + this.resultTargetModuleIDs.length + " successful modules"));
        }
        return this.resultTargetModuleIDs;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        ResourceBundle resourceBundle = AppUtils.getBundle(DeploymentManagerImpl.getLocalePrefs());
        throw new OperationUnsupportedException(AppUtils.getMessage(resourceBundle, "ADMA8005E"));
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        ResourceBundle resourceBundle = AppUtils.getBundle(DeploymentManagerImpl.getLocalePrefs());
        throw new OperationUnsupportedException(AppUtils.getMessage(resourceBundle, "ADMA8006E"));
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.progressListeners.add(progressListener);
        if (!this.notified && (this.deploymentStatus.getState().equals(StateType.COMPLETED) || this.deploymentStatus.getState().equals(StateType.FAILED))) {
            this.notifyListeners(null, this.deploymentStatus);
            this.notified = true;
        }
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.progressListeners.removeElement(progressListener);
    }

    public boolean setFinalStateAndNotify(StateType stateType) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setFinalStateAndNotify");
        }
        boolean bl = false;
        this.decreaseEventCount();
        if (this.eventCounter < 1) {
            this.deploymentStatus.setState(stateType.getValue());
            this.notifyListeners(null, this.deploymentStatus);
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setFinalStateAndNotify", (Object)new Boolean(this.notified));
        }
        return bl;
    }

    public boolean isLast() {
        return this.eventCounter <= 1;
    }

    public void sendModuleEvent(TargetModuleID targetModuleID, StateType stateType, String string, Object[] objectArray) {
        DeploymentStatusImpl deploymentStatusImpl = (DeploymentStatusImpl)this.deploymentStatus.clone();
        deploymentStatusImpl.setState(stateType.getValue());
        if (string != null) {
            deploymentStatusImpl.setMessage(string, objectArray);
        }
        this.notifyListeners(targetModuleID, deploymentStatusImpl);
    }

    private void notifyListeners(TargetModuleID targetModuleID, DeploymentStatus deploymentStatus) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"notifyListeners");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"notifyListeners", (Object)deploymentStatus);
        }
        for (int i = 0; i < this.progressListeners.size(); ++i) {
            try {
                this.notified = true;
                ((ProgressListener)this.progressListeners.elementAt(i)).handleProgressEvent(new ProgressEvent((Object)this, targetModuleID, deploymentStatus));
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADMJ1020E", (Object)new Object[]{throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"notifyListeners");
        }
    }

    public void increaseEventCount() {
        ++this.eventCounter;
    }

    public void decreaseEventCount() {
        --this.eventCounter;
    }

    public void addSuccessfulResult(TargetModuleID targetModuleID) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addSuccessfulResult", (Object)((TargetModuleIDImpl)targetModuleID).getObjectName());
        }
        if (this.successfulTargetMods == null) {
            this.successfulTargetMods = new Vector();
        }
        this.successfulTargetMods.add(targetModuleID);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addSuccessfulResult");
        }
    }

    public void addFailedResult(TargetModuleID targetModuleID) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addFailedResult", (Object)((TargetModuleIDImpl)targetModuleID).getObjectName());
        }
        if (this.failedTargetMods == null) {
            this.failedTargetMods = new Vector();
        }
        this.failedTargetMods.add(targetModuleID);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addFailedResult");
        }
    }
}

