/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs.utils;

import com.ibm.ejs.models.base.bindings.clientbnd.ApplicationClientBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.AbstractAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceEnvRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPConnectionFactoryBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.etools.client.ApplicationClient;
import com.ibm.etools.commonarchive.ApplicationClientFile;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.j2ee.common.EJBLocalRef;
import com.ibm.etools.j2ee.common.EjbRef;
import com.ibm.etools.j2ee.common.ResourceEnvRef;
import com.ibm.etools.j2ee.common.ResourceRef;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import java.io.PrintStream;
import java.util.Iterator;

public class ShowBindingsCmd {
    EARFile ear = null;
    PrintStream out = System.out;

    public ShowBindingsCmd(EARFile eARFile) {
        this.ear = eARFile;
        this.out = System.out;
    }

    public ShowBindingsCmd(EARFile eARFile, PrintStream printStream) {
        this.ear = eARFile;
        this.out = printStream;
    }

    public void execute() {
        this.showBindings(this.ear);
    }

    protected void showBindings(EARFile eARFile) {
        try {
            Iterator iterator = eARFile.getModuleFiles().iterator();
            System.out.println("\n------------------------");
            while (iterator.hasNext()) {
                Archive archive = (Archive)iterator.next();
                if (archive.isEJBJarFile()) {
                    this.showEjbJarBindings((EJBJarFile)archive);
                } else if (archive.isWARFile()) {
                    this.showWarBindings((WARFile)archive);
                } else if (archive.isApplicationClientFile()) {
                    this.showAppClientBindings((ApplicationClientFile)archive);
                }
                this.out.println("\n------------------------\n");
            }
            this.out.println();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.dfltbndngs.utils.ShowBindingsCmd.showBindings", (String)"95", (Object)this);
            this.out.println("ERROR displaying bindings info ... continuing:" + throwable.toString());
        }
    }

    protected void showEjbJarBindings(EJBJarFile eJBJarFile) {
        try {
            AbstractAuthData abstractAuthData;
            Object object;
            String string;
            this.out.println();
            this.out.println(eJBJarFile.getName());
            EJBJarBinding eJBJarBinding = eJBJarFile.getBindings();
            EJBJar eJBJar = eJBJarFile.getDeploymentDescriptor();
            CMPConnectionFactoryBinding cMPConnectionFactoryBinding = eJBJarBinding.getDefaultCMPConnectionFactory();
            if (cMPConnectionFactoryBinding != null && (string = cMPConnectionFactoryBinding.getJndiName()) != null) {
                this.out.println("  Default Connection Factory --> " + string + "," + Preferences.RES_AUTH[cMPConnectionFactoryBinding.getResAuth().getValue()]);
            }
            if ((string = eJBJarBinding.getDefaultDatasource()) != null && (object = string.getJndiName()) != null) {
                abstractAuthData = string.getDefaultAuth();
                this.out.println("  Default Data Source --> " + (String)object + " (" + string.getClass().getName() + ")");
            }
            object = eJBJar.getEnterpriseBeans().iterator();
            while (object.hasNext()) {
                try {
                    ResourceRefBinding resourceRefBinding;
                    Object object2;
                    Object object3;
                    Object object4;
                    Iterator iterator;
                    abstractAuthData = (EnterpriseBean)object.next();
                    EnterpriseBeanBinding enterpriseBeanBinding = eJBJarBinding.getEJBBinding((EnterpriseBean)abstractAuthData);
                    if (abstractAuthData.isMessageDriven()) {
                        this.out.println("  " + abstractAuthData.getName());
                        this.out.println("    port: " + ((MessageDrivenBeanBinding)enterpriseBeanBinding).getListenerInputPortName());
                    } else {
                        this.out.println("  " + abstractAuthData.getName() + " --> " + enterpriseBeanBinding.getJndiName());
                        if (abstractAuthData.isContainerManagedEntity()) {
                            if (eJBJar.isVersion2_0Descriptor()) {
                                iterator = enterpriseBeanBinding.getCmpConnectionFactory();
                                if (iterator != null && iterator.getJndiName() != null) {
                                    this.out.println("    Connection Factory --> " + iterator.getJndiName() + "," + Preferences.RES_AUTH[iterator.getResAuth().getValue()]);
                                } else {
                                    this.out.println("    Connection Factory --> default");
                                }
                            }
                            if (eJBJar.isVersion1_1Descriptor()) {
                                iterator = enterpriseBeanBinding.getDatasource();
                                if (iterator != null && iterator.getJndiName() != null) {
                                    this.out.println("    Data Source --> " + iterator.getJndiName());
                                } else {
                                    this.out.println("    Data Source --> default");
                                }
                            }
                        }
                    }
                    iterator = abstractAuthData.getEjbRefs().iterator();
                    while (iterator.hasNext()) {
                        object4 = (EjbRef)iterator.next();
                        object3 = enterpriseBeanBinding.getEjbRefBinding((EjbRef)object4);
                        this.out.println("    <ejb-ref> java:comp/env/" + object4.getName() + " --> " + object3.getJndiName());
                    }
                    object4 = abstractAuthData.getEjbLocalRefs().iterator();
                    while (object4.hasNext()) {
                        object3 = (EJBLocalRef)object4.next();
                        object2 = enterpriseBeanBinding.getEjbRefBinding((EjbRef)object3);
                        this.out.println("    <ejb-local-ref> java:comp/env/" + object3.getName() + " --> " + object2.getJndiName());
                    }
                    object3 = abstractAuthData.getResourceRefs().iterator();
                    while (object3.hasNext()) {
                        object2 = (ResourceRef)object3.next();
                        resourceRefBinding = enterpriseBeanBinding.getResRefBinding((ResourceRef)object2);
                        this.out.println("    <resource-ref> java:comp/env/" + object2.getName() + " --> " + resourceRefBinding.getJndiName());
                    }
                    object2 = abstractAuthData.getResourceEnvRefs().iterator();
                    while (object2.hasNext()) {
                        resourceRefBinding = (ResourceEnvRef)object3.next();
                        ResourceEnvRefBinding resourceEnvRefBinding = enterpriseBeanBinding.getResEnvRefBinding((ResourceEnvRef)resourceRefBinding);
                        this.out.println("    <resource-env-ref> java:comp/env/" + resourceRefBinding.getName() + " --> " + resourceEnvRefBinding.getJndiName());
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.dfltbndngs.utils.ShowBindingsCmd.showEjbJarBindings", (String)"238", (Object)this);
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.dfltbndngs.utils.ShowBindingsCmd.showEjbJarBindings", (String)"243", (Object)this);
        }
    }

    protected void showWarBindings(WARFile wARFile) {
        Object object;
        Object object2;
        WebApp webApp = wARFile.getDeploymentDescriptor();
        WebAppBinding webAppBinding = wARFile.getBindings();
        this.out.println();
        this.out.println(wARFile.getName());
        this.out.println("  <virtual-host> --> " + webAppBinding.getVirtualHostName());
        Iterator iterator = webAppBinding.getEjbRefBindings().iterator();
        while (iterator.hasNext()) {
            object2 = (EjbRefBinding)iterator.next();
            this.out.println("  <ejb-ref> java:comp/env/" + object2.getBindingEjbRef().getName() + " --> " + object2.getJndiName());
        }
        object2 = webAppBinding.getResRefBindings().iterator();
        while (object2.hasNext()) {
            object = (ResourceRefBinding)object2.next();
            this.out.println("    <resource-ref> java:comp/env/" + object.getBindingResourceRef().getName() + " --> " + object.getJndiName());
        }
        object = webAppBinding.getResourceEnvRefBindings().iterator();
        while (object.hasNext()) {
            ResourceEnvRefBinding resourceEnvRefBinding = (ResourceEnvRefBinding)object.next();
            this.out.println("    <resource-env-ref> java:comp/env/" + resourceEnvRefBinding.getBindingResourceEnvRef().getName() + " --> " + resourceEnvRefBinding.getJndiName());
        }
    }

    protected void showAppClientBindings(ApplicationClientFile applicationClientFile) {
        Object object;
        Object object2;
        ApplicationClient applicationClient = applicationClientFile.getDeploymentDescriptor();
        ApplicationClientBinding applicationClientBinding = applicationClientFile.getBindings();
        this.out.println();
        this.out.println(applicationClientFile.getName());
        Iterator iterator = applicationClientBinding.getEjbRefs().iterator();
        while (iterator.hasNext()) {
            object2 = (EjbRefBinding)iterator.next();
            this.out.println("  <ejb-ref> java:comp/env/" + object2.getBindingEjbRef().getName() + " --> " + object2.getJndiName());
        }
        object2 = applicationClientBinding.getResourceRefs().iterator();
        while (object2.hasNext()) {
            object = (ResourceRefBinding)object2.next();
            this.out.println("    <resource-ref> java:comp/env/" + (object.getBindingResourceRef() != null ? object.getBindingResourceRef().getName() : "???") + " --> " + object.getJndiName());
        }
        object = applicationClientBinding.getResourceEnvRefBindings().iterator();
        while (object.hasNext()) {
            ResourceEnvRefBinding resourceEnvRefBinding = (ResourceEnvRefBinding)object.next();
            this.out.println("    <resource-env-ref> java:comp/env/" + (resourceEnvRefBinding.getBindingResourceEnvRef() != null ? resourceEnvRefBinding.getBindingResourceEnvRef().getName() : "???") + " --> " + resourceEnvRefBinding.getJndiName());
        }
    }
}

