/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs.utils;

import com.ibm.ejs.models.base.bindings.clientbnd.ApplicationClientBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.CommonbndFactoryImpl;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.ClientModuleRef;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBModuleRef;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.etools.commonarchive.WebModuleRef;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.j2ee.common.EjbRef;
import com.ibm.ws.management.application.dfltbndngs.utils.EJBRefPkg;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class GetEjbRefs {
    static TraceComponent tc = Tr.register((Class)GetEjbRefs.class, null, (String)"com.ibm.ws.management.application.dfltbndngs.utils.GetEjbRefs");
    protected EARFile earFile;
    protected Vector ejbRefs;
    protected boolean created = false;

    public GetEjbRefs(EARFile eARFile) {
        this.earFile = eARFile;
    }

    public GetEjbRefs(EARFile eARFile, boolean bl) {
        this.earFile = eARFile;
        this.created = bl;
    }

    public Collection execute() throws Exception {
        this.ejbRefs = new Vector();
        List list = this.earFile.getWebModuleRefs();
        for (int i = 0; i < list.size(); ++i) {
            WebModuleRef webModuleRef = (WebModuleRef)list.get(i);
            this.addRefs(webModuleRef);
        }
        List list2 = this.earFile.getEJBModuleRefs();
        for (int i = 0; i < list2.size(); ++i) {
            EJBModuleRef eJBModuleRef = (EJBModuleRef)list2.get(i);
            this.addRefs(eJBModuleRef);
        }
        List list3 = this.earFile.getClientModuleRefs();
        for (int i = 0; i < list3.size(); ++i) {
            ClientModuleRef clientModuleRef = (ClientModuleRef)list3.get(i);
            this.addRefs(clientModuleRef);
        }
        return this.ejbRefs;
    }

    protected void addRefs(WebModuleRef webModuleRef) throws Exception {
        EList eList = webModuleRef.getWebAppBinding().getEjbRefBindings();
        EList eList2 = webModuleRef.getWebApp().getEjbRefs();
        this.addRefs(webModuleRef, (List)eList2, (List)eList);
        EList eList3 = webModuleRef.getWebApp().getEjbLocalRefs();
        this.addRefs(webModuleRef, (List)eList3, (List)eList);
    }

    protected void addRefs(ClientModuleRef clientModuleRef) throws Exception {
        ApplicationClientBinding applicationClientBinding = clientModuleRef.getApplicationClientBinding();
        EList eList = applicationClientBinding.getEjbRefs();
        EList eList2 = clientModuleRef.getApplicationClient().getEjbReferences();
        this.addRefs(clientModuleRef, (Collection)eList2, (Collection)eList);
    }

    protected void addRefs(EJBModuleRef eJBModuleRef) throws Exception {
        EJBJar eJBJar = eJBModuleRef.getEJBJar();
        EJBJarBinding eJBJarBinding = eJBModuleRef.getEJBJarBinding();
        EList eList = eJBJar.getEnterpriseBeans();
        for (int i = 0; i < eList.size(); ++i) {
            EnterpriseBean enterpriseBean = (EnterpriseBean)eList.get(i);
            EnterpriseBeanBinding enterpriseBeanBinding = eJBJarBinding.getEJBBinding(enterpriseBean);
            EList eList2 = enterpriseBeanBinding.getEjbRefBindings();
            this.addRefs(eJBModuleRef, eJBJar, enterpriseBean, (Collection)enterpriseBean.getEjbRefs(), (Collection)eList2);
            this.addRefs(eJBModuleRef, eJBJar, enterpriseBean, (Collection)enterpriseBean.getEjbLocalRefs(), (Collection)eList2);
        }
    }

    protected void addRefs(WebModuleRef webModuleRef, List list, List list2) {
        for (int i = 0; i < list.size(); ++i) {
            EjbRef ejbRef = (EjbRef)list.get(i);
            if (this.created) {
                this.ensureBinding(list2, ejbRef);
                continue;
            }
            EJBRefPkg eJBRefPkg = new EJBRefPkg();
            eJBRefPkg.setRefBinding(this.ensureBinding(list2, ejbRef));
            eJBRefPkg.setQualifier(this.qualify((ModuleRef)webModuleRef));
            this.ejbRefs.addElement(eJBRefPkg);
        }
    }

    protected void addRefs(ClientModuleRef clientModuleRef, Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            EjbRef ejbRef = (EjbRef)iterator.next();
            if (this.created) {
                this.ensureBinding(collection2, ejbRef);
                continue;
            }
            EJBRefPkg eJBRefPkg = new EJBRefPkg();
            eJBRefPkg.setRefBinding(this.ensureBinding(collection2, ejbRef));
            eJBRefPkg.setQualifier(this.qualify((ModuleRef)clientModuleRef));
            this.ejbRefs.addElement(eJBRefPkg);
        }
    }

    protected void addRefs(EJBModuleRef eJBModuleRef, EJBJar eJBJar, EnterpriseBean enterpriseBean, Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            EjbRef ejbRef = (EjbRef)iterator.next();
            if (this.created) {
                this.ensureBinding(collection2, ejbRef);
                continue;
            }
            EJBRefPkg eJBRefPkg = new EJBRefPkg();
            eJBRefPkg.setRefBinding(this.ensureBinding(collection2, ejbRef));
            eJBRefPkg.setQualifier(this.qualify(eJBModuleRef, eJBJar, enterpriseBean));
            this.ejbRefs.addElement(eJBRefPkg);
        }
    }

    protected EjbRefBinding ensureBinding(Collection collection, EjbRef ejbRef) {
        EjbRefBinding ejbRefBinding = this.locateBinding(collection, ejbRef);
        if (ejbRefBinding == null) {
            ejbRefBinding = this.createBinding(ejbRef);
            collection.add(ejbRefBinding);
        }
        return ejbRefBinding;
    }

    protected EjbRefBinding locateBinding(Collection collection, EjbRef ejbRef) {
        EjbRefBinding ejbRefBinding = null;
        Iterator iterator = collection.iterator();
        while (ejbRefBinding == null && iterator.hasNext()) {
            EjbRefBinding ejbRefBinding2 = (EjbRefBinding)iterator.next();
            EjbRef ejbRef2 = ejbRefBinding2.getBindingEjbRef();
            if (ejbRef2 == null) {
                System.out.println("WCCM.WARNING: EjbRefBinding has no binding EJB Ref: " + ejbRef);
                continue;
            }
            if (!ejbRef2.equals(ejbRef)) continue;
            ejbRefBinding = ejbRefBinding2;
        }
        return ejbRefBinding;
    }

    protected EjbRefBinding createBinding(EjbRef ejbRef) {
        EjbRefBinding ejbRefBinding = CommonbndFactoryImpl.getActiveFactory().createEjbRefBinding();
        ejbRefBinding.setBindingEjbRef(ejbRef);
        return ejbRefBinding;
    }

    protected String qualify(ModuleRef moduleRef) {
        return moduleRef.getModule().getUri();
    }

    protected String qualify(EJBModuleRef eJBModuleRef, EJBJar eJBJar, EnterpriseBean enterpriseBean) {
        return this.qualify(eJBModuleRef, eJBJar) + ":" + this.qualify(enterpriseBean);
    }

    protected String qualify(EJBModuleRef eJBModuleRef, EJBJar eJBJar) {
        String string = eJBJar.getDisplayName();
        if (string == null) {
            string = this.qualify((ModuleRef)eJBModuleRef);
        }
        return string;
    }

    protected String qualify(EnterpriseBean enterpriseBean) {
        String string = enterpriseBean.getDisplayName();
        if (string == null) {
            string = enterpriseBean.getEjbClassName();
        }
        return string;
    }
}

