/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.commonext.CommonextFactory;
import com.ibm.ejs.models.base.extensions.commonext.CommonextPackage;
import com.ibm.ejs.models.base.extensions.commonext.IsolationLevelKind;
import com.ibm.ejs.models.base.extensions.commonext.ResourceRefExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextFactory;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextPackage;
import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.ejb.EJBJar;
import com.ibm.etools.ejb.EnterpriseBean;
import com.ibm.etools.j2ee.common.ResourceRef;
import com.ibm.etools.j2ee.common.XMLResource;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.client.CorrectOracleIsolationLevel;
import com.ibm.ws.management.application.client.util;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public class CorrectOracleIsolationLevelHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register((Class)CorrectOracleIsolationLevelHelper.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");

    public AppDeploymentTask createTask(AppDeploymentController appDeploymentController, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createTask");
        }
        try {
            String string2 = this.getClass().getName();
            int n = string2.lastIndexOf("Helper");
            Class<?> clazz = Class.forName(string2.substring(0, n));
            Constructor<?> constructor = clazz.getDeclaredConstructor(AppDeploymentController.class);
            return (AppDeploymentTask)constructor.newInstance(appDeploymentController);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error instantiating task" + exception));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareTask");
        }
        if (appDeploymentTask.getTaskData() != null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = appDeploymentTask.getColumnNames();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        this.prepareForEJB(appDeploymentInfo, vector);
        this.prepareForWAR(appDeploymentInfo, vector);
        String[][] stringArray2 = util.buildTaskData(vector, stringArray.length);
        appDeploymentTask.setTaskData(stringArray2);
        ((CorrectOracleIsolationLevel)appDeploymentTask).saveTaskData(stringArray2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareTask");
        }
    }

    private void prepareForEJB(AppDeploymentInfo appDeploymentInfo, Vector vector) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareForEJB");
        }
        Vector vector2 = appDeploymentInfo.getModuleConfig("JAR_DD");
        Vector vector3 = appDeploymentInfo.getModuleConfig("JAR_BND");
        Vector vector4 = appDeploymentInfo.getModuleConfig("JAR_EXT");
        for (int i = 0; i < vector3.size(); ++i) {
            EJBJarBinding eJBJarBinding = (EJBJarBinding)vector3.elementAt(i);
            EJBJar eJBJar = (EJBJar)vector2.elementAt(i);
            EJBJarExtension eJBJarExtension = (EJBJarExtension)vector4.elementAt(i);
            Iterator iterator = eJBJar.getEnterpriseBeans().iterator();
            while (iterator.hasNext()) {
                EnterpriseBean enterpriseBean = (EnterpriseBean)iterator.next();
                EnterpriseBeanBinding enterpriseBeanBinding = eJBJarBinding.getEJBBinding(enterpriseBean);
                Iterator iterator2 = enterpriseBean.getResourceRefs().iterator();
                while (iterator2.hasNext()) {
                    this.getIsolationLevel(appDeploymentInfo, (ResourceRef)iterator2.next(), (List)enterpriseBeanBinding.getResRefBindings(), (EObject)eJBJarExtension, (EObject)eJBJar, vector);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareForEJB");
        }
    }

    private void prepareForWAR(AppDeploymentInfo appDeploymentInfo, Vector vector) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareForWAR");
        }
        Vector vector2 = appDeploymentInfo.getModuleConfig("WAR_DD");
        Vector vector3 = appDeploymentInfo.getModuleConfig("WAR_BND");
        Vector vector4 = appDeploymentInfo.getModuleConfig("WAR_EXT");
        for (int i = 0; i < vector3.size(); ++i) {
            WebApp webApp = (WebApp)vector2.get(i);
            WebAppBinding webAppBinding = (WebAppBinding)vector3.get(i);
            WebAppExtension webAppExtension = (WebAppExtension)vector4.get(i);
            Iterator iterator = webApp.getResourceRefs().iterator();
            while (iterator.hasNext()) {
                this.getIsolationLevel(appDeploymentInfo, (ResourceRef)iterator.next(), (List)webAppBinding.getResRefBindings(), (EObject)webAppExtension, (EObject)webApp, vector);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareForWAR");
        }
    }

    private void getIsolationLevel(AppDeploymentInfo appDeploymentInfo, ResourceRef resourceRef, List list, EObject eObject, EObject eObject2, Vector vector) throws AppDeploymentException {
        ResourceRefBinding resourceRefBinding;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getIsolationLevel");
        }
        if ((resourceRefBinding = this.findResRefBinding(resourceRef, list)) == null) {
            return;
        }
        if (((XMLResource)resourceRef.eResource()).getVersionID() >= 13) {
            ResourceRefExtension resourceRefExtension = this.findExtension(eObject, resourceRef);
            IsolationLevelKind isolationLevelKind = null;
            if (resourceRefExtension != null) {
                isolationLevelKind = resourceRefExtension.getIsolationLevel();
            }
            if (isolationLevelKind == null || isolationLevelKind.getValue() != 2 && isolationLevelKind.getValue() != 8) {
                this.addTaskData(appDeploymentInfo, eObject2, resourceRef, resourceRefBinding, isolationLevelKind == null ? null : new Integer(isolationLevelKind.getValue()), vector);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getIsolationLevel");
        }
    }

    private ResourceRefExtension findExtension(EObject eObject, ResourceRef resourceRef) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findExtension");
        }
        ResourceRefExtension resourceRefExtension = null;
        if (eObject != null && resourceRef != null) {
            if (eObject instanceof EJBJarExtension) {
                resourceRefExtension = this.findExtension((EJBJarExtension)eObject, resourceRef);
            } else if (eObject instanceof WebAppExtension) {
                resourceRefExtension = this.findExtension((WebAppExtension)eObject, resourceRef);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unknown ref object: " + eObject));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findExtension");
        }
        return resourceRefExtension;
    }

    private ResourceRefExtension findExtension(EJBJarExtension eJBJarExtension, ResourceRef resourceRef) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findExtension");
        }
        ResourceRefExtension resourceRefExtension = null;
        if (resourceRef != null && eJBJarExtension != null) {
            Iterator iterator = eJBJarExtension.getEjbExtensions().iterator();
            block0: while (iterator.hasNext()) {
                EnterpriseBeanExtension enterpriseBeanExtension = (EnterpriseBeanExtension)iterator.next();
                Iterator iterator2 = enterpriseBeanExtension.getResourceRefExtensions().iterator();
                while (iterator2.hasNext()) {
                    ResourceRefExtension resourceRefExtension2 = (ResourceRefExtension)iterator2.next();
                    ResourceRef resourceRef2 = resourceRefExtension2.getResourceRef();
                    if (resourceRef2 != resourceRef) continue;
                    resourceRefExtension = resourceRefExtension2;
                    continue block0;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findExtension");
        }
        return resourceRefExtension;
    }

    private ResourceRefExtension findExtension(WebAppExtension webAppExtension, ResourceRef resourceRef) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findExtension");
        }
        ResourceRefExtension resourceRefExtension = null;
        if (resourceRef != null && webAppExtension != null) {
            Iterator iterator = webAppExtension.getResourceRefExtensions().iterator();
            while (iterator.hasNext()) {
                ResourceRefExtension resourceRefExtension2 = (ResourceRefExtension)iterator.next();
                ResourceRef resourceRef2 = resourceRefExtension2.getResourceRef();
                if (resourceRef2 != resourceRef) continue;
                resourceRefExtension = resourceRefExtension2;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findExtension");
        }
        return resourceRefExtension;
    }

    private EnterpriseBeanExtension findExtension(EJBJarExtension eJBJarExtension, EnterpriseBean enterpriseBean) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findExtension");
        }
        EnterpriseBeanExtension enterpriseBeanExtension = null;
        if (enterpriseBean != null && eJBJarExtension != null) {
            Iterator iterator = eJBJarExtension.getEjbExtensions().iterator();
            while (iterator.hasNext()) {
                EnterpriseBeanExtension enterpriseBeanExtension2 = (EnterpriseBeanExtension)iterator.next();
                if (enterpriseBeanExtension2.getEnterpriseBean() != enterpriseBean) continue;
                enterpriseBeanExtension = enterpriseBeanExtension2;
                break;
            }
        }
        return enterpriseBeanExtension;
    }

    private ResourceRefBinding findResRefBinding(ResourceRef resourceRef, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findResRefBinding");
        }
        ResourceRefBinding resourceRefBinding = null;
        for (int i = 0; resourceRefBinding == null && i < list.size(); ++i) {
            ResourceRefBinding resourceRefBinding2 = (ResourceRefBinding)list.get(i);
            if (resourceRefBinding2.getBindingResourceRef() != resourceRef) continue;
            resourceRefBinding = resourceRefBinding2;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findResRefBinding");
        }
        return resourceRefBinding;
    }

    private void addTaskData(AppDeploymentInfo appDeploymentInfo, EObject eObject, ResourceRef resourceRef, ResourceRefBinding resourceRefBinding, Integer n, Vector vector) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addTaskData");
        }
        vector.addElement(util.getModuleName(appDeploymentInfo, eObject));
        vector.addElement(resourceRef.getName());
        vector.addElement(resourceRefBinding.getJndiName());
        if (n != null) {
            vector.addElement(n.toString());
        } else {
            vector.addElement("");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addTaskData");
        }
    }

    public void completeTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"completeTask");
        }
        if (!appDeploymentTask.isTaskEmpty()) {
            this.completeForEJB(appDeploymentInfo, appDeploymentTask);
            this.completeForWAR(appDeploymentInfo, appDeploymentTask);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"completeTask");
        }
    }

    private void completeForEJB(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"completeForEJB");
        }
        Vector vector = appDeploymentInfo.getModuleConfig("JAR_DD");
        Vector vector2 = appDeploymentInfo.getModuleConfig("JAR_BND");
        Vector vector3 = appDeploymentInfo.getModuleConfig("JAR_EXT");
        for (int i = 0; i < vector2.size(); ++i) {
            EJBJarBinding eJBJarBinding = (EJBJarBinding)vector2.elementAt(i);
            EJBJar eJBJar = (EJBJar)vector.elementAt(i);
            EJBJarExtension eJBJarExtension = (EJBJarExtension)vector3.elementAt(i);
            Iterator iterator = eJBJar.getEnterpriseBeans().iterator();
            while (iterator.hasNext()) {
                EnterpriseBean enterpriseBean = (EnterpriseBean)iterator.next();
                EnterpriseBeanBinding enterpriseBeanBinding = eJBJarBinding.getEJBBinding(enterpriseBean);
                Iterator iterator2 = enterpriseBean.getResourceRefs().iterator();
                while (iterator2.hasNext()) {
                    this.findIsolationLevel(appDeploymentInfo, appDeploymentTask, (ResourceRef)iterator2.next(), (List)enterpriseBeanBinding.getResRefBindings(), (EObject)eJBJarExtension, (EObject)eJBJar, enterpriseBean);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"completeForEJB");
        }
    }

    private void completeForWAR(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"completeForWAR");
        }
        Vector vector = appDeploymentInfo.getModuleConfig("WAR_DD");
        Vector vector2 = appDeploymentInfo.getModuleConfig("WAR_BND");
        Vector vector3 = appDeploymentInfo.getModuleConfig("WAR_EXT");
        for (int i = 0; i < vector2.size(); ++i) {
            WebApp webApp = (WebApp)vector.get(i);
            WebAppBinding webAppBinding = (WebAppBinding)vector2.get(i);
            WebAppExtension webAppExtension = (WebAppExtension)vector3.get(i);
            Iterator iterator = webApp.getResourceRefs().iterator();
            while (iterator.hasNext()) {
                this.findIsolationLevel(appDeploymentInfo, appDeploymentTask, (ResourceRef)iterator.next(), (List)webAppBinding.getResRefBindings(), (EObject)webAppExtension, (EObject)webApp, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"compareForWAR");
        }
    }

    private void findIsolationLevel(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask, ResourceRef resourceRef, List list, EObject eObject, EObject eObject2, EnterpriseBean enterpriseBean) throws AppDeploymentException {
        ResourceRefBinding resourceRefBinding;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findIsolationLevel");
        }
        if ((resourceRefBinding = this.findResRefBinding(resourceRef, list)) == null) {
            return;
        }
        String[] stringArray = this.findTaskData(appDeploymentInfo, appDeploymentTask, resourceRef, resourceRefBinding, eObject2);
        if (stringArray == null) {
            return;
        }
        ResourceRefExtension resourceRefExtension = this.findExtension(eObject, resourceRef);
        IsolationLevelKind isolationLevelKind = null;
        if (resourceRefExtension != null) {
            isolationLevelKind = resourceRefExtension.getIsolationLevel();
        }
        CorrectOracleIsolationLevel correctOracleIsolationLevel = (CorrectOracleIsolationLevel)appDeploymentTask;
        if (stringArray.length > CorrectOracleIsolationLevel.isolationLevelColumn) {
            String string = stringArray[CorrectOracleIsolationLevel.isolationLevelColumn];
            try {
                if (Integer.valueOf(string) != 2 && Integer.valueOf(string) != 8) {
                    throw new AppDeploymentException(MessageFormat.format(util.getMessage(appDeploymentTask, "ADMA0025E"), resourceRef.getName(), util.getModuleName(appDeploymentInfo, eObject2)), null);
                }
                if (resourceRefExtension == null) {
                    resourceRefExtension = this.createResourceRefExtension(appDeploymentInfo, resourceRef, eObject, eObject2, enterpriseBean);
                }
                resourceRefExtension.setIsolationLevel(IsolationLevelKind.get((int)Integer.parseInt(string)));
            }
            catch (NumberFormatException numberFormatException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Isolation level not in number format: " + string + " " + numberFormatException));
                }
                throw new AppDeploymentException(MessageFormat.format(util.getMessage(appDeploymentTask, "ADMA0026E"), string), numberFormatException);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Missing isolation level column for resource ref " + resourceRef.getName() + " for module " + util.getModuleName(appDeploymentInfo, eObject2)));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findIsolationLevel");
        }
    }

    private ResourceRefExtension createResourceRefExtension(AppDeploymentInfo appDeploymentInfo, ResourceRef resourceRef, EObject eObject, EObject eObject2, EnterpriseBean enterpriseBean) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createResourceRefExtension");
        }
        CommonextFactory commonextFactory = ((CommonextPackage)EPackage.Registry.INSTANCE.getEPackage("commonext.xmi")).getCommonextFactory();
        ResourceRefExtension resourceRefExtension = commonextFactory.createResourceRefExtension();
        resourceRefExtension.setResourceRef(resourceRef);
        if (enterpriseBean != null) {
            this.addResourceRefExtension(appDeploymentInfo, (EJBJar)eObject2, (EJBJarExtension)eObject, enterpriseBean, resourceRefExtension);
        } else if (eObject2 instanceof WebApp) {
            this.addResourceRefExtension(appDeploymentInfo, (WebApp)eObject2, (WebAppExtension)eObject, resourceRefExtension);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createResourceRefExtension");
        }
        return resourceRefExtension;
    }

    private void addResourceRefExtension(AppDeploymentInfo appDeploymentInfo, EJBJar eJBJar, EJBJarExtension eJBJarExtension, EnterpriseBean enterpriseBean, ResourceRefExtension resourceRefExtension) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addResourceRefExtension");
        }
        Object object = null;
        EJBJarExtension eJBJarExtension2 = eJBJarExtension;
        object = this.findExtension(eJBJarExtension2, enterpriseBean);
        if (object == null) {
            EjbextFactory ejbextFactory = ((EjbextPackage)EPackage.Registry.INSTANCE.getEPackage("ejbext.xmi")).getEjbextFactory();
            object = enterpriseBean.isEntity() ? ejbextFactory.createEntityExtension() : ejbextFactory.createSessionExtension();
            object.setEnterpriseBean(enterpriseBean);
            object.setEjbJarExtension(eJBJarExtension2);
            eJBJarExtension2.getEjbExtensions().add(object);
        }
        object.getResourceRefExtensions().add((Object)resourceRefExtension);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addResourceRefExtension");
        }
    }

    private void addResourceRefExtension(AppDeploymentInfo appDeploymentInfo, WebApp webApp, WebAppExtension webAppExtension, ResourceRefExtension resourceRefExtension) throws AppDeploymentException {
        WebAppExtension webAppExtension2 = webAppExtension;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addResourceRefExtension");
        }
        webAppExtension2.getResourceRefExtensions().add((Object)resourceRefExtension);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addResourceRefExtension");
        }
    }

    private String[] findTaskData(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask, ResourceRef resourceRef, ResourceRefBinding resourceRefBinding, EObject eObject) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findTaskData");
        }
        CorrectOracleIsolationLevel correctOracleIsolationLevel = (CorrectOracleIsolationLevel)appDeploymentTask;
        String[] stringArray = null;
        String[][] stringArray2 = appDeploymentTask.getTaskData();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].length <= CorrectOracleIsolationLevel.jndiColumn) continue;
            if (!resourceRef.getName().equals(stringArray2[i][CorrectOracleIsolationLevel.refBindingColumn])) continue;
            if (!util.getModuleName(appDeploymentInfo, eObject).equals(stringArray2[i][CorrectOracleIsolationLevel.moduleColumn])) continue;
            if (!resourceRefBinding.getJndiName().equals(stringArray2[i][CorrectOracleIsolationLevel.jndiColumn])) continue;
            stringArray = stringArray2[i];
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findTaskData");
        }
        return stringArray;
    }
}

