/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtension;
import com.ibm.ejs.models.base.extensions.applicationext.ApplicationextPackage;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentProfile;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.ArchiveDeploymentInfo;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appcfg.AppcfgFactory;
import com.ibm.websphere.models.config.appcfg.AppcfgPackage;
import com.ibm.websphere.models.config.appcfg.ApplicationConfig;
import com.ibm.websphere.models.config.appcfg.DeployedObjectConfig;
import com.ibm.websphere.models.config.appcfg.impl.AppcfgPackageImpl;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionManager;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.classloader.ClassLoaderPolicy;
import com.ibm.websphere.models.config.classloader.ClassLoadingMode;
import com.ibm.websphere.models.config.classloader.Classloader;
import com.ibm.websphere.models.config.classloader.ClassloaderFactory;
import com.ibm.websphere.models.config.classloader.ClassloaderPackage;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeployUtil;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentHelper;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.wtp.emf.utilities.copy.EtoolsCopyUtility;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class AppDeploymentOptionsHelper
implements AppDeploymentTaskHelper,
J2EEDeploymentHelper {
    private static TraceComponent tc = Tr.register((Class)AppDeploymentOptionsHelper.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static ClassloaderFactory _gClassloaderFactory;
    private static AppcfgFactory _appCfgFactory;

    public AppDeploymentTask createTask(AppDeploymentController appDeploymentController, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createTask");
        }
        try {
            String string2 = this.getClass().getName();
            int n = string2.lastIndexOf("Helper");
            Class<?> clazz = Class.forName(string2.substring(0, n));
            Constructor<?> constructor = clazz.getDeclaredConstructor(AppDeploymentController.class);
            return (AppDeploymentTask)constructor.newInstance(appDeploymentController);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error instantiating task" + exception));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareTask");
        }
        if (appDeploymentTask.getTaskData() != null) {
            return;
        }
        Vector vector = AppDeploymentProfile.getProfile(appDeploymentTask.getAppDeploymentController().getDeploymentMode());
        if (vector.size() == 0) {
            appDeploymentTask.setIsTaskDisabled(true);
            appDeploymentTask.setTaskData(null);
            return;
        }
        String[][] stringArray = new String[2][vector.size()];
        ApplicationDeployment applicationDeployment = ((ArchiveDeploymentInfo)appDeploymentInfo).getAppDeploymentObject(true);
        Hashtable hashtable = appDeploymentTask.getAppDeploymentController().getAppOptions();
        for (int i = 0; i < vector.size(); ++i) {
            AppDeploymentProfile.DeplOption deplOption = (AppDeploymentProfile.DeplOption)vector.elementAt(i);
            String string = "";
            Object object = this.getOptionValue(appDeploymentInfo, hashtable, applicationDeployment, deplOption);
            string = Boolean.TRUE.equals(object) ? "AppDeploymentOption.Yes" : (Boolean.FALSE.equals(object) ? "AppDeploymentOption.No" : string + object);
            stringArray[0][i] = deplOption.name;
            stringArray[1][i] = string;
        }
        appDeploymentTask.setTaskData(stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareTask");
        }
    }

    private Object getOptionValue(AppDeploymentInfo appDeploymentInfo, Hashtable hashtable, ApplicationDeployment applicationDeployment, AppDeploymentProfile.DeplOption deplOption) {
        Object object;
        block30: {
            object = hashtable.get(deplOption.name);
            if (object != null) {
                return object;
            }
            if (deplOption.name.equals("installed.ear.destination") && (object = AppDeploymentOptionsHelper.readFromAppDepl(applicationDeployment, deplOption.attr)) != null) {
                object = AppUtils.getInstallDirFromBinariesURL(applicationDeployment);
            }
            if (deplOption.name.equals("appname")) {
                object = appDeploymentInfo.getAppDisplayName();
            } else if (deplOption.name.equals("edition")) {
                if (applicationDeployment == null) {
                    object = "";
                } else {
                    String string = ((ContextResourceSet)applicationDeployment.eResource().getResourceSet()).getContext().getName();
                    object = EditionHelper.getAppAndEdition(string)[1];
                }
            } else {
                if (deplOption.name.equals("edition.desc")) {
                    try {
                        if (applicationDeployment != null) {
                            RepositoryContext repositoryContext = ((ContextResourceSet)applicationDeployment.eResource().getResourceSet()).getContext();
                            Properties properties = AppUtils.getEditionProps(repositoryContext);
                            object = properties.getProperty(EditionHelper.getEditionDescPropName(repositoryContext.getName()), "");
                            break block30;
                        }
                        object = "";
                    }
                    catch (AdminException adminException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Error reading edition props: " + (Object)((Object)adminException)));
                        }
                        break block30;
                    }
                }
                if (deplOption.name.equals("distributeApp")) {
                    object = AppDeploymentOptionsHelper.readFromAppDepl(applicationDeployment, deplOption.attr);
                } else if (deplOption.name.equals("useMetaDataFromBinary")) {
                    object = AppDeploymentOptionsHelper.readFromAppDepl(applicationDeployment, deplOption.attr);
                } else if (deplOption.name.equals("createMBeansForResources")) {
                    object = AppDeploymentOptionsHelper.readFromAppDepl(applicationDeployment, deplOption.attr);
                } else if (deplOption.name.equals("reloadEnabled")) {
                    ApplicationExtension applicationExtension;
                    object = AppDeploymentOptionsHelper.readFromAppDepl(applicationDeployment, deplOption.attr);
                    if (object == null && (applicationExtension = appDeploymentInfo.getApplicationExtensions()) != null && applicationExtension.eIsSet((EStructuralFeature)ApplicationextPackage.eINSTANCE.getApplicationExtension_ReloadInterval())) {
                        object = Boolean.TRUE;
                    }
                } else if (deplOption.name.equals("reloadInterval")) {
                    ApplicationExtension applicationExtension;
                    object = AppDeploymentOptionsHelper.readFromAppDepl(applicationDeployment, deplOption.attr);
                    if (object == null && (applicationExtension = appDeploymentInfo.getApplicationExtensions()) != null && applicationExtension.eIsSet((EStructuralFeature)ApplicationextPackage.eINSTANCE.getApplicationExtension_ReloadInterval())) {
                        object = applicationExtension.eGet((EStructuralFeature)ApplicationextPackage.eINSTANCE.getApplicationExtension_ReloadInterval());
                    }
                } else if (deplOption.name.equals("processEmbeddedConfig")) {
                    object = AppConstants.APPDEPL_PROCESS_EMBEDDEDCFG_INSTALL_DEFAULT;
                    if (!((ArchiveDeploymentInfo)appDeploymentInfo).checkIfEnhancedEar()) {
                        object = Boolean.FALSE;
                    }
                } else if (deplOption.name.equals("deployejb")) {
                    object = new Boolean(!((ArchiveDeploymentInfo)appDeploymentInfo).checkIfEarDeployed());
                }
            }
        }
        if (object != null) {
            return object;
        }
        return deplOption.defaultVal;
    }

    private static Object readFromAppDepl(ApplicationDeployment applicationDeployment, EAttribute eAttribute) {
        if (applicationDeployment == null) {
            return null;
        }
        if (applicationDeployment.eIsSet((EStructuralFeature)eAttribute)) {
            return applicationDeployment.eGet((EStructuralFeature)eAttribute);
        }
        return null;
    }

    public void completeTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"completeTask");
        }
        if (appDeploymentTask.isTaskDisabled()) {
            return;
        }
        if (!appDeploymentTask.isTaskEmpty()) {
            String[][] stringArray = appDeploymentTask.getTaskData();
            for (int i = 0; i < stringArray[0].length; ++i) {
                Object object = stringArray[1][i];
                if (object == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("NULL data for col : " + stringArray[0][i]));
                    continue;
                }
                if ("AppDeploymentOption.Yes".equals(object)) {
                    object = Boolean.TRUE;
                } else if ("AppDeploymentOption.No".equals(object)) {
                    object = Boolean.FALSE;
                }
                appDeploymentTask.getAppDeploymentController().getAppOptions().put(stringArray[0][i], object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"completeTask");
        }
    }

    private static boolean valueIsEmpty(Object object) {
        if (object instanceof String) {
            return AppUtils.isEmpty((String)object);
        }
        return object == null;
    }

    public static void saveAppOptions(long l, Scheduler scheduler, ApplicationDeployment applicationDeployment, RepositoryContext repositoryContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"saveAppOptions");
        }
        Hashtable hashtable = scheduler.getProperties();
        Vector vector = AppDeploymentProfile.getProfile(l);
        vector.addAll(AppDeploymentProfile.getHidden(l));
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            Properties properties;
            RepositoryContext repositoryContext2;
            AppDeploymentProfile.DeplOption deplOption = (AppDeploymentProfile.DeplOption)vector.elementAt(i);
            Object object = hashtable.get(deplOption.name);
            if (AppDeploymentOptionsHelper.valueIsEmpty(object) && (l & 0x110L) != 0L) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Option " + deplOption.name + " not found in options table and hence not set in ApplicationDeployment"));
                continue;
            }
            if (AppDeploymentOptionsHelper.valueIsEmpty(object) && deplOption.attr != null && applicationDeployment.eIsSet((EStructuralFeature)deplOption.attr)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Value for " + deplOption.name + " not passed in but already set in deployment.xml"));
                continue;
            }
            Object v = object;
            if (AppDeploymentOptionsHelper.valueIsEmpty(object)) {
                object = deplOption.defaultVal;
            } else if (!deplOption.defaultVal.getClass().equals(object.getClass())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("XXXX " + object + " is not a valid value " + " for " + deplOption.name + " .. ignoring and using default " + deplOption.defaultVal + ".!"));
                }
                object = deplOption.defaultVal;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Writing to file - " + deplOption.name + " = " + object));
            }
            if (deplOption.name.equals("installed.ear.destination")) {
                object = AppUtils.getAppInstallDir(scheduler, repositoryContext);
                applicationDeployment.setBinariesURL((String)object);
                continue;
            }
            if (deplOption.name.equals("distributeApp")) {
                applicationDeployment.setEnableDistribution(((Boolean)object).booleanValue());
                continue;
            }
            if (deplOption.name.equals("useMetaDataFromBinary")) {
                applicationDeployment.setUseMetadataFromBinaries(((Boolean)object).booleanValue());
                continue;
            }
            if (deplOption.name.equals("createMBeansForResources")) {
                applicationDeployment.setCreateMBeansForResources(((Boolean)object).booleanValue());
                continue;
            }
            if (deplOption.name.equals("reloadEnabled")) {
                applicationDeployment.setReloadEnabled(((Boolean)object).booleanValue());
                continue;
            }
            if (deplOption.name.equals("edition")) {
                try {
                    repositoryContext2 = repositoryContext;
                    properties = AppUtils.getEditionProps(repositoryContext2);
                    string = "INACTIVE";
                    if (properties.isEmpty()) {
                        string = "ACTIVE";
                    }
                    properties.put(EditionHelper.getEditionStatePropName(repositoryContext2.getName()), string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("setting config.state(" + repositoryContext2.getName() + ")=" + string));
                    }
                    AppUtils.setEditionProps(repositoryContext2, properties);
                }
                catch (AdminException adminException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Error saving active property for edition: " + (Object)((Object)adminException)));
                }
                continue;
            }
            if (deplOption.name.equals("edition.desc")) {
                if (AppUtils.isEmpty((String)object)) continue;
                try {
                    repositoryContext2 = repositoryContext;
                    properties = AppUtils.getEditionProps(repositoryContext2);
                    properties.put(EditionHelper.getEditionDescPropName(repositoryContext2.getName()), (String)object);
                    AppUtils.setEditionProps(repositoryContext2, properties);
                }
                catch (AdminException adminException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Error saving desc for edition: " + (Object)((Object)adminException)));
                }
                continue;
            }
            if (deplOption.name.equals("reloadInterval")) {
                if (!applicationDeployment.isReloadEnabled() || AppUtils.isEmpty((String)object)) continue;
                Tr.debug((TraceComponent)tc, (String)"Class reloading is enabled ");
                try {
                    applicationDeployment.setReloadInterval(Long.parseLong((String)object));
                }
                catch (Throwable throwable) {
                    Tr.warning((TraceComponent)tc, (String)"ADMA5050E", (Object)new Object[]{object});
                }
                continue;
            }
            if (deplOption.name.equals("classLoaderPolicy")) {
                if (!"0".equals(object) && !"1".equals(object)) {
                    if (AppDeploymentOptionsHelper.valueIsEmpty(object)) {
                        Tr.warning((TraceComponent)tc, (String)"ADMA5051W", (Object)new Object[]{object});
                    }
                    object = deplOption.defaultVal;
                }
                applicationDeployment.setWarClassLoaderPolicy("1".equals(object) ? ClassLoaderPolicy.SINGLE_LITERAL : ClassLoaderPolicy.MULTIPLE_LITERAL);
                continue;
            }
            if (deplOption.name.equals("classLoadingMode")) {
                if (!"0".equals(object) && !"1".equals(object)) {
                    if (AppDeploymentOptionsHelper.valueIsEmpty(object)) {
                        Tr.warning((TraceComponent)tc, (String)"ADMA5052W", (Object)new Object[]{object});
                    }
                    object = deplOption.defaultVal;
                }
                if ((repositoryContext2 = applicationDeployment.getClassloader()) == null) {
                    repositoryContext2 = AppDeploymentOptionsHelper.getClassloaderFactory().createClassloader();
                    applicationDeployment.setClassloader((Classloader)repositoryContext2);
                } else if (AppDeploymentOptionsHelper.valueIsEmpty(v) && repositoryContext2.eIsSet((EStructuralFeature)ClassloaderPackage.eINSTANCE.getClassloader_Mode())) continue;
                repositoryContext2.setMode("0".equals(object) ? ClassLoadingMode.PARENT_FIRST_LITERAL : ClassLoadingMode.PARENT_LAST_LITERAL);
                continue;
            }
            if (deplOption.name.equals("zeroBinaryCopy")) {
                if (!Boolean.TRUE.equals(object)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"!! Zero bin copy mode set.");
                }
                applicationDeployment.setUseMetadataFromBinaries(true);
                applicationDeployment.setEnableDistribution(false);
                applicationDeployment.setZeroBinaryCopy(true);
                continue;
            }
            if (deplOption.name.equals("copy.sessionmgr.servername")) {
                if (AppUtils.isEmpty((String)object)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"!! Copy session mgr settings.");
                }
                AppDeploymentOptionsHelper.copySessionMgr(applicationDeployment, (String)object, repositoryContext);
                continue;
            }
            if (deplOption.name.equals("was.loose.config")) {
                if (AppUtils.isEmpty((String)object)) continue;
                repositoryContext2 = applicationDeployment.getProperties();
                for (int j = 0; j < repositoryContext2.size(); ++j) {
                    string = (Property)repositoryContext2.get(j);
                    if (!"was.loose.config".equals(string.getName())) continue;
                    repositoryContext2.remove(string);
                    break;
                }
                properties = PropertiesFactory.eINSTANCE.createProperty();
                properties.setName("was.loose.config");
                properties.setValue((String)object);
                repositoryContext2.add(properties);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("XXXXXX Unexpected attr " + deplOption.name + " in hash2Files()"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"hash2Files");
        }
    }

    private static ClassloaderFactory getClassloaderFactory() {
        if (_gClassloaderFactory == null) {
            ClassloaderPackage classloaderPackage = (ClassloaderPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/classloader.xmi");
            _gClassloaderFactory = classloaderPackage.getClassloaderFactory();
        }
        return _gClassloaderFactory;
    }

    private static void copySessionMgr(ApplicationDeployment applicationDeployment, String string, RepositoryContext repositoryContext) {
        try {
            ApplicationConfig applicationConfig;
            EObject eObject;
            RepositoryContext repositoryContext2;
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"copySessionMgr");
            }
            if ((repositoryContext2 = AppUtils.findContext("servers", string, null, repositoryContext.getParent().getParent(), repositoryContext.getWorkSpace(), false)) == null) {
                Tr.warning((TraceComponent)tc, (String)"ADMA5034W", (Object)new Object[]{string});
                return;
            }
            URI uRI = URI.createURI((String)"server.xml");
            Resource resource = repositoryContext2.getResourceSet().createResource(uRI);
            HashMap hashMap = new HashMap();
            resource.load(hashMap);
            Server server = (Server)resource.getContents().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Server: " + server));
            }
            ApplicationServer applicationServer = null;
            EList eList = server.getComponents();
            for (int i = 0; i < eList.size(); ++i) {
                if (!(eList.get(i) instanceof ApplicationServer)) continue;
                applicationServer = (ApplicationServer)eList.get(i);
                break;
            }
            if (applicationServer == null) {
                Tr.exit((TraceComponent)tc, (String)("No app server in " + string));
                return;
            }
            WebContainer webContainer = null;
            eList = applicationServer.getComponents();
            for (int i = 0; i < eList.size(); ++i) {
                if (!(eList.get(i) instanceof WebContainer)) continue;
                webContainer = (WebContainer)eList.get(i);
                break;
            }
            if (webContainer == null) {
                Tr.exit((TraceComponent)tc, (String)("No web container in " + applicationServer));
                return;
            }
            eList = webContainer.getServices();
            SessionManager sessionManager = null;
            for (int i = 0; i < eList.size(); ++i) {
                if (!(eList.get(i) instanceof SessionManager)) continue;
                sessionManager = (SessionManager)eList.get(i);
                break;
            }
            if (sessionManager == null) {
                Tr.exit((TraceComponent)tc, (String)("No session mgr in " + webContainer));
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("session mgr: " + sessionManager));
            }
            if (!((eObject = EtoolsCopyUtility.createCopy(sessionManager)) instanceof SessionManager)) {
                Tr.warning((TraceComponent)tc, (String)"ADMA5035E", (Object)new Object[]{string, eObject});
                return;
            }
            if (_appCfgFactory == null) {
                ConfigInit.init();
                AppdeploymentPackageImpl.init();
                AppcfgPackageImpl.init();
                applicationConfig = (AppcfgPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appcfg.xmi");
                _appCfgFactory = applicationConfig.getAppcfgFactory();
            }
            applicationConfig = _appCfgFactory.createApplicationConfig();
            applicationConfig.setSessionManagement((SessionManager)eObject);
            applicationDeployment.getConfigs().add((Object)applicationConfig);
            EList eList2 = applicationDeployment.getTargetMappings();
            for (int i = 0; i < eList2.size(); ++i) {
                ((DeploymentTargetMapping)eList2.get(i)).setConfig((DeployedObjectConfig)applicationConfig);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Set session mgr for DTM: " + eList2.get(i)));
            }
        }
        catch (Throwable throwable) {
            Tr.warning((TraceComponent)tc, (String)"ADMA5036E", (Object)new Object[]{throwable, string});
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.client.AppDeploymentOptionsProfile.copySessionMgr", (String)"759");
        }
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"copySessionMgr");
        }
    }

    public Hashtable getXPathInfo(Vector vector) {
        ModuleType moduleType = vector.contains(ModuleType.EAR) ? ModuleType.EAR : (ModuleType)vector.elementAt(0);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(moduleType.toString(), "/");
        return hashtable;
    }

    public void taskData2DCBean(AppDeploymentTask appDeploymentTask, DConfigBeanImpl dConfigBeanImpl, String string) {
        J2EEDeployUtil.allTaskData2DC(appDeploymentTask, dConfigBeanImpl);
        Vector vector = dConfigBeanImpl.allProps();
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Hashtable hashtable = (Hashtable)vector.elementAt(i);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("root dcImpl prop table from: " + hashtable.get("taskName")));
            }
            if (!"AppDeploymentOptions".equals(hashtable.get("taskName"))) continue;
            hashtable.put("enableEndpoint", "AppDeploymentOption.No");
            hashtable.put("enableHttpRouterSecurity", "AppDeploymentOption.No");
            hashtable.put("contextroot", "/");
        }
    }

    public void dcBean2TaskData(AppDeploymentTask appDeploymentTask, Hashtable hashtable, Hashtable hashtable2) {
        Object v = hashtable2.remove("enableEndpoint");
        if (v != null && "AppDeploymentOption.Yes".equals(v)) {
            appDeploymentTask.getAppDeploymentController().getAppOptions().put("enableEndpoint", Boolean.TRUE);
        } else {
            appDeploymentTask.getAppDeploymentController().getAppOptions().put("enableEndpoint", Boolean.FALSE);
        }
        v = hashtable2.remove("enableHttpRouterSecurity");
        if (v != null && "AppDeploymentOption.Yes".equals(v)) {
            appDeploymentTask.getAppDeploymentController().getAppOptions().put("enableHttpRouterSecurity", Boolean.TRUE);
        } else {
            appDeploymentTask.getAppDeploymentController().getAppOptions().put("enableHttpRouterSecurity", Boolean.FALSE);
        }
        v = hashtable2.remove("contextroot");
        if (!AppUtils.isEmpty((String)v)) {
            appDeploymentTask.getAppDeploymentController().getAppOptions().put("contextroot", v);
        }
        J2EEDeployUtil.dcBean2TaskData(appDeploymentTask, hashtable, hashtable2);
    }
}

