/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.Container;
import com.ibm.etools.j2ee.commonarchivecore.ModuleRef;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.ArchiveSchedulerImpl;
import com.ibm.ws.management.application.DefaultTaskProvider;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.application.task.DeltaDataTask;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class UpdateSchedulerImpl
extends ArchiveSchedulerImpl
implements UpdateScheduler {
    private static TraceComponent tc = Tr.register((Class)UpdateSchedulerImpl.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private boolean inPreUpdate = true;
    private String _contentURI;
    private String _operation;
    private String _origContentType;
    private List _deltaContents;

    public UpdateSchedulerImpl(String string, String string2, String string3, String string4, Hashtable hashtable, AppManagement appManagement, AppNotification.Listener listener) {
        super(string3, string, hashtable, appManagement, listener);
        this.appTaskName = "UpdateApplication";
        this._contentType = (String)hashtable.get("contenttype");
        this._contentURI = string2;
        if (this._contentURI != null) {
            this._contentURI = this._contentURI.replace('\\', '/');
        }
        this._operation = string4;
        this._origContentType = this._contentType;
        this._deltaContents = new ArrayList();
    }

    public String getOperation() {
        return this._operation;
    }

    public String getContentPath() {
        return super.getArchivePath();
    }

    public void setContentPath(String string) throws AdminException {
        super.setArchivePath(string);
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getOrigContentType() {
        return this._origContentType;
    }

    public void setContentType(String string) throws AdminException {
        if (string == null || string.equals(this.getContentType())) {
            return;
        }
        if (!this.inPreUpdate) {
            throw new AdminException("ContentType can only be set in pre update phase.");
        }
        this._contentType = string;
        this.setContentPath(this.getContentPath());
    }

    public Archive getContentAsArchive() throws AdminException {
        return super.getArchive();
    }

    public String getContentURI() {
        return this._contentURI;
    }

    protected AppNotification createCompletionEvent(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCompletionEvent");
        }
        String string = "Update of " + this.appName + " has ended.";
        AppNotification appNotification = new AppNotification("UpdateApplication", "", bl ? "Completed" : "Failed", "", string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCompletionEvent");
        }
        return appNotification;
    }

    protected AppNotification createStartEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createStartEvent");
        }
        String string = "Update of " + this.appName + " has started.";
        AppNotification appNotification = new AppNotification("UpdateApplication", "", "InProgress", "", string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createStartEvent");
        }
        return appNotification;
    }

    protected String getJMXEventType() {
        return "websphere.admin.appmgmt.update";
    }

    protected void setupTasks() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setupTasks");
        }
        try {
            this.validateParams(this.getProperties(), this._contentURI, this._pathToContent, this._operation);
        }
        catch (AdminException adminException) {
            String string = "";
            this.propagateTaskEvent(new AppNotification("UpdateApplication", "", "InProgress", "", string + adminException.getMessage()));
            throw adminException;
        }
        this.tasks = new Vector();
        DefaultTaskProvider defaultTaskProvider = new DefaultTaskProvider();
        defaultTaskProvider.providePreUpdateTasks(this.tasks, this);
        ExtensionHelper.processServerPreUpdateExtensions(this.properties, this.tasks, this);
        this.inPreUpdate = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setupTasks");
        }
    }

    protected void performCleanup(boolean bl) throws Exception {
        super.performCleanup(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateParams(Hashtable hashtable, String string, String string2, String string3) throws Exception {
        String string4;
        RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, this.getWorkSpace(), this.getProperties());
        if (repositoryContext == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
        }
        boolean bl = AppUtils.isEmpty(string);
        boolean bl2 = AppUtils.isEmpty(string2);
        boolean bl3 = ConfigRepoHelper.checkIfZeroBinCopy(repositoryContext);
        if (!bl) {
            this._contentURI = string.replace('\\', '/');
        }
        if (AppUtils.isEmpty(string4 = (String)hashtable.get("contenttype")) || !string4.equals("app") && !string4.equals("file") && !string4.equals("partialapp") && !string4.equals("modulefile")) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0130E", new String[]{string4, this.appName}));
        }
        if (!(string4.equals("partialapp") || !AppUtils.isEmpty(string3) && (string3.equalsIgnoreCase("add") || string3.equalsIgnoreCase("addupdate") || string3.equalsIgnoreCase("delete") || string3.equalsIgnoreCase("update")))) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0132E", new String[]{string3, this.appName}));
        }
        if ("delete".equals(this._operation) && (string4.equals("file") || string4.equals("modulefile"))) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Remove jsp precompile or ejbdeploy flags for delete");
            }
            this.getProperties().remove("preCompileJSPs");
            this.getProperties().remove("deployejb");
        }
        if (bl3) {
            if (!"modulefile".equals(string4) || !"add".equalsIgnoreCase(string3) && !"delete".equalsIgnoreCase(string3)) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0136E", new String[]{string4, this.appName}));
            }
            hashtable.put("zeroBinaryCopy", Boolean.TRUE);
        }
        if (string4.equals("partialapp")) {
            if (bl2) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0131E", new String[0]));
            }
            File file = new File(string2);
            if (!file.exists()) {
                throw new AdminException("ERROR: Content does not exist at path specified for partialapp update.");
            }
        } else {
            File file;
            if (string3.equals("add") || string3.equals("addupdate") || string3.equals("update")) {
                if (bl || bl2) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0133E"));
                }
                file = new File(string2);
                if (!file.exists()) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0134E", new String[]{string2, this.appName}));
                }
            } else if (string3.equalsIgnoreCase("delete") && bl) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0135E"));
            }
            if (bl3) {
                return;
            }
            file = null;
            try {
                file = ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, this.getWorkSpace(), this.resBundle, null, true);
                if ("modulefile".equals(string4) && "addupdate".equals(string3)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"For ModuleFile::ADDUPDATE case lets decide if ADD or UPDATE");
                    }
                    this._operation = this.containsModuleFile((EARFile)file, string) ? "update" : "add";
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("For ModuleFile::ADDUPDATE case changed operation to " + this._operation));
                    }
                }
                if ("modulefile".equals(string4) && "delete".equals(string3)) {
                    this.checkRemoveLastModule((EARFile)file, string);
                }
                if ("add".equals(string3) || "update".equals(string3)) {
                    this.checkDuplicate((EARFile)file, string, string3);
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof AdminException) {
                    throw (AdminException)((Object)throwable);
                }
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.UpdateScheduler.validateParams", (String)"360", (Object)this);
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
    }

    private boolean containsModuleFile(EARFile eARFile, String string) throws Exception {
        EList eList = eARFile.getModuleRefs();
        for (int i = 0; i < eList.size(); ++i) {
            if (!((ModuleRef)eList.get(i)).getUri().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void checkDuplicate(EARFile eARFile, String string, String string2) throws AdminException {
        Object[] objectArray = null;
        try {
            objectArray = AppUtils.getContainerAndOffset((Container)eARFile, string);
        }
        catch (Exception exception) {
            throw new AdminException("ERROR: " + exception.getMessage());
        }
        Container container = (Container)objectArray[0];
        String string3 = (String)objectArray[1];
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("container = " + container + " , offset = " + string3));
        }
        if (container.containsFile(string3)) {
            if ("add".equals(string2)) {
                throw new AdminException("ERROR: Duplicate file for add operation.");
            }
        } else if ("update".equals(string2)) {
            throw new AdminException("ERROR: File does not exist for update operation");
        }
    }

    private void checkRemoveLastModule(EARFile eARFile, String string) throws AdminException {
        EList eList = eARFile.getModuleRefs();
        if (eList.size() == 1 && ((ModuleRef)eList.get(0)).getUri().equals(string)) {
            throw new AdminException("ERROR: Attempt to remove last module.");
        }
    }

    protected AbstractTask getNextTask() throws AdminException {
        if (this.inPreUpdate && this.nextTaskNum >= this.tasks.size()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Preupdate phase is over . gather update tasks");
            }
            this.inPreUpdate = false;
            Vector<String> vector = new Vector<String>();
            DefaultTaskProvider defaultTaskProvider = new DefaultTaskProvider();
            defaultTaskProvider.provideUpdateTasks(vector, this);
            try {
                ExtensionHelper.processServerUpdateExtensions(this.properties, vector, this);
            }
            catch (AppDeploymentException appDeploymentException) {
                throw new AdminException(appDeploymentException, "");
            }
            if (!Boolean.TRUE.equals(this.getProperties().get("zeroBinaryCopy"))) {
                vector.addElement(DeltaDataTask.class.getName());
            }
            this.tasks.addAll(vector);
            vector = null;
        }
        return super.getNextTask();
    }

    public void notifyDeltaUpdate(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("notifyDeltaUpdate: " + string + ", " + string2));
        }
        this._deltaContents.add(string);
        this._deltaContents.add(string2);
    }

    public List getDeltaContents() {
        return this._deltaContents;
    }
}

