/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.Hashtable;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;

public class RedeploymentManager
implements AppNotification.Listener,
NotificationListener {
    private static TraceComponent tc = Tr.register((Class)RedeploymentManager.class, null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    String earPath;
    String appName;
    Hashtable properties;
    String workspaceID;
    String origWID;
    WorkSpace ws = null;
    AppNotification.Listener localListener;
    AppManagementImpl appM;
    Object handback = null;
    boolean isLocal;

    public RedeploymentManager(String string, String string2, Hashtable hashtable, String string3, AppNotification.Listener listener, boolean bl, AppManagement appManagement) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("RedeploymentManager: " + string2));
        }
        this.earPath = string;
        this.appName = string2;
        this.properties = hashtable;
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put("contenttype", "app");
        this.appM = (AppManagementImpl)appManagement;
        this.workspaceID = string3;
        this.origWID = string3;
        if (this.workspaceID == null) {
            this.workspaceID = Long.toHexString(System.currentTimeMillis());
        }
        this.localListener = listener;
        this.isLocal = bl;
        if (!this.isLocal) {
            this.handback = Long.toHexString(System.currentTimeMillis());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("RedeploymentManager: " + string2));
        }
    }

    public void performTask() throws AdminException {
        try {
            Object object;
            block15: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"performTask");
                }
                this.ws = ConfigRepoHelper.getWorkSpace(this.workspaceID);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Workspace: " + this.workspaceID));
                }
                try {
                    object = AppUtils.findAppContextFromConfig(this.appName, this.ws, this.properties);
                    if (object != null) {
                        ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)object);
                        this.properties.put("AppDeplObj", applicationDeployment);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.RedeploymentManager.doCleanup", (String)"106", (Object)this);
                    if (!tc.isDebugEnabled()) break block15;
                    Tr.debug((TraceComponent)tc, (String)("Error in loading old deployment.xml: " + throwable));
                }
            }
            if (!this.isLocal) {
                object = new NotificationFilterSupport();
                ((NotificationFilterSupport)object).enableType("websphere.admin.appmgmt");
                AdminServiceFactory.getAdminService().addNotificationListener(this.appM.getObjectName(), this, (NotificationFilter)object, this.handback);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Added listener for JMX");
                }
            }
            if (this.isLocal) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Calling local uninstall");
                }
                this.appM.uninstallApplicationLocal(this.appName, this.properties, this, this.workspaceID);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Calling JMX uninstall");
                }
                this.appM.uninstallApplication(this.appName, this.properties, this.workspaceID);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"performTask");
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, "");
        }
    }

    public void appEventReceived(AppNotification appNotification) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("appEventReceived: " + appNotification));
        }
        if (appNotification.taskName.equals("UninstallApplication")) {
            if (appNotification.taskStatus.equals("Completed")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Uninstall ended .. start install..");
                }
                try {
                    if (this.isLocal) {
                        this.appM.installApplicationLocal(this.earPath, this.appName, this.properties, this, this.workspaceID);
                    } else {
                        this.appM.installApplication(this.earPath, this.appName, this.properties, this.workspaceID);
                    }
                }
                catch (AdminException adminException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception in invoking install: " + (Object)((Object)adminException)));
                    }
                    this.doCleanup(appNotification);
                }
            }
            if (appNotification.taskStatus.equals("Failed")) {
                this.doCleanup(appNotification);
            }
        } else if (appNotification.taskName.equals("InstallApplication") && (appNotification.taskStatus.equals("Completed") || appNotification.taskStatus.equals("Failed"))) {
            this.doCleanup(appNotification);
        }
        if (this.isLocal && this.localListener != null) {
            this.localListener.appEventReceived(appNotification);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"appEventReceived");
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (object == null || !object.equals(this.handback)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("not my event: " + object + ", handback=" + this.handback));
            }
            return;
        }
        Object object2 = notification.getUserData();
        if (object2 instanceof AppNotification) {
            this.appEventReceived((AppNotification)object2);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unknown ud: " + object2));
        }
    }

    public void doCleanup(AppNotification appNotification) {
        block9: {
            block8: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"doCleanup");
                }
                try {
                    if (!this.isLocal) {
                        AdminServiceFactory.getAdminService().removeNotificationListener(this.appM.getObjectName(), this);
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)("!!!Error removing the listener: " + this));
                }
            }
            if (this.origWID == null) {
                try {
                    ConfigRepoHelper.removeWorkSpace(appNotification.taskStatus.equals("Completed") && appNotification.taskName.equals("InstallApplication"), this.ws);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.RedeploymentManager.doCleanup", (String)"326", (Object)this);
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)tc, (String)("Error in removing workspace: " + throwable));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doCleanup");
        }
    }
}

