/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.SchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.application.task.DistributionStatusTask;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class DistributionStatusSchedulerImpl
extends SchedulerImpl {
    private static TraceComponent tc = Tr.register((Class)DistributionStatusSchedulerImpl.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    List _nodes;
    String _compStatus = null;

    public DistributionStatusSchedulerImpl(String string, Hashtable hashtable, AppManagement appManagement, AppNotification.Listener listener) {
        super(string, hashtable, appManagement, listener);
        this.appTaskName = "AppDistribution";
    }

    protected void setupTasks() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setupTasks");
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        if (AppManagementImpl.isLocalMode()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Local mode: no-op");
            }
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0090E", new Object[]{"getDistributionStatus"}));
        }
        try {
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.appName, this.getWorkSpace(), this.getProperties());
            if (repositoryContext == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
            }
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
            Vector vector = new Vector();
            Vector vector2 = ConfigRepoHelper.getServersForAppDeployment(applicationDeployment, vector, this.getCellContext(), this.getWorkSpace(), false);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("App targets : " + vector2));
            }
            if (vector.size() > 0 && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Not found : " + vector));
            }
            Hashtable hashtable = ConfigRepoHelper.getNodeServerRelation(this.getWorkSpace(), vector2);
            this._nodes = new ArrayList();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                this._nodes.add(((RepositoryContext)enumeration.nextElement()).getName());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Nodes are: " + this._nodes));
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.DistributionStatusScheduler.setupTasks", (String)"132", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception thrown in setupTasks: " + throwable));
            }
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, throwable.getMessage());
        }
        this.tasks = new Vector();
        this.tasks.addElement(DistributionStatusTask.class.getName());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The tasks are: " + this.tasks));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setupTasks");
        }
    }

    protected AppNotification createCompletionEvent(boolean bl) {
        String string = "";
        if (this.resBundle != null) {
            string = AppUtils.getMessage(this.resBundle, "ADMA5072I", new String[]{this.appName});
        }
        AppNotification appNotification = new AppNotification("AppDistributionNode", "", bl ? "Completed" : "Failed", "", string);
        Properties properties = new Properties();
        if (this._compStatus != null) {
            properties.put("AppDistributionAll", this._compStatus);
        }
        appNotification.setProperties(properties);
        return appNotification;
    }

    protected AppNotification createStartEvent() {
        String string = "";
        if (this.resBundle != null) {
            string = AppUtils.getMessage(this.resBundle, "ADMA5071I", new String[]{this.appName});
        }
        AppNotification appNotification = new AppNotification("AppDistributionNode", "", "InProgress", "", string);
        return appNotification;
    }

    protected void performCleanup(boolean bl) throws Exception {
    }

    public List get_nodes() {
        return this._nodes;
    }

    public String addCompStatus(String string) {
        this._compStatus = AppUtils.isEmpty(this._compStatus) ? string : this._compStatus + "+" + string;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("comp status: " + this._compStatus));
        }
        return this._compStatus;
    }
}

