/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveOptions;
import com.ibm.etools.j2ee.commonarchivecore.looseconfig.LooseConfigRegister;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.SchedulerImpl;
import com.ibm.ws.management.application.client.AppInstallHelper;
import java.io.File;
import java.util.Hashtable;

public abstract class ArchiveSchedulerImpl
extends SchedulerImpl {
    private static TraceComponent tc = Tr.register((Class)ArchiveSchedulerImpl.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    protected String _origPathToContent;
    protected String _pathToContent;
    private Archive archive;
    protected String _contentType;

    public ArchiveSchedulerImpl(String string, String string2, Hashtable hashtable, AppManagement appManagement, AppNotification.Listener listener) {
        super(string2, hashtable, appManagement, listener);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ArchiveSchedulerImpl");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Archive: " + string + ", appName: " + string2 + ", options: " + hashtable));
        }
        this._origPathToContent = string;
        this._pathToContent = string;
        this._contentType = "app";
        Object v = this.properties.get("was.loose.config");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("LOOSE_CONFI_PROPERTY: " + v));
        }
        if (v != null) {
            LooseConfigRegister.singleton().addLooseMapping(this._origPathToContent, (String)v);
        }
        if ((v = this.properties.get("zeroBinaryCopy")) != null && v instanceof String && "true".equalsIgnoreCase((String)v)) {
            this.properties.put("zeroBinaryCopy", Boolean.TRUE);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Uniquie id: " + this.id));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ArchiveSchedulerImpl");
        }
    }

    protected String getArchivePath() {
        return this._pathToContent;
    }

    protected void setArchivePath(String string) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setContentPath");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("new path: " + string));
        }
        this._pathToContent = string;
        if (this.archive != null) {
            try {
                Tr.debug((TraceComponent)tc, (String)("********** closing: " + this.archive.getURI()));
                this.archive.close();
                this.archive = null;
            }
            catch (Throwable throwable) {
                if (this.resBundle != null) {
                    throw new AdminException(throwable, AppUtils.getMessage(this.resBundle, "ADMA0053E", new Object[]{this._pathToContent}));
                }
                throw new AdminException(throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setContentPath");
        }
    }

    protected Archive getArchive() throws AdminException {
        return this.getArchive(false, false);
    }

    protected Archive getArchive(boolean bl, boolean bl2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getArchive: " + bl2 + ", " + bl));
        }
        if (!this._contentType.equals("app") && !this._contentType.equals("modulefile")) {
            return null;
        }
        if (this.archive == null) {
            try {
                this.archive = AppInstallHelper.getArchive(this._pathToContent, bl, bl2, this.resBundle, this._contentType.equals("app"));
                Tr.debug((TraceComponent)tc, (String)("********** opening: " + this.archive.getURI()));
            }
            catch (AppDeploymentException appDeploymentException) {
                throw new AdminException(appDeploymentException.getEmbeddedEx(), appDeploymentException.getMessage());
            }
        }
        ArchiveOptions archiveOptions = this.archive.getOptions();
        boolean bl3 = !bl2 && archiveOptions.isReadOnly();
        boolean bl4 = bl3 = bl3 || bl && !archiveOptions.useJavaReflection();
        if (bl3) {
            this.archive.close();
            this.archive = null;
            try {
                AppUtils.dbg(tc, "Reopening since: read=" + archiveOptions.isReadOnly() + ", refl=" + archiveOptions.useJavaReflection());
                this.archive = AppInstallHelper.getArchive(this._pathToContent, bl, bl2, this.resBundle, this._contentType.equals("app"));
            }
            catch (AppDeploymentException appDeploymentException) {
                throw new AdminException(appDeploymentException.getEmbeddedEx(), appDeploymentException.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getArchive");
        }
        return this.archive;
    }

    protected void performCleanup(boolean bl) throws Exception {
        Object v;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performCleanup");
        }
        if (this.archive != null) {
            Tr.debug((TraceComponent)tc, (String)("Closing ear: " + this.archive.getURI()));
            this.archive.close();
        }
        if ((v = this.getProperties().get("DeleteSourceEar")) != null && v.equals(Boolean.TRUE)) {
            File file = new File(this._origPathToContent);
            boolean bl2 = file.delete();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Delete original ear: " + this._origPathToContent + " -- success: " + bl2));
            }
        }
        this.archive = null;
        if (this.setupDone) {
            AppUtils.dbg(tc, AppUtils.getMessage(this.resBundle, "ADMA6011I", new Object[]{AppUtils.getAppTempDir(this)}));
            AppUtils.deleteDirTree(AppUtils.getAppTempDir(this));
        }
        if (this.properties.get("was.loose.config") != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removing loose mapping for: " + this._origPathToContent));
            }
            LooseConfigRegister.singleton().removeLooseMapping(this._origPathToContent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performCleanup");
        }
    }
}

