/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.workspace.query.WorkSpaceQueryUtil;
import com.ibm.ws.workspace.query.WorkSpaceQueryUtilFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class ResValidationHelper {
    private static TraceComponent tc = Tr.register((Class)ResValidationHelper.class, null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private Map JNDIKeys = Collections.synchronizedMap(new HashMap());
    private Map inScopeResources = Collections.synchronizedMap(new HashMap());
    private Map outOfScopeResources = Collections.synchronizedMap(new HashMap());
    private String CELL_NAME = "";
    private RepositoryContext CELL_CONTEXT = null;
    public static String[] resTypes = new String[]{"J2CResourceAdapter", "J2CActivationSpec", "J2CAdminObject", "J2CConnectionFactory", "JDBCProvider", "WAS40DataSource", "WAS50DataSource", "JMSProvider", "MailProvider", "URLProvider", "ResourceEnvironmentProvider"};
    public static String[] resTaskArray = new String[]{"DataSourceFor10CMPBeans", "DataSourceFor20CMPBeans", "DataSourceFor10EJBModules", "DataSourceFor20EJBModules", "MapResRefToEJB", "MapResEnvRefToRes", "MapMessageDestinationRefToEJB", "BindJndiForEJBMessageBinding", "ActSpecJNDI"};
    private static Map typeTranslation = new HashMap();

    public void gatherJNDINames(AppDeploymentController appDeploymentController, String string, WorkSpace workSpace) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"gatherAllJNDINames", (Object)new Object[]{appDeploymentController, string, workSpace});
        }
        try {
            Object object;
            Object object2;
            String string2;
            Object object3;
            String string3;
            String string4;
            Hashtable hashtable;
            block22: {
                this.CELL_NAME = string;
                hashtable = new Hashtable();
                try {
                    hashtable = appDeploymentController.getServerTable();
                }
                catch (AppDeploymentException appDeploymentException) {
                    FFDCFilter.processException((Throwable)appDeploymentException, (String)"com.ibm.websphere.management.application.client.ResValidationHelper.gatherJNDINames", (String)"148", (Object)this);
                    if (!tc.isDebugEnabled()) break block22;
                    Tr.debug((TraceComponent)tc, (String)("Exception when calling getServerTable: " + appDeploymentException));
                }
            }
            if (hashtable == null || hashtable.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"gatherJNDINames: empty mod2svr table");
                }
                return;
            }
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string4 = (String)enumeration.nextElement();
                string3 = (String)hashtable.get(string4);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("key: " + string4 + " -- targets: " + string3));
                }
                if (string3.indexOf(43) > 0) {
                    object3 = new StringTokenizer(string3, "+");
                    while (((StringTokenizer)object3).hasMoreTokens()) {
                        hashSet.add(((StringTokenizer)object3).nextToken());
                    }
                    continue;
                }
                hashSet.add(string3);
            }
            string4 = AppUtils.findContext("cells", string, null, null, workSpace, true);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cell Context", (Object)string4);
            }
            this.CELL_CONTEXT = string4;
            string3 = RepositoryMetaDataFactory.getRepositoryMetaData();
            object3 = hashSet.iterator();
            while (object3.hasNext()) {
                Object object4;
                String string5;
                Object object5;
                string2 = (String)object3.next();
                object2 = "";
                if (this._isServerTarget(string2)) {
                    Cloneable cloneable;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Server Target: " + string2));
                    }
                    object = this._getPreviousLevel(string2);
                    object5 = this._getKeyProperties((String)object);
                    string5 = ((Properties)object5).getProperty("node");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Node Name: " + string5));
                    }
                    object4 = string4.getChild(string3.getContextType("nodes"), string5);
                    if (!this.inScopeResources.containsKey(object)) {
                        cloneable = this._getJNDINames((RepositoryContext)object4);
                        this._addToJNDITable((ArrayList)cloneable, this.JNDIKeys, (String)object);
                        this.inScopeResources.put(object, cloneable);
                    }
                    cloneable = this._getKeyProperties(string2);
                    String string6 = ((Properties)cloneable).getProperty("server");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Server Name: " + string6));
                    }
                    RepositoryContext repositoryContext = object4.getChild(string3.getContextType("servers"), string6);
                    ArrayList arrayList = this._getJNDINames(repositoryContext);
                    this._addToJNDITable(arrayList, this.JNDIKeys, string2);
                    this.inScopeResources.put(string2, arrayList);
                    continue;
                }
                if (this._isClusterTarget(string2)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Cluster Target: " + string2));
                    }
                    object = this._getKeyProperties(string2);
                    object5 = ((Properties)object).getProperty("cluster");
                    string5 = string4.getChild(string3.getContextType("clusters"), (String)object5);
                    object4 = this._getJNDINames((RepositoryContext)string5);
                    this._addToJNDITable((ArrayList)object4, this.JNDIKeys, string2);
                    this.inScopeResources.put(string2, object4);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Odd Target Passed in: " + string2));
            }
            string2 = "WebSphere:cell=" + string;
            object2 = this._getJNDINames((RepositoryContext)string4);
            object = this._getEmbeddedRarJNDIs(appDeploymentController);
            this._addToJNDITable((ArrayList)object, this.JNDIKeys, string2);
            ((ArrayList)object2).addAll(object);
            this.inScopeResources.put(string2, object2);
            this._addToJNDITable((ArrayList)object2, this.JNDIKeys, string2);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.management.application.client.ResValidationHelper.gatherJNDINames", (String)"238", (Object)this);
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, "Unexpected Exception from gatherJNDINames: " + throwable.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"gatherAllJNDINames");
        }
    }

    public ArrayList getResourceJndiNames(AppDeploymentController appDeploymentController, String string) throws AdminException {
        Object object;
        String string2;
        Object object2;
        Hashtable hashtable;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getResourceJndiNames ", (Object)new Object[]{appDeploymentController, string});
            }
            hashtable = null;
            try {
                hashtable = appDeploymentController.getServerTable();
            }
            catch (AppDeploymentException appDeploymentException) {
                FFDCFilter.processException((Throwable)appDeploymentException, (String)"com.ibm.websphere.management.application.client.ResValidationHelper.getResourceJNDINames", (String)"267", (Object)this);
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug((TraceComponent)tc, (String)("Exception when calling getServerTable: " + appDeploymentException));
            }
        }
        if (hashtable == null || hashtable.size() == 0) {
            if (tc.isEntryEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"gatherJNDINames: empty mod2svr table");
            }
            return new ArrayList();
        }
        HashSet hashSet = new HashSet();
        HashSet<String> hashSet2 = new HashSet<String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            string2 = (String)hashtable.get(object2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("key: " + (String)object2 + ".. targets: " + string2));
            }
            object = new StringTokenizer(string2, "+");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                if (string3 == null || string3.trim().equals("") || hashSet2.contains(string3)) continue;
                hashSet2.add(string3);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("tempset: " + hashSet2));
        }
        object2 = hashSet2.iterator();
        while (object2.hasNext()) {
            string2 = (String)object2.next();
            object = this.getResourceJndiNames(string2, string, new HashSet());
            hashSet.addAll(object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResourceJndiNames ", (Object)new Object[]{hashSet});
        }
        return new ArrayList(hashSet);
    }

    public Map resourceValidation(AppDeploymentController appDeploymentController, String string) throws AdminException {
        String string2;
        String string3;
        Enumeration enumeration;
        Hashtable hashtable;
        Map map;
        AppDeploymentTask appDeploymentTask;
        block17: {
            block16: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"resourceValidation ", (Object)new Object[]{appDeploymentController, string});
                }
                appDeploymentTask = null;
                boolean bl = false;
                map = new Hashtable();
                for (int i = 0; i < resTaskArray.length; ++i) {
                    if (!string.equals(resTaskArray[i])) continue;
                    bl = true;
                }
                if (!bl) {
                    Tr.warning((TraceComponent)tc, (String)("The task " + string + " is not in the resource task list."));
                    return null;
                }
                try {
                    if (bl) {
                        appDeploymentTask = appDeploymentController.getTaskByName(string, false);
                    }
                }
                catch (AppDeploymentException appDeploymentException) {
                    FFDCFilter.processException((Throwable)appDeploymentException, (String)"com.ibm.websphere.management.application.client.ResValidationHelper.resourceValidation", (String)"337", (Object)this);
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug((TraceComponent)tc, (String)("Exception when calling getTaskByName: " + appDeploymentException));
                }
            }
            hashtable = new Hashtable();
            try {
                hashtable = appDeploymentController.getServerTable();
            }
            catch (AppDeploymentException appDeploymentException) {
                FFDCFilter.processException((Throwable)appDeploymentException, (String)"com.ibm.websphere.management.application.client.ResValidationHelper.resourceValidation", (String)"348", (Object)this);
                if (!tc.isDebugEnabled()) break block17;
                Tr.debug((TraceComponent)tc, (String)("Exception when calling getServerTable: " + appDeploymentException));
            }
        }
        if ((hashtable == null || hashtable.size() == 0) && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"gatherJNDINames: empty mod2svr table");
        }
        WorkSpace workSpace = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (workSpace != null) {
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                string2 = (String)hashtable.get(string3);
                if (this._isAppServer(string2, workSpace)) continue;
                hashtable.remove(string3);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Removed targets: " + string2 + "REMOVED"));
            }
        }
        if (tc.isDebugEnabled()) {
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                string2 = (String)hashtable.get(string3);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("key: " + string3 + ".. targets: " + string2));
            }
        }
        map = this._validateTaskResources(appDeploymentTask, hashtable);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resourceValidation ", (Object)new Object[]{map});
        }
        return map;
    }

    public Vector resValidation(String string, String string2, WorkSpace workSpace, Hashtable hashtable) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resValidation ", (Object)new Object[]{string, string2, workSpace, hashtable});
        }
        Vector<String> vector = new Vector<String>();
        try {
            AppDeploymentController appDeploymentController = AppManagementFactory.readArchive(string, hashtable);
            Hashtable hashtable2 = new Hashtable();
            hashtable2 = appDeploymentController.getAppOptions();
            hashtable2.putAll(hashtable);
            this.gatherJNDINames(appDeploymentController, string2, workSpace);
            Map map = new HashMap();
            for (int i = 0; i < resTaskArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("resTaskArray[i] " + resTaskArray[i]));
                }
                String string3 = resTaskArray[i];
                map = this.resourceValidation(appDeploymentController, string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("resMap " + map));
                }
                HashMap hashMap = new HashMap();
                if (map.size() <= 0) continue;
                Set set = map.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string4;
                    hashMap = (HashMap)map.get(iterator.next());
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("failedResTable " + hashMap));
                    }
                    if (hashMap.size() <= 0) continue;
                    String string5 = (String)hashMap.get("uri");
                    String string6 = (String)hashMap.get("EJBModule");
                    String string7 = (String)hashMap.get("module");
                    String string8 = (String)hashMap.get("JNDI");
                    String string9 = (String)hashMap.get("Targets");
                    String string10 = (String)hashMap.get("referenceBinding");
                    String string11 = (String)hashMap.get("resRef.type");
                    String string12 = (String)hashMap.get("resEnvRef.type");
                    String string13 = (String)hashMap.get("messageDestinationRefName");
                    String string14 = (String)hashMap.get("messageDestinationObject");
                    String string15 = (String)hashMap.get("RARModule");
                    String string16 = (String)hashMap.get("j2cid");
                    String string17 = (String)hashMap.get("j2c.jndiName");
                    String string18 = (String)hashMap.get("MisType");
                    Tr.debug((TraceComponent)tc, (String)("misresoure type " + string18));
                    String string19 = (String)hashMap.get("ResourceType");
                    Tr.debug((TraceComponent)tc, (String)("expected resource type " + string19));
                    String string20 = null;
                    String string21 = null;
                    if (string7 != null) {
                        string6 = string7;
                    } else if (string15 != null) {
                        string6 = string15;
                    }
                    if (string8 == null) {
                        string8 = string17;
                    }
                    if (string11 != null) {
                        string20 = string10;
                        string21 = string11;
                    }
                    if (string12 != null) {
                        string20 = string10;
                        string21 = string12;
                    }
                    if (string14 != null) {
                        string20 = string13;
                        string21 = string14;
                    }
                    if (string16 != null) {
                        string20 = string16;
                        string21 = "J2CActivationSpec";
                    }
                    if (string18 == null) {
                        if (string20 != null || string21 != null) {
                            string4 = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0115W", new String[]{string20, string21, string8, string6, string5, string9});
                            vector.addElement(string4);
                            continue;
                        }
                        string4 = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0114W", new String[]{string8, string6, string5, string9});
                        vector.addElement(string4);
                        continue;
                    }
                    if (string20 != null || string21 != null) {
                        string4 = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0139W", new String[]{string20, string21, string8, string6, string5, string9, string18, string19});
                        vector.addElement(string4);
                        continue;
                    }
                    string4 = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0138W", new String[]{string8, string6, string5, string9, string18, string19});
                    vector.addElement(string4);
                }
            }
            appDeploymentController.close(false, false, false);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.websphere.management.application.client.ResValidationHelper.resValidation", (String)"482", (Object)this);
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, "Unexpected Exception from resValidation: " + throwable.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resValidation ", (Object)new Object[]{vector});
        }
        return vector;
    }

    protected ArrayList getResourceJndiNames(String string, String string2, Set set) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResourceJndiNames ", (Object)new Object[]{string, string2, set});
        }
        ArrayList arrayList = (ArrayList)this.inScopeResources.get(string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"List : ", (Object)arrayList);
        }
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3;
                String string4 = (String)arrayList.get(i);
                Properties properties = this._getKeyProperties(string4);
                Tr.debug((TraceComponent)tc, (String)("subtype: " + properties.getProperty("subtype")));
                Tr.debug((TraceComponent)tc, (String)("type: " + properties.getProperty("type")));
                if (string2.equals("Topic") || string2.equals("TopicConnectionFactory") || string2.equals("Queue") || string2.equals("QueueConnectionFactory") || string2.equals("ConnectionFactory") || string2.equals("XAQueueConnectionFactory")) {
                    if (!string2.equals(properties.getProperty("subtype")) || (string3 = properties.getProperty("JNDI")) == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getResourceJndiNames adding to List: " + string3));
                    }
                    set.add(string3);
                    continue;
                }
                if (!string2.equals(properties.getProperty("type")) || (string3 = properties.getProperty("JNDI")) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getResourceJndiNames adding to List: " + string3));
                }
                set.add(string3);
            }
        }
        if (this._isServerTarget(string)) {
            String string5 = this._getPreviousLevel(string);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResourceJndiNames ", (Object)new Object[]{set});
            }
            return this.getResourceJndiNames(string5, string2, set);
        }
        if (this._isNodeTarget(string) || this._isClusterTarget(string)) {
            String string6 = this._getPreviousLevel(string);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResourceJndiNames ", (Object)new Object[]{set});
            }
            return this.getResourceJndiNames(string6, string2, set);
        }
        if (this._isCellTarget(string) && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResourceJndiNames ", (Object)new Object[]{set});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResourceJndiNames ", (Object)new Object[]{set});
        }
        return new ArrayList(set);
    }

    private Properties _getKeyProperties(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"_getKeyProperties: ", (Object)string);
        }
        Properties properties = new Properties();
        if (string.startsWith("WebSphere:")) {
            string = string.substring(10, string.length());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Target: " + string));
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = null;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Token: " + string2));
            }
            if (string2.startsWith("cell")) {
                string3 = "cell";
            } else if (string2.startsWith("node")) {
                string3 = "node";
            } else if (string2.startsWith("server")) {
                string3 = "server";
            } else if (string2.startsWith("JNDI")) {
                string3 = "JNDI";
            } else if (string2.startsWith("name")) {
                string3 = "name";
            } else if (string2.startsWith("type")) {
                string3 = "type";
            } else if (string2.startsWith("cluster")) {
                string3 = "cluster";
            } else if (string2.startsWith("subtype")) {
                string3 = "subtype";
            } else if (string2.startsWith("mistype")) {
                string3 = "mistype";
            }
            if (string3 == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Adding Key: " + string3 + " +  value: " + string2.substring(string2.indexOf("=") + 1)));
            }
            properties.setProperty(string3, string2.substring(string2.indexOf("=") + 1));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_getKeyProperties: ", (Object)properties);
        }
        return properties;
    }

    private boolean _isValidTarget(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"_isValidTarget ", (Object)new Object[]{string, string2});
        }
        List list = this._convertMultipleTargets(string);
        for (int i = 0; i < list.size(); ++i) {
            String string3;
            String string4;
            String string5;
            String string6;
            String string7 = (String)list.get(i);
            Properties properties = this._getKeyProperties(string7);
            Properties properties2 = this._getKeyProperties(string2);
            if (this._isServerTarget(string7)) {
                WorkSpace workSpace;
                String string8;
                string6 = properties.getProperty("cell");
                if (!string6.equals(string5 = properties2.getProperty("cell"))) {
                    if (!tc.isEntryEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"not the same cell");
                    continue;
                }
                string4 = properties.getProperty("node");
                string3 = properties2.getProperty("node");
                if (string3 != null && !string4.equals(string3)) {
                    if (!tc.isEntryEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"not the same node");
                    continue;
                }
                String string9 = properties.getProperty("server");
                if (!string9.equals(string8 = properties2.getProperty("server"))) {
                    if (!tc.isEntryEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"not the same server");
                    continue;
                }
                try {
                    workSpace = ConfigRepoHelper.getWorkSpace(null);
                }
                catch (Exception exception) {
                    return false;
                }
                if (!this._isAppServer(string7, workSpace)) {
                    return false;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"_isValidTarget ", (Object)new Boolean(true));
                }
                return true;
            }
            if (!this._isClusterTarget(string7)) continue;
            string6 = properties.getProperty("cluster");
            if (!string6.equals(string5 = properties2.getProperty("cluster"))) {
                if (!tc.isEntryEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"not the same cluster");
                continue;
            }
            string4 = properties.getProperty("cell");
            if (!string4.equals(string3 = properties2.getProperty("cell"))) {
                if (!tc.isEntryEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"not the same cell");
                continue;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"_isValidTarget ", (Object)new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_isValidTarget ", (Object)new Boolean(false));
        }
        return false;
    }

    private boolean _isAppServer(String string, WorkSpace workSpace) {
        return true;
    }

    private boolean _isServerTarget(String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() < 3) {
            return false;
        }
        stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        return string3.startsWith("node=") && (string2 = stringTokenizer.nextToken()).startsWith("server=");
    }

    private boolean _isCellTarget(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() != 1) {
            return false;
        }
        String string2 = stringTokenizer.nextToken();
        return string2.startsWith("WebSphere:cell=");
    }

    private boolean _isNodeTarget(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() < 2) {
            return false;
        }
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        return string2.startsWith("node=");
    }

    private boolean _isClusterTarget(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() < 2) {
            return false;
        }
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        return string2.startsWith("cluster=");
    }

    private String _getPreviousLevel(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"_getPreviousLevel", (Object)string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = null;
        if (stringTokenizer.countTokens() >= 2) {
            if (stringTokenizer.countTokens() == 2) {
                string2 = stringTokenizer.nextToken();
            } else if (stringTokenizer.countTokens() == 3) {
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                string2 = string3 + "," + string4;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_getPreviousLevel", (Object)string2);
        }
        return string2;
    }

    private Map _validateTaskResources(AppDeploymentTask appDeploymentTask, Hashtable hashtable) {
        HashMap hashMap = new HashMap();
        if (appDeploymentTask == null) {
            return hashMap;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateTaskResources ", (Object)new Object[]{appDeploymentTask.getName()});
        }
        String string = appDeploymentTask.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("task Name " + string));
        }
        String[] stringArray = appDeploymentTask.getColumnNames();
        int n = stringArray.length;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        for (int i = 0; i < n; ++i) {
            if ("uri".equals(stringArray[i])) {
                n3 = i;
            }
            if ("JNDI".equals(stringArray[i])) {
                n2 = i;
            }
            if ("EJBModule".equals(stringArray[i])) {
                n4 = i;
            }
            if ("module".equals(stringArray[i])) {
                n5 = i;
            }
            if ("referenceBinding".equals(stringArray[i])) {
                n6 = i;
            }
            if ("resRef.type".equals(stringArray[i])) {
                n7 = i;
            }
            if ("messageDestinationRefName".equals(stringArray[i])) {
                n9 = i;
            }
            if ("messageDestinationObject".equals(stringArray[i])) {
                n10 = i;
            }
            if ("resEnvRef.type".equals(stringArray[i])) {
                n8 = i;
            }
            if ("RARModule".equals(stringArray[i])) {
                n11 = i;
            }
            if ("j2cid".equals(stringArray[i])) {
                n12 = i;
            }
            if (!"j2c.jndiName".equals(stringArray[i])) continue;
            n2 = i;
        }
        if (!appDeploymentTask.isTaskEmpty()) {
            String[][] stringArray2 = appDeploymentTask.getTaskData();
            for (int i = 1; i < stringArray2.length; ++i) {
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                String string2 = Integer.toString(i);
                String string3 = null;
                String string4 = null;
                String string5 = null;
                if (stringArray2[i][n3] != null && !stringArray2[i][n3].equals("")) {
                    string3 = util.getModuleUriFromUriString(stringArray2[i][n3]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"URI is", (Object)string3);
                    }
                    string5 = stringArray2[i][n3].replace(',', '+');
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Unique ID", (Object)string5);
                    }
                }
                if (stringArray2[i][n2] != null && !stringArray2[i][n2].equals("")) {
                    string4 = stringArray2[i][n2];
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("jndi column " + string4));
                    }
                }
                Vector vector = new Vector();
                String string6 = null;
                String string7 = null;
                String string8 = null;
                string6 = (String)hashtable.get(string5);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"target", (Object)string6);
                }
                Set set = this.inScopeResources.keySet();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("KeySet: " + set));
                }
                if (stringArray2[i][n2] != null && !stringArray2[i][n2].equals("")) {
                    String string9;
                    hashMap2.put("uri", stringArray2[i][n3]);
                    hashMap2.put("JNDI", stringArray2[i][n2]);
                    if (string6 == null) {
                        string6 = "";
                    }
                    hashMap2.put("Targets", string6);
                    if (string.equals("DataSourceFor10CMPBeans") || string.equals("DataSourceFor20CMPBeans") || string.equals("DataSourceFor10EJBModules") || string.equals("DataSourceFor20EJBModules")) {
                        hashMap2.put("EJBModule", stringArray2[i][n4]);
                        string8 = "JDBCProvider";
                    }
                    if (string.equals("BindJndiForEJBMessageBinding")) {
                        hashMap2.put("EJBModule", stringArray2[i][n4]);
                        string8 = "JMS";
                    }
                    if (string.equals("MapResRefToEJB") || string.equals("MapResEnvRefToRes") || string.equals("MapMessageDestinationRefToEJB")) {
                        hashMap2.put("module", stringArray2[i][n5]);
                    }
                    if (string.equals("MapResRefToEJB")) {
                        hashMap2.put("referenceBinding", stringArray2[i][n6]);
                        hashMap2.put("resRef.type", stringArray2[i][n7]);
                        string8 = stringArray2[i][6];
                        string9 = (String)typeTranslation.get(string8);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("JNDI Type Translation: " + string9));
                        }
                        if (string9 != null) {
                            string8 = string9;
                        }
                    }
                    if (string.equals("MapResEnvRefToRes")) {
                        hashMap2.put("referenceBinding", stringArray2[i][n6]);
                        hashMap2.put("resEnvRef.type", stringArray2[i][n8]);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Begining Search for : " + string4));
                        }
                        string8 = stringArray2[i][4];
                        string9 = (String)typeTranslation.get(string8);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("JNDI Type Translation for resEnvRef: " + string9));
                        }
                        string8 = string9 != null ? string9 : "ResourceEnvironmentProvider";
                    }
                    if (string.equals("MapMessageDestinationRefToEJB")) {
                        hashMap2.put("messageDestinationObject", stringArray2[i][n10]);
                        hashMap2.put("messageDestinationRefName", stringArray2[i][n9]);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Begining Search for : " + string4));
                        }
                        string8 = "J2CAdminObject";
                    }
                }
                if (string.equals("ActSpecJNDI") && stringArray2[i][n2] != null && !stringArray2[i][n2].trim().equals("")) {
                    hashMap2.put("j2c.jndiName", stringArray2[i][n2]);
                    hashMap2.put("RARModule", stringArray2[i][n11]);
                    hashMap2.put("j2cid", stringArray2[i][n12]);
                    string8 = "J2CActivationSpec";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("JNDI Type: " + string8));
                }
                if (string8 != null) {
                    hashMap2.put("ExpectedJNDIType", string8);
                }
                Tr.debug((TraceComponent)tc, (String)("JNDI: " + string4));
                if (string4 != null) {
                    Object object;
                    string7 = this._validateResourceJndiNames(string4, string8, string6, new HashSet(set), this.inScopeResources, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("JNDI Key: " + string7));
                    }
                    boolean bl = false;
                    if (string7 == null) {
                        Tr.debug((TraceComponent)tc, (String)"JNDI Key was not found in scope");
                        object = new String[]{};
                        try {
                            string7 = this._locateOutOfScopeResourceTargets(string6, string4, string8);
                            Tr.debug((TraceComponent)tc, (String)("Found out of scope jndi key: " + string7));
                            bl = true;
                            hashMap2.put("OutOfScope", "true");
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.application.client.ResValidationHelper._validateTaskResources", (String)"920", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"Error loading Resources: ", (Object)exception);
                        }
                    }
                    if (string7 != null) {
                        object = this._getEarliestLocation(string7, string6);
                        Properties properties = this._getKeyProperties(string7);
                        String string10 = properties.getProperty("mistype");
                        if (object != null) {
                            if (this._isValidTarget(string6, (String)object) && !bl && string10 == null) {
                                hashMap2 = new HashMap();
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)"Scope is valid, skipping");
                                continue;
                            }
                            hashMap2.put("Scope", object);
                        } else {
                            hashMap2.put("Scope", this.JNDIKeys.get(string7));
                        }
                        String string11 = properties.getProperty("name");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("ResName: " + string11));
                        }
                        if (string11 != null) {
                            hashMap2.put("ResourceName", string11);
                        }
                        String string12 = properties.getProperty("type");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("ResType: " + string12));
                        }
                        if (string11 != null) {
                            hashMap2.put("ResourceType", string12);
                        }
                        Tr.debug((TraceComponent)tc, (String)("misType " + string10));
                        if (string10 != null) {
                            hashMap2.put("MisType", string10);
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("resInfoTable " + hashMap2));
                }
                if (hashMap2.size() <= 0) continue;
                hashMap.put(string2, hashMap2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validateTaskResources ", (Object)new Object[]{hashMap});
            }
        }
        return hashMap;
    }

    private String _locateOutOfScopeResourceTargets(String string, String string2, String string3) throws Exception {
        String string4;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"_locateOutOfScopeResourceTargets", (Object)new Object[]{string, string2, string3});
        }
        String[] stringArray = new String[]{};
        if (this._isClusterTarget(string)) {
            stringArray = this._findOutOfScopeResourceTargets(null);
        } else if (this._isServerTarget(string)) {
            object = this._getKeyProperties(string);
            string4 = ((Properties)object).getProperty("node");
            stringArray = this._findOutOfScopeResourceTargets(string4);
        }
        this._loadOutOfScopeResourceTargets(stringArray);
        object = this.outOfScopeResources.keySet();
        string4 = this._findJNDIKey((Set)object, string2, string3, this.outOfScopeResources, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_locateOutOfScopeResourceTargets", (Object)string4);
        }
        return string4;
    }

    private void _loadOutOfScopeResourceTargets(String[] stringArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"_loadOutOfScopeResourceTargets", (Object)stringArray);
        }
        String string = "WebSphere:cell=" + this.CELL_NAME;
        ArrayList arrayList = this._getJNDINames(this.CELL_CONTEXT);
        this._addToJNDITable(arrayList, this.JNDIKeys, string);
        this.outOfScopeResources.put(string, arrayList);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cell Context", (Object)this.CELL_CONTEXT);
            }
            if (this.outOfScopeResources.containsKey(string2 = string + ",node=" + stringArray[i])) continue;
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            RepositoryContext repositoryContext = this.CELL_CONTEXT.getChild(repositoryMetaData.getContextType("nodes"), stringArray[i]);
            ArrayList arrayList2 = this._getJNDINames(repositoryContext);
            this._addToJNDITable(arrayList2, this.JNDIKeys, string2);
            this.outOfScopeResources.put(string2, arrayList2);
            Collection collection = repositoryContext.findContext(repositoryMetaData.getContextType("servers"));
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Server Context", (Object)repositoryContext2);
                }
                String string3 = string2 + ",server=" + repositoryContext2.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Server Target" + string3));
                }
                ArrayList arrayList3 = this._getJNDINames(repositoryContext2);
                this._addToJNDITable(arrayList3, this.JNDIKeys, string3);
                this.outOfScopeResources.put(string3, arrayList3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_loadOutOfScopeResourceTargets", (Object)new Object[]{this.outOfScopeResources});
        }
    }

    private String[] _findOutOfScopeResourceTargets(String string) throws CommandNotFoundException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"_findOutOfScopeResourceTargets", (Object)string);
        }
        Session session = new Session();
        HashSet<String> hashSet = new HashSet<String>();
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        if (string == null) {
            AdminCommand adminCommand = commandMgr.createCommand("listNodes");
            adminCommand.setConfigSession(session);
            adminCommand.setParameter("nodeGroup", "DefaultNodeGroup");
            adminCommand.execute();
            CommandResult commandResult = adminCommand.getCommandResult();
            String[] stringArray = (String[])commandResult.getResult();
            return stringArray;
        }
        AdminCommand adminCommand = commandMgr.createCommand("listNodeGroups");
        adminCommand.setConfigSession(session);
        adminCommand.setTargetObject(string);
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        String[] stringArray = (String[])commandResult.getResult();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"NodeGroups: ", (Object)stringArray);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            AdminCommand adminCommand2 = commandMgr.createCommand("listNodes");
            adminCommand2.setConfigSession(session);
            adminCommand2.setParameter("nodeGroup", stringArray[i]);
            adminCommand2.execute();
            CommandResult commandResult2 = adminCommand2.getCommandResult();
            String[] stringArray2 = (String[])commandResult2.getResult();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Nodes: ", (Object)stringArray);
            }
            for (int j = 0; j < stringArray2.length; ++j) {
                hashSet.add(stringArray2[j]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"NodeSet: ", hashSet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_findOutOfScopeResourceTargets", hashSet);
        }
        return hashSet.toArray(new String[0]);
    }

    private ArrayList _getJNDINames(RepositoryContext repositoryContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"_getJNDINames", (Object)new Object[]{repositoryContext});
        }
        WorkSpaceQueryUtil workSpaceQueryUtil = WorkSpaceQueryUtilFactory.getUtil();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < resTypes.length; ++i) {
            ArrayList arrayList2;
            block16: {
                Tr.debug((TraceComponent)tc, (String)("resTypes[i] " + resTypes[i]));
                arrayList2 = new ArrayList();
                try {
                    if (resTypes[i].equals("WAS40DataSource")) {
                        arrayList2 = (ArrayList)workSpaceQueryUtil.get40CMPResourceJNDINames(repositoryContext);
                        Tr.debug((TraceComponent)tc, (String)("jndiList for 40datasource " + arrayList2));
                    } else if (resTypes[i].equals("WAS50DataSource")) {
                        arrayList2 = (ArrayList)workSpaceQueryUtil.get50DataSourceResourceJNDINames(repositoryContext);
                        Tr.debug((TraceComponent)tc, (String)("jndiList for 50datasource " + arrayList2));
                    } else if (resTypes[i].equals("J2CAdminObject")) {
                        arrayList2 = (ArrayList)workSpaceQueryUtil.getJ2CAdminObjectsJNDINames(repositoryContext);
                        Tr.debug((TraceComponent)tc, (String)("jndiList for j2CAdminObject " + arrayList2));
                    } else if (resTypes[i].equals("J2CActivationSpec")) {
                        arrayList2 = (ArrayList)workSpaceQueryUtil.getJ2CActivationSpecJNDINames(repositoryContext);
                        Tr.debug((TraceComponent)tc, (String)("jndiList for J2CActivationSpec " + arrayList2));
                    } else if (resTypes[i].equals("J2CConnectionFactory")) {
                        arrayList2 = (ArrayList)workSpaceQueryUtil.getJ2CConnectionFactoryJNDINames(repositoryContext);
                        Tr.debug((TraceComponent)tc, (String)("jndiList for J2CConnectionFactory " + arrayList2));
                    } else {
                        arrayList2 = (ArrayList)workSpaceQueryUtil.getResourceJNDINames(repositoryContext, resTypes[i]);
                        Tr.debug((TraceComponent)tc, (String)("jndiList for resources " + arrayList2));
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.application.client.ResValidationHelper._findOutOfScopeResourceTargets", (String)"1123", (Object)this);
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug((TraceComponent)tc, (String)("Exception when getting jndi list: " + exception));
                }
            }
            for (int j = 0; j < arrayList2.size(); ++j) {
                String string = new String();
                String string2 = (String)arrayList2.get(j);
                String string3 = workSpaceQueryUtil.getResourceNameFromJNDI(repositoryContext, resTypes[i], string2);
                String string4 = workSpaceQueryUtil.getResourceTypeFromJNDI(repositoryContext, resTypes[i], string2);
                string = "WebSphere:JNDI=" + string2 + ",type=" + resTypes[i] + ",name=" + string3 + ",subtype=" + string4;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("JNDI Key: " + string));
                }
                arrayList.add(string);
            }
        }
        Tr.debug((TraceComponent)tc, (String)("_getJNDINames List: " + arrayList));
        return arrayList;
    }

    private void _addToJNDITable(ArrayList arrayList, Map map, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"_addToJNDITable", (Object)new Object[]{arrayList, map, string});
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            HashSet hashSet;
            String string2 = (String)arrayList.get(i);
            if (map.get(string2) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"New List");
                }
                hashSet = new HashSet();
                hashSet.add(string);
                map.put(string2, hashSet);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Table already contains list");
            }
            hashSet = (HashSet)map.get(string2);
            hashSet.add(string);
            map.put(string2, hashSet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_addToJNDITable", (Object)new Object[]{map});
        }
    }

    private List _convertMultipleTargets(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"_convertMultipleTargets", (Object)new Object[]{string});
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("nextToken: " + string2));
            }
            if (string2 == null || string2.trim().equals("") || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_convertMultipleTargets", (Object)new Object[]{arrayList});
        }
        return arrayList;
    }

    private String _getEarliestLocation(String string, String string2) {
        Properties properties;
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"_getEarliestLocation", (Object)new Object[]{string, string2});
        }
        if ((string3 = (properties = this._getKeyProperties(string)).getProperty("mistype")) != null) {
            int n = string.lastIndexOf(",mistype=");
            string = string.substring(0, n);
            Tr.debug((TraceComponent)tc, (String)("jndiKey " + string));
        }
        HashSet hashSet = (HashSet)this.JNDIKeys.get(string);
        List list = this._convertMultipleTargets(string2);
        for (int i = 0; i < list.size(); ++i) {
            String string4 = (String)list.get(i);
            if (!hashSet.contains(string4)) continue;
            String string5 = this._getPreviousLevel(string);
            if (hashSet.contains(string5)) {
                String string6 = this._getPreviousLevel(string5);
                if (hashSet.contains(string6)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"_getEarliestLocation", (Object)new Object[]{string6});
                    }
                    return string6;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"_getEarliestLocation", (Object)new Object[]{string5});
                }
                return string5;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"_getEarliestLocation", (Object)new Object[]{string4});
            }
            return string4;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_getEarliestLocation", (Object)new Object[]{null});
        }
        return null;
    }

    private String _validateResourceJndiNames(String string, String string2, String string3, Set set, Map map, boolean bl) {
        Object object;
        String string4;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"_validateResourceJndiNames ", (Object)new Object[]{string, string3, set, map, new Boolean(bl)});
        }
        String string5 = null;
        List list = this._convertMultipleTargets(string3);
        for (n = 0; n < list.size() && string5 == null; ++n) {
            string4 = (String)list.get(n);
            object = (ArrayList)map.get(string4);
            if (!set.contains(string4)) continue;
            set.remove(string4);
            if (object == null) continue;
            string5 = this._findJNDIKey(string4, string, string2, map, bl);
        }
        if (string5 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"no match, looking at parent scope");
            }
            for (n = 0; n < list.size() && string5 == null; ++n) {
                string4 = (String)list.get(n);
                if (this._isCellTarget(string4)) continue;
                object = this._getPreviousLevel(string4);
                string5 = this._validateResourceJndiNames(string, string2, (String)object, set, map, bl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_validateResourceJndiNames", string5);
        }
        return string5;
    }

    private String _findJNDIKey(Set set, String string, String string2, Map map, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"_findJNDIKeyFromSet", (Object)new Object[]{set, string, string2, map});
        }
        Iterator iterator = set.iterator();
        String string3 = null;
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            string3 = this._findJNDIKey(string4, string, string2, map, bl);
            if (string3 == null) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"_findJNDIKeyFromSet", (Object)string3);
            }
            return string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_findJNDIKeyFromSet", string3);
        }
        return string3;
    }

    private String _findJNDIKey(String string, String string2, String string3, Map map, boolean bl) {
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"_findJNDIKey", (Object)new Object[]{string, string2, string3, map, new Boolean(bl)});
        }
        if ((arrayList = (ArrayList)map.get(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"_findJNDIKey no list");
            }
            return null;
        }
        Iterator iterator = arrayList.iterator();
        String string4 = null;
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            Properties properties = this._getKeyProperties(string5);
            String string6 = properties.getProperty("JNDI");
            String string7 = properties.getProperty("type");
            if (!string6.equals(string2) && !string6.equals("eis/" + string2 + "_CMP")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found Match name: " + string6));
            }
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Strict Match of Type: " + string7));
                }
                if (string3.equals(string7)) {
                    string4 = string5;
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"_findJNDIKey", (Object)new Object[]{string4});
                    }
                    return string4;
                }
                if (string7.equals("J2CResourceAdapter") || string7.equals("J2CAdminObject") || string7.equals("J2CActivationSpec")) {
                    if (string3.equals("JDBCProvider") || string3.equals("JMS")) {
                        string4 = string5;
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"_findJNDIKey", (Object)new Object[]{string4});
                        }
                        return string4;
                    }
                } else if (string3.equals("mailSession") && string7.equals("MailProvider")) {
                    string4 = string5;
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"_findJNDIKey", (Object)new Object[]{string4});
                    }
                    return string4;
                }
                string4 = string5 = string5 + ",mistype=" + string3;
                continue;
            }
            string4 = string5;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"_findJNDIKey", (Object)new Object[]{string4});
            }
            return string4;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_findJNDIKey", (Object)new Object[]{string4});
        }
        return string4;
    }

    private ArrayList _getEmbeddedRarJNDIs(AppDeploymentController appDeploymentController) {
        Vector vector;
        AppDeploymentTask appDeploymentTask;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"_getEmbeddedRarJNDIs", (Object)new Object[]{appDeploymentController});
            }
            appDeploymentTask = null;
            vector = new Vector();
            try {
                appDeploymentTask = appDeploymentController.getTaskByName("EmbeddedRar", false);
            }
            catch (AppDeploymentException appDeploymentException) {
                FFDCFilter.processException((Throwable)appDeploymentException, (String)"com.ibm.websphere.management.application.client.ResValidationHelper._getEmbeddedRarJNDIs", (String)"1320", (Object)this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)("Exception when calling getTaskByName: " + appDeploymentException));
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!appDeploymentTask.isTaskEmpty()) {
            String[][] stringArray = appDeploymentTask.getTaskData();
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i][5] == null || stringArray[i][5].equals("")) continue;
                Tr.debug((TraceComponent)tc, (String)("j2c jndi " + stringArray[i][5]));
                String string = stringArray[i][2];
                String string2 = stringArray[i][5];
                String string3 = "WebSphere:JNDI=" + string2 + ",type=" + string;
                arrayList.add(string3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_getEmbeddedRarJNDIs", (Object)new Object[]{vector});
        }
        return arrayList;
    }

    static {
        typeTranslation.put("javax.sql.DataSource", "JDBCProvider");
        typeTranslation.put("javax.mail.Session", "mailSession");
        typeTranslation.put("java.net.URL", "URLProvider");
        typeTranslation.put("javax.jms.QueueConnectionFactory", "JMS");
        typeTranslation.put("javax.jms.TopicConnectionFactory", "JMS");
        typeTranslation.put("javax.jms.ConnectionFactory", "JMS");
        typeTranslation.put("javax.jms.Queue", "JMS");
        typeTranslation.put("javax.jms.Topic", "JMS");
        typeTranslation.put("javax.resource.cci.ConnectionFactory", "J2CResourceAdapter");
    }
}

