/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

import com.ibm.pkcs11.PKCS11;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.util.Date;

public abstract class PKCS11Object {
    public static final int CLASS = 0;
    public static final int TOKEN = 1;
    public static final int PRIVATE = 2;
    public static final int LABEL = 3;
    public static final int APPLICATION = 16;
    public static final int VALUE = 17;
    public static final int OBJECT_ID = 18;
    public static final int CERTIFICATE_TYPE = 128;
    public static final int ISSUER = 129;
    public static final int SERIAL_NUMBER = 130;
    public static final int AC_ISSUER = 131;
    public static final int OWNER = 132;
    public static final int ATTR_TYPES = 133;
    public static final int TRUSTED = 134;
    public static final int KEY_TYPE = 256;
    public static final int SUBJECT = 257;
    public static final int ID = 258;
    public static final int SENSITIVE = 259;
    public static final int ENCRYPT = 260;
    public static final int DECRYPT = 261;
    public static final int WRAP = 262;
    public static final int UNWRAP = 263;
    public static final int SIGN = 264;
    public static final int SIGN_RECOVER = 265;
    public static final int VERIFY = 266;
    public static final int VERIFY_RECOVER = 267;
    public static final int DERIVE = 268;
    public static final int START_DATE = 272;
    public static final int END_DATE = 273;
    public static final int MODULUS = 288;
    public static final int MODULUS_BITS = 289;
    public static final int PUBLIC_EXPONENT = 290;
    public static final int PRIVATE_EXPONENT = 291;
    public static final int PRIME_1 = 292;
    public static final int PRIME_2 = 293;
    public static final int EXPONENT_1 = 294;
    public static final int EXPONENT_2 = 295;
    public static final int COEFFICIENT = 296;
    public static final int PRIME = 304;
    public static final int SUBPRIME = 305;
    public static final int BASE = 306;
    public static final int PRIME_BITS = 307;
    public static final int SUBPRIME_BITS = 308;
    public static final int VALUE_BITS = 352;
    public static final int VALUE_LEN = 353;
    public static final int EXTRACTABLE = 354;
    public static final int LOCAL = 355;
    public static final int NEVER_EXTRACTABLE = 356;
    public static final int ALWAYS_SENSITIVE = 357;
    public static final int KEY_GEN_MECHANISM = 358;
    public static final int MODIFIABLE = 368;
    public static final int ECDSA_PARAMS = 384;
    public static final int EC_PARAMS = 384;
    public static final int EC_POINT = 385;
    public static final int SECONDARY_AUTH = 512;
    public static final int AUTH_PIN_FLAGS = 513;
    public static final int HW_FEATURE_TYPE = 768;
    public static final int RESET_ON_INIT = 769;
    public static final int HAS_RESET = 770;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;
    public static final int INVALID = -1;
    private static final int[] CKA_types = new int[]{0, 1, 2, 3, 16, 17, 18, 128, 129, 130, 131, 132, 133, 134, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 272, 273, 288, 289, 290, 291, 292, 293, 294, 295, 296, 304, 305, 306, 307, 308, 352, 353, 354, 355, 356, 357, 358, 368, 384, 384, 385, 512, 513, 768, 769, 770};
    private static final String[] CKA_names = new String[]{PKCS11Object.a("S<q+X"), PKCS11Object.a("D?{=E"), PKCS11Object.a("@\"y.JD5"), PKCS11Object.a("\\1r=G"), PKCS11Object.a("Q `4BS1d1D^"), PKCS11Object.a("F1|-N"), PKCS11Object.a("_2z=HD/y<"), PKCS11Object.a("S5b,BV9s9_U/d![U"), PKCS11Object.a("Y#c-NB"), PKCS11Object.a("C5b1J\\/~-FR5b"), PKCS11Object.a("Q3o1XC%u*"), PKCS11Object.a("_'~=Y"), PKCS11Object.a("Q$d*TD)`=X"), PKCS11Object.a("D\"e+_U4"), PKCS11Object.a("[5i'_I u"), PKCS11Object.a("C%r2NS$"), PKCS11Object.a("Y4"), PKCS11Object.a("C5~+BD9f="), PKCS11Object.a("U>s*R@$"), PKCS11Object.a("T5s*R@$"), PKCS11Object.a("G\"q("), PKCS11Object.a("E>g*J@"), PKCS11Object.a("C9w6"), PKCS11Object.a("C9w6TB5s7]U\""), PKCS11Object.a("F5b1MI"), PKCS11Object.a("F5b1MI/b=H_&u*"), PKCS11Object.a("T5b1]U"), PKCS11Object.a("C$q*_O4q,N"), PKCS11Object.a("U>t'OQ$u"), PKCS11Object.a("]?t-GE#"), PKCS11Object.a("]?t-GE#o:BD#"), PKCS11Object.a("@%r4BS/u [_>u6_"), PKCS11Object.a("@\"y.JD5o=S@?~=ED"), PKCS11Object.a("@\"y5NOA"), PKCS11Object.a("@\"y5NOB"), PKCS11Object.a("U(`7EU>d':"), PKCS11Object.a("U(`7EU>d'9"), PKCS11Object.a("S?u>MY3y=ED"), PKCS11Object.a("@\"y5N"), PKCS11Object.a("C%r(YY=u"), PKCS11Object.a("R1c="), PKCS11Object.a("@\"y5NO2y,X"), PKCS11Object.a("C%r(YY=u'IY$c"), PKCS11Object.a("F1|-NO2y,X"), PKCS11Object.a("F1|-NO<u6"), PKCS11Object.a("U(d*JS$q:GU"), PKCS11Object.a("\\?s9G"), PKCS11Object.a("^5f=YO5h,YQ3d9I\\5"), PKCS11Object.a("Q<g9RC/c=EC9d1]U"), PKCS11Object.a("[5i'LU>o5NS8q6BC="), PKCS11Object.a("]?t1MY1r4N"), PKCS11Object.a("U3t+JO q*J]#"), PKCS11Object.a("U3o(JB1}+"), PKCS11Object.a("U3o(DY>d"), PKCS11Object.a("C5s7ET1b!TQ%d0"), PKCS11Object.a("Q%d0T@9~'M\\1w+"), PKCS11Object.a("X'o>NQ$e*NO$i(N"), PKCS11Object.a("B5c=_O?~'B^9d"), PKCS11Object.a("X1c'YU#u,")};
    private static final Class[] CKA_classes = new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%Y\u001eD\u001dlu\u0002"))) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%C\u0004B\u0011ew"))) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%C\u0004B\u0011ew"))) : class$java$lang$String, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("K2"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("K2"))) : array$B, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%Y\u001eD\u001dlu\u0002"))) : class$java$lang$Integer, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("K2"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("K2"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("K2"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("K2"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("K2"))) : array$B, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%Y\u001eD\u001dlu\u0002"))) : class$java$lang$Integer, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("K2"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("K2"))) : array$B, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$util$Date == null ? (class$java$util$Date = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%e\u0004Y\u0014%T\u0011D\u001d"))) : class$java$util$Date, class$java$util$Date == null ? (class$java$util$Date = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%e\u0004Y\u0014%T\u0011D\u001d"))) : class$java$util$Date, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%}\u0011D\u0010%R\u0019W1ed\u0015W\u001dy"))) : class$java$math$BigInteger, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%Y\u001eD\u001dlu\u0002"))) : class$java$lang$Integer, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%}\u0011D\u0010%R\u0019W1ed\u0015W\u001dy"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%}\u0011D\u0010%R\u0019W1ed\u0015W\u001dy"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%}\u0011D\u0010%R\u0019W1ed\u0015W\u001dy"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%}\u0011D\u0010%R\u0019W1ed\u0015W\u001dy"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%}\u0011D\u0010%R\u0019W1ed\u0015W\u001dy"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%}\u0011D\u0010%R\u0019W1ed\u0015W\u001dy"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%}\u0011D\u0010%R\u0019W1ed\u0015W\u001dy"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%}\u0011D\u0010%R\u0019W1ed\u0015W\u001dy"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%}\u0011D\u0010%R\u0019W1ed\u0015W\u001dy"))) : class$java$math$BigInteger, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%}\u0011D\u0010%R\u0019W1ed\u0015W\u001dy"))) : class$java$math$BigInteger, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%Y\u001eD\u001dlu\u0002"))) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%Y\u001eD\u001dlu\u0002"))) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%Y\u001eD\u001dlu\u0002"))) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%Y\u001eD\u001dlu\u0002"))) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%Y\u001eD\u001dlu\u0002"))) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("K2"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("K2"))) : array$B, array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("K2"))) : array$B, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%Y\u001eD\u001dlu\u0002"))) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%Y\u001eD\u001dlu\u0002"))) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean};
    public static final Integer RSA = new Integer(0);
    public static final Integer DSA = new Integer(1);
    public static final Integer DH = new Integer(2);
    public static final Integer ECDSA = new Integer(3);
    public static final Integer EC = new Integer(3);
    public static final Integer X9_42_DH = new Integer(4);
    public static final Integer KEA = new Integer(5);
    public static final Integer GENERIC_SECRET = new Integer(16);
    public static final Integer RC2 = new Integer(17);
    public static final Integer RC4 = new Integer(18);
    public static final Integer DES = new Integer(19);
    public static final Integer DES2 = new Integer(20);
    public static final Integer DES3 = new Integer(21);
    public static final Integer CAST = new Integer(22);
    public static final Integer CAST3 = new Integer(23);
    public static final Integer CAST5 = new Integer(24);
    public static final Integer CAST128 = new Integer(24);
    public static final Integer RC5 = new Integer(25);
    public static final Integer IDEA = new Integer(26);
    public static final Integer SKIPJACK = new Integer(27);
    public static final Integer BATON = new Integer(28);
    public static final Integer JUNIPER = new Integer(29);
    public static final Integer CDMF = new Integer(30);
    public static final Integer AES = new Integer(31);
    private static final Integer[] CKK_types = new Integer[]{RSA, DSA, DH, ECDSA, EC, X9_42_DH, KEA, GENERIC_SECRET, RC2, RC4, DES, DES2, DES3, CAST, CAST3, CAST5, CAST128, RC5, IDEA, SKIPJACK, BATON, JUNIPER, CDMF, AES};
    private static final String[] CKK_names = new String[]{PKCS11Object.a("B#q"), PKCS11Object.a("T#q"), PKCS11Object.a("T8"), PKCS11Object.a("U3t+J"), PKCS11Object.a("U3"), PKCS11Object.a("HIoL9O4x"), PKCS11Object.a("[5q"), PKCS11Object.a("W5~=YY3o+NS\"u,"), PKCS11Object.a("B3\u0002"), PKCS11Object.a("B3\u0004"), PKCS11Object.a("T5c"), PKCS11Object.a("T5cJ"), PKCS11Object.a("T5cK"), PKCS11Object.a("S1c,"), PKCS11Object.a("S1c,8"), PKCS11Object.a("S1c,>"), PKCS11Object.a("S1c,:\"H"), PKCS11Object.a("B3\u0005"), PKCS11Object.a("Y4u9"), PKCS11Object.a("C;y(AQ3{"), PKCS11Object.a("R1d7E"), PKCS11Object.a("Z%~1[U\""), PKCS11Object.a("S4}>"), PKCS11Object.a("Q5c")};
    public static final Integer DATA = new Integer(0);
    public static final Integer CERTIFICATE = new Integer(1);
    public static final Integer PUBLIC_KEY = new Integer(2);
    public static final Integer PRIVATE_KEY = new Integer(3);
    public static final Integer SECRET_KEY = new Integer(4);
    public static final Integer HW_FEATURE = new Integer(5);
    public static final Integer DOMAIN_PARAMETERS = new Integer(6);
    private static final Integer[] CKO_types = new Integer[]{DATA, CERTIFICATE, PUBLIC_KEY, PRIVATE_KEY, SECRET_KEY, HW_FEATURE, DOMAIN_PARAMETERS};
    private static final String[] CKO_names = new String[]{PKCS11Object.a("T1d9"), PKCS11Object.a("S5b,BV9s9_U"), PKCS11Object.a("@%r4BS/{=R"), PKCS11Object.a("@\"y.JD5o3NI"), PKCS11Object.a("C5s*ND/{=R"), PKCS11Object.a("X'o>NQ$e*N"), PKCS11Object.a("T?}9B^/`9YQ=u,NB#")};
    public static final Integer MONOTONIC_COUNTER = new Integer(1);
    public static final Integer CLOCK = new Integer(2);
    private static final Integer[] CKH_types = new Integer[]{MONOTONIC_COUNTER, CLOCK};
    private static final String[] CKH_names = new String[]{PKCS11Object.a("]?~7__>y;TS?e6_U\""), PKCS11Object.a("S<\u007f;@")};
    public static final Integer X_509 = new Integer(0);
    public static final Integer X_509_ATTR_CERT = new Integer(1);
    private static final Integer[] CKC_types = new Integer[]{X_509, X_509_ATTR_CERT};
    private static final String[] CKC_names = new String[]{PKCS11Object.a("H/\u0005H2"), PKCS11Object.a("H/\u0005H2O1d,YO3u*_")};
    public static final Boolean TRUE = Boolean.TRUE;
    public static final Boolean FALSE = Boolean.FALSE;
    private static final int[] pinflagList = new int[]{65536, 131072, 262144, 524288};
    static final String[] pinflagNames = new String[]{PKCS11Object.a("E#u*T@9~'H_%~,T\\?g"), PKCS11Object.a("E#u*T@9~'MY>q4TD\"i"), PKCS11Object.a("E#u*T@9~'G_3{=O"), PKCS11Object.a("E#u*T@9~'__/r=TS8q6LU4")};
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigInteger;

    protected PKCS11Object() {
    }

    public abstract PKCS11Session getSession() throws PKCS11Exception;

    public abstract PKCS11Object copy(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void destroy() throws PKCS11Exception;

    public abstract int size() throws PKCS11Exception;

    public Object[] getAttributeValues(int[] nArray) throws PKCS11Exception {
        Object[] objectArray = new Object[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            objectArray[n2] = this.getAttributeValue(nArray[n2]);
            ++n2;
        }
        return objectArray;
    }

    public abstract Object getAttributeValue(int var1) throws PKCS11Exception;

    public boolean getBoolAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean)) {
            throw new PKCS11Exception(18);
        }
        return (Boolean)this.getAttributeValue(n2);
    }

    public int getIntAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%Y\u001eD\u001dlu\u0002"))) : class$java$lang$Integer)) {
            throw new PKCS11Exception(18);
        }
        return (Integer)this.getAttributeValue(n2);
    }

    public String getStringAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$String == null ? (class$java$lang$String = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%C\u0004B\u0011ew"))) : class$java$lang$String)) {
            throw new PKCS11Exception(18);
        }
        return (String)this.getAttributeValue(n2);
    }

    public byte[] getByteArrayAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("K2"))) : array$B)) {
            throw new PKCS11Exception(18);
        }
        return (byte[])this.getAttributeValue(n2);
    }

    public Date getDateAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$util$Date == null ? (class$java$util$Date = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%e\u0004Y\u0014%T\u0011D\u001d"))) : class$java$util$Date)) {
            throw new PKCS11Exception(18);
        }
        return (Date)this.getAttributeValue(n2);
    }

    public BigInteger getBigIntegerAttributeValue(int n2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%}\u0011D\u0010%R\u0019W1ed\u0015W\u001dy"))) : class$java$math$BigInteger)) {
            throw new PKCS11Exception(18);
        }
        return (BigInteger)this.getAttributeValue(n2);
    }

    public abstract void setAttributeValues(int[] var1, Object[] var2) throws PKCS11Exception;

    public abstract void setAttributeValue(int var1, Object var2) throws PKCS11Exception;

    public void setBoolAttributeValue(int n2, boolean bl2) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%R\u001f_\u0014nq\u001e"))) : class$java$lang$Boolean)) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(n2, new Boolean(bl2));
    }

    public void setIntAttributeValue(int n2, int n3) throws PKCS11Exception {
        if (PKCS11Object.valueClass(n2) != (class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%Y\u001eD\u001dlu\u0002"))) : class$java$lang$Integer)) {
            throw new PKCS11Exception(18);
        }
        this.setAttributeValue(n2, new Integer(n3));
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(512);
        String string = PKCS11Object.a("0P\u0010X+0P\u0010X+0P\u0010X+0P\u0010X+");
        stringBuffer.append(PKCS11Object.a("\u007f\u0012Z\u001dhdJ:"));
        int n3 = 0;
        while (n3 < CKA_types.length) {
            String string2;
            String string3;
            block6: {
                n2 = CKA_types[n3];
                string3 = PKCS11Object.typeToString(n2);
                string2 = null;
                try {
                    Object object = this.getAttributeValue(n2);
                    string2 = PKCS11Object.attrToString(n2, object);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    if (pKCS11Exception.getCode() != 17) break block6;
                    string2 = PKCS11Object.a("81d,YY2e,NO#u6XY$y.N9");
                }
            }
            if (string2 != null) {
                stringBuffer.append("\t").append(string3).append(":");
                stringBuffer.append(string.substring(string3.length()));
                stringBuffer.append(string2).append("\n");
            }
            ++n3;
        }
        try {
            n2 = this.size();
            stringBuffer.append(PKCS11Object.a("\u0019#y\"N*")).append(string.substring(4)).append(n2).append("\n");
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static Class valueClass(int n2) {
        int n3 = 0;
        while (n3 < CKA_types.length) {
            if (CKA_types[n3] == n2) {
                return CKA_classes[n3];
            }
            ++n3;
        }
        return null;
    }

    public static String typeToString(int n2) {
        int n3 = 0;
        while (n3 < CKA_types.length) {
            if (CKA_types[n3] == n2) {
                return CKA_names[n3];
            }
            ++n3;
        }
        return PKCS11Object.a(" \b") + Integer.toHexString(n2);
    }

    public static String classToString(Integer n2) {
        return PKCS11Object.IntegerToString(n2, CKO_types, CKO_names);
    }

    public static String keyToString(Integer n2) {
        return PKCS11Object.IntegerToString(n2, CKK_types, CKK_names);
    }

    public static String hwfeatureToString(Integer n2) {
        return PKCS11Object.IntegerToString(n2, CKH_types, CKH_names);
    }

    public static String certToString(Integer n2) {
        return PKCS11Object.IntegerToString(n2, CKC_types, CKC_names);
    }

    public static String pinflagsToString(Integer n2) {
        return PKCS11.flagsToString(n2, pinflagList, pinflagNames, PKCS11Object.a("0\f\u0010"));
    }

    public static String attrToString(int n2, Object object) {
        if (object == null) {
            return PKCS11Object.a("~\u0005\\\u0014");
        }
        Class clazz = PKCS11Object.valueClass(n2);
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%|\u0011^\u001f%Y\u001eD\u001dlu\u0002"))) : class$java$lang$Integer)) {
            switch (n2) {
                case 0: {
                    return PKCS11Object.classToString((Integer)object);
                }
                case 256: {
                    return PKCS11Object.keyToString((Integer)object);
                }
                case 128: {
                    return PKCS11Object.certToString((Integer)object);
                }
                case 513: {
                    return PKCS11Object.pinflagsToString((Integer)object);
                }
                case 768: {
                    return PKCS11Object.hwfeatureToString((Integer)object);
                }
            }
            return object.toString();
        }
        if (clazz == (array$B == null ? (array$B = PKCS11Object.class$(PKCS11Object.a("K2"))) : array$B)) {
            return PKCS11Object.bytesToString((byte[])object, 10);
        }
        if (clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = PKCS11Object.class$(PKCS11Object.a("z\u0011F\u0019%}\u0011D\u0010%R\u0019W1ed\u0015W\u001dy"))) : class$java$math$BigInteger)) {
            return PKCS11Object.a(" \b") + ((BigInteger)object).toString(16);
        }
        return object.toString();
    }

    public static String bytesToString(byte[] byArray, int n2) {
        if (byArray == null) {
            return PKCS11Object.a("~\u0005\\\u0014");
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            if (n2 != 0 && n4 > n2) {
                stringBuffer.append(PKCS11Object.a("0^\u001eV+8")).append(byArray.length).append(PKCS11Object.a("0\u0012I\fncY"));
                break;
            }
            if (n3 == 16) {
                stringBuffer.append('\n');
                n3 = 0;
            }
            if (n3 > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(PKCS11Object.a(" A\u0002K?%F\u0007@2q\u0012S\u001cnv").charAt(byArray[n4] >> 4 & 0xF));
            stringBuffer.append(PKCS11Object.a(" A\u0002K?%F\u0007@2q\u0012S\u001cnv").charAt(byArray[n4] & 0xF));
            ++n4;
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static String IntegerToString(Integer n2, Integer[] integerArray, String[] stringArray) {
        int n3 = n2;
        int n4 = 0;
        while (n4 < integerArray.length) {
            if (integerArray[n4] == n3) {
                return stringArray[n4];
            }
            ++n4;
        }
        return PKCS11Object.a(" \b") + Integer.toHexString(n3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 16;
                        break;
                    }
                    case 1: {
                        n5 = 112;
                        break;
                    }
                    case 2: {
                        n5 = 48;
                        break;
                    }
                    case 3: {
                        n5 = 120;
                        break;
                    }
                    default: {
                        n5 = 11;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

