/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

public class PKCS11Exception
extends RuntimeException {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int HOST_MEMORY = 2;
    public static final int SLOT_ID_INVALID = 3;
    public static final int GENERAL_ERROR = 5;
    public static final int FUNCTION_FAILED = 6;
    public static final int ARGUMENTS_BAD = 7;
    public static final int NO_EVENT = 8;
    public static final int NEED_TO_CREATE_THREADS = 9;
    public static final int CANT_LOCK = 10;
    public static final int ATTRIBUTE_READ_ONLY = 16;
    public static final int ATTRIBUTE_SENSITIVE = 17;
    public static final int ATTRIBUTE_TYPE_INVALID = 18;
    public static final int ATTRIBUTE_VALUE_INVALID = 19;
    public static final int DATA_INVALID = 32;
    public static final int DATA_LEN_RANGE = 33;
    public static final int DEVICE_ERROR = 48;
    public static final int DEVICE_MEMORY = 49;
    public static final int DEVICE_REMOVED = 50;
    public static final int ENCRYPTED_DATA_INVALID = 64;
    public static final int ENCRYPTED_DATA_LEN_RANGE = 65;
    public static final int FUNCTION_CANCELED = 80;
    public static final int FUNCTION_NOT_PARALLEL = 81;
    public static final int FUNCTION_NOT_SUPPORTED = 84;
    public static final int KEY_HANDLE_INVALID = 96;
    public static final int KEY_SIZE_RANGE = 98;
    public static final int KEY_TYPE_INCONSISTENT = 99;
    public static final int KEY_NOT_NEEDED = 100;
    public static final int KEY_CHANGED = 101;
    public static final int KEY_NEEDED = 102;
    public static final int KEY_INDIGESTIBLE = 103;
    public static final int KEY_FUNCTION_NOT_PERMITTED = 104;
    public static final int KEY_NOT_WRAPPABLE = 105;
    public static final int KEY_UNEXTRACTABLE = 106;
    public static final int MECHANISM_INVALID = 112;
    public static final int MECHANISM_PARAM_INVALID = 113;
    public static final int OBJECT_HANDLE_INVALID = 130;
    public static final int OPERATION_ACTIVE = 144;
    public static final int OPERATION_NOT_INITIALIZED = 145;
    public static final int PIN_INCORRECT = 160;
    public static final int PIN_INVALID = 161;
    public static final int PIN_LEN_RANGE = 162;
    public static final int PIN_EXPIRED = 163;
    public static final int PIN_LOCKED = 164;
    public static final int SESSION_CLOSED = 176;
    public static final int SESSION_COUNT = 177;
    public static final int SESSION_HANDLE_INVALID = 179;
    public static final int SESSION_PARALLEL_NOT_SUPPORTED = 180;
    public static final int SESSION_READ_ONLY = 181;
    public static final int SESSION_EXISTS = 182;
    public static final int SESSION_READ_ONLY_EXISTS = 183;
    public static final int SESSION_READ_WRITE_SO_EXISTS = 184;
    public static final int SIGNATURE_INVALID = 192;
    public static final int SIGNATURE_LEN_RANGE = 193;
    public static final int TEMPLATE_INCOMPLETE = 208;
    public static final int TEMPLATE_INCONSISTENT = 209;
    public static final int TOKEN_NOT_PRESENT = 224;
    public static final int TOKEN_NOT_RECOGNIZED = 225;
    public static final int TOKEN_WRITE_PROTECTED = 226;
    public static final int UNWRAPPING_KEY_HANDLE_INVALID = 240;
    public static final int UNWRAPPING_KEY_SIZE_RANGE = 241;
    public static final int UNWRAPPING_KEY_TYPE_INCONSISTENT = 242;
    public static final int USER_ALREADY_LOGGED_IN = 256;
    public static final int USER_NOT_LOGGED_IN = 257;
    public static final int USER_PIN_NOT_INITIALIZED = 258;
    public static final int USER_TYPE_INVALID = 259;
    public static final int USER_ANOTHER_ALREADY_LOGGED_IN = 260;
    public static final int USER_TOO_MANY_TYPES = 261;
    public static final int WRAPPED_KEY_INVALID = 272;
    public static final int WRAPPED_KEY_LEN_RANGE = 274;
    public static final int WRAPPING_KEY_HANDLE_INVALID = 275;
    public static final int WRAPPING_KEY_SIZE_RANGE = 276;
    public static final int WRAPPING_KEY_TYPE_INCONSISTENT = 277;
    public static final int RANDOM_SEED_NOT_SUPPORTED = 288;
    public static final int RANDOM_NO_RNG = 289;
    public static final int DOMAIN_PARAMS_INVALID = 304;
    public static final int BUFFER_TOO_SMALL = 336;
    public static final int SAVED_STATE_INVALID = 352;
    public static final int INFORMATION_SENSITIVE = 368;
    public static final int STATE_UNSAVEABLE = 384;
    public static final int CRYPTOKI_NOT_INITIALIZED = 400;
    public static final int CRYPTOKI_ALREADY_INITIALIZED = 401;
    public static final int MUTEX_BAD = 416;
    public static final int MUTEX_NOT_LOCKED = 417;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;
    private static final int[] CKR_types = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 16, 17, 18, 19, 32, 33, 48, 49, 50, 64, 65, 80, 81, 84, 96, 98, 99, 100, 101, 102, 103, 104, 105, 106, 112, 113, 130, 144, 145, 160, 161, 162, 163, 164, 176, 177, 179, 180, 181, 182, 183, 184, 192, 193, 208, 209, 224, 225, 226, 240, 241, 242, 256, 257, 258, 259, 260, 261, 272, 274, 275, 276, 277, 288, 289, 304, 336, 352, 368, 384, 400, 401, 416, 417};
    static final String[] CKR_names = new String[]{PKCS11Exception.a("\rUcG5\"Oc\u0004)*S-G.&PaA5.D-W4(ChW2-UaH8"), PKCS11Exception.a("\rUcG5\"Oc\u00042#OxH%kBh\u0004\"*NnA-.D"), PKCS11Exception.a("\u0005Oy\u0004$%OxC)kMhI.9Y-K/kHbW5"), PKCS11Exception.a("\u0018LbPa\u0002d-M2kIcR 'Ii"), PKCS11Exception.a("\u001eN\u007fA\"$VhV )Lh\u0004$9RbV"), PKCS11Exception.a("\u001fHh\u00043.QxA2?Ei\u0004'>NnP($N-G.>Li\u0004/$T-F$kPhV'$R`A%"), PKCS11Exception.a("\u0018U}T-\"Ei\u0004 9GxI$%T~\u0004/$T-E1;RbT3\"AyA"), PKCS11Exception.a("\u0005O-J$<\u0000hR$%T~\u0004 =AdH )Lh"), PKCS11Exception.a("\u0005AyM7.\u0000yL3.Ai\u00042>P}K3?\u0000\u007fA0>I\u007fA%"), PKCS11Exception.a("\u0007OnO(%G-J.?\u0000lR \"LlF-."), PKCS11Exception.a("\nTyV()UyAa\"S-V$*D K/'Y"), PKCS11Exception.a("\nTyV()UyAa\"S-W$%SdP(=E-E//\u0000nE/%Oy\u0004#.\u0000\u007fA7.AaA%"), PKCS11Exception.a("\nTyV()UyAa?Y}Aa\"S-M/=AaM%"), PKCS11Exception.a("\nTyV()UyAa=AaQ$kI~\u0004(%VlH(/"), PKCS11Exception.a("\u000fAyEa\"S-M/=AaM%"), PKCS11Exception.a("\u0002N{E-\"D-@ ?A-H$%GyL"), PKCS11Exception.a("\u000fE{M\".\u0000hV3$R"), PKCS11Exception.a("\u0005Oy\u0004$%OxC)kMhI.9Y-K/kDhR((E"), PKCS11Exception.a("\u000fE{M\".\u0000eE2kBhA/kRhI.=Ei"), PKCS11Exception.a("\u000eNnV8;Th@a/AyEa\"S-M/=AaM%"), PKCS11Exception.a("\u000eNnV8;Th@a/AyEa'EcC5#\u0000dWa$Uy\u0004.-\u0000\u007fE/,E"), PKCS11Exception.a("\rUcG5\"Oc\u0004)*S-F$.N-G %ChH$/"), PKCS11Exception.a("\u0005O-B4%CyM.%\u0000dWa.XhG4?IcCa\"N-T 9AaH$'"), PKCS11Exception.a("\u001fHh\u00043.QxA2?Ei\u0004'>NnP($N-M2kNbPa8U}T.9Th@"), PKCS11Exception.a("\u0000Et\u0004)*NiH$kI~\u0004(%VlH(/"), PKCS11Exception.a("\u0000Et\u00042\"Zh\u0004(8\u0000bQ5kOk\u00043*NjA"), PKCS11Exception.a("\u0000Et\u000452Ph\u0004(8\u0000dJ\"$N~M2?EcPa<IyLa&EnL %I~I"), PKCS11Exception.a("\u0000Et\u0004/$T-J$.Dh@mkEuP3*NhK48\u0000fA8kSxT1'Ih@"), PKCS11Exception.a("\u0000Et\u0004)*S-F$.N-G)*NjA%"), PKCS11Exception.a("\u0000Et\u0004/.EiA%g\u0000cKa Et\u00042>P}H(.D"), PKCS11Exception.a("\u001fHh\u00047*LxAa$F-P).\u0000~T$(IkM$/\u0000fA8kClJ/$T-F$kDdC$8Th@"), PKCS11Exception.a("\rUcG5\"Oc\u0004/$T-T$9MdP5.D-B.9\u0000yL(8\u0000fA8"), PKCS11Exception.a("\u0000Et\u0004\"*NcK5kBh\u000469A}T$/"), PKCS11Exception.a("\u0000Et\u0004(8\u0000xJ$3T\u007fE\"?AoH$"), PKCS11Exception.a("\u0006EnL %I~Ia\"N{E-\"D"), PKCS11Exception.a("\u0006EnL %I~Ia;A\u007fE,.ThVa\"S-M/=AaM%"), PKCS11Exception.a("\u0004BgA\"?\u0000eE//Lh\u0004(8\u0000dJ7*Ld@"), PKCS11Exception.a("\nNbP).R-K1.RlP($N-M2kAaV$*Dt\u0004 (TdR$"), PKCS11Exception.a("\u0004PhV ?IbJa#A~\u0004/$T-F$.N-M/\"TdE-\"Zh@"), PKCS11Exception.a("\u001bIc\u0004(8\u0000dJ\"$R\u007fA\"?"), PKCS11Exception.a("\u0005Ez\u0004\u0011\u0002n-G.?AdJ2kIcR 'Ii\u0004\"#A\u007fE\"?E\u007fW"), PKCS11Exception.a("\u0005Ez\u0004\u0011\u0002n-H$%GyLa\"S-K4?\u0000bBa9AcC$"), PKCS11Exception.a("\u001bIc\u0004)*S-A9;I\u007fA%"), PKCS11Exception.a("\u001bIc\u0004(8\u0000aK\" Ei"), PKCS11Exception.a("\u0018E~W($N-L 8\u0000oA$%\u0000nH.8Ei"), PKCS11Exception.a("\u0018E~W($N-H(&IyWa#A{Aa)EhJa9ElG).D"), PKCS11Exception.a("\u0018E~W($N-L %DaAa\"S-M/=AaM%"), PKCS11Exception.a("\u001bA\u007fE-'Ea\u0004$3EnQ5\"Oc\u0004(8\u0000cK5kSxT1$RyA%"), PKCS11Exception.a("\u0018E~W($N-M2kRhE%fOcH8"), PKCS11Exception.a("\n\u0000~A28IbJa<IyLa?Hh\u00045$KhJa\"S-E-9El@8kO}A/"), PKCS11Exception.a("\n\u0000\u007fA /\rbJ-2\u0000~A28IbJa*L\u007fA /Y-A9\"SyWa*Ni\u00045#E-w\u000ekClJ/$T-F$kLbC&.D-M/"), PKCS11Exception.a("\n\u0000\u007fA /\u000fzV(?E-w\u000ekShW2\"Oc\u0004 'RhE%2\u0000h\\(8T~\u0004 %D-P).\u0000^ka(AcJ.?\u0000oAa'OjC$/\u0000dJ"), PKCS11Exception.a("\u0018IjJ ?U\u007fAa\"S-M/=AaM%"), PKCS11Exception.a("\u0018IjJ ?U\u007fAa'EcC5#\u0000dWa$Uy\u0004.-\u0000\u007fE/,E"), PKCS11Exception.a("\u001fE`T-*Th\u0004(8\u0000dJ\"$M}H$?E"), PKCS11Exception.a("\u001fE`T-*Th\u0004(8\u0000dJ\"$N~M2?EcP"), PKCS11Exception.a("\u0018LbPa/OhWa%Oy\u0004\"$NyE(%\u0000l\u00045$KhJ"), PKCS11Exception.a("\u001fHh\u00045$KhJa<A~\u0004/$T-V$(OjJ(1Ei"), PKCS11Exception.a("\u001fOfA/kI~\u000469IyAl;RbP$(Th@"), PKCS11Exception.a("\u001eNzV ;PdJ&kKh]a#Ac@-.\u0000dWa\"N{E-\"D"), PKCS11Exception.a("\u001eNzV ;PdJ&kKh]a8IwAa\"S-K4?\u0000bBa9AcC$"), PKCS11Exception.a("\u001eNzV ;PdJ&kKh]a\"S-M/(OcW(8ThJ5kWdP)kMhG)*NdW,"), PKCS11Exception.a("\n\u0000xW$9\u0000dWa*L\u007fA /Y-H.,Gh@a\"N"), PKCS11Exception.a("\n\u0000xW$9\u0000dWa%Oy\u0004-$GjA%kIc"), PKCS11Exception.a("\u001fHh\u000448E\u007f\u00032kpDja#A~\u0004/$T-F$.N-M/\"TdE-\"Zh@"), PKCS11Exception.a("\u001eShVa?Y}Aa\"S-M/=AaM%"), PKCS11Exception.a("\nNbP).R-Q2.R-M2kAaV$*Dt\u0004-$GjA%kIc"), PKCS11Exception.a("\u001fOb\u0004,*Nt\u000448E\u007fWa'OjC$/\u0000dJ"), PKCS11Exception.a("\u001cRlT1.D-O$2\u0000dWa\"N{E-\"D"), PKCS11Exception.a("\u001cRlT1.D-O$2\u0000aA/,Te\u0004(8\u0000bQ5kOk\u00043*NjA"), PKCS11Exception.a("\u001cRlT1\"Nj\u0004*.Y-L %DaAa\"S-M/=AaM%"), PKCS11Exception.a("\u001cRlT1\"Nj\u0004*.Y-W(1E-M2kIcR 'Ii"), PKCS11Exception.a("\u001cRlT1\"Nj\u0004*.Y-P8;E-M2kIcG.%SdW5.Ny\u00046\"Te\u0004,.CeE/\"S`"), PKCS11Exception.a("\u0019Ac@.&\u0000cQ,)E\u007f\u0004&.NhV ?O\u007f\u0004%$E~\u0004/$T-E\"(E}Pa8Eh@(%G"), PKCS11Exception.a("\u001fHh\u00045$KhJa/OhWa%Oy\u0004)*Vh\u0004 kRlJ%$M-J4&BhVa,EcA3*TbV"), PKCS11Exception.a("\u0002N{E-\"D-K3kUcW4;PbV5.D-@.&AdJa;A\u007fE,.ThV2"), PKCS11Exception.a("\tUkB$9\u0000yK.kS`E-'"), PKCS11Exception.a("\u001fHh\u00042*Vh@a$PhV ?IbJ2kSyE5.\u0000dWa\"N{E-\"D-E//\u0000nE/%Oy\u0004#.\u0000\u007fA2?O\u007fA%"), PKCS11Exception.a("\u001fHh\u00043.QxA2?Ei\u0004(%FbV,*TdK/kI~\u00042.N~M5\"Vh\u0004 %D-G %NbPa)E-V$=ElH$/"), PKCS11Exception.a("\u001fHh\u0004.;E\u007fE5\"OcWa8TlP$kClJ/$T-F$kSlR$/"), PKCS11Exception.a("\bRtT5$Kd\u0004(8\u0000cK5kYhPa\"NdP(*Ld^$/"), PKCS11Exception.a("\bRtT5$Kd\u0004(8\u0000lH3.Ai]a\"NdP(*Ld^$/"), PKCS11Exception.a("\u0006UyA9kOoN$(T-M2kBl@"), PKCS11Exception.a("\u0006UyA9kI~\u0004/$T-H.(Kh@")};
    int code;

    public PKCS11Exception(int n2) {
        super(PKCS11Exception.errorMessage(n2));
        this.code = n2;
    }

    public PKCS11Exception(String string) {
        super(string);
        this.code = Integer.MIN_VALUE;
    }

    public int getCode() {
        return this.code;
    }

    static String errorMessage(int n2) {
        if ((n2 & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return PKCS11Exception.a("\u001dEc@.9\u0000iA'\"Nh@a.R\u007fK3");
        }
        int n3 = 0;
        while (n3 < CKR_names.length) {
            if (CKR_types[n3] == n2) {
                return CKR_names[n3];
            }
            ++n3;
        }
        return PKCS11Exception.a("\u001eNfJ.<N-A39O\u007f\u0004i{X") + Integer.toHexString(n2) + ")";
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 75;
                        break;
                    }
                    case 1: {
                        n5 = 32;
                        break;
                    }
                    case 2: {
                        n5 = 13;
                        break;
                    }
                    case 3: {
                        n5 = 36;
                        break;
                    }
                    default: {
                        n5 = 65;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

