/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.eval;

import com.ibm.ObjectQuery.IObjectQueryServiceConfiguration;
import com.ibm.ObjectQuery.IObjectQueryServiceImpl;
import com.ibm.ObjectQuery.IQueryLogger;
import com.ibm.ObjectQuery.engine.GlbThreadLocal;
import com.ibm.ObjectQuery.eval.Constant;
import com.ibm.ObjectQuery.eval.ConstantBigDecimal;
import com.ibm.ObjectQuery.eval.ConstantBoolean;
import com.ibm.ObjectQuery.eval.ConstantByte;
import com.ibm.ObjectQuery.eval.ConstantBytes;
import com.ibm.ObjectQuery.eval.ConstantCharacter;
import com.ibm.ObjectQuery.eval.ConstantDate;
import com.ibm.ObjectQuery.eval.ConstantDouble;
import com.ibm.ObjectQuery.eval.ConstantFloat;
import com.ibm.ObjectQuery.eval.ConstantInt;
import com.ibm.ObjectQuery.eval.ConstantLong;
import com.ibm.ObjectQuery.eval.ConstantRef;
import com.ibm.ObjectQuery.eval.ConstantSerializableObject;
import com.ibm.ObjectQuery.eval.ConstantShort;
import com.ibm.ObjectQuery.eval.ConstantString;
import com.ibm.ObjectQuery.eval.ConstantTime;
import com.ibm.ObjectQuery.eval.ConstantTimestamp;
import com.ibm.ObjectQuery.eval.Expression;
import com.ibm.ObjectQuery.eval.Plan;
import com.ibm.ObjectQuery.eval.Tuple;
import com.ibm.websphere.ejbquery.QueryException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;

class RelationalCursor {
    private static final String theClassName = RelationalCursor.class.getName();
    private static IQueryLogger queryLogger = null;
    private Object conn_;
    private Statement statement_;
    private ResultSet resultSet_;
    private ArrayList hxpTypeList;
    private ResultSetMetaData resultSetMetaData_;
    private boolean isExhausted_ = false;
    private int copyTmstmpFlag_ = 0;
    private IObjectQueryServiceConfiguration connectionLookupStrategy = IObjectQueryServiceImpl.getConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeCursor() throws QueryException, SQLException {
        this.isExhausted_ = true;
        try {
            if (this.resultSet_ != null) {
                this.resultSet_.close();
                this.resultSet_ = null;
            }
            if (this.statement_ != null) {
                this.statement_.close();
                this.statement_ = null;
            }
            Object var2_1 = null;
            if (this.conn_ == null) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.conn_ == null) throw throwable;
            IObjectQueryServiceImpl.getConfiguration().connectionClose(this.conn_, null);
            this.conn_ = null;
            throw throwable;
        }
        IObjectQueryServiceImpl.getConfiguration().connectionClose(this.conn_, null);
        this.conn_ = null;
    }

    ArrayList getRemainingRows() throws QueryException {
        try {
            ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
            while (this.resultSet_.next()) {
                arrayList.add(this.getRow());
            }
            this.closeCursor();
            return arrayList;
        }
        catch (SQLException sQLException) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "getRemainingRows", sQLException);
            }
            if (this.conn_ != null) {
                IObjectQueryServiceImpl.getConfiguration().connectionClose(this.conn_, null);
                this.conn_ = null;
            }
            String string = queryLogger.message(4L, theClassName, "getRemainingRows", "RTDSERR", new Object[]{sQLException.getMessage()});
            throw new QueryException(string, (Exception)sQLException, new Object[]{theClassName, "getRemainingRows"});
        }
    }

    private Tuple getRow() throws QueryException {
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, theClassName, "getRow", null);
        }
        try {
            Constant constant = null;
            StringBuffer stringBuffer = null;
            int n = this.resultSetMetaData_.getColumnCount();
            if (queryLogger.isLogging()) {
                queryLogger.text(1024L, theClassName, "getRow", "Column count of result data: " + n);
                stringBuffer = new StringBuffer("Extracted column values = ");
            }
            Tuple tuple = new Tuple(n);
            for (int i = 1; i <= n; ++i) {
                switch (this.getHxpType(i - 1)) {
                    case -7: {
                        constant = new ConstantBoolean(this.resultSet_.getBoolean(i));
                        break;
                    }
                    case -6: {
                        constant = new ConstantByte(this.resultSet_.getByte(i));
                        break;
                    }
                    case 5: {
                        constant = new ConstantShort(this.resultSet_.getShort(i));
                        break;
                    }
                    case 4: {
                        constant = new ConstantInt(this.resultSet_.getInt(i));
                        break;
                    }
                    case -5: {
                        constant = new ConstantLong(this.resultSet_.getLong(i));
                        break;
                    }
                    case 1118: {
                        String string = this.resultSet_.getString(i);
                        constant = string != null ? new ConstantCharacter(string.charAt(0)) : new ConstantCharacter();
                        break;
                    }
                    case 1: 
                    case 12: {
                        constant = new ConstantString(this.resultSet_.getString(i));
                        break;
                    }
                    case 91: {
                        constant = new ConstantDate(this.resultSet_.getDate(i));
                        break;
                    }
                    case 92: {
                        constant = new ConstantTime(this.resultSet_.getTime(i));
                        break;
                    }
                    case 93: {
                        Timestamp timestamp = this.resultSet_.getTimestamp(i);
                        if (timestamp != null) {
                            if (this.copyTmstmpFlag_ == 0) {
                                this.copyTmstmpFlag_ = timestamp.getClass().getName().equals("java.sql.Timestamp") ? 1 : 2;
                            }
                            if (this.copyTmstmpFlag_ == 1) {
                                constant = new ConstantTimestamp(timestamp);
                                break;
                            }
                            constant = new ConstantTimestamp(timestamp.getTime(), timestamp.getNanos());
                            break;
                        }
                        constant = new ConstantTimestamp(timestamp);
                        break;
                    }
                    case 2: 
                    case 3: {
                        constant = new ConstantBigDecimal(this.resultSet_.getBigDecimal(i));
                        break;
                    }
                    case 7: {
                        constant = new ConstantFloat(this.resultSet_.getFloat(i));
                        break;
                    }
                    case 6: 
                    case 8: {
                        constant = new ConstantDouble(this.resultSet_.getDouble(i));
                        break;
                    }
                    case -3: 
                    case -2: {
                        constant = new ConstantBytes(this.resultSet_.getBytes(i));
                        break;
                    }
                    case -4: {
                        constant = new ConstantBytes(this.resultSet_.getBytes(i));
                        break;
                    }
                    case -1: {
                        constant = new ConstantSerializableObject(this.resultSet_.getCharacterStream(i), -1);
                        break;
                    }
                    case 2004: {
                        byte[] byArray = null;
                        Blob blob = this.resultSet_.getBlob(i);
                        if (blob == null) {
                            constant = new ConstantBytes(byArray);
                            break;
                        }
                        constant = new ConstantBytes(blob.getBytes(1L, (int)blob.length()));
                        break;
                    }
                    case 2005: {
                        Clob clob = this.resultSet_.getClob(i);
                        byte[] byArray = null;
                        if (clob != null && clob.length() != 0L) {
                            long l = clob.length();
                            InputStream inputStream = clob.getAsciiStream();
                            if (inputStream != null) {
                                byArray = new byte[(int)l];
                                int n2 = -1;
                                int n3 = 0;
                                n2 = inputStream.read(byArray, 0, (int)l);
                                if ((long)n2 != l) {
                                    n3 = n2;
                                    while ((long)n3 != l) {
                                        n2 = inputStream.read(byArray, n3, (int)l - n3);
                                        n3 += n2;
                                    }
                                }
                            }
                        }
                        constant = new ConstantBytes(byArray);
                        break;
                    }
                    case 2006: {
                        constant = new ConstantRef(this.resultSet_.getRef(i));
                        break;
                    }
                    default: {
                        String string = queryLogger.message(4L, theClassName, "getRow", "RTNSJT", new Object[]{new Integer(this.resultSetMetaData_.getColumnType(i))});
                        throw new QueryException(string);
                    }
                }
                if (queryLogger.isLogging()) {
                    if (constant instanceof ConstantBytes) {
                        stringBuffer.append("col #").append(i).append(" = ").append(((ConstantBytes)constant).getls100Bytes()).append("\t");
                    } else {
                        stringBuffer.append("col #").append(i).append(" = ").append(constant.getObject()).append("\t");
                    }
                }
                if (this.resultSet_.wasNull()) {
                    constant.isNull_ = true;
                }
                tuple.addElement(constant);
            }
            if (queryLogger.isLogging()) {
                queryLogger.text(1024L, theClassName, "getRow", stringBuffer.toString());
                queryLogger.exit(256L, theClassName, "getRow", tuple);
            }
            return tuple;
        }
        catch (Exception exception) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "getRow", exception);
            }
            if (this.conn_ != null) {
                IObjectQueryServiceImpl.getConfiguration().connectionClose(this.conn_, null);
                this.conn_ = null;
            }
            String string = queryLogger.message(4L, theClassName, "getRow", "RTDSERR", new Object[]{exception.toString()});
            throw new QueryException(string, exception, new Object[]{theClassName, "getRow"});
        }
    }

    boolean inValidTransactionContext() {
        return true;
    }

    boolean isExhausted() {
        return this.isExhausted_;
    }

    Tuple next() throws QueryException {
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, theClassName, "next", null);
        }
        try {
            if (queryLogger.isLogging()) {
                queryLogger.text(1024L, theClassName, "next", "Calling next() on the resultSet_ object");
            }
            if (this.resultSet_.next()) {
                Tuple tuple = this.getRow();
                if (queryLogger.isLogging()) {
                    queryLogger.exit(256L, theClassName, "next", tuple);
                }
                return tuple;
            }
            this.closeCursor();
            return null;
        }
        catch (SQLException sQLException) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "next", sQLException);
            }
            if (this.conn_ != null) {
                IObjectQueryServiceImpl.getConfiguration().connectionClose(this.conn_, null);
                this.conn_ = null;
            }
            String string = queryLogger.message(4L, theClassName, "next", "RTDSERR", new Object[]{sQLException.getMessage()});
            throw new QueryException(string, (Exception)sQLException, new Object[]{theClassName, "next"});
        }
    }

    RelationalCursor(String string, String string2, ArrayList arrayList, Plan plan, ArrayList arrayList2, ArrayList arrayList3) throws QueryException {
        Object object = GlbThreadLocal.get();
        if (object == null) {
            object = IObjectQueryServiceImpl.getConfiguration().getQueryHelper(string, null);
        }
        this.hxpTypeList = arrayList2;
        PreparedStatement preparedStatement = null;
        if (queryLogger.isLogging()) {
            queryLogger.entry(128L, theClassName, "RelationalCursor", new Object[]{string, string2, arrayList});
        }
        if (string2.indexOf("?") != -1) {
            Expression expression = null;
            try {
                this.conn_ = this.connectionLookupStrategy.connectionLookup(string, null, object);
                preparedStatement = this.connectionLookupStrategy.prepareSQLStatement(this.conn_, string2);
                for (int i = 0; i < arrayList.size(); ++i) {
                    expression = (Expression)arrayList.get(i);
                    expression.evaluate(plan);
                    if (expression.result_ instanceof ConstantBoolean && IObjectQueryServiceImpl.getConfiguration().getVendorType(string, null, object).equals("INFORMIX")) {
                        preparedStatement.setShort(i + 1, (short)((Boolean)expression.result_.getObject() != false ? 1 : 0));
                        continue;
                    }
                    if (expression.result_ instanceof ConstantByte) {
                        preparedStatement.setByte(i + 1, (Byte)expression.result_.getObject());
                        continue;
                    }
                    if (expression.result_ instanceof ConstantCharacter) {
                        preparedStatement.setObject(i + 1, expression.result_.getObject().toString());
                        continue;
                    }
                    preparedStatement.setObject(i + 1, expression.result_.getObject());
                }
                Object[] objectArray = arrayList3.toArray();
                IObjectQueryServiceImpl.getConfiguration().flushCache(objectArray, object);
                this.resultSet_ = preparedStatement.executeQuery();
                this.resultSetMetaData_ = this.resultSet_.getMetaData();
                this.statement_ = preparedStatement;
            }
            catch (SQLException sQLException) {
                if (queryLogger.isLogging()) {
                    queryLogger.exception(512L, theClassName, "RelationalCursor", sQLException);
                }
                if (this.conn_ != null) {
                    IObjectQueryServiceImpl.getConfiguration().connectionClose(this.conn_, preparedStatement);
                    this.conn_ = null;
                }
                String string3 = queryLogger.message(4L, theClassName, "RelationalCursor", "RTDSERR", new Object[]{sQLException.getMessage()});
                throw new QueryException(string3, (Exception)sQLException, new Object[]{theClassName, "RelationalCursor"});
            }
        }
        try {
            this.conn_ = this.connectionLookupStrategy.connectionLookup(string, null, object);
            this.statement_ = this.connectionLookupStrategy.createStatement(this.conn_);
            Object[] objectArray = arrayList3.toArray();
            IObjectQueryServiceImpl.getConfiguration().flushCache(objectArray, object);
            this.resultSet_ = this.statement_.executeQuery(string2);
            this.resultSetMetaData_ = this.resultSet_.getMetaData();
        }
        catch (SQLException sQLException) {
            if (queryLogger.isLogging()) {
                queryLogger.exception(512L, theClassName, "RelationalCursor", sQLException);
            }
            if (this.conn_ != null) {
                IObjectQueryServiceImpl.getConfiguration().connectionClose(this.conn_, null);
                this.conn_ = null;
            }
            String string4 = queryLogger.message(4L, theClassName, "RelationalCursor", "RTDSERR", new Object[]{sQLException.getMessage()});
            throw new QueryException(string4, (Exception)sQLException, new Object[]{theClassName, "RelationalCursor"});
        }
        if (queryLogger.isLogging()) {
            queryLogger.exit(256L, theClassName, "RelationalCursor");
        }
    }

    public int getHxpType(int n) {
        return (Integer)this.hxpTypeList.get(n);
    }

    static {
        try {
            queryLogger = IObjectQueryServiceImpl.getConfiguration().getLogger();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

