/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.eval;

import com.ibm.ObjectQuery.eval.Constant;
import com.ibm.ObjectQuery.eval.ConstantBigDecimal;
import com.ibm.ObjectQuery.eval.ConstantDateTime;
import com.ibm.ObjectQuery.eval.ConstantDuration;
import com.ibm.ObjectQuery.eval.FunctionScalarSQL;
import com.ibm.websphere.ejbquery.QueryException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

class ConstantTimestamp
extends ConstantDateTime {
    private Timestamp timestamp_;

    ConstantTimestamp() {
        super(93);
    }

    ConstantTimestamp(Timestamp timestamp) {
        super(93);
        this.timestamp_ = timestamp;
    }

    ConstantTimestamp(long l, int n) {
        super(93);
        this.timestamp_ = new Timestamp(l);
        this.timestamp_.setNanos(n);
    }

    void assign(Constant constant) throws QueryException {
        this.superAssign(constant);
        this.setObject(constant.getObject());
    }

    public Object clone() {
        ConstantTimestamp constantTimestamp = new ConstantTimestamp();
        constantTimestamp.timestamp_ = this.timestamp_;
        constantTimestamp.isNull_ = this.isNull_;
        return constantTimestamp;
    }

    int compareTo(Constant constant) {
        return this.compareTo((ConstantTimestamp)constant);
    }

    private int compareTo(ConstantTimestamp constantTimestamp) {
        if (this.comparingUnknowns(constantTimestamp)) {
            return this.compareUnknowns(constantTimestamp);
        }
        if (this.timestamp_.equals(constantTimestamp.timestamp_)) {
            return 0;
        }
        if (this.timestamp_.before(constantTimestamp.timestamp_)) {
            return -1;
        }
        if (this.timestamp_.after(constantTimestamp.timestamp_)) {
            return 1;
        }
        return this.compareUnknowns(constantTimestamp);
    }

    Object getObject() {
        return this.timestamp_;
    }

    Timestamp getTimestamp() {
        return this.timestamp_;
    }

    void setObject(Object object) {
        this.setTimestamp((Timestamp)object);
    }

    void setTimestamp(Timestamp timestamp) {
        this.timestamp_ = timestamp;
    }

    public Timestamp addTo(ConstantDuration constantDuration) throws QueryException {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Date date = new Date(this.getTimewithnanos(this.timestamp_));
        calendar.setTime(date);
        calendar.add(1, constantDuration.getYear());
        calendar.add(2, constantDuration.getMonth());
        calendar.add(5, constantDuration.getDate());
        calendar.add(10, constantDuration.getHour());
        calendar.add(12, constantDuration.getMinute());
        calendar.add(13, constantDuration.getSecond());
        calendar.add(14, constantDuration.getMicrosecond() / 1000);
        if (calendar.get(0) == 0 || calendar.get(1) > 9999) {
            String string = queryLogger.message(4L, "ConstantDate", "addTo", "RTDTNV", null);
            throw new QueryException(string);
        }
        return new Timestamp(calendar.getTime().getTime());
    }

    public Timestamp subtractBy(ConstantDuration constantDuration) throws QueryException {
        constantDuration.setPlus(false);
        return this.addTo(constantDuration);
    }

    public ConstantDuration subtractBy(ConstantTimestamp constantTimestamp) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = new Date(this.getTimewithnanos(this.timestamp_));
        gregorianCalendar.setTime(date);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        Date date2 = new Date(this.getTimewithnanos(constantTimestamp.getTimestamp()));
        gregorianCalendar2.setTime(date2);
        ConstantDuration constantDuration = new ConstantDuration();
        if (this.compareTo(constantTimestamp) >= 0) {
            constantDuration.setTimestamp(this.diff(7, gregorianCalendar, gregorianCalendar2), this.diff(6, gregorianCalendar, gregorianCalendar2), this.diff(5, gregorianCalendar, gregorianCalendar2), this.diff(4, gregorianCalendar, gregorianCalendar2), this.diff(3, gregorianCalendar, gregorianCalendar2), this.diff(2, gregorianCalendar, gregorianCalendar2), this.diff(1, gregorianCalendar, gregorianCalendar2));
        } else {
            constantDuration.setTimestamp(this.diff(7, gregorianCalendar2, gregorianCalendar), this.diff(6, gregorianCalendar2, gregorianCalendar), this.diff(5, gregorianCalendar2, gregorianCalendar), this.diff(4, gregorianCalendar2, gregorianCalendar), this.diff(3, gregorianCalendar2, gregorianCalendar), this.diff(2, gregorianCalendar2, gregorianCalendar), this.diff(1, gregorianCalendar2, gregorianCalendar));
            constantDuration.setPlus(false);
        }
        return constantDuration;
    }

    public Timestamp addTo(ConstantBigDecimal constantBigDecimal) throws QueryException {
        return this.addTo(FunctionScalarSQL.decimal2duration(constantBigDecimal));
    }

    public Timestamp subtractBy(ConstantBigDecimal constantBigDecimal) throws QueryException {
        return this.subtractBy(FunctionScalarSQL.decimal2duration(constantBigDecimal));
    }

    public long getTimewithnanos(Timestamp timestamp) {
        long l = timestamp.getTime();
        l /= 1000L;
        int n = timestamp.getNanos();
        long l2 = (l *= 1000L) + (long)(n / 1000000);
        return l2;
    }
}

