/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.engine;

import com.ibm.ObjectQuery.engine.KeyedObject;
import java.util.ArrayList;
import java.util.Hashtable;

class InternalHashCollection {
    ArrayList c;
    Hashtable hc;
    int cs;

    InternalHashCollection() {
        this.c = new ArrayList();
        this.hc = new Hashtable();
        this.cs = -1;
    }

    InternalHashCollection(int n) {
        switch (n) {
            case 1: {
                this.c = new ArrayList();
                this.hc = new Hashtable();
                this.cs = -1;
                break;
            }
            case 2: {
                this.c = new ArrayList();
                this.hc = new Hashtable();
                this.cs = -1;
            }
        }
    }

    void add(KeyedObject keyedObject) {
        this.c.add(keyedObject);
        this.hc.put(keyedObject.key(), keyedObject);
    }

    void addAllFrom(InternalHashCollection internalHashCollection) {
        this.c.addAll(internalHashCollection.c);
        this.hc.putAll(internalHashCollection.hc);
        this.cs = internalHashCollection.cs;
    }

    void addAsFirst(KeyedObject keyedObject) {
        this.c.add(0, keyedObject);
        this.hc.put(keyedObject.key(), keyedObject);
    }

    void addAsLast(KeyedObject keyedObject) {
        this.c.add(this.c.size(), keyedObject);
        this.hc.put(keyedObject.key(), keyedObject);
    }

    void addAsNext(KeyedObject keyedObject, int n) {
        this.c.add(n, keyedObject);
        this.hc.put(keyedObject.key(), keyedObject);
    }

    boolean containsElementWithKey(Object object) {
        return this.hc.containsKey(object);
    }

    void copy(InternalHashCollection internalHashCollection) {
        if (!this.c.isEmpty()) {
            this.c.clear();
            this.hc.clear();
        }
        this.c.addAll(internalHashCollection.c);
        this.hc.putAll(internalHashCollection.hc);
        this.cs = internalHashCollection.cs;
    }

    Object elementAt(int n) {
        return this.c.get(n);
    }

    Object elementAtCursor() {
        return this.c.get(this.cs);
    }

    Object elementWithKey(Object object) {
        return this.hc.get(object);
    }

    protected void finalize() {
    }

    Object firstElement() {
        return this.c.get(0);
    }

    boolean isEmpty() {
        return this.c.isEmpty();
    }

    boolean isLast(int n) {
        return n == this.c.size() - 1;
    }

    boolean isValid() {
        return this.cs < this.c.size() && this.cs >= 0;
    }

    long numberOfElements() {
        return this.c.size();
    }

    void removeAll() {
        this.c.clear();
        this.hc.clear();
        this.cs = -1;
    }

    boolean removeElementWithKey(Object object) {
        boolean bl = true;
        Object v = this.hc.remove(object);
        int n = this.c.indexOf(v);
        if (n == -1) {
            bl = false;
        } else {
            this.c.remove(n);
        }
        return bl;
    }

    void setToFirst() {
        this.cs = 0;
    }

    void setToLast() {
        this.cs = this.c.size() - 1;
    }

    void setToNext() {
        ++this.cs;
    }

    void setToPrevious() {
        --this.cs;
    }

    int size() {
        return this.c.size();
    }
}

