/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.runtime;

import com.ibm.ObjectQuery.crud.runtime.RdbRuntimeQueryTemplate;
import java.util.Iterator;
import java.util.List;

public class RdbRuntimeUpdateTemplate
implements RdbRuntimeQueryTemplate {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final String UPDATE = "UPDATE ";
    public static final String WHERE = " WHERE ";
    public static final String SET = " SET ";
    public static final String COMMASPACE = ", ";
    public static final String SPACE = " ";
    public static final String DOT = ".";
    public static final String EQUALS = " = ";
    public static final String ISNULL = " IS NULL";
    public static final String MARKER = "?";
    public static final String AND = " AND ";
    public static final char DEL = '\"';
    public static final String ARG = ":";
    private String fSchema;
    private String fTable;
    private String[] fColumns;
    private String[] fKey;
    private String[] fPredicates;
    private String[] fDiscriminator;
    private boolean fDelimitedNameFlag = false;
    private boolean fAliasFlag = false;
    private boolean fQualifyTableFlag = false;
    private boolean fParmMarkers = true;
    private boolean[] fDirtyFlags;
    private int[] fCmpFieldMap;

    public void assignmentsOn(StringBuffer stringBuffer) {
        boolean bl = true;
        int n = this.columns().length;
        for (int i = 0; i < n; ++i) {
            if (this.dirtyFlags() != null && !this.dirtyFlags()[this.cmpFieldMap()[i]]) continue;
            if (!bl) {
                stringBuffer.append(COMMASPACE);
            } else {
                bl = false;
            }
            String string = this.columns()[i];
            this.nameOn(stringBuffer, string);
            stringBuffer.append(EQUALS);
            this.variableOn(stringBuffer, string);
        }
    }

    public String[] columns() {
        return this.fColumns;
    }

    public void columns(String[] stringArray) {
        this.fColumns = stringArray;
    }

    public void delimitedNames(boolean bl) {
        this.fDelimitedNameFlag = bl;
    }

    public String[] discriminator() {
        return this.fDiscriminator;
    }

    public void discriminator(String[] stringArray) {
        this.fDiscriminator = stringArray;
    }

    public void equalsOn(StringBuffer stringBuffer, String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            this.nameOn(stringBuffer, string);
            stringBuffer.append(EQUALS);
            this.variableOn(stringBuffer, string);
            if (i >= n - 1) continue;
            stringBuffer.append(AND);
        }
    }

    public boolean isQualifyingTableNames() {
        return this.fQualifyTableFlag;
    }

    public boolean isUsingDelimitedNames() {
        return this.fDelimitedNameFlag;
    }

    public String[] key() {
        return this.fKey;
    }

    public void key(String[] stringArray) {
        this.fKey = stringArray;
    }

    public void nameOn(StringBuffer stringBuffer, String string) {
        if (!this.isUsingDelimitedNames()) {
            stringBuffer.append(string);
            return;
        }
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            stringBuffer.append(string);
            return;
        }
        stringBuffer.append('\"');
        stringBuffer.append(string);
        stringBuffer.append('\"');
    }

    public String nativeQuery() {
        StringBuffer stringBuffer = new StringBuffer();
        this.statementOn(stringBuffer);
        return stringBuffer.toString();
    }

    public String nativeQuery(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        this.statementOn(stringBuffer, objectArray);
        return stringBuffer.toString();
    }

    public void parmMarkers(boolean bl) {
        this.fParmMarkers = bl;
    }

    public void predicateOn(StringBuffer stringBuffer, List list, List list2) {
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.nameOn(stringBuffer, string);
            if (iterator2.next() == null) {
                stringBuffer.append(ISNULL);
            } else {
                stringBuffer.append(EQUALS);
            }
            this.variableOn(stringBuffer, string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(AND);
        }
    }

    public String[] predicates() {
        return this.fPredicates;
    }

    public void predicates(String[] stringArray) {
        this.fPredicates = stringArray;
    }

    public void predicatesOn(StringBuffer stringBuffer, Object[] objectArray) {
        if (this.predicates().length == 0) {
            return;
        }
        int n = this.predicates().length;
        for (int i = 0; i < n; ++i) {
            String string = this.predicates()[i];
            this.nameOn(stringBuffer, string);
            if (objectArray[i] == null) {
                stringBuffer.append(ISNULL);
            } else {
                stringBuffer.append(EQUALS);
            }
            this.variableOn(stringBuffer, string);
            if (i >= n - 1) continue;
            stringBuffer.append(AND);
        }
    }

    public void qualifyTableNames(boolean bl) {
        this.fQualifyTableFlag = bl;
    }

    public String schema() {
        return this.fSchema;
    }

    public void schema(String string) {
        this.fSchema = string;
    }

    public void statementOn(StringBuffer stringBuffer) {
        stringBuffer.append(UPDATE);
        this.tableOn(stringBuffer);
        stringBuffer.append(SET);
        this.assignmentsOn(stringBuffer);
        this.whereClauseOn(stringBuffer, null);
    }

    public void statementOn(StringBuffer stringBuffer, Object[] objectArray) {
        stringBuffer.append(UPDATE);
        this.tableOn(stringBuffer);
        stringBuffer.append(SET);
        this.assignmentsOn(stringBuffer);
        this.whereClauseOn(stringBuffer, objectArray);
    }

    public String table() {
        return this.fTable;
    }

    public void table(String string) {
        this.fTable = string;
    }

    public void tableOn(StringBuffer stringBuffer) {
        if (this.isQualifyingTableNames() && this.schema() != null) {
            this.nameOn(stringBuffer, this.schema());
            stringBuffer.append(DOT);
        } else {
            this.nameOn(stringBuffer, this.table());
        }
    }

    public boolean useParmMarkers() {
        return this.fParmMarkers;
    }

    public void variableOn(StringBuffer stringBuffer, String string) {
        if (this.useParmMarkers()) {
            stringBuffer.append(MARKER);
            return;
        }
        stringBuffer.append(ARG);
        stringBuffer.append(string);
    }

    public void whereClauseOn(StringBuffer stringBuffer, Object[] objectArray) {
        stringBuffer.append(WHERE);
        this.equalsOn(stringBuffer, this.key());
        if (this.discriminator() != null && this.discriminator().length != 0) {
            stringBuffer.append(AND);
            this.equalsOn(stringBuffer, this.discriminator());
        }
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        if (this.predicates() != null && this.predicates().length != 0) {
            stringBuffer.append(AND);
            this.predicatesOn(stringBuffer, objectArray);
        }
    }

    public boolean[] dirtyFlags() {
        return this.fDirtyFlags;
    }

    public void dirtyFlags(boolean[] blArray) {
        this.fDirtyFlags = blArray;
    }

    public void cmpFieldMap(int[] nArray) {
        this.fCmpFieldMap = nArray;
    }

    public int[] cmpFieldMap() {
        return this.fCmpFieldMap;
    }
}

