/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public class UserRegistryProxy {
    private static final TraceComponent tc = Tr.register((Class)UserRegistryProxy.class, null, (String)"com.ibm.ejs.resources.security");
    private Method getUserSecurityNameMethod = null;
    private Method getGroupSecurityNameMethod = null;
    private Object reg = null;

    public UserRegistryProxy(Properties properties) throws Exception {
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.security.registry.UserRegistryImpl");
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            this.reg = constructor.newInstance(new Object[0]);
            Method method = clazz.getMethod("initialize", Properties.class);
            this.getGroupSecurityNameMethod = clazz.getMethod("getGroupSecurityName", String.class);
            this.getUserSecurityNameMethod = clazz.getMethod("getUserSecurityName", String.class);
            method.invoke(this.reg, properties);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"InvocationTargetException");
            }
            throw invocationTargetException;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"General Exception");
            }
            throw exception;
        }
    }

    public String getUserSecurityName(String string) {
        try {
            return (String)this.getUserSecurityNameMethod.invoke(this.reg, string);
        }
        catch (IllegalAccessException illegalAccessException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"IllegalAccessException during getUserSecurityName method invocation");
            }
            return null;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception during getUserSecurityName method invocation");
            }
            return null;
        }
    }

    public String getGroupSecurityName(String string) {
        try {
            return (String)this.getGroupSecurityNameMethod.invoke(this.reg, string);
        }
        catch (IllegalAccessException illegalAccessException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception during getGroupSecurityName method invocation");
            }
            return null;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception during getGroupSecurityName method invocation");
            }
            return null;
        }
    }
}

