/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.util;

import com.ibm.record.util.IOrderedDictionaryEnumerator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class OrderedDictionaryEnumerator
implements IOrderedDictionaryEnumerator {
    private static String copyright = "Licensed Material - Property of IBM IBM(R) VisualAge(TM) for Java(TM) Version 2.0 (C) Copyright IBM Corp. 1998 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    int index;
    Vector model;

    public OrderedDictionaryEnumerator(Vector collection) {
        this.model = collection;
        this.index = 0;
        int length = this.model.size();
        while (this.index < length && this.model.elementAt(this.index) == null) {
            ++this.index;
        }
        if (this.index == this.model.size()) {
            this.index = -1;
        }
    }

    public Object element() {
        return this.model.elementAt(this.index);
    }

    public boolean hasMoreElements() {
        return this.index != -1;
    }

    public int indexOfKey() {
        return this.index;
    }

    public boolean isValid() {
        return this.index != -1;
    }

    public Object locate(Object key) {
        if (!this.model.contains(key)) {
            return null;
        }
        this.index = this.model.indexOf(key);
        Object e = this.model.elementAt(this.index);
        return e;
    }

    public Object nextElement() {
        Object e = null;
        try {
            e = this.model.elementAt(this.index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
        ++this.index;
        int length = this.model.size();
        while (this.index < length && this.model.elementAt(this.index) == null) {
            ++this.index;
        }
        if (this.index == this.model.size()) {
            this.index = -1;
        }
        return e;
    }

    public boolean setToFirst() {
        this.index = 0;
        int length = this.model.size();
        while (this.index < length && this.model.elementAt(this.index) == null) {
            ++this.index;
        }
        if (this.index == this.model.size()) {
            this.index = -1;
            return false;
        }
        return true;
    }

    public boolean setToLast() {
        this.index = this.model.size() - 1;
        while (this.index >= 0 && this.model.elementAt(this.index) == null) {
            --this.index;
        }
        return this.index != -1;
    }

    public boolean setToNext() {
        ++this.index;
        int length = this.model.size();
        while (this.index < length && this.model.elementAt(this.index) == null) {
            ++this.index;
        }
        if (this.index == this.model.size()) {
            this.index = -1;
            return false;
        }
        return true;
    }

    public boolean setToPrevious() {
        --this.index;
        while (this.index >= 0 && this.model.elementAt(this.index) == null) {
            --this.index;
        }
        return this.index != -1;
    }
}

