/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.ctypes;

class CTypeUtil {
    private static String copyright = "(c) Copyright IBM Corporation 1999, 2000.";

    CTypeUtil() {
    }

    public static char convertFromByteToChar(byte[] sb) {
        return (char)CTypeUtil.convertFromByteToShort(sb);
    }

    public static double convertFromByteToDouble(byte[] sb) {
        long doubleLongBits = CTypeUtil.convertFromByteToLong(sb);
        return Double.longBitsToDouble(doubleLongBits);
    }

    public static float convertFromByteToFloat(byte[] sb) {
        int floatIntBits = CTypeUtil.convertFromByteToInt(sb);
        return Float.intBitsToFloat(floatIntBits);
    }

    public static int convertFromByteToInt(byte[] sb) {
        int i = sb[0] << 24 >>> 0 | sb[1] << 24 >>> 8 | sb[2] << 24 >>> 16 | sb[3] << 24 >>> 24;
        return i;
    }

    public static long convertFromByteToLong(byte[] sb) {
        long l = (long)sb[0] << 56 & 0xFF00000000000000L | (long)sb[1] << 48 & 0xFF000000000000L | (long)sb[2] << 40 & 0xFF0000000000L | (long)sb[3] << 32 & 0xFF00000000L | (long)sb[4] << 24 & 0xFF000000L | (long)sb[5] << 16 & 0xFF0000L | (long)sb[6] << 8 & 0xFF00L | (long)sb[7] & 0xFFL;
        return l;
    }

    public static short convertFromByteToShort(byte[] sb) {
        int i = sb[0] << 24 >>> 16 | sb[1] << 24 >>> 24;
        return (short)i;
    }

    public static byte[] convertToByte(char sb) {
        byte[] tb = new byte[]{(byte)(((short)sb & 0xFF00) >>> 8), (byte)((short)sb & 0xFF)};
        return tb;
    }

    public static byte[] convertToByte(double sb) {
        new Double(sb);
        long doubleLongBits = Double.doubleToLongBits(sb);
        byte[] tb = CTypeUtil.convertToByte(doubleLongBits);
        return tb;
    }

    public static byte[] convertToByte(float sb) {
        new Float(sb);
        int floatIntBits = Float.floatToIntBits(sb);
        byte[] tb = CTypeUtil.convertToByte(floatIntBits);
        return tb;
    }

    public static byte[] convertToByte(int sb) {
        byte[] tb = new byte[]{(byte)((sb & 0xFF000000) >>> 24), (byte)((sb & 0xFF0000) >>> 16), (byte)((sb & 0xFF00) >>> 8), (byte)(sb & 0xFF)};
        return tb;
    }

    public static byte[] convertToByte(long sb) {
        byte[] tb = new byte[]{(byte)((sb & 0xFF00000000000000L) >>> 56), (byte)((sb & 0xFF000000000000L) >>> 48), (byte)((sb & 0xFF0000000000L) >>> 40), (byte)((sb & 0xFF00000000L) >>> 32), (byte)((sb & 0xFF000000L) >>> 24), (byte)((sb & 0xFF0000L) >>> 16), (byte)((sb & 0xFF00L) >>> 8), (byte)(sb & 0xFFL)};
        return tb;
    }

    public static byte[] convertToByte(short sb) {
        byte[] tb = new byte[]{(byte)((sb & 0xFF00) >>> 8), (byte)(sb & 0xFF)};
        return tb;
    }

    public static void endianSwap(byte[] buffer) {
        int leftSide = 0;
        int rightSide = buffer.length - 1;
        while (leftSide < rightSide) {
            byte b = buffer[leftSide];
            buffer[leftSide] = buffer[rightSide];
            buffer[rightSide] = b;
            ++leftSide;
            --rightSide;
        }
    }

    public static void fillBytes(byte fillByte, byte[] target, int offset, int length) throws ArrayIndexOutOfBoundsException {
        if (length > 0) {
            int span = 1;
            target[offset] = fillByte;
            while (span * 2 <= length) {
                System.arraycopy(target, offset, target, offset + span, span);
                span *= 2;
            }
            System.arraycopy(target, offset, target, offset + span, length - span);
        }
    }
}

