/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.ctypes;

import com.ibm.record.FixedLengthType;
import com.ibm.record.IRecord;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordException;
import com.ibm.record.ctypes.CLanguageRecordAttributes;
import com.ibm.record.ctypes.CTypeUtil;
import java.io.Serializable;
import java.math.BigDecimal;

public class CLongLong
extends FixedLengthType
implements Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = -5505182596404345504L;
    private static final int size_ = 8;

    public boolean canConvertFromBigDecimal() {
        return true;
    }

    public boolean canConvertFromByte() {
        return true;
    }

    public boolean canConvertFromChar() {
        return true;
    }

    public boolean canConvertFromInt() {
        return true;
    }

    public boolean canConvertFromLong() {
        return true;
    }

    public boolean canConvertFromObject() {
        return true;
    }

    public boolean canConvertFromShort() {
        return true;
    }

    public boolean canConvertFromString() {
        return true;
    }

    public boolean canConvertToBigDecimal() {
        return true;
    }

    public boolean canConvertToDouble() {
        return true;
    }

    public boolean canConvertToLong() {
        return true;
    }

    public boolean canConvertToObject() {
        return true;
    }

    public boolean canConvertToString() {
        return true;
    }

    public boolean checkConstantValue(IRecord record, byte[] fieldBytes, Object constantValue) {
        return CLongLong.testConstantValue(record, fieldBytes, constantValue);
    }

    public boolean checkConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        return CLongLong.testConstantValue(record, fieldOffset, constantValue);
    }

    public static void fromInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof Long)) {
            throw new RecordConversionUnsupportedException();
        }
        long l = (Long)initialValue;
        CLongLong.fromLong(record, fieldOffset, l);
    }

    public static byte[] fromInitialValue(IRecord record, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof Long)) {
            throw new RecordConversionUnsupportedException();
        }
        long l = (Long)initialValue;
        return CLongLong.fromLong(record, l);
    }

    public static void fromLong(IRecord record, int fieldOffset, long value) throws RecordConversionFailureException {
        byte[] tb = CTypeUtil.convertToByte(value);
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(tb);
        }
        System.arraycopy(tb, 0, record.getRawBytes(), fieldOffset, 8);
    }

    public static byte[] fromLong(IRecord record, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte[] tb = CTypeUtil.convertToByte(value);
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(tb);
        }
        return tb;
    }

    public int getAlignmentHint() {
        return 8;
    }

    public BigDecimal getBigDecimal(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        long longValue = CLongLong.toLong(record, byteArray);
        return BigDecimal.valueOf(longValue);
    }

    public BigDecimal getBigDecimal(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        long longValue = CLongLong.toLong(record, fieldOffset);
        return BigDecimal.valueOf(longValue);
    }

    public double getDouble(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLongLong.toLong(record, byteArray);
    }

    public double getDouble(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CLongLong.toLong(record, fieldOffset);
    }

    public long getLong(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLongLong.toLong(record, byteArray);
    }

    public long getLong(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CLongLong.toLong(record, fieldOffset);
    }

    public Object getObject(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        long l = CLongLong.toLong(record, byteArray);
        return new Long(l);
    }

    public Object getObject(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        long l = CLongLong.toLong(record, fieldOffset);
        return new Long(l);
    }

    public int getSize() {
        return 8;
    }

    public String getString(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        long value = CLongLong.toLong(record, byteArray);
        return Long.toString(value);
    }

    public String getString(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        long value = CLongLong.toLong(record, fieldOffset);
        return Long.toString(value);
    }

    public void setBigDecimal(IRecord record, int fieldOffset, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        long longVal = value.longValue();
        CLongLong.fromLong(record, fieldOffset, longVal);
    }

    public byte[] setBigDecimal(IRecord record, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        long longVal = value.longValue();
        return CLongLong.fromLong(record, longVal);
    }

    public byte[] setByte(IRecord record, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLongLong.fromLong(record, value);
    }

    public void setByte(IRecord record, int fieldOffset, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CLongLong.fromLong(record, fieldOffset, value);
    }

    public byte[] setChar(IRecord record, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLongLong.fromLong(record, value);
    }

    public void setChar(IRecord record, int fieldOffset, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CLongLong.fromLong(record, fieldOffset, value);
    }

    public void setInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CLongLong.fromInitialValue(record, fieldOffset, initialValue);
    }

    public byte[] setInitialValue(IRecord record, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLongLong.fromInitialValue(record, initialValue);
    }

    public byte[] setInt(IRecord record, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLongLong.fromLong(record, value);
    }

    public void setInt(IRecord record, int fieldOffset, int value) throws RecordConversionFailureException {
        CLongLong.fromLong(record, fieldOffset, value);
    }

    public void setLong(IRecord record, int fieldOffset, long value) throws RecordConversionFailureException {
        CLongLong.fromLong(record, fieldOffset, value);
    }

    public byte[] setLong(IRecord record, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLongLong.fromLong(record, value);
    }

    public void setObject(IRecord record, int fieldOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof Long)) {
            throw new RecordConversionUnsupportedException();
        }
        long l = (Long)value;
        CLongLong.fromLong(record, fieldOffset, l);
    }

    public byte[] setObject(IRecord record, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof Long)) {
            throw new RecordConversionUnsupportedException();
        }
        long l = (Long)value;
        return CLongLong.fromLong(record, l);
    }

    public void setShort(IRecord record, int fieldOffset, short value) throws RecordConversionFailureException {
        CLongLong.fromLong(record, fieldOffset, value);
    }

    public byte[] setshort(IRecord record, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLongLong.fromLong(record, value);
    }

    public void setString(IRecord record, int fieldOffset, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            Long longValue = Long.valueOf(value);
            CLongLong.fromLong(record, fieldOffset, longValue);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public byte[] setString(IRecord record, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            Long longValue = Long.valueOf(value);
            return CLongLong.fromLong(record, longValue);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public static boolean testConstantValue(IRecord record, byte[] fieldBytes, Object constantValue) {
        long l;
        if (!(constantValue instanceof Long)) {
            return false;
        }
        long cv = (Long)constantValue;
        try {
            l = CLongLong.toLong(record, fieldBytes);
        }
        catch (RecordException recordException) {
            return false;
        }
        return cv == l;
    }

    public static boolean testConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        long l;
        if (!(constantValue instanceof Long)) {
            return false;
        }
        long cv = (Long)constantValue;
        try {
            l = CLongLong.toLong(record, fieldOffset);
        }
        catch (RecordException recordException) {
            return false;
        }
        return cv == l;
    }

    public static long toLong(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte[] sb = byteArray;
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(sb);
        }
        long i = CTypeUtil.convertFromByteToLong(sb);
        return i;
    }

    public static long toLong(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        byte[] sb = new byte[8];
        System.arraycopy(record.getRawBytes(), fieldOffset, sb, 0, 8);
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(sb);
        }
        long i = CTypeUtil.convertFromByteToLong(sb);
        return i;
    }
}

