/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.ctypes;

import com.ibm.record.FixedLengthType;
import com.ibm.record.IRecord;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordException;
import com.ibm.record.ctypes.CLanguageRecordAttributes;
import com.ibm.record.ctypes.CTypeUtil;
import java.io.Serializable;
import java.math.BigDecimal;

public class CLong
extends FixedLengthType
implements Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = 8400650641181086146L;
    private static final int size_ = 4;

    public boolean canConvertFromBigDecimal() {
        return true;
    }

    public boolean canConvertFromByte() {
        return true;
    }

    public boolean canConvertFromChar() {
        return true;
    }

    public boolean canConvertFromInt() {
        return true;
    }

    public boolean canConvertFromObject() {
        return true;
    }

    public boolean canConvertFromShort() {
        return true;
    }

    public boolean canConvertFromString() {
        return true;
    }

    public boolean canConvertToBigDecimal() {
        return true;
    }

    public boolean canConvertToDouble() {
        return true;
    }

    public boolean canConvertToFloat() {
        return true;
    }

    public boolean canConvertToInt() {
        return true;
    }

    public boolean canConvertToLong() {
        return true;
    }

    public boolean canConvertToObject() {
        return true;
    }

    public boolean canConvertToString() {
        return true;
    }

    public boolean checkConstantValue(IRecord record, byte[] fieldBytes, Object constantValue) {
        return CLong.testConstantValue(record, fieldBytes, constantValue);
    }

    public boolean checkConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        return CLong.testConstantValue(record, fieldOffset, constantValue);
    }

    public static void fromInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof Integer)) {
            throw new RecordConversionUnsupportedException();
        }
        int i = (Integer)initialValue;
        CLong.fromInt(record, fieldOffset, i);
    }

    public static byte[] fromInitialValue(IRecord record, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof Integer)) {
            throw new RecordConversionUnsupportedException();
        }
        int i = (Integer)initialValue;
        return CLong.fromInt(record, i);
    }

    public static byte[] fromInt(IRecord record, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte[] tb = CTypeUtil.convertToByte(value);
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(tb);
        }
        return tb;
    }

    public static void fromInt(IRecord record, int fieldOffset, int value) throws RecordConversionFailureException {
        byte[] tb = CTypeUtil.convertToByte(value);
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(tb);
        }
        System.arraycopy(tb, 0, record.getRawBytes(), fieldOffset, 4);
    }

    public int getAlignmentHint() {
        return 4;
    }

    public BigDecimal getBigDecimal(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int intValue = CLong.toInt(record, byteArray);
        return BigDecimal.valueOf(intValue);
    }

    public BigDecimal getBigDecimal(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int intValue = CLong.toInt(record, fieldOffset);
        return BigDecimal.valueOf(intValue);
    }

    public double getDouble(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLong.toInt(record, byteArray);
    }

    public double getDouble(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CLong.toInt(record, fieldOffset);
    }

    public float getFloat(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLong.toInt(record, byteArray);
    }

    public float getFloat(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CLong.toInt(record, fieldOffset);
    }

    public int getInt(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLong.toInt(record, byteArray);
    }

    public int getInt(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CLong.toInt(record, fieldOffset);
    }

    public long getLong(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLong.toInt(record, byteArray);
    }

    public long getLong(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CLong.toInt(record, fieldOffset);
    }

    public Object getObject(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int i = CLong.toInt(record, byteArray);
        return new Integer(i);
    }

    public Object getObject(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        int i = CLong.toInt(record, fieldOffset);
        return new Integer(i);
    }

    public int getSize() {
        return 4;
    }

    public String getString(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int value = CLong.toInt(record, byteArray);
        return Integer.toString(value);
    }

    public String getString(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int value = CLong.toInt(record, fieldOffset);
        return Integer.toString(value);
    }

    public void setBigDecimal(IRecord record, int fieldOffset, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int intVal = value.intValue();
        CLong.fromInt(record, fieldOffset, intVal);
    }

    public byte[] setBigDecimal(IRecord record, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int intVal = value.intValue();
        return CLong.fromInt(record, intVal);
    }

    public byte[] setByte(IRecord record, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLong.fromInt(record, value);
    }

    public void setByte(IRecord record, int fieldOffset, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CLong.fromInt(record, fieldOffset, value);
    }

    public byte[] setChar(IRecord record, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLong.fromInt(record, value);
    }

    public void setChar(IRecord record, int fieldOffset, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CLong.fromInt(record, fieldOffset, value);
    }

    public void setInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CLong.fromInitialValue(record, fieldOffset, initialValue);
    }

    public byte[] setInitialValue(IRecord record, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLong.fromInitialValue(record, initialValue);
    }

    public byte[] setInt(IRecord record, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLong.fromInt(record, value);
    }

    public void setInt(IRecord record, int fieldOffset, int value) throws RecordConversionFailureException {
        CLong.fromInt(record, fieldOffset, value);
    }

    public void setObject(IRecord record, int fieldOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof Integer)) {
            throw new RecordConversionUnsupportedException();
        }
        int i = (Integer)value;
        CLong.fromInt(record, fieldOffset, i);
    }

    public byte[] setObject(IRecord record, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof Integer)) {
            throw new RecordConversionUnsupportedException();
        }
        int i = (Integer)value;
        return CLong.fromInt(record, i);
    }

    public void setShort(IRecord record, int fieldOffset, short value) throws RecordConversionFailureException {
        CLong.fromInt(record, fieldOffset, value);
    }

    public byte[] setShort(IRecord record, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CLong.fromInt(record, value);
    }

    public void setString(IRecord record, int fieldOffset, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            Integer intValue = Integer.valueOf(value);
            CLong.fromInt(record, fieldOffset, intValue);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public byte[] setString(IRecord record, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            Integer intValue = Integer.valueOf(value);
            return CLong.fromInt(record, intValue);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public static boolean testConstantValue(IRecord record, byte[] fieldBytes, Object constantValue) {
        int i;
        if (!(constantValue instanceof Integer)) {
            return false;
        }
        int cv = (Integer)constantValue;
        try {
            i = CLong.toInt(record, fieldBytes);
        }
        catch (RecordException recordException) {
            return false;
        }
        return cv == i;
    }

    public static boolean testConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        int i;
        if (!(constantValue instanceof Integer)) {
            return false;
        }
        int cv = (Integer)constantValue;
        try {
            i = CLong.toInt(record, fieldOffset);
        }
        catch (RecordException recordException) {
            return false;
        }
        return cv == i;
    }

    public static int toInt(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(byteArray);
        }
        int i = CTypeUtil.convertFromByteToInt(byteArray);
        return i;
    }

    public static int toInt(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        byte[] sb = new byte[4];
        System.arraycopy(record.getRawBytes(), fieldOffset, sb, 0, 4);
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(sb);
        }
        int i = CTypeUtil.convertFromByteToInt(sb);
        return i;
    }
}

