/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.ctypes;

import com.ibm.record.FixedLengthType;
import com.ibm.record.IRecord;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordException;
import com.ibm.record.ctypes.CLanguageRecordAttributes;
import com.ibm.record.ctypes.CTypeUtil;
import com.ibm.record.ctypes.Float390;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;

public class CFloat
extends FixedLengthType
implements Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = 5858199007264639286L;
    private static final int size_ = 4;

    public boolean canConvertFromBigDecimal() {
        return true;
    }

    public boolean canConvertFromByte() {
        return true;
    }

    public boolean canConvertFromChar() {
        return true;
    }

    public boolean canConvertFromFloat() {
        return true;
    }

    public boolean canConvertFromInt() {
        return true;
    }

    public boolean canConvertFromLong() {
        return true;
    }

    public boolean canConvertFromObject() {
        return true;
    }

    public boolean canConvertFromShort() {
        return true;
    }

    public boolean canConvertFromString() {
        return true;
    }

    public boolean canConvertToBigDecimal() {
        return true;
    }

    public boolean canConvertToDouble() {
        return true;
    }

    public boolean canConvertToFloat() {
        return true;
    }

    public boolean canConvertToObject() {
        return true;
    }

    public boolean canConvertToString() {
        return true;
    }

    public boolean checkConstantValue(IRecord record, byte[] fieldBytes, Object constantValue) {
        return CFloat.testConstantValue(record, fieldBytes, constantValue);
    }

    public boolean checkConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        return CFloat.testConstantValue(record, fieldOffset, constantValue);
    }

    public static byte[] fromFloat(IRecord record, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte[] tb = null;
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getFloatingPointFormat() == 0) {
            try {
                int s390Value = Float390.floatToS390IntBits(value);
                tb = CTypeUtil.convertToByte(s390Value);
            }
            catch (IOException exc) {
                throw new RecordConversionFailureException(exc.getMessage());
            }
        } else {
            tb = CTypeUtil.convertToByte(value);
        }
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(tb);
        }
        return tb;
    }

    public static void fromFloat(IRecord record, int fieldOffset, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte[] tb = null;
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getFloatingPointFormat() == 0) {
            try {
                int s390Value = Float390.floatToS390IntBits(value);
                tb = CTypeUtil.convertToByte(s390Value);
            }
            catch (IOException exc) {
                throw new RecordConversionFailureException(exc.getMessage());
            }
        } else {
            tb = CTypeUtil.convertToByte(value);
        }
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(tb);
        }
        System.arraycopy(tb, 0, record.getRawBytes(), fieldOffset, 4);
    }

    public static void fromInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof Float)) {
            throw new RecordConversionUnsupportedException();
        }
        float f = ((Float)initialValue).floatValue();
        CFloat.fromFloat(record, fieldOffset, f);
    }

    public static byte[] fromInitialValue(IRecord record, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof Float)) {
            throw new RecordConversionUnsupportedException();
        }
        float f = ((Float)initialValue).floatValue();
        return CFloat.fromFloat(record, f);
    }

    public int getAlignmentHint() {
        return 4;
    }

    public BigDecimal getBigDecimal(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        float floatValue = CFloat.toFloat(record, byteArray);
        return new BigDecimal(floatValue);
    }

    public BigDecimal getBigDecimal(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        float floatValue = CFloat.toFloat(record, fieldOffset);
        return new BigDecimal(floatValue);
    }

    public double getDouble(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CFloat.toFloat(record, byteArray);
    }

    public double getDouble(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CFloat.toFloat(record, fieldOffset);
    }

    public float getFloat(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CFloat.toFloat(record, byteArray);
    }

    public float getFloat(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CFloat.toFloat(record, fieldOffset);
    }

    public Object getObject(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        float f = CFloat.toFloat(record, byteArray);
        return new Float(f);
    }

    public Object getObject(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        float f = CFloat.toFloat(record, fieldOffset);
        return new Float(f);
    }

    public int getSize() {
        return 4;
    }

    public String getString(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        float value = CFloat.toFloat(record, byteArray);
        return Float.toString(value);
    }

    public String getString(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        float value = CFloat.toFloat(record, fieldOffset);
        return Float.toString(value);
    }

    public void setBigDecimal(IRecord record, int fieldOffset, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        float floatVal = value.floatValue();
        CFloat.fromFloat(record, fieldOffset, floatVal);
    }

    public byte[] setBigDecimal(IRecord record, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        float floatVal = value.floatValue();
        return CFloat.fromFloat(record, floatVal);
    }

    public byte[] setByte(IRecord record, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CFloat.fromFloat(record, value);
    }

    public void setByte(IRecord record, int fieldOffset, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CFloat.fromFloat(record, fieldOffset, value);
    }

    public byte[] setChar(IRecord record, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CFloat.fromFloat(record, value);
    }

    public void setChar(IRecord record, int fieldOffset, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CFloat.fromFloat(record, fieldOffset, value);
    }

    public byte[] setFloat(IRecord record, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CFloat.fromFloat(record, value);
    }

    public void setFloat(IRecord record, int fieldOffset, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CFloat.fromFloat(record, fieldOffset, value);
    }

    public void setInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CFloat.fromInitialValue(record, fieldOffset, initialValue);
    }

    public byte[] setInitialValue(IRecord record, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CFloat.fromInitialValue(record, initialValue);
    }

    public byte[] setInt(IRecord record, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CFloat.fromFloat(record, value);
    }

    public void setInt(IRecord record, int fieldOffset, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CFloat.fromFloat(record, fieldOffset, value);
    }

    public void setLong(IRecord record, int fieldOffset, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CFloat.fromFloat(record, fieldOffset, value);
    }

    public byte[] setLong(IRecord record, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CFloat.fromFloat(record, value);
    }

    public void setObject(IRecord record, int fieldOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof Float)) {
            throw new RecordConversionUnsupportedException();
        }
        float f = ((Float)value).floatValue();
        CFloat.fromFloat(record, fieldOffset, f);
    }

    public byte[] setObject(IRecord record, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof Float)) {
            throw new RecordConversionUnsupportedException();
        }
        float f = ((Float)value).floatValue();
        return CFloat.fromFloat(record, f);
    }

    public void setShort(IRecord record, int fieldOffset, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CFloat.fromFloat(record, fieldOffset, value);
    }

    public byte[] setShort(IRecord record, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CFloat.fromFloat(record, value);
    }

    public void setString(IRecord record, int fieldOffset, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            Float floatValue = Float.valueOf(value);
            CFloat.fromFloat(record, fieldOffset, floatValue.floatValue());
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public byte[] setString(IRecord record, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            Float floatValue = Float.valueOf(value);
            return CFloat.fromFloat(record, floatValue.floatValue());
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public static boolean testConstantValue(IRecord record, byte[] fieldBytes, Object constantValue) {
        float f;
        if (!(constantValue instanceof Float)) {
            return false;
        }
        float cv = ((Float)constantValue).floatValue();
        try {
            f = CFloat.toFloat(record, fieldBytes);
        }
        catch (RecordException recordException) {
            return false;
        }
        return cv == f;
    }

    public static boolean testConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        float f;
        if (!(constantValue instanceof Float)) {
            return false;
        }
        float cv = ((Float)constantValue).floatValue();
        try {
            f = CFloat.toFloat(record, fieldOffset);
        }
        catch (RecordException recordException) {
            return false;
        }
        return cv == f;
    }

    public static float toFloat(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte[] sb = byteArray;
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(sb);
        }
        float i = 0.0f;
        if (recAttr.getFloatingPointFormat() == 0) {
            try {
                i = Float390.intS390BitsToFloat(CTypeUtil.convertFromByteToInt(sb));
            }
            catch (IOException exc) {
                throw new RecordConversionFailureException(exc.getMessage());
            }
        } else {
            i = CTypeUtil.convertFromByteToFloat(sb);
        }
        return i;
    }

    public static float toFloat(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte[] sb = new byte[4];
        System.arraycopy(record.getRawBytes(), fieldOffset, sb, 0, 4);
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(sb);
        }
        float i = 0.0f;
        if (recAttr.getFloatingPointFormat() == 0) {
            try {
                i = Float390.intS390BitsToFloat(CTypeUtil.convertFromByteToInt(sb));
            }
            catch (IOException exc) {
                throw new RecordConversionFailureException(exc.getMessage());
            }
        } else {
            i = CTypeUtil.convertFromByteToFloat(sb);
        }
        return i;
    }
}

