/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.ctypes;

import com.ibm.record.FixedLengthType;
import com.ibm.record.IRecord;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordException;
import com.ibm.record.ctypes.CLanguageRecordAttributes;
import com.ibm.record.ctypes.CTypeUtil;
import com.ibm.record.ctypes.Float390;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;

public class CDouble
extends FixedLengthType
implements Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = 8745376712963984063L;
    private static final int size_ = 8;

    public boolean canConvertFromBigDecimal() {
        return true;
    }

    public boolean canConvertFromByte() {
        return true;
    }

    public boolean canConvertFromChar() {
        return true;
    }

    public boolean canConvertFromDouble() {
        return true;
    }

    public boolean canConvertFromFloat() {
        return true;
    }

    public boolean canConvertFromInt() {
        return true;
    }

    public boolean canConvertFromLong() {
        return true;
    }

    public boolean canConvertFromObject() {
        return true;
    }

    public boolean canConvertFromShort() {
        return true;
    }

    public boolean canConvertFromString() {
        return true;
    }

    public boolean canConvertToBigDecimal() {
        return true;
    }

    public boolean canConvertToDouble() {
        return true;
    }

    public boolean canConvertToObject() {
        return true;
    }

    public boolean canConvertToString() {
        return true;
    }

    public boolean checkConstantValue(IRecord record, byte[] fieldBytes, Object constantValue) {
        return CDouble.testConstantValue(record, fieldBytes, constantValue);
    }

    public boolean checkConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        return CDouble.testConstantValue(record, fieldOffset, constantValue);
    }

    public static byte[] fromDouble(IRecord record, double value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte[] tb = null;
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getFloatingPointFormat() == 0) {
            try {
                long s390Value = Float390.doubleToS390LongBits(value);
                tb = CTypeUtil.convertToByte(s390Value);
            }
            catch (IOException exc) {
                throw new RecordConversionFailureException(exc.getMessage());
            }
        } else {
            tb = CTypeUtil.convertToByte(value);
        }
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(tb);
        }
        return tb;
    }

    public static void fromDouble(IRecord record, int fieldOffset, double value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte[] tb = null;
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getFloatingPointFormat() == 0) {
            try {
                long s390Value = Float390.doubleToS390LongBits(value);
                tb = CTypeUtil.convertToByte(s390Value);
            }
            catch (IOException exc) {
                throw new RecordConversionFailureException(exc.getMessage());
            }
        } else {
            tb = CTypeUtil.convertToByte(value);
        }
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(tb);
        }
        System.arraycopy(tb, 0, record.getRawBytes(), fieldOffset, 8);
    }

    public static void fromInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof Double)) {
            throw new RecordConversionUnsupportedException();
        }
        double i = (Double)initialValue;
        CDouble.fromDouble(record, fieldOffset, i);
    }

    public static byte[] fromInitialValue(IRecord record, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof Double)) {
            throw new RecordConversionUnsupportedException();
        }
        double i = (Double)initialValue;
        return CDouble.fromDouble(record, i);
    }

    public int getAlignmentHint() {
        return 8;
    }

    public BigDecimal getBigDecimal(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        double doubleValue = CDouble.toDouble(record, byteArray);
        return new BigDecimal(doubleValue);
    }

    public BigDecimal getBigDecimal(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        double doubleValue = CDouble.toDouble(record, fieldOffset);
        return new BigDecimal(doubleValue);
    }

    public double getDouble(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CDouble.toDouble(record, byteArray);
    }

    public double getDouble(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CDouble.toDouble(record, fieldOffset);
    }

    public Object getObject(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        double i = CDouble.toDouble(record, byteArray);
        return new Double(i);
    }

    public Object getObject(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        double i = CDouble.toDouble(record, fieldOffset);
        return new Double(i);
    }

    public int getSize() {
        return 8;
    }

    public String getString(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        double value = CDouble.toDouble(record, byteArray);
        return Double.toString(value);
    }

    public String getString(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        double value = CDouble.toDouble(record, fieldOffset);
        return Double.toString(value);
    }

    public void setBigDecimal(IRecord record, int fieldOffset, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        double doubleVal = value.doubleValue();
        CDouble.fromDouble(record, fieldOffset, doubleVal);
    }

    public byte[] setBigDecimal(IRecord record, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        double doubleVal = value.doubleValue();
        return CDouble.fromDouble(record, doubleVal);
    }

    public byte[] setByte(IRecord record, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CDouble.fromDouble(record, value);
    }

    public void setByte(IRecord record, int fieldOffset, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CDouble.fromDouble(record, fieldOffset, value);
    }

    public byte[] setChar(IRecord record, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CDouble.fromDouble(record, value);
    }

    public void setChar(IRecord record, int fieldOffset, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CDouble.fromDouble(record, fieldOffset, value);
    }

    public byte[] setDouble(IRecord record, double value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CDouble.fromDouble(record, value);
    }

    public void setDouble(IRecord record, int fieldOffset, double value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CDouble.fromDouble(record, fieldOffset, value);
    }

    public byte[] setFloat(IRecord record, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CDouble.fromDouble(record, value);
    }

    public void setFloat(IRecord record, int fieldOffset, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CDouble.fromDouble(record, fieldOffset, value);
    }

    public void setInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CDouble.fromInitialValue(record, fieldOffset, initialValue);
    }

    public byte[] setInitialValue(IRecord record, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CDouble.fromInitialValue(record, initialValue);
    }

    public byte[] setInt(IRecord record, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CDouble.fromDouble(record, value);
    }

    public void setInt(IRecord record, int fieldOffset, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CDouble.fromDouble(record, fieldOffset, value);
    }

    public void setLong(IRecord record, int fieldOffset, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CDouble.fromDouble(record, fieldOffset, value);
    }

    public byte[] setLong(IRecord record, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CDouble.fromDouble(record, value);
    }

    public void setObject(IRecord record, int fieldOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof Double)) {
            throw new RecordConversionUnsupportedException();
        }
        double i = (Double)value;
        CDouble.fromDouble(record, fieldOffset, i);
    }

    public byte[] setObject(IRecord record, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof Double)) {
            throw new RecordConversionUnsupportedException();
        }
        double i = (Double)value;
        return CDouble.fromDouble(record, i);
    }

    public void setShort(IRecord record, int fieldOffset, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CDouble.fromDouble(record, fieldOffset, value);
    }

    public byte[] setShort(IRecord record, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CDouble.fromDouble(record, value);
    }

    public void setString(IRecord record, int fieldOffset, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            Double doubleValue = Double.valueOf(value);
            CDouble.fromDouble(record, fieldOffset, doubleValue);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public byte[] setString(IRecord record, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            Double doubleValue = Double.valueOf(value);
            return CDouble.fromDouble(record, doubleValue);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public static boolean testConstantValue(IRecord record, byte[] fieldBytes, Object constantValue) {
        double d;
        if (!(constantValue instanceof Double)) {
            return false;
        }
        double cv = (Double)constantValue;
        try {
            d = CDouble.toDouble(record, fieldBytes);
        }
        catch (RecordException recordException) {
            return false;
        }
        return cv == d;
    }

    public static boolean testConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        double d;
        if (!(constantValue instanceof Double)) {
            return false;
        }
        double cv = (Double)constantValue;
        try {
            d = CDouble.toDouble(record, fieldOffset);
        }
        catch (RecordException recordException) {
            return false;
        }
        return cv == d;
    }

    public static double toDouble(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte[] sb = byteArray;
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(sb);
        }
        double i = 0.0;
        if (recAttr.getFloatingPointFormat() == 0) {
            try {
                i = Float390.longS390BitsToDouble(CTypeUtil.convertFromByteToLong(sb));
            }
            catch (IOException exc) {
                throw new RecordConversionFailureException(exc.getMessage());
            }
        } else {
            i = CTypeUtil.convertFromByteToDouble(sb);
        }
        return i;
    }

    public static double toDouble(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte[] sb = new byte[8];
        System.arraycopy(record.getRawBytes(), fieldOffset, sb, 0, 8);
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(sb);
        }
        double i = 0.0;
        if (recAttr.getFloatingPointFormat() == 0) {
            try {
                i = Float390.longS390BitsToDouble(CTypeUtil.convertFromByteToLong(sb));
            }
            catch (IOException exc) {
                throw new RecordConversionFailureException(exc.getMessage());
            }
        } else {
            i = CTypeUtil.convertFromByteToDouble(sb);
        }
        return i;
    }
}

