/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.ctypes;

import com.ibm.record.FixedLengthType;
import com.ibm.record.IRecord;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordException;
import java.io.Serializable;
import java.math.BigDecimal;

public class CByte
extends FixedLengthType
implements Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 2000";
    static final long serialVersionUID = 3497903612106392734L;
    private static final int size_ = 1;

    public boolean canConvertFromByte() {
        return true;
    }

    public boolean canConvertFromObject() {
        return true;
    }

    public boolean canConvertFromString() {
        return true;
    }

    public boolean canConvertToBigDecimal() {
        return true;
    }

    public boolean canConvertToByte() {
        return true;
    }

    public boolean canConvertToChar() {
        return true;
    }

    public boolean canConvertToDouble() {
        return true;
    }

    public boolean canConvertToFloat() {
        return true;
    }

    public boolean canConvertToInt() {
        return true;
    }

    public boolean canConvertToLong() {
        return true;
    }

    public boolean canConvertToObject() {
        return true;
    }

    public boolean canConvertToShort() {
        return true;
    }

    public boolean canConvertToString() {
        return true;
    }

    public boolean checkConstantValue(IRecord record, byte[] fieldBytes, Object constantValue) {
        return CByte.testConstantValue(record, fieldBytes, constantValue);
    }

    public boolean checkConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        return CByte.testConstantValue(record, fieldOffset, constantValue);
    }

    public static byte[] fromByte(IRecord record, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte[] returnBytes = new byte[]{value};
        return returnBytes;
    }

    public static void fromByte(IRecord record, int fieldOffset, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte[] byteArray = record.getRawBytes();
        byteArray[fieldOffset] = value;
    }

    public static void fromInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof Byte)) {
            throw new RecordConversionUnsupportedException();
        }
        byte b = (Byte)initialValue;
        CByte.fromByte(record, fieldOffset, b);
    }

    public static byte[] fromInitialValue(IRecord record, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof Byte)) {
            throw new RecordConversionUnsupportedException();
        }
        byte b = (Byte)initialValue;
        return CByte.fromByte(record, b);
    }

    public int getAlignmentHint() {
        return 1;
    }

    public BigDecimal getBigDecimal(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte byteValue = CByte.toByte(record, byteArray);
        return BigDecimal.valueOf(byteValue);
    }

    public BigDecimal getBigDecimal(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte byteValue = CByte.toByte(record, fieldOffset);
        return BigDecimal.valueOf(byteValue);
    }

    public byte getByte(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CByte.toByte(record, byteArray);
    }

    public byte getByte(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CByte.toByte(record, fieldOffset);
    }

    public char getChar(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        char c = (char)CByte.toByte(record, byteArray);
        return c;
    }

    public char getChar(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        char c = (char)CByte.toByte(record, fieldOffset);
        return c;
    }

    public double getDouble(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CByte.toByte(record, byteArray);
    }

    public double getDouble(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CByte.toByte(record, fieldOffset);
    }

    public float getFloat(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CByte.toByte(record, byteArray);
    }

    public float getFloat(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CByte.toByte(record, fieldOffset);
    }

    public int getInt(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CByte.toByte(record, byteArray);
    }

    public int getInt(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CByte.toByte(record, fieldOffset);
    }

    public long getLong(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CByte.toByte(record, byteArray);
    }

    public long getLong(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CByte.toByte(record, fieldOffset);
    }

    public Object getObject(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte b = CByte.toByte(record, byteArray);
        return new Byte(b);
    }

    public Object getObject(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte b = CByte.toByte(record, fieldOffset);
        return new Byte(b);
    }

    public short getShort(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CByte.toByte(record, byteArray);
    }

    public short getShort(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CByte.toByte(record, fieldOffset);
    }

    public int getSize() {
        return 1;
    }

    public String getString(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte value = CByte.toByte(record, byteArray);
        return Byte.toString(value);
    }

    public String getString(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte value = CByte.toByte(record, fieldOffset);
        return Byte.toString(value);
    }

    public byte[] setByte(IRecord record, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CByte.fromByte(record, value);
    }

    public void setByte(IRecord record, int fieldOffset, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CByte.fromByte(record, fieldOffset, value);
    }

    public void setInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CByte.fromInitialValue(record, fieldOffset, initialValue);
    }

    public byte[] setInitialValue(IRecord record, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CByte.fromInitialValue(record, initialValue);
    }

    public void setObject(IRecord record, int fieldOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof Byte)) {
            throw new RecordConversionUnsupportedException();
        }
        byte b = (Byte)value;
        CByte.fromByte(record, fieldOffset, b);
    }

    public byte[] setObject(IRecord record, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof Byte)) {
            throw new RecordConversionUnsupportedException();
        }
        byte b = (Byte)value;
        return CByte.fromByte(record, b);
    }

    public void setString(IRecord record, int fieldOffset, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            byte byteValue = Byte.parseByte(value);
            CByte.fromByte(record, fieldOffset, byteValue);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public byte[] setString(IRecord record, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            byte byteValue = Byte.parseByte(value);
            return CByte.fromByte(record, byteValue);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public static boolean testConstantValue(IRecord record, byte[] fieldBytes, Object constantValue) {
        byte b;
        if (!(constantValue instanceof Byte)) {
            return false;
        }
        byte cv = (Byte)constantValue;
        try {
            b = CByte.toByte(record, fieldBytes);
        }
        catch (RecordException recordException) {
            return false;
        }
        return cv == b;
    }

    public static boolean testConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        byte b;
        if (!(constantValue instanceof Byte)) {
            return false;
        }
        byte cv = (Byte)constantValue;
        try {
            b = CByte.toByte(record, fieldOffset);
        }
        catch (RecordException recordException) {
            return false;
        }
        return cv == b;
    }

    public static byte toByte(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return byteArray[0];
    }

    public static byte toByte(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte[] byteArray = record.getRawBytes();
        return byteArray[fieldOffset];
    }
}

