/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.DynamicRecord;
import com.ibm.record.Field;
import com.ibm.record.IAnyComposedType;
import com.ibm.record.IAnyDynamicRecordType;
import com.ibm.record.IAnyField;
import com.ibm.record.IAnyType;
import com.ibm.record.IArrayField;
import com.ibm.record.IArrayType;
import com.ibm.record.IDynamicRecord;
import com.ibm.record.IFixedLengthType;
import com.ibm.record.IRecord;
import com.ibm.record.IVariableSizeArrayDimensionField;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordFieldNameNotSetException;
import com.ibm.record.RecordFieldNotFoundException;
import com.ibm.record.RecordFieldTypeNotValidException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Vector;

public class VariableSizeArrayDimensionField
extends Field
implements IVariableSizeArrayDimensionField,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1999.";
    static final long serialVersionUID = 4186880618723868626L;
    protected Vector arrayFieldNames_ = null;
    protected int maxDimensions_ = 0;

    protected VariableSizeArrayDimensionField() {
        this.arrayFieldNames_ = new Vector();
    }

    public VariableSizeArrayDimensionField(IAnyType type) throws RecordFieldTypeNotValidException {
        super(type);
        this.arrayFieldNames_ = new Vector();
    }

    public VariableSizeArrayDimensionField(IAnyType type, String name) throws RecordFieldTypeNotValidException {
        super(type, name);
        this.arrayFieldNames_ = new Vector();
    }

    public VariableSizeArrayDimensionField(IAnyType type, String name, Object initialValue) throws RecordFieldTypeNotValidException {
        super(type, name, initialValue);
        this.arrayFieldNames_ = new Vector();
    }

    public VariableSizeArrayDimensionField(IAnyType type, String name, Object initialValue, Object constantValue, boolean readOnly) throws RecordFieldTypeNotValidException {
        super(type, name, initialValue, constantValue, readOnly);
        this.arrayFieldNames_ = new Vector();
    }

    public VariableSizeArrayDimensionField(IAnyType type, String name, Object initialValue, boolean readOnly) throws RecordFieldTypeNotValidException {
        super(type, name, initialValue, readOnly);
        this.arrayFieldNames_ = new Vector();
    }

    public VariableSizeArrayDimensionField(IAnyType type, String name, Vector arrayFieldNames) throws RecordFieldTypeNotValidException {
        super(type, name);
        this.setArrayFieldNames(arrayFieldNames);
    }

    public VariableSizeArrayDimensionField(IAnyType type, String name, boolean readOnly) throws RecordFieldTypeNotValidException {
        super(type, name, readOnly);
        this.arrayFieldNames_ = new Vector();
    }

    public VariableSizeArrayDimensionField(IAnyType type, boolean readOnly) throws RecordFieldTypeNotValidException {
        super(type, readOnly);
        this.arrayFieldNames_ = new Vector();
    }

    public Object clone() {
        VariableSizeArrayDimensionField newType = (VariableSizeArrayDimensionField)super.clone();
        if (this.arrayFieldNames_ != null) {
            newType.arrayFieldNames_ = (Vector)this.arrayFieldNames_.clone();
            int i = 0;
            while (i < this.arrayFieldNames_.size()) {
                String[] names = (String[])this.arrayFieldNames_.elementAt(i);
                String[] newNames = new String[names.length];
                int j = 0;
                while (j < names.length) {
                    newNames[j] = names[j];
                    ++j;
                }
                newType.arrayFieldNames_.setElementAt(newNames, i);
                ++i;
            }
        }
        return newType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VariableSizeArrayDimensionField)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        VariableSizeArrayDimensionField tmpField = (VariableSizeArrayDimensionField)obj;
        if (this.arrayFieldNames_ == null ^ tmpField.arrayFieldNames_ == null) {
            return false;
        }
        if (this.arrayFieldNames_ == null) {
            return true;
        }
        if (this.arrayFieldNames_.size() != tmpField.arrayFieldNames_.size()) {
            return false;
        }
        Enumeration cursor = null;
        Enumeration cursor2 = null;
        cursor = this.arrayFieldNames_.elements();
        cursor2 = tmpField.arrayFieldNames_.elements();
        while (cursor.hasMoreElements()) {
            String[] name1 = (String[])cursor.nextElement();
            String[] name2 = (String[])cursor2.nextElement();
            int i = name1.length - 1;
            int j = name2.length - 1;
            while (i >= 0 && j >= 0) {
                if (!name1[i].equals(name2[j])) {
                    return false;
                }
                --i;
                --j;
            }
        }
        return true;
    }

    public Vector getArrayFieldNames() {
        return this.arrayFieldNames_;
    }

    public int getMaximumArraySize() {
        return this.maxDimensions_;
    }

    private void setArrayDimensionAndPack(IRecord record, int newDimension) throws RecordFieldNotFoundException, RecordFieldNameNotSetException {
        if (this.arrayFieldNames_.size() == 0) {
            throw new RecordFieldNameNotSetException();
        }
        if (newDimension > this.maxDimensions_ || newDimension < 0) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(newDimension));
        }
        int[] dimension = new int[]{newDimension};
        Enumeration cursor = this.arrayFieldNames_.elements();
        while (cursor.hasMoreElements()) {
            String[] arrayFieldName = (String[])cursor.nextElement();
            IAnyField field = ((DynamicRecord)record).getField(arrayFieldName);
            IArrayType arrType = (IArrayType)field.getType();
            arrType.setDimensions(dimension);
            IAnyDynamicRecordType recType = (IAnyDynamicRecordType)record.getRecordType();
            recType.pack(record.getAlignmentOffset());
        }
        int recSize = record.getRecordType().getSize();
        int bufferSize = record.getRawBytes().length;
        if (bufferSize < recSize) {
            byte[] bytes = new byte[recSize];
            System.arraycopy(record.getRawBytes(), 0, bytes, 0, bufferSize);
            record.setRawBytes(bytes);
        }
    }

    public void setArrayFieldNames(Vector fieldNames) {
        Vector oldNames = this.arrayFieldNames_;
        this.arrayFieldNames_ = fieldNames;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("arrayFieldNames", oldNames, this.arrayFieldNames_);
        }
    }

    public void setBigDecimal(IRecord record, int parentOffset, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int newDim = 0;
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setBigDecimal(record, value);
            newDim = this.fieldType_.getInt(record, this.byteCache_);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setBigDecimal(record, offset, value);
            newDim = ((IFixedLengthType)this.fieldType_).getInt(record, offset);
        }
        this.setArrayDimensionAndPack(record, newDim);
    }

    public void setBoolean(IRecord record, int parentOffset, boolean value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int newDim = 0;
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setBoolean(record, value);
            newDim = this.fieldType_.getInt(record, this.byteCache_);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setBoolean(record, offset, value);
            newDim = ((IFixedLengthType)this.fieldType_).getInt(record, offset);
        }
        this.setArrayDimensionAndPack(record, newDim);
    }

    public void setByte(IRecord record, int parentOffset, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int newDim = 0;
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setByte(record, value);
            newDim = this.fieldType_.getInt(record, this.byteCache_);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setByte(record, offset, value);
            newDim = ((IFixedLengthType)this.fieldType_).getInt(record, offset);
        }
        this.setArrayDimensionAndPack(record, newDim);
    }

    public void setChar(IRecord record, int parentOffset, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int newDim = 0;
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setChar(record, value);
            newDim = this.fieldType_.getInt(record, this.byteCache_);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setChar(record, offset, value);
            newDim = ((IFixedLengthType)this.fieldType_).getInt(record, offset);
        }
        this.setArrayDimensionAndPack(record, newDim);
    }

    public void setDouble(IRecord record, int parentOffset, double value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int newDim = 0;
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setDouble(record, value);
            newDim = this.fieldType_.getInt(record, this.byteCache_);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setDouble(record, offset, value);
            newDim = ((IFixedLengthType)this.fieldType_).getInt(record, offset);
        }
        this.setArrayDimensionAndPack(record, newDim);
    }

    public void setFloat(IRecord record, int parentOffset, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int newDim = 0;
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setFloat(record, value);
            newDim = this.fieldType_.getInt(record, this.byteCache_);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setFloat(record, offset, value);
            newDim = ((IFixedLengthType)this.fieldType_).getInt(record, offset);
        }
        this.setArrayDimensionAndPack(record, newDim);
    }

    public void setInitialValue(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.arrayFieldNames_.size() == 0) {
            throw new RecordFieldNameNotSetException();
        }
        Enumeration cursor = this.arrayFieldNames_.elements();
        while (cursor.hasMoreElements()) {
            String[] arrayFieldName = (String[])cursor.nextElement();
            IArrayField field = (IArrayField)((IDynamicRecord)record).getField(arrayFieldName);
            int[] dims = ((IArrayType)field.getType()).getDimensions();
            this.maxDimensions_ = this.maxDimensions_ != 0 ? Math.min(this.maxDimensions_, dims[0]) : dims[0];
            if (!this.hasInitialValue()) continue;
            int newDim = 0;
            if (this.cacheValues(record)) {
                this.setByteCache(this.getType().setInitialValue(record, this.initialValue_));
                newDim = this.fieldType_.getInt(record, this.byteCache_);
            } else {
                int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
                ((IFixedLengthType)this.getType()).setInitialValue(record, offset, this.initialValue_);
                newDim = ((IFixedLengthType)this.fieldType_).getInt(record, offset);
            }
            this.setArrayDimensionAndPack(record, newDim);
        }
    }

    public void setInt(IRecord record, int parentOffset, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int newDim = 0;
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setInt(record, value);
            newDim = this.fieldType_.getInt(record, this.byteCache_);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setInt(record, offset, value);
            newDim = value;
        }
        this.setArrayDimensionAndPack(record, newDim);
    }

    public void setLong(IRecord record, int parentOffset, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int newDim = 0;
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setLong(record, value);
            newDim = this.fieldType_.getInt(record, this.byteCache_);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setLong(record, offset, value);
            newDim = ((IFixedLengthType)this.fieldType_).getInt(record, offset);
        }
        this.setArrayDimensionAndPack(record, newDim);
    }

    public void setMaximumArraySize(int size) {
        int oldSize = this.maxDimensions_;
        this.maxDimensions_ = size;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("maximumArraySize", new Integer(oldSize), new Integer(this.maxDimensions_));
        }
    }

    public void setObject(IRecord record, int parentOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int newDim = 0;
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setObject(record, value);
            newDim = this.fieldType_.getInt(record, this.byteCache_);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setObject(record, offset, value);
            newDim = ((IFixedLengthType)this.fieldType_).getInt(record, offset);
        }
        this.setArrayDimensionAndPack(record, newDim);
    }

    public void setShort(IRecord record, int parentOffset, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int newDim = 0;
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setShort(record, value);
            newDim = this.fieldType_.getInt(record, this.byteCache_);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setShort(record, offset, value);
            newDim = ((IFixedLengthType)this.fieldType_).getInt(record, offset);
        }
        this.setArrayDimensionAndPack(record, newDim);
    }

    public void setString(IRecord record, int parentOffset, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int newDim = 0;
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setString(record, value);
            newDim = this.fieldType_.getInt(record, this.byteCache_);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setString(record, offset, value);
            newDim = ((IFixedLengthType)this.fieldType_).getInt(record, offset);
        }
        this.setArrayDimensionAndPack(record, newDim);
    }

    public void setType(IAnyType type) throws RecordFieldTypeNotValidException {
        if (type instanceof IAnyComposedType) {
            throw new RecordFieldTypeNotValidException(type.getClass().getName());
        }
        if (!(type instanceof IFixedLengthType)) {
            throw new RecordFieldTypeNotValidException(type.getClass().getName());
        }
        if (!type.canConvertToInt()) {
            throw new RecordFieldTypeNotValidException(type.getClass().getName());
        }
        IAnyType oldType = this.fieldType_;
        this.fieldType_ = type;
        this.setFieldKind(0);
        this.setInitialValue(null);
        this.setConstantValue(null);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("type", oldType, this.fieldType_);
        }
    }
}

