/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.IRangeObject;

public class StringRange
implements IRangeObject {
    private static String copyright = "(c) Copyright IBM Corporation 1999.";
    static final long serialVersionUID = 3348787800915702263L;
    protected String lowerRange_;
    protected String upperRange_;

    public StringRange() {
        this.lowerRange_ = new String();
        this.upperRange_ = new String();
    }

    public StringRange(String lowerRange, String upperRange) throws IllegalArgumentException {
        if (lowerRange == null || upperRange == null) {
            throw new IllegalArgumentException();
        }
        if (upperRange.compareTo(lowerRange) < 0) {
            throw new IllegalArgumentException(upperRange);
        }
        this.lowerRange_ = lowerRange;
        this.upperRange_ = upperRange;
    }

    public Object clone() {
        try {
            StringRange newType = (StringRange)super.clone();
            return newType;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StringRange)) {
            return false;
        }
        StringRange tmpRange = (StringRange)obj;
        if (!this.lowerRange_.equals(tmpRange.lowerRange_)) {
            return false;
        }
        return this.upperRange_.equals(tmpRange.upperRange_);
    }

    public Object getLowerRange() {
        return this.lowerRange_;
    }

    public Object[] getRangeValues() {
        Object[] values = new String[]{this.lowerRange_, this.upperRange_};
        return values;
    }

    public Object getUpperRange() {
        return this.upperRange_;
    }

    public boolean isInRange(Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        String stringVal = (String)value;
        return StringRange.isInRange(this.lowerRange_, this.upperRange_, stringVal);
    }

    public static boolean isInRange(String lowerRange, String upperRange, String value) throws IllegalArgumentException {
        if (lowerRange == null || upperRange == null || value == null) {
            throw new IllegalArgumentException();
        }
        if (upperRange.compareTo(lowerRange) < 0) {
            throw new IllegalArgumentException(upperRange);
        }
        return lowerRange.compareTo(value) <= 0 && upperRange.compareTo(value) >= 0;
    }

    public void setLowerRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.lowerRange_ = (String)value;
    }

    public void setUpperRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.upperRange_ = (String)value;
    }
}

