/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.FixedLengthComposedType;
import com.ibm.record.IArrayType;
import com.ibm.record.IFixedLengthComposedType;
import com.ibm.record.IFixedLengthType;
import com.ibm.record.IRecord;
import com.ibm.record.RecordArrayBaseTypeNotValidException;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Vector;

public class RowMajorArrayType
extends FixedLengthComposedType
implements IArrayType,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = 6130295589006033813L;
    protected IFixedLengthType baseType_;
    protected int[] dimensions_;
    protected static final int OBJECT_ARRAY = 0;
    protected static final int BOOLEAN_ARRAY = 1;
    protected static final int BYTE_ARRAY = 2;
    protected static final int CHAR_ARRAY = 3;
    protected static final int DOUBLE_ARRAY = 4;
    protected static final int FLOAT_ARRAY = 5;
    protected static final int INT_ARRAY = 6;
    protected static final int LONG_ARRAY = 7;
    protected static final int SHORT_ARRAY = 8;
    protected static final int STRING_ARRAY = 9;
    protected static final int BIGDECIMAL_ARRAY = 10;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    protected RowMajorArrayType() {
        this.baseType_ = null;
        this.dimensions_ = null;
    }

    public RowMajorArrayType(int[] dimensions) {
        this.baseType_ = null;
        this.dimensions_ = dimensions;
    }

    public RowMajorArrayType(int[] dimensions, int packingHint) {
        super(packingHint);
        this.baseType_ = null;
        this.dimensions_ = dimensions;
    }

    public RowMajorArrayType(int[] dimensions, int packingHint, IFixedLengthType baseType) throws RecordArrayBaseTypeNotValidException {
        super(packingHint);
        this.setBaseType(baseType);
        this.dimensions_ = dimensions;
    }

    public RowMajorArrayType(int[] dimensions, IFixedLengthType baseType) throws RecordArrayBaseTypeNotValidException {
        this.setBaseType(baseType);
        this.dimensions_ = dimensions;
    }

    protected int[] calculateArrayDimensions(Object array) {
        Vector<Integer> vector = new Vector<Integer>();
        int length = Array.getLength(array);
        vector.addElement(new Integer(length));
        Object theElement = Array.get(array, 0);
        if (theElement.getClass().isArray()) {
            this.calculateArrayDimensions(theElement, vector);
        }
        int[] intArray = new int[vector.size()];
        int i = 0;
        Enumeration cursor = vector.elements();
        while (cursor.hasMoreElements()) {
            Integer theInt = (Integer)cursor.nextElement();
            intArray[i] = theInt;
            ++i;
        }
        return intArray;
    }

    private void calculateArrayDimensions(Object array, Vector vector) {
        int length = Array.getLength(array);
        vector.addElement(new Integer(length));
        Object theElement = Array.get(array, 0);
        if (theElement.getClass().isArray()) {
            this.calculateArrayDimensions(theElement, vector);
        }
    }

    public boolean canConvertFromObject() {
        return true;
    }

    public boolean canConvertToObject() {
        return true;
    }

    public boolean checkConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        int dim = 0;
        int baseSize = this.baseType_.getSize();
        int[] constValDims = this.calculateArrayDimensions(constantValue);
        Object[] objArray = (Object[])constantValue;
        int arraySize = constValDims[dim];
        if (constValDims.length > this.dimensions_.length) {
            return false;
        }
        int i = 0;
        while (i < constValDims.length) {
            if (constValDims[i] > this.dimensions_[i]) {
                return false;
            }
            ++i;
        }
        int totalSize = 1;
        int i2 = dim + 1;
        while (i2 < this.dimensions_.length) {
            totalSize *= this.dimensions_[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < arraySize) {
            int offset;
            if (dim + 1 < this.dimensions_.length ? !this.checkConstantValue(record, fieldOffset + i2 * totalSize * baseSize, objArray[i2], dim + 1, baseSize, constValDims) : !this.baseType_.checkConstantValue(record, offset = fieldOffset + i2 * baseSize, objArray[i2])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private boolean checkConstantValue(IRecord record, int fieldOffset, Object constantValue, int dim, int baseSize, int[] constValDims) {
        int arraySize = constValDims[dim];
        Object[] objArray = (Object[])constantValue;
        int totalSize = 1;
        int i = dim + 1;
        while (i < this.dimensions_.length) {
            totalSize *= this.dimensions_[i];
            ++i;
        }
        i = 0;
        while (i < arraySize) {
            int offset;
            if (dim + 1 < this.dimensions_.length ? !this.checkConstantValue(record, fieldOffset + i * totalSize * baseSize, objArray[i], dim + 1, baseSize, constValDims) : !this.baseType_.checkConstantValue(record, offset = fieldOffset + i * baseSize, objArray[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object clone() {
        RowMajorArrayType newType = (RowMajorArrayType)super.clone();
        if (this.baseType_ != null) {
            newType.baseType_ = (IFixedLengthType)this.baseType_.clone();
        }
        if (this.dimensions_ != null) {
            newType.dimensions_ = new int[this.dimensions_.length];
            int i = 0;
            while (i < this.dimensions_.length) {
                newType.dimensions_[i] = this.dimensions_[i];
                ++i;
            }
        }
        return newType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RowMajorArrayType)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RowMajorArrayType tmpType = (RowMajorArrayType)obj;
        if (this.dimensions_ == null ^ tmpType.dimensions_ == null) {
            return false;
        }
        if (this.dimensions_ != null) {
            if (this.dimensions_.length != tmpType.dimensions_.length) {
                return false;
            }
            int i = 0;
            while (i < this.dimensions_.length) {
                if (this.dimensions_[i] != tmpType.dimensions_[i]) {
                    return false;
                }
                ++i;
            }
        }
        if (this.baseType_ == null ^ tmpType.baseType_ == null) {
            return false;
        }
        if (this.baseType_ == null) {
            return true;
        }
        return this.baseType_.equals(tmpType.baseType_);
    }

    public int getAlignmentHint() {
        return this.baseType_.getAlignmentHint();
    }

    private Object getArray(IRecord record, int fieldOffset, int dim, int baseSize, Class componentType, int componentFlag) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        int[] dimParm = new int[this.dimensions_.length - dim];
        int k = dim;
        while (k < this.dimensions_.length) {
            dimParm[k - dim] = this.dimensions_[dim];
            ++k;
        }
        int arraySize = this.dimensions_[dim];
        Object objArray = Array.newInstance(componentType, dimParm);
        int totalSize = 1;
        int i = dim + 1;
        while (i < this.dimensions_.length) {
            totalSize *= this.dimensions_[i];
            ++i;
        }
        i = 0;
        while (i < arraySize) {
            if (dim + 1 < this.dimensions_.length) {
                Array.set(objArray, i, this.getArray(record, fieldOffset + i * totalSize * baseSize, dim + 1, baseSize, componentType, componentFlag));
            } else {
                int offset = fieldOffset + i * baseSize;
                switch (componentFlag) {
                    case 0: {
                        Array.set(objArray, i, this.baseType_.getObject(record, offset));
                        break;
                    }
                    case 1: {
                        Array.setBoolean(objArray, i, this.baseType_.getBoolean(record, offset));
                        break;
                    }
                    case 2: {
                        Array.setByte(objArray, i, this.baseType_.getByte(record, offset));
                        break;
                    }
                    case 3: {
                        Array.setChar(objArray, i, this.baseType_.getChar(record, offset));
                        break;
                    }
                    case 4: {
                        Array.setDouble(objArray, i, this.baseType_.getDouble(record, offset));
                        break;
                    }
                    case 5: {
                        Array.setFloat(objArray, i, this.baseType_.getFloat(record, offset));
                        break;
                    }
                    case 6: {
                        Array.setInt(objArray, i, this.baseType_.getInt(record, offset));
                        break;
                    }
                    case 7: {
                        Array.setLong(objArray, i, this.baseType_.getLong(record, offset));
                        break;
                    }
                    case 8: {
                        Array.setShort(objArray, i, this.baseType_.getShort(record, offset));
                        break;
                    }
                    case 9: {
                        Array.set(objArray, i, this.baseType_.getString(record, offset));
                        break;
                    }
                    case 10: {
                        Array.set(objArray, i, this.baseType_.getBigDecimal(record, offset));
                    }
                }
            }
            ++i;
        }
        return objArray;
    }

    public Object getArray(IRecord record, int fieldOffset, Class componentType) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        int dim = 0;
        Object objArray = Array.newInstance(componentType, this.dimensions_);
        int totalSize = 1;
        int i = dim + 1;
        while (i < this.dimensions_.length) {
            totalSize *= this.dimensions_[i];
            ++i;
        }
        int baseSize = this.baseType_.getSize();
        int arrayType = 0;
        if (componentType == Boolean.TYPE) {
            arrayType = 1;
        } else if (componentType == Byte.TYPE) {
            arrayType = 2;
        } else if (componentType == Character.TYPE) {
            arrayType = 3;
        } else if (componentType == Double.TYPE) {
            arrayType = 4;
        } else if (componentType == Float.TYPE) {
            arrayType = 5;
        } else if (componentType == Integer.TYPE) {
            arrayType = 6;
        } else if (componentType == Long.TYPE) {
            arrayType = 7;
        } else if (componentType == Short.TYPE) {
            arrayType = 8;
        } else {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (componentType == clazz) {
                arrayType = 9;
            } else {
                Class<?> clazz2 = class$9;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$9 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                arrayType = componentType == clazz2 ? 10 : 0;
            }
        }
        int i2 = 0;
        while (i2 < this.dimensions_[dim]) {
            if (dim + 1 < this.dimensions_.length) {
                Array.set(objArray, i2, this.getArray(record, fieldOffset + i2 * totalSize * baseSize, dim + 1, baseSize, componentType, arrayType));
            } else {
                int offset = fieldOffset + i2 * baseSize;
                switch (arrayType) {
                    case 0: {
                        Array.set(objArray, i2, this.baseType_.getObject(record, offset));
                        break;
                    }
                    case 1: {
                        Array.setBoolean(objArray, i2, this.baseType_.getBoolean(record, offset));
                        break;
                    }
                    case 2: {
                        Array.setByte(objArray, i2, this.baseType_.getByte(record, offset));
                        break;
                    }
                    case 3: {
                        Array.setChar(objArray, i2, this.baseType_.getChar(record, offset));
                        break;
                    }
                    case 4: {
                        Array.setDouble(objArray, i2, this.baseType_.getDouble(record, offset));
                        break;
                    }
                    case 5: {
                        Array.setFloat(objArray, i2, this.baseType_.getFloat(record, offset));
                        break;
                    }
                    case 6: {
                        Array.setInt(objArray, i2, this.baseType_.getInt(record, offset));
                        break;
                    }
                    case 7: {
                        Array.setLong(objArray, i2, this.baseType_.getLong(record, offset));
                        break;
                    }
                    case 8: {
                        Array.setShort(objArray, i2, this.baseType_.getShort(record, offset));
                        break;
                    }
                    case 9: {
                        Array.set(objArray, i2, this.baseType_.getString(record, offset));
                        break;
                    }
                    case 10: {
                        Array.set(objArray, i2, this.baseType_.getBigDecimal(record, offset));
                    }
                }
            }
            ++i2;
        }
        return objArray;
    }

    public IFixedLengthType getBaseType() {
        return this.baseType_;
    }

    public BigDecimal getBigDecimal(IRecord record, int fieldOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getBigDecimal(record, offset);
    }

    public BigDecimal getBigDecimal(IRecord record, int fieldOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getBigDecimal(record, offset);
    }

    public boolean getBoolean(IRecord record, int fieldOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getBoolean(record, offset);
    }

    public boolean getBoolean(IRecord record, int fieldOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getBoolean(record, offset);
    }

    public byte getByte(IRecord record, int fieldOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getByte(record, offset);
    }

    public byte getByte(IRecord record, int fieldOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getByte(record, offset);
    }

    public char getChar(IRecord record, int fieldOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getChar(record, offset);
    }

    public char getChar(IRecord record, int fieldOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getChar(record, offset);
    }

    public int[] getDimensions() {
        return this.dimensions_;
    }

    public double getDouble(IRecord record, int fieldOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getDouble(record, offset);
    }

    public double getDouble(IRecord record, int fieldOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getDouble(record, offset);
    }

    public int getElementOffset(int[] index) throws ArrayIndexOutOfBoundsException {
        return RowMajorArrayType.getElementOffset(index, this.dimensions_, this.getElementSize());
    }

    public static int getElementOffset(int[] index, int[] arrayDimensions, int elementSize) throws ArrayIndexOutOfBoundsException {
        if (arrayDimensions.length != index.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int offset = 0;
        int i = 0;
        while (i < arrayDimensions.length) {
            if (index[i] < 0 || index[i] >= arrayDimensions[i]) {
                throw new ArrayIndexOutOfBoundsException(index[i]);
            }
            int allocationValue = 1;
            int j = i + 1;
            while (j < arrayDimensions.length) {
                allocationValue *= arrayDimensions[j];
                ++j;
            }
            offset += index[i] * allocationValue;
            ++i;
        }
        return offset * elementSize;
    }

    public int getElementOffset(int index) throws ArrayIndexOutOfBoundsException {
        return RowMajorArrayType.getElementOffset(index, this.dimensions_, this.getElementSize());
    }

    public static int getElementOffset(int index, int[] arrayDimensions, int elementSize) throws ArrayIndexOutOfBoundsException {
        if (arrayDimensions.length != 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (index < 0 || index >= arrayDimensions[0]) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int offset = index * elementSize;
        return offset;
    }

    public int getElementSize() {
        return this.baseType_.getSize();
    }

    public float getFloat(IRecord record, int fieldOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getFloat(record, offset);
    }

    public float getFloat(IRecord record, int fieldOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getFloat(record, offset);
    }

    public int getInt(IRecord record, int fieldOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getInt(record, offset);
    }

    public int getInt(IRecord record, int fieldOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getInt(record, offset);
    }

    public long getLong(IRecord record, int fieldOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getLong(record, offset);
    }

    public long getLong(IRecord record, int fieldOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getLong(record, offset);
    }

    public Object getObject(IRecord record, int fieldOffset) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        int dim = 0;
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object objArray = Array.newInstance(clazz, this.dimensions_);
        int totalSize = 1;
        int i = dim + 1;
        while (i < this.dimensions_.length) {
            totalSize *= this.dimensions_[i];
            ++i;
        }
        int baseSize = this.baseType_.getSize();
        int i2 = 0;
        while (i2 < this.dimensions_[dim]) {
            if (dim + 1 < this.dimensions_.length) {
                Array.set(objArray, i2, this.getObject(record, fieldOffset + i2 * totalSize * baseSize, dim + 1, baseSize));
            } else {
                int offset = fieldOffset + i2 * baseSize;
                Array.set(objArray, i2, this.baseType_.getObject(record, offset));
            }
            ++i2;
        }
        return objArray;
    }

    public Object getObject(IRecord record, int fieldOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getObject(record, offset);
    }

    public Object getObject(IRecord record, int fieldOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getObject(record, offset);
    }

    private Object getObject(IRecord record, int fieldOffset, int dim, int baseSize) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        int[] dimParm = new int[this.dimensions_.length - dim];
        int k = dim;
        while (k < this.dimensions_.length) {
            dimParm[k - dim] = this.dimensions_[dim];
            ++k;
        }
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object[] objArray = (Object[])Array.newInstance(clazz, dimParm);
        int arraySize = this.dimensions_[dim];
        int totalSize = 1;
        int i = dim + 1;
        while (i < this.dimensions_.length) {
            totalSize *= this.dimensions_[i];
            ++i;
        }
        i = 0;
        while (i < arraySize) {
            if (dim + 1 < this.dimensions_.length) {
                objArray[i] = this.getObject(record, fieldOffset + i * totalSize * baseSize, dim + 1, baseSize);
            } else {
                int offset = fieldOffset + i * baseSize;
                objArray[i] = this.baseType_.getObject(record, offset);
            }
            ++i;
        }
        return objArray;
    }

    public short getShort(IRecord record, int fieldOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getShort(record, offset);
    }

    public short getShort(IRecord record, int fieldOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getShort(record, offset);
    }

    public int getSize() {
        int numElements = 1;
        int i = 0;
        while (i < this.dimensions_.length) {
            numElements *= this.dimensions_[i];
            ++i;
        }
        int size = this.baseType_.getSize() * numElements;
        return size;
    }

    public String getString(IRecord record, int fieldOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getString(record, offset);
    }

    public String getString(IRecord record, int fieldOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        return this.baseType_.getString(record, offset);
    }

    public void pack(int startingOffset) {
        if (this.baseType_ instanceof IFixedLengthComposedType) {
            ((IFixedLengthComposedType)this.baseType_).pack(startingOffset);
        }
    }

    private void setArray(IRecord record, int fieldOffset, Object value, int dim, int baseSize, int arrayType) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int arraySize = this.dimensions_[dim];
        if (arraySize != Array.getLength(value)) {
            throw new RecordConversionUnsupportedException();
        }
        int totalSize = 1;
        int i = dim + 1;
        while (i < this.dimensions_.length) {
            totalSize *= this.dimensions_[i];
            ++i;
        }
        i = 0;
        while (i < arraySize) {
            if (dim + 1 < this.dimensions_.length) {
                this.setArray(record, fieldOffset + i * totalSize * baseSize, Array.get(value, i), dim + 1, baseSize, arrayType);
            } else {
                int offset = fieldOffset + i * baseSize;
                switch (arrayType) {
                    case 0: {
                        this.baseType_.setObject(record, offset, Array.get(value, i));
                        break;
                    }
                    case 1: {
                        this.baseType_.setBoolean(record, offset, Array.getBoolean(value, i));
                        break;
                    }
                    case 2: {
                        this.baseType_.setByte(record, offset, Array.getByte(value, i));
                        break;
                    }
                    case 3: {
                        this.baseType_.setChar(record, offset, Array.getChar(value, i));
                        break;
                    }
                    case 4: {
                        this.baseType_.setDouble(record, offset, Array.getDouble(value, i));
                        break;
                    }
                    case 5: {
                        this.baseType_.setFloat(record, offset, Array.getFloat(value, i));
                        break;
                    }
                    case 6: {
                        this.baseType_.setInt(record, offset, Array.getInt(value, i));
                        break;
                    }
                    case 7: {
                        this.baseType_.setLong(record, offset, Array.getLong(value, i));
                        break;
                    }
                    case 8: {
                        this.baseType_.setShort(record, offset, Array.getShort(value, i));
                        break;
                    }
                    case 9: {
                        this.baseType_.setString(record, offset, (String)Array.get(value, i));
                        break;
                    }
                    case 10: {
                        this.baseType_.setBigDecimal(record, offset, (BigDecimal)Array.get(value, i));
                    }
                }
            }
            ++i;
        }
    }

    public void setArray(IRecord record, int fieldOffset, Object value, Class componentType) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!value.getClass().isArray()) {
            throw new RecordConversionUnsupportedException();
        }
        int dim = 0;
        int baseSize = this.baseType_.getSize();
        int arraySize = this.dimensions_[dim];
        if (arraySize != Array.getLength(value)) {
            throw new RecordConversionUnsupportedException();
        }
        int arrayType = 0;
        if (componentType == Boolean.TYPE) {
            arrayType = 1;
        } else if (componentType == Byte.TYPE) {
            arrayType = 2;
        } else if (componentType == Character.TYPE) {
            arrayType = 3;
        } else if (componentType == Double.TYPE) {
            arrayType = 4;
        } else if (componentType == Float.TYPE) {
            arrayType = 5;
        } else if (componentType == Integer.TYPE) {
            arrayType = 6;
        } else if (componentType == Long.TYPE) {
            arrayType = 7;
        } else if (componentType == Short.TYPE) {
            arrayType = 8;
        } else {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (componentType == clazz) {
                arrayType = 9;
            } else {
                Class<?> clazz2 = class$9;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$9 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                arrayType = componentType == clazz2 ? 10 : 0;
            }
        }
        int totalSize = 1;
        int i = dim + 1;
        while (i < this.dimensions_.length) {
            totalSize *= this.dimensions_[i];
            ++i;
        }
        i = 0;
        while (i < arraySize) {
            if (dim + 1 < this.dimensions_.length) {
                this.setArray(record, fieldOffset + i * totalSize * baseSize, Array.get(value, i), dim + 1, baseSize, arrayType);
            } else {
                int offset = fieldOffset + i * baseSize;
                switch (arrayType) {
                    case 0: {
                        this.baseType_.setObject(record, offset, Array.get(value, i));
                        break;
                    }
                    case 1: {
                        this.baseType_.setBoolean(record, offset, Array.getBoolean(value, i));
                        break;
                    }
                    case 2: {
                        this.baseType_.setByte(record, offset, Array.getByte(value, i));
                        break;
                    }
                    case 3: {
                        this.baseType_.setChar(record, offset, Array.getChar(value, i));
                        break;
                    }
                    case 4: {
                        this.baseType_.setDouble(record, offset, Array.getDouble(value, i));
                        break;
                    }
                    case 5: {
                        this.baseType_.setFloat(record, offset, Array.getFloat(value, i));
                        break;
                    }
                    case 6: {
                        this.baseType_.setInt(record, offset, Array.getInt(value, i));
                        break;
                    }
                    case 7: {
                        this.baseType_.setLong(record, offset, Array.getLong(value, i));
                        break;
                    }
                    case 8: {
                        this.baseType_.setShort(record, offset, Array.getShort(value, i));
                        break;
                    }
                    case 9: {
                        this.baseType_.setString(record, offset, (String)Array.get(value, i));
                        break;
                    }
                    case 10: {
                        this.baseType_.setBigDecimal(record, offset, (BigDecimal)Array.get(value, i));
                    }
                }
            }
            ++i;
        }
    }

    public void setBaseType(IFixedLengthType baseType) throws RecordArrayBaseTypeNotValidException {
        if (baseType instanceof IArrayType) {
            throw new RecordArrayBaseTypeNotValidException(baseType.toString());
        }
        IFixedLengthType oldBaseType = this.baseType_;
        this.baseType_ = baseType;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("baseType", oldBaseType, this.baseType_);
        }
    }

    public void setBigDecimal(IRecord record, int fieldOffset, int[] index, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setBigDecimal(record, offset, value);
    }

    public void setBigDecimal(IRecord record, int fieldOffset, int index, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setBigDecimal(record, offset, value);
    }

    public void setBoolean(IRecord record, int fieldOffset, int[] index, boolean value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setBoolean(record, offset, value);
    }

    public void setBoolean(IRecord record, int fieldOffset, int index, boolean value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setBoolean(record, offset, value);
    }

    public void setByte(IRecord record, int fieldOffset, int[] index, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setByte(record, offset, value);
    }

    public void setByte(IRecord record, int fieldOffset, int index, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setByte(record, offset, value);
    }

    public void setChar(IRecord record, int fieldOffset, int[] index, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setChar(record, offset, value);
    }

    public void setChar(IRecord record, int fieldOffset, int index, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setChar(record, offset, value);
    }

    public void setDimensions(int[] dimensions) {
        int[] oldDimensions = this.dimensions_;
        this.dimensions_ = dimensions;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dimensions", oldDimensions, this.dimensions_);
        }
    }

    public void setDouble(IRecord record, int fieldOffset, int[] index, double value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setDouble(record, offset, value);
    }

    public void setDouble(IRecord record, int fieldOffset, int index, double value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setDouble(record, offset, value);
    }

    public void setFloat(IRecord record, int fieldOffset, int[] index, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setFloat(record, offset, value);
    }

    public void setFloat(IRecord record, int fieldOffset, int index, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setFloat(record, offset, value);
    }

    public void setInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!initialValue.getClass().isArray()) {
            throw new RecordConversionUnsupportedException();
        }
        int dim = 0;
        int baseSize = this.baseType_.getSize();
        int[] initValDims = this.calculateArrayDimensions(initialValue);
        Object[] objArray = (Object[])initialValue;
        int arraySize = initValDims[dim];
        if (initValDims.length > this.dimensions_.length) {
            throw new RecordConversionUnsupportedException();
        }
        int i = 0;
        while (i < initValDims.length) {
            if (initValDims[i] > this.dimensions_[i]) {
                throw new RecordConversionUnsupportedException();
            }
            ++i;
        }
        int totalSize = 1;
        int i2 = dim + 1;
        while (i2 < this.dimensions_.length) {
            totalSize *= this.dimensions_[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < arraySize) {
            if (dim + 1 < this.dimensions_.length) {
                this.setInitialValue(record, fieldOffset + i2 * totalSize * baseSize, objArray[i2], dim + 1, baseSize, initValDims);
            } else {
                int offset = fieldOffset + i2 * baseSize;
                this.baseType_.setInitialValue(record, offset, objArray[i2]);
            }
            ++i2;
        }
    }

    private void setInitialValue(IRecord record, int fieldOffset, Object initialValue, int dim, int baseSize, int[] initValDims) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int arraySize = initValDims[dim];
        Object[] objArray = (Object[])initialValue;
        int totalSize = 1;
        int i = dim + 1;
        while (i < this.dimensions_.length) {
            totalSize *= this.dimensions_[i];
            ++i;
        }
        i = 0;
        while (i < arraySize) {
            if (dim + 1 < this.dimensions_.length) {
                this.setInitialValue(record, fieldOffset + i * totalSize * baseSize, objArray[i], dim + 1, baseSize, initValDims);
            } else {
                int offset = fieldOffset + i * baseSize;
                this.baseType_.setInitialValue(record, offset, objArray[i]);
            }
            ++i;
        }
    }

    public void setInt(IRecord record, int fieldOffset, int[] index, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setInt(record, offset, value);
    }

    public void setInt(IRecord record, int fieldOffset, int index, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setInt(record, offset, value);
    }

    public void setLong(IRecord record, int fieldOffset, int[] index, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setLong(record, offset, value);
    }

    public void setLong(IRecord record, int fieldOffset, int index, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setLong(record, offset, value);
    }

    public void setObject(IRecord record, int fieldOffset, int[] index, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setObject(record, offset, value);
    }

    public void setObject(IRecord record, int fieldOffset, int index, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setObject(record, offset, value);
    }

    public void setObject(IRecord record, int fieldOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!value.getClass().isArray()) {
            throw new RecordConversionUnsupportedException();
        }
        int dim = 0;
        int baseSize = this.baseType_.getSize();
        int arraySize = this.dimensions_[dim];
        Object[] objArray = (Object[])value;
        if (arraySize != objArray.length) {
            throw new RecordConversionUnsupportedException();
        }
        int totalSize = 1;
        int i = dim + 1;
        while (i < this.dimensions_.length) {
            totalSize *= this.dimensions_[i];
            ++i;
        }
        i = 0;
        while (i < arraySize) {
            if (dim + 1 < this.dimensions_.length) {
                this.setObject(record, fieldOffset + i * totalSize * baseSize, objArray[i], dim + 1, baseSize);
            } else {
                int offset = fieldOffset + i * baseSize;
                this.baseType_.setObject(record, offset, objArray[i]);
            }
            ++i;
        }
    }

    private void setObject(IRecord record, int fieldOffset, Object value, int dim, int baseSize) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int arraySize = this.dimensions_[dim];
        Object[] objArray = (Object[])value;
        if (arraySize != objArray.length) {
            throw new RecordConversionUnsupportedException();
        }
        int totalSize = 1;
        int i = dim + 1;
        while (i < this.dimensions_.length) {
            totalSize *= this.dimensions_[i];
            ++i;
        }
        i = 0;
        while (i < arraySize) {
            if (dim + 1 < this.dimensions_.length) {
                this.setObject(record, fieldOffset + i * totalSize * baseSize, objArray[i], dim + 1, baseSize);
            } else {
                int offset = fieldOffset + i * baseSize;
                this.baseType_.setObject(record, offset, objArray[i]);
            }
            ++i;
        }
    }

    public void setShort(IRecord record, int fieldOffset, int[] index, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setShort(record, offset, value);
    }

    public void setShort(IRecord record, int fieldOffset, int index, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setShort(record, offset, value);
    }

    public void setString(IRecord record, int fieldOffset, int[] index, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setString(record, offset, value);
    }

    public void setString(IRecord record, int fieldOffset, int index, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = this.getElementOffset(index) + fieldOffset;
        this.baseType_.setString(record, offset, value);
    }
}

