/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.IAnyDynamicRecordType;
import com.ibm.record.IAnyField;
import com.ibm.record.IArrayField;
import com.ibm.record.IArrayType;
import com.ibm.record.IDynamicRecord;
import com.ibm.record.IFieldEnumeration;
import com.ibm.record.INestedRecordField;
import com.ibm.record.IOverlayField;
import com.ibm.record.IRecord;
import com.ibm.record.IRecordAttributes;
import com.ibm.record.IRecordType;
import com.ibm.record.IVariableLengthRecordType;
import com.ibm.record.IVariableSizeArrayDimensionField;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordException;
import com.ibm.record.TypeData;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Record
implements IRecord,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = 5674807977125621194L;
    protected int startingOffset_;
    protected int alignmentOffset_;
    protected byte[] bytes_;
    protected IRecordAttributes recordAttributes_;
    protected transient PropertyChangeSupport changes_;
    protected boolean notificationOn_;
    private static byte[] resourceLock_ = new byte[1];

    public Record() {
        this.startingOffset_ = 0;
        this.alignmentOffset_ = 0;
        this.bytes_ = null;
        this.recordAttributes_ = null;
        this.changes_ = null;
        this.notificationOn_ = true;
    }

    public Record(byte[] bytes, IRecordAttributes attributes, int startingOffset, int alignmentOffset) throws IllegalArgumentException, RecordException {
        this.changes_ = null;
        this.notificationOn_ = true;
        this.setStartingOffset(startingOffset);
        this.setAlignmentOffset(alignmentOffset);
        this.setRecordAttributes(attributes);
        this.setBytes(bytes);
        this.setInitialValues();
    }

    public Record(IRecordAttributes attributes, int startingOffset, int alignmentOffset) throws IllegalArgumentException {
        this.changes_ = null;
        this.notificationOn_ = true;
        this.setStartingOffset(startingOffset);
        this.setAlignmentOffset(alignmentOffset);
        this.setRecordAttributes(attributes);
        this.bytes_ = null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        byte[] byArray = resourceLock_;
        synchronized (resourceLock_) {
            if (this.changes_ == null) {
                this.changes_ = new PropertyChangeSupport(this);
            }
            this.changes_.addPropertyChangeListener(listener);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public abstract boolean checkBytes(byte[] var1);

    public Object clone() {
        try {
            Record newType = (Record)super.clone();
            newType.changes_ = null;
            if (this.bytes_ != null) {
                newType.bytes_ = new byte[this.bytes_.length];
                System.arraycopy(this.bytes_, 0, newType.bytes_, 0, this.bytes_.length);
            }
            if (this.recordAttributes_ != null) {
                newType.recordAttributes_ = (IRecordAttributes)this.recordAttributes_.clone();
            }
            return newType;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    protected void disableNotification() {
        this.notificationOn_ = false;
    }

    public static void dumpBytes(PrintStream stream, IRecord record) {
        StringBuffer strBuf = new StringBuffer();
        Record.dumpBytes(strBuf, record);
        System.out.println(strBuf.toString());
    }

    public static void dumpBytes(StringBuffer stream, IRecord record) {
        byte[] theBytes = record.getBytes();
        int bufSize = 0;
        if (theBytes != null) {
            bufSize = theBytes.length;
        }
        int size = bufSize;
        char[] buf = new char[16];
        while (size % 16 != 0) {
            ++size;
        }
        stream.append("Record Size: " + record.getSize() + " bytes");
        stream.append("\n");
        stream.append("Buffer Size: " + bufSize + " bytes");
        stream.append("\n");
        stream.append("Starting Offset: " + record.getStartingOffset());
        stream.append("\n");
        stream.append("Alignment Offset: " + record.getAlignmentOffset());
        stream.append("\n");
        Record.dumpRecordAttributes(stream, record.getRecordAttributes());
        stream.append("\n");
        if (theBytes == null) {
            return;
        }
        int j = 0;
        int i = 1;
        while (i <= size) {
            int k;
            if (i > bufSize) {
                stream.append(Integer.toHexString(0));
                stream.append(Integer.toHexString(0));
                buf[j] = '\u0000';
            } else {
                k = (theBytes[i - 1] & 0xF0) >> 4;
                int l = theBytes[i - 1] & 0xF;
                stream.append(Integer.toHexString(k));
                stream.append(Integer.toHexString(l));
                buf[j] = (char)theBytes[i - 1];
            }
            if (i % 4 == 0) {
                stream.append(" ");
            }
            if (i % 16 == 0) {
                stream.append(" |");
                k = 0;
                while (k < 16) {
                    if (Character.isIdentifierIgnorable(buf[k])) {
                        stream.append(".");
                    } else {
                        stream.append(buf[k]);
                    }
                    ++k;
                }
                stream.append("|");
                stream.append("\n");
                j = 0;
            } else {
                ++j;
            }
            ++i;
        }
        stream.append("\n");
    }

    public static void dumpRecordAttributes(PrintStream stream, IRecordAttributes attributes) {
        StringBuffer strBuf = new StringBuffer();
        Record.dumpRecordAttributes(strBuf, attributes);
        System.out.println(strBuf.toString());
    }

    public static void dumpRecordAttributes(StringBuffer stream, IRecordAttributes attributes) {
        BeanInfo info;
        if (attributes == null) {
            return;
        }
        try {
            info = Introspector.getBeanInfo(attributes.getClass());
        }
        catch (IntrospectionException introspectionException) {
            return;
        }
        PropertyDescriptor[] properties = info.getPropertyDescriptors();
        if (properties == null) {
            return;
        }
        int i = 0;
        while (i < properties.length) {
            Method method = properties[i].getReadMethod();
            String name = method.getName();
            if (!name.equals("getClass")) {
                name = name.substring(3);
                stream.append(String.valueOf(name) + ": ");
                try {
                    stream.append(method.invoke((Object)attributes, null));
                    stream.append("\n");
                }
                catch (Exception exception) {
                    stream.append("\n");
                }
            }
            ++i;
        }
    }

    protected void enableNotification() {
        this.notificationOn_ = true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record tmpRec = (Record)obj;
        if (this.startingOffset_ != tmpRec.startingOffset_) {
            return false;
        }
        if (this.alignmentOffset_ != tmpRec.alignmentOffset_) {
            return false;
        }
        if (this.bytes_ == null ^ tmpRec.bytes_ == null) {
            return false;
        }
        if (this.bytes_ != null) {
            if (this.bytes_.length != tmpRec.bytes_.length) {
                return false;
            }
            int i = 0;
            while (i < this.bytes_.length) {
                if (this.bytes_[i] != tmpRec.bytes_[i]) {
                    return false;
                }
                ++i;
            }
        }
        if (this.recordAttributes_ == null ^ tmpRec.recordAttributes_ == null) {
            return false;
        }
        if (this.recordAttributes_ == null) {
            return true;
        }
        return this.recordAttributes_.equals(tmpRec.recordAttributes_);
    }

    private void flushByteCache(INestedRecordField nestedField, int parentOffset) {
        IAnyDynamicRecordType type = (IAnyDynamicRecordType)nestedField.getType();
        if (type instanceof IVariableLengthRecordType) {
            byte[] fieldBytes = nestedField.getBytes(this);
            System.arraycopy(fieldBytes, 0, this.bytes_, parentOffset, fieldBytes.length);
        } else {
            IFieldEnumeration cursor = type.fields();
            while (cursor.hasMoreFields()) {
                IAnyField field = cursor.nextField();
                if (!(field instanceof INestedRecordField)) continue;
                this.flushByteCache((INestedRecordField)field, parentOffset + field.getRelativeOffset());
            }
        }
    }

    public int getAlignmentOffset() {
        return this.alignmentOffset_;
    }

    public byte[] getBytes() {
        switch (this.getRecordKind()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                Vector<byte[]> bufferVec = new Vector<byte[]>();
                IFieldEnumeration cursor = ((IAnyDynamicRecordType)this.getRecordType()).fields();
                while (cursor.hasMoreFields()) {
                    IAnyField field = cursor.nextField();
                    bufferVec.addElement(field.getBytes(this));
                }
                int size = this.startingOffset_;
                Enumeration cursor2 = bufferVec.elements();
                while (cursor2.hasMoreElements()) {
                    byte[] buf = (byte[])cursor2.nextElement();
                    size += buf.length;
                }
                int offset = this.startingOffset_;
                if (this.bytes_ == null || this.bytes_.length != size) {
                    this.bytes_ = new byte[size];
                }
                Enumeration cursor3 = bufferVec.elements();
                while (cursor3.hasMoreElements()) {
                    byte[] buf = (byte[])cursor3.nextElement();
                    System.arraycopy(buf, 0, this.bytes_, offset, buf.length);
                    offset += buf.length;
                }
                this.bytes_ = ((IAnyDynamicRecordType)this.getRecordType()).packageBytes(this, this.bytes_);
                break;
            }
            case 3: {
                IFieldEnumeration cursor = ((IAnyDynamicRecordType)this.getRecordType()).fields();
                while (cursor.hasMoreFields()) {
                    IAnyField field = cursor.nextField();
                    if (!(field instanceof INestedRecordField)) continue;
                    this.flushByteCache((INestedRecordField)field, field.getRelativeOffset());
                }
                break;
            }
        }
        return this.bytes_;
    }

    public byte[] getRawBytes() {
        return this.bytes_;
    }

    public IRecordAttributes getRecordAttributes() {
        return this.recordAttributes_;
    }

    public abstract IRecordType getRecordType();

    public abstract int getSize();

    public int getStartingOffset() {
        return this.startingOffset_;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        byte[] byArray = resourceLock_;
        synchronized (resourceLock_) {
            if (this.changes_ == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.changes_.removePropertyChangeListener(listener);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setAlignmentOffset(int offset) throws IllegalArgumentException {
        if (offset < 0) {
            throw new IllegalArgumentException(Integer.toString(offset));
        }
        this.alignmentOffset_ = offset;
    }

    public void setBytes(byte[] theBytes) {
        byte[] oldBytes = this.bytes_;
        this.bytes_ = theBytes;
        switch (this.getRecordKind()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                TypeData data = ((IAnyDynamicRecordType)this.getRecordType()).retrieveBytes(this, this.bytes_, this.startingOffset_);
                theBytes = data.bytes_;
                int currentOffset = 0;
                IFieldEnumeration cursor = ((IAnyDynamicRecordType)this.getRecordType()).fields();
                while (cursor.hasMoreFields()) {
                    IAnyField field = cursor.nextField();
                    currentOffset += field.setBytes(this, theBytes, currentOffset);
                }
                break;
            }
            case 3: {
                IFieldEnumeration cursor = ((IAnyDynamicRecordType)this.getRecordType()).fields();
                while (cursor.hasMoreFields()) {
                    IAnyField field = cursor.nextField();
                    if (!(field instanceof INestedRecordField)) continue;
                    field.setBytes(this, theBytes, field.getRelativeOffset());
                }
                break;
            }
            case 4: {
                this.setVarSizeArrayDimensions((IAnyDynamicRecordType)this.getRecordType(), new String[0]);
                break;
            }
            case 5: {
                this.setVarSizeArrayDimensions((IAnyDynamicRecordType)this.getRecordType(), new String[0]);
                IFieldEnumeration cursor = ((IAnyDynamicRecordType)this.getRecordType()).fields();
                while (cursor.hasMoreFields()) {
                    IAnyField field = cursor.nextField();
                    if (!(field instanceof INestedRecordField)) continue;
                    field.setBytes(this, theBytes, field.getRelativeOffset());
                }
                break;
            }
        }
        if (this.changes_ != null && this.notificationOn_) {
            this.changes_.firePropertyChange("bytes", oldBytes, this.bytes_);
        }
    }

    public abstract void setInitialValues() throws RecordConversionFailureException, RecordConversionUnsupportedException;

    public void setRawBytes(byte[] bytes) {
        this.bytes_ = bytes;
    }

    public void setRecordAttributes(IRecordAttributes attributes) throws IllegalArgumentException {
        IAnyDynamicRecordType recType;
        if (attributes == null) {
            throw new IllegalArgumentException();
        }
        if (this instanceof IDynamicRecord && this.getRecordType() != null && !(recType = (IAnyDynamicRecordType)this.getRecordType()).getRecordAttributesClass().isInstance(attributes)) {
            throw new IllegalArgumentException();
        }
        this.recordAttributes_ = attributes;
    }

    public abstract void setRecordType(IRecordType var1) throws IllegalArgumentException;

    public void setStartingOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException(Integer.toString(offset));
        }
        this.startingOffset_ = offset;
    }

    private void setVarSizeArrayDimensions(IAnyDynamicRecordType recType, String[] fieldNames) {
        IFieldEnumeration cursor = recType.fields();
        while (cursor.hasMoreFields()) {
            IAnyField field = cursor.nextField();
            int size = fieldNames.length;
            String[] newFieldNames = new String[size + 1];
            System.arraycopy(fieldNames, 0, newFieldNames, 0, size);
            newFieldNames[size] = field.getName();
            if (field instanceof INestedRecordField || field instanceof IOverlayField) {
                this.setVarSizeArrayDimensions((IAnyDynamicRecordType)field.getType(), newFieldNames);
                continue;
            }
            if (!(field instanceof IVariableSizeArrayDimensionField)) continue;
            IVariableSizeArrayDimensionField varField = (IVariableSizeArrayDimensionField)field;
            IDynamicRecord record = (IDynamicRecord)((Object)this);
            int dims = record.getInt(newFieldNames);
            if (varField.getMaximumArraySize() == 0) {
                Object initialValue = varField.getInitialValue();
                if (initialValue != null) {
                    varField.setInitialValue(null);
                }
                varField.setInitialValue(this, 0);
                if (initialValue != null) {
                    varField.setInitialValue(initialValue);
                }
            }
            Vector arrayNames = varField.getArrayFieldNames();
            int[] dimensions = new int[]{dims};
            Enumeration nameCursor = arrayNames.elements();
            while (nameCursor.hasMoreElements()) {
                String[] arrayFieldName = (String[])nameCursor.nextElement();
                IArrayField arrayField = (IArrayField)record.getField(arrayFieldName);
                ((IArrayType)arrayField.getType()).setDimensions(dimensions);
            }
            ((IAnyDynamicRecordType)this.getRecordType()).pack(this.getAlignmentOffset());
        }
    }

    public abstract int getRecordKind();
}

