/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.AnyFixedLengthRecordType;
import com.ibm.record.IAnyComposedType;
import com.ibm.record.IAnyField;
import com.ibm.record.IAnyType;
import com.ibm.record.IFieldEnumeration;
import com.ibm.record.IFixedLengthType;
import com.ibm.record.INestedRecordField;
import com.ibm.record.IOverlayField;
import com.ibm.record.IOverlayType;
import com.ibm.record.IRecord;
import com.ibm.record.IRecordAttributes;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import java.io.Serializable;

public abstract class OverlayType
extends AnyFixedLengthRecordType
implements IOverlayType,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = -672737947369810358L;
    protected int size_ = 0;

    public OverlayType() {
    }

    public OverlayType(int packingHint) {
        super(packingHint);
    }

    public boolean canConvertFromObject() {
        return true;
    }

    public boolean canConvertToObject() {
        return true;
    }

    public Object clone() {
        OverlayType newType = (OverlayType)super.clone();
        return newType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OverlayType)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        OverlayType tmpObj = (OverlayType)obj;
        return this.size_ == tmpObj.size_;
    }

    public Object getObject(IRecord record, int fieldOffset) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        try {
            IRecordAttributes recAttr = (IRecordAttributes)record.getRecordAttributes().clone();
            IOverlayType recType = (IOverlayType)this.clone();
            IRecord returnRecord = recType.newRecord(recAttr, 0, fieldOffset);
            int length = this.getSize();
            byte[] bytes = new byte[length];
            System.arraycopy(record.getBytes(), fieldOffset, bytes, 0, length);
            returnRecord.setBytes(bytes);
            return returnRecord;
        }
        catch (Exception exception) {
            throw new RecordConversionFailureException();
        }
    }

    public abstract Class getRecordAttributesClass();

    public int getSize() {
        return this.size_;
    }

    public void pack(int startingOffset) {
        IFieldEnumeration iFieldEnumeration = this.fields();
        while (iFieldEnumeration.hasMoreFields()) {
            IAnyField field = iFieldEnumeration.nextField();
            field.setRelativeOffset(0);
            IAnyType type = field.getType();
            if (type instanceof IAnyComposedType) {
                ((IAnyComposedType)type).pack(startingOffset);
            }
            this.size_ = Math.max(this.size_, field.getSize());
        }
        int hint = Math.min(this.getAlignmentHint(), this.getPackingHint());
        while (this.size_ % hint != 0) {
            ++this.size_;
        }
    }

    public void setInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField field = (IAnyField)this.dict_.firstElement();
        if (field instanceof INestedRecordField || field instanceof IOverlayField) {
            field.setInitialValue(record, fieldOffset);
        } else {
            Object initVal = initialValue;
            if (initVal == null) {
                initVal = field.getInitialValue();
            }
            ((IFixedLengthType)field.getType()).setInitialValue(record, fieldOffset, initVal);
        }
    }

    public void setObject(IRecord record, int fieldOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            IRecord aRecord = (IRecord)value;
            if (!aRecord.getRecordType().equals(this)) {
                throw new RecordConversionUnsupportedException();
            }
            int length = this.getSize();
            if (length != aRecord.getSize()) {
                throw new RecordConversionFailureException();
            }
            System.arraycopy(aRecord.getBytes(), aRecord.getStartingOffset(), record.getBytes(), fieldOffset, length);
        }
        catch (Exception exception) {
            throw new RecordConversionFailureException();
        }
    }
}

