/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.AnyField;
import com.ibm.record.IAnyDynamicRecordType;
import com.ibm.record.IAnyField;
import com.ibm.record.IAnyType;
import com.ibm.record.IArrayField;
import com.ibm.record.IArrayType;
import com.ibm.record.IFieldEnumeration;
import com.ibm.record.IFixedLengthType;
import com.ibm.record.INestedRecordField;
import com.ibm.record.IOverlayField;
import com.ibm.record.IOverlayType;
import com.ibm.record.IRecord;
import com.ibm.record.IVariableSizeArrayDimensionField;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordFieldTypeNotValidException;
import java.io.Serializable;

public class OverlayField
extends AnyField
implements IOverlayField,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = -3818277421651347924L;
    protected IOverlayType fieldType_;

    private OverlayField() {
        this.fieldType_ = null;
        this.setFieldKind(0);
    }

    public OverlayField(IOverlayType type) {
        this.fieldType_ = type;
        this.setFieldKind(0);
    }

    public OverlayField(IOverlayType type, String name) {
        super(name);
        this.fieldType_ = type;
        this.setFieldKind(0);
    }

    public OverlayField(IOverlayType type, String name, Object initialValue) {
        super(name, initialValue);
        this.fieldType_ = type;
        this.setFieldKind(0);
    }

    public Object clone() {
        OverlayField newType = (OverlayField)super.clone();
        if (this.fieldType_ != null) {
            newType.fieldType_ = (IOverlayType)this.fieldType_.clone();
        }
        return newType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OverlayField)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        OverlayField tmpField = (OverlayField)obj;
        if (this.fieldType_ == null ^ tmpField.fieldType_ == null) {
            return false;
        }
        if (this.fieldType_ == null) {
            return true;
        }
        return this.fieldType_.equals(tmpField.fieldType_);
    }

    public int getFieldKind() {
        return 0;
    }

    public Object getObject(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.cacheValues(record)) {
            return this.fieldType_.getObject(record, this.byteCache_);
        }
        int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
        return ((IFixedLengthType)this.fieldType_).getObject(record, offset);
    }

    public int getSize() {
        return this.fieldType_.getSize();
    }

    public IAnyType getType() {
        return this.fieldType_;
    }

    public boolean hasInitialValue() {
        IAnyField field;
        if (this.initialValue_ != null) {
            return true;
        }
        IFieldEnumeration cursor = this.fieldType_.fields();
        return cursor.hasMoreFields() && (field = cursor.nextField()).hasInitialValue();
    }

    private void initVarSizeArrayFields(IRecord record, int parentOffset, IAnyDynamicRecordType recType) {
        IFieldEnumeration cursor = recType.fields();
        while (cursor.hasMoreFields()) {
            IAnyField field = cursor.nextField();
            if (field instanceof IVariableSizeArrayDimensionField) {
                field.setInitialValue(record, parentOffset);
                continue;
            }
            if (field instanceof IArrayField) {
                IArrayType arrayType = (IArrayType)field.getType();
                IFixedLengthType baseType = arrayType.getBaseType();
                if (!(baseType instanceof IAnyDynamicRecordType)) continue;
                this.initVarSizeArrayFields(record, parentOffset + field.getRelativeOffset(), (IAnyDynamicRecordType)((Object)baseType));
                continue;
            }
            if (!(field instanceof INestedRecordField) && !(field instanceof IOverlayField)) continue;
            this.initVarSizeArrayFields(record, parentOffset + field.getRelativeOffset(), (IAnyDynamicRecordType)field.getType());
        }
    }

    public void setInitialValue(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        super.setInitialValue(record, parentOffset);
        this.initVarSizeArrayFields(record, parentOffset, this.fieldType_);
    }

    public void setObject(IRecord record, int parentOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setObject(record, value);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setObject(record, offset, value);
        }
    }

    public void setType(IAnyType type) throws RecordFieldTypeNotValidException {
        if (!(type instanceof IOverlayType)) {
            throw new RecordFieldTypeNotValidException(type.getClass().getName());
        }
        IOverlayType oldType = this.fieldType_;
        this.fieldType_ = (IOverlayType)type;
        this.setFieldKind(0);
        this.setInitialValue(null);
        this.setConstantValue(null);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("type", oldType, this.fieldType_);
        }
    }
}

