/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.IRangeObject;

public class FloatRange
implements IRangeObject {
    private static String copyright = "(c) Copyright IBM Corporation 1999.";
    static final long serialVersionUID = -4489841197295344943L;
    protected float lowerRange_;
    protected float upperRange_;

    public FloatRange() {
        this.lowerRange_ = 0.0f;
        this.upperRange_ = 0.0f;
    }

    public FloatRange(float lowerRange, float upperRange) throws IllegalArgumentException {
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(Float.toString(upperRange));
        }
        this.lowerRange_ = lowerRange;
        this.upperRange_ = upperRange;
    }

    public Object clone() {
        try {
            FloatRange newType = (FloatRange)super.clone();
            return newType;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatRange)) {
            return false;
        }
        FloatRange tmpRange = (FloatRange)obj;
        if (this.lowerRange_ != tmpRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == tmpRange.upperRange_;
    }

    public Object getLowerRange() {
        return new Float(this.lowerRange_);
    }

    public Object getUpperRange() {
        return new Float(this.upperRange_);
    }

    public static boolean isInRange(float lowerRange, float upperRange, float value) throws IllegalArgumentException {
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(Float.toString(upperRange));
        }
        return value >= lowerRange && value <= upperRange;
    }

    public boolean isInRange(Object value) {
        if (!(value instanceof Float)) {
            return false;
        }
        float floatVal = ((Float)value).floatValue();
        return FloatRange.isInRange(this.lowerRange_, this.upperRange_, floatVal);
    }

    public void setLowerRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Float)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.lowerRange_ = ((Float)value).floatValue();
    }

    public void setUpperRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Float)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.upperRange_ = ((Float)value).floatValue();
    }
}

