/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.AnyFixedLengthRecordType;
import com.ibm.record.Field;
import com.ibm.record.IAnyComposedType;
import com.ibm.record.IAnyDynamicRecordType;
import com.ibm.record.IAnyField;
import com.ibm.record.IAnyType;
import com.ibm.record.IArrayField;
import com.ibm.record.IArrayType;
import com.ibm.record.IDynamicRecord;
import com.ibm.record.IFieldEnumeration;
import com.ibm.record.IFixedLengthRecordType;
import com.ibm.record.INestedRecordField;
import com.ibm.record.IOverlayField;
import com.ibm.record.IRecord;
import com.ibm.record.IRecordAttributes;
import com.ibm.record.IVariableSizeArrayDimensionField;
import com.ibm.record.PaddingType;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordException;
import com.ibm.record.RecordFieldNotFoundException;
import com.ibm.record.RecordFieldTypeNotValidException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class FixedLengthRecordType
extends AnyFixedLengthRecordType
implements IFixedLengthRecordType,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = 7226047218087513529L;
    protected int size_ = 0;
    protected int padFieldCounter_ = 0;
    private static final String PADFIELDHEADER = "__IVJ_PADFIELD_";
    private static final String PADFIELDTRAILER = "__";

    public FixedLengthRecordType() {
    }

    public FixedLengthRecordType(int packingHint) {
        super(packingHint);
    }

    public void addPadding(int length) throws IllegalArgumentException {
        PaddingType padType = new PaddingType(length);
        Field field = null;
        try {
            field = new Field(padType);
        }
        catch (RecordFieldTypeNotValidException recordFieldTypeNotValidException) {}
        String name = this.createPaddingFieldName();
        field.setName(name);
        try {
            this.addField(field);
        }
        catch (RecordException recordException) {}
    }

    public void addPaddingAfter(int length, String fieldName) throws IllegalArgumentException, RecordFieldNotFoundException {
        PaddingType padType = new PaddingType(length);
        Field field = null;
        try {
            field = new Field(padType);
        }
        catch (RecordFieldTypeNotValidException recordFieldTypeNotValidException) {}
        String name = this.createPaddingFieldName();
        field.setName(name);
        try {
            this.addFieldAfter(field, fieldName);
        }
        catch (RecordFieldNotFoundException exc) {
            throw exc;
        }
        catch (RecordException recordException) {}
    }

    public boolean canConvertFromObject() {
        return true;
    }

    public boolean canConvertToObject() {
        return true;
    }

    public Object clone() {
        FixedLengthRecordType newType = (FixedLengthRecordType)super.clone();
        return newType;
    }

    public String createPaddingFieldName() {
        String name = new String(PADFIELDHEADER + this.padFieldCounter_ + PADFIELDTRAILER);
        ++this.padFieldCounter_;
        return name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FixedLengthRecordType)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        FixedLengthRecordType tmpType = (FixedLengthRecordType)obj;
        if (this.size_ != tmpType.size_) {
            return false;
        }
        return this.padFieldCounter_ == tmpType.padFieldCounter_;
    }

    public Object getObject(IRecord record, int fieldOffset) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        try {
            IRecordAttributes recAttr = (IRecordAttributes)record.getRecordAttributes().clone();
            IAnyDynamicRecordType recType = (IAnyDynamicRecordType)this.clone();
            int alignment = fieldOffset + record.getAlignmentOffset();
            IRecord returnRecord = null;
            returnRecord = recType.getClass().getName().indexOf(36) == -1 ? recType.newRecord(recAttr, 0, alignment) : recType.newRecord(recAttr, 0, alignment, record);
            int length = this.getSize();
            byte[] bytes = new byte[length];
            System.arraycopy(record.getBytes(), fieldOffset, bytes, 0, length);
            returnRecord.setRawBytes(bytes);
            return returnRecord;
        }
        catch (Exception exception) {
            throw new RecordConversionFailureException();
        }
    }

    public abstract Class getRecordAttributesClass();

    public int getSize() {
        return this.size_;
    }

    public void pack(int startingOffset) {
        int nextOffset_ = 0;
        IFieldEnumeration cursor = this.fields();
        while (cursor.hasMoreFields()) {
            IAnyField field = cursor.nextField();
            int fieldHint = field.getType().getAlignmentHint();
            int hint = Math.min(fieldHint, this.packingHint_);
            while (nextOffset_ % hint != 0) {
                ++nextOffset_;
            }
            field.setRelativeOffset(nextOffset_);
            IAnyType type = field.getType();
            if (type instanceof IAnyComposedType) {
                ((IAnyComposedType)type).pack(nextOffset_);
            }
            nextOffset_ += field.getSize();
        }
        int hint = Math.min(this.getAlignmentHint(), this.getPackingHint());
        while (nextOffset_ % hint != 0) {
            ++nextOffset_;
        }
        this.size_ = nextOffset_;
    }

    public void setObject(IRecord record, int fieldOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            IDynamicRecord aRecord = (IDynamicRecord)value;
            if (!aRecord.getRecordType().equals(this)) {
                if (record.getRecordKind() != 4 && record.getRecordKind() != 5 || aRecord.getRecordKind() != 4 && aRecord.getRecordKind() != 5) {
                    throw new RecordConversionUnsupportedException();
                }
                this.updateArrayDimensions(aRecord, (IAnyDynamicRecordType)aRecord.getRecordType(), (IDynamicRecord)record, this);
                if (!aRecord.getRecordType().equals(this)) {
                    record.setBytes(record.getBytes());
                    throw new RecordConversionUnsupportedException();
                }
            }
            int length = this.getSize();
            System.arraycopy(aRecord.getBytes(), aRecord.getStartingOffset(), record.getBytes(), fieldOffset, length);
        }
        catch (Exception exception) {
            throw new RecordConversionFailureException();
        }
    }

    private void updateArrayDimensions(IDynamicRecord subRec, IAnyDynamicRecordType subRecType, IDynamicRecord parentRec, IAnyDynamicRecordType parentRecType) {
        IFieldEnumeration subRecCursor = subRecType.fields();
        IFieldEnumeration parentRecCursor = parentRecType.fields();
        while (subRecCursor.hasMoreFields()) {
            IAnyField field = subRecCursor.nextField();
            IAnyField parentField = parentRecCursor.nextField();
            if (field instanceof INestedRecordField || field instanceof IOverlayField) {
                this.updateArrayDimensions(subRec, (IAnyDynamicRecordType)field.getType(), parentRec, (IAnyDynamicRecordType)parentField.getType());
                continue;
            }
            if (!(field instanceof IVariableSizeArrayDimensionField)) continue;
            IVariableSizeArrayDimensionField varField = (IVariableSizeArrayDimensionField)field;
            IVariableSizeArrayDimensionField parentVarField = (IVariableSizeArrayDimensionField)parentField;
            Vector arrayNames = varField.getArrayFieldNames();
            Vector parentArrayNames = parentVarField.getArrayFieldNames();
            Enumeration nameCursor = arrayNames.elements();
            Enumeration parentNameCursor = parentArrayNames.elements();
            while (nameCursor.hasMoreElements()) {
                String[] arrayFieldName = (String[])nameCursor.nextElement();
                String[] parentArrayFieldName = (String[])parentNameCursor.nextElement();
                IArrayField arrayField = (IArrayField)subRec.getField(arrayFieldName);
                IArrayField parentArrayField = (IArrayField)parentRec.getField(parentArrayFieldName);
                int[] dimensions = ((IArrayType)arrayField.getType()).getDimensions();
                int[] parentDimensions = ((IArrayType)parentArrayField.getType()).getDimensions();
                parentDimensions[0] = dimensions[0];
            }
            ((IAnyDynamicRecordType)parentRec.getRecordType()).pack(parentRec.getAlignmentOffset());
        }
    }
}

