/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.AnyField;
import com.ibm.record.IAnyComposedType;
import com.ibm.record.IAnyType;
import com.ibm.record.IField;
import com.ibm.record.IFixedLengthType;
import com.ibm.record.IRecord;
import com.ibm.record.PaddingType;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordFieldTypeNotValidException;
import java.io.Serializable;
import java.math.BigDecimal;

public class Field
extends AnyField
implements IField,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = -631926706647486304L;
    protected IAnyType fieldType_;

    protected Field() {
        this.fieldType_ = null;
    }

    public Field(IAnyType type) throws RecordFieldTypeNotValidException {
        this.setType(type);
    }

    public Field(IAnyType type, String name) throws RecordFieldTypeNotValidException {
        super(name);
        this.setType(type);
    }

    public Field(IAnyType type, String name, Object initialValue) throws RecordFieldTypeNotValidException {
        super(name, initialValue);
        this.setType(type);
        this.setInitialValue(initialValue);
    }

    public Field(IAnyType type, String name, Object initialValue, Object constantValue, boolean readOnly) throws RecordFieldTypeNotValidException {
        super(name, initialValue, constantValue, readOnly);
        this.setType(type);
        this.setInitialValue(initialValue);
        this.setConstantValue(constantValue);
    }

    public Field(IAnyType type, String name, Object initialValue, Object constantValue, boolean readOnly, boolean generateAccessor) throws RecordFieldTypeNotValidException {
        super(name, initialValue, constantValue, readOnly, generateAccessor);
        this.setType(type);
        this.setInitialValue(initialValue);
        this.setConstantValue(constantValue);
    }

    public Field(IAnyType type, String name, Object initialValue, boolean readOnly) throws RecordFieldTypeNotValidException {
        super(name, initialValue, readOnly);
        this.setType(type);
        this.setInitialValue(initialValue);
    }

    public Field(IAnyType type, String name, boolean readOnly) throws RecordFieldTypeNotValidException {
        super(name, readOnly);
        this.setType(type);
    }

    public Field(IAnyType type, boolean readOnly) throws RecordFieldTypeNotValidException {
        super(readOnly);
        this.setType(type);
    }

    public Object clone() {
        Field newType = (Field)super.clone();
        if (this.fieldType_ != null) {
            newType.fieldType_ = (IAnyType)this.fieldType_.clone();
        }
        return newType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Field)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Field tmpField = (Field)obj;
        if (this.fieldType_ == null ^ tmpField.fieldType_ == null) {
            return false;
        }
        if (this.fieldType_ == null) {
            return true;
        }
        return this.fieldType_.equals(tmpField.fieldType_);
    }

    public BigDecimal getBigDecimal(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.cacheValues(record)) {
            return this.fieldType_.getBigDecimal(record, this.byteCache_);
        }
        int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
        return ((IFixedLengthType)this.fieldType_).getBigDecimal(record, offset);
    }

    public boolean getBoolean(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.cacheValues(record)) {
            return this.fieldType_.getBoolean(record, this.byteCache_);
        }
        int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
        return ((IFixedLengthType)this.fieldType_).getBoolean(record, offset);
    }

    public byte getByte(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.cacheValues(record)) {
            return this.fieldType_.getByte(record, this.byteCache_);
        }
        int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
        return ((IFixedLengthType)this.fieldType_).getByte(record, offset);
    }

    public char getChar(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.cacheValues(record)) {
            return this.fieldType_.getChar(record, this.byteCache_);
        }
        int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
        return ((IFixedLengthType)this.fieldType_).getChar(record, offset);
    }

    public double getDouble(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.cacheValues(record)) {
            return this.fieldType_.getDouble(record, this.byteCache_);
        }
        int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
        return ((IFixedLengthType)this.fieldType_).getDouble(record, offset);
    }

    public float getFloat(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.cacheValues(record)) {
            return this.fieldType_.getFloat(record, this.byteCache_);
        }
        int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
        return ((IFixedLengthType)this.fieldType_).getFloat(record, offset);
    }

    public int getInt(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.cacheValues(record)) {
            return this.fieldType_.getInt(record, this.byteCache_);
        }
        int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
        return ((IFixedLengthType)this.fieldType_).getInt(record, offset);
    }

    public long getLong(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.cacheValues(record)) {
            return this.fieldType_.getLong(record, this.byteCache_);
        }
        int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
        return ((IFixedLengthType)this.fieldType_).getLong(record, offset);
    }

    public Object getObject(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.cacheValues(record)) {
            return this.fieldType_.getObject(record, this.byteCache_);
        }
        int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
        return ((IFixedLengthType)this.fieldType_).getObject(record, offset);
    }

    public short getShort(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.cacheValues(record)) {
            return this.fieldType_.getShort(record, this.byteCache_);
        }
        int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
        return ((IFixedLengthType)this.fieldType_).getShort(record, offset);
    }

    public int getSize() {
        return this.fieldType_.getSize();
    }

    public String getString(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.cacheValues(record)) {
            return this.fieldType_.getString(record, this.byteCache_);
        }
        int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
        return ((IFixedLengthType)this.fieldType_).getString(record, offset);
    }

    public IAnyType getType() {
        return this.fieldType_;
    }

    public boolean isPadding() {
        if (this.fieldType_ == null) {
            return false;
        }
        return this.fieldType_ instanceof PaddingType;
    }

    public void setBigDecimal(IRecord record, int parentOffset, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setBigDecimal(record, value);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setBigDecimal(record, offset, value);
        }
    }

    public void setBoolean(IRecord record, int parentOffset, boolean value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setBoolean(record, value);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setBoolean(record, offset, value);
        }
    }

    public void setByte(IRecord record, int parentOffset, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setByte(record, value);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setByte(record, offset, value);
        }
    }

    public void setChar(IRecord record, int parentOffset, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setChar(record, value);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setChar(record, offset, value);
        }
    }

    public void setDouble(IRecord record, int parentOffset, double value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setDouble(record, value);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setDouble(record, offset, value);
        }
    }

    public void setFloat(IRecord record, int parentOffset, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setFloat(record, value);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setFloat(record, offset, value);
        }
    }

    public void setInt(IRecord record, int parentOffset, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setInt(record, value);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setInt(record, offset, value);
        }
    }

    public void setLong(IRecord record, int parentOffset, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setLong(record, value);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setLong(record, offset, value);
        }
    }

    public void setObject(IRecord record, int parentOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setObject(record, value);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setObject(record, offset, value);
        }
    }

    public void setShort(IRecord record, int parentOffset, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setShort(record, value);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setShort(record, offset, value);
        }
    }

    public void setString(IRecord record, int parentOffset, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setString(record, value);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.fieldType_).setString(record, offset, value);
        }
    }

    public void setType(IAnyType type) throws RecordFieldTypeNotValidException {
        if (type instanceof IAnyComposedType) {
            throw new RecordFieldTypeNotValidException(type.getClass().getName());
        }
        IAnyType oldType = this.fieldType_;
        this.fieldType_ = type;
        if (type instanceof IFixedLengthType) {
            this.setFieldKind(0);
        } else {
            this.setFieldKind(1);
        }
        this.setInitialValue(null);
        this.setConstantValue(null);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("type", oldType, this.fieldType_);
        }
    }
}

