/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.CustomRecord;
import com.ibm.record.ICustomRecordType;
import com.ibm.record.IRecord;
import com.ibm.record.IRecordAttributes;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordException;
import java.io.Serializable;
import java.lang.reflect.Constructor;

public class CustomRecordType
implements ICustomRecordType,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = -5035560876155015031L;
    protected Class customRecordClass_;
    protected int theSize_;

    private CustomRecordType() {
    }

    public CustomRecordType(Class aClass, int recordSize) {
        this.customRecordClass_ = aClass;
        this.theSize_ = recordSize;
    }

    public Object clone() {
        try {
            CustomRecordType newType = (CustomRecordType)super.clone();
            return newType;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CustomRecordType)) {
            return false;
        }
        CustomRecordType tmpType = (CustomRecordType)obj;
        if (this.theSize_ != tmpType.theSize_) {
            return false;
        }
        if (this.customRecordClass_ == null ^ tmpType.customRecordClass_ == null) {
            return false;
        }
        if (this.customRecordClass_ == null) {
            return true;
        }
        return this.customRecordClass_.equals(tmpType.customRecordClass_);
    }

    private static Object getClassInstance(Class customRecordClass) throws RecordException {
        String className = customRecordClass.getName();
        int index = className.lastIndexOf(36);
        Object newObj = null;
        if (index != -1) {
            newObj = CustomRecordType.getClassInstance(className, customRecordClass.getClassLoader());
        } else {
            try {
                newObj = customRecordClass.newInstance();
            }
            catch (Exception exc) {
                throw new RecordException(exc.getMessage());
            }
        }
        return newObj;
    }

    private static Object getClassInstance(String className, ClassLoader loader) throws RecordException {
        int index = className.lastIndexOf(36);
        Object newObj = null;
        Class<?> currentClass = null;
        if (index != -1) {
            String parentClassName = className.substring(0, index);
            Object parentInstance = CustomRecordType.getClassInstance(parentClassName, loader);
            try {
                currentClass = loader == null ? Class.forName(className) : loader.loadClass(className);
                Constructor<?> ctor = currentClass.getConstructor(parentInstance.getClass());
                newObj = ctor.newInstance(parentInstance);
            }
            catch (Exception exc) {
                throw new RecordException(exc.getMessage());
            }
        }
        try {
            currentClass = loader == null ? Class.forName(className) : loader.loadClass(className);
            newObj = currentClass.newInstance();
        }
        catch (Exception exc) {
            throw new RecordException(exc.getMessage());
        }
        return newObj;
    }

    public Object getObject(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public int getSize() {
        return this.theSize_;
    }

    public IRecord newRecord() throws RecordException {
        CustomRecord aRecord = (CustomRecord)CustomRecordType.getClassInstance(this.customRecordClass_);
        aRecord.setRecordType(this);
        return aRecord;
    }

    public IRecord newRecord(IRecordAttributes attributes, int startingOffset, int alignmentOffset) throws RecordException {
        IRecord aRecord = this.newRecord();
        aRecord.setRecordAttributes(attributes);
        aRecord.setStartingOffset(startingOffset);
        aRecord.setAlignmentOffset(alignmentOffset);
        return aRecord;
    }

    public IRecord newRecord(IRecordAttributes attributes, int startingOffset, int alignmentOffset, Object enclosingClass) throws RecordException {
        IRecord aRecord = this.newRecord(enclosingClass);
        aRecord.setRecordAttributes(attributes);
        aRecord.setStartingOffset(startingOffset);
        aRecord.setAlignmentOffset(alignmentOffset);
        return aRecord;
    }

    public IRecord newRecord(Object enclosingClass) throws RecordException {
        CustomRecord aRecord = null;
        try {
            Constructor ctor = this.customRecordClass_.getConstructor(enclosingClass.getClass());
            aRecord = (CustomRecord)ctor.newInstance(enclosingClass);
        }
        catch (Exception exc) {
            throw new RecordException(exc.getMessage());
        }
        aRecord.setRecordType(this);
        return aRecord;
    }

    public IRecord newRecordWithBytes() throws RecordException {
        IRecord aRecord = this.newRecord();
        byte[] bytes = new byte[aRecord.getSize()];
        aRecord.setBytes(bytes);
        aRecord.setInitialValues();
        return aRecord;
    }

    public IRecord newRecordWithBytes(IRecordAttributes attributes, int startingOffset, int alignmentOffset) throws RecordException {
        IRecord aRecord = this.newRecord();
        aRecord.setRecordAttributes(attributes);
        aRecord.setStartingOffset(startingOffset);
        aRecord.setAlignmentOffset(alignmentOffset);
        byte[] bytes = new byte[aRecord.getSize()];
        aRecord.setBytes(bytes);
        aRecord.setInitialValues();
        return aRecord;
    }

    public IRecord newRecordWithBytes(IRecordAttributes attributes, int startingOffset, int alignmentOffset, Object enclosingClass) throws RecordException {
        IRecord aRecord = this.newRecord(enclosingClass);
        aRecord.setRecordAttributes(attributes);
        aRecord.setStartingOffset(startingOffset);
        aRecord.setAlignmentOffset(alignmentOffset);
        byte[] bytes = new byte[aRecord.getSize()];
        aRecord.setBytes(bytes);
        aRecord.setInitialValues();
        return aRecord;
    }

    public IRecord newRecordWithBytes(Object enclosingClass) throws RecordException {
        IRecord aRecord = this.newRecord(enclosingClass);
        byte[] bytes = new byte[aRecord.getSize()];
        aRecord.setBytes(bytes);
        aRecord.setInitialValues();
        return aRecord;
    }

    public void setObject(IRecord record, int fieldOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }
}

